/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentListener;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRColor;
import uk.ac.uea.cmp.nlct.jdr.JDRColorCMYK;
import uk.ac.uea.cmp.nlct.jdr.JDRColorHSB;
import uk.ac.uea.cmp.nlct.jdr.JDRGray;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRShading;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.ColorButton;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.ColorCMYKPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.ColorHSBPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.ColorRGBPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.GreyPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.SingleColourSelector;

public class ColorPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private ColorRGBPanel rgbPanel;
    private ColorCMYKPanel cmykPanel;
    private ColorHSBPanel hsbPanel;
    private GreyPanel greyPanel;
    private JTabbedPane tabbedPane;
    private SingleColourSelector currentPanel;
    private ColorButton[] predefinedButtons;
    private static final int MAX_PREDEFINED = 20;
    private JPanel predefinedPanel;
    private int predefined_n = 0;

    public ColorPanel() {
        this.rgbPanel = new ColorRGBPanel();
        this.cmykPanel = new ColorCMYKPanel();
        this.hsbPanel = new ColorHSBPanel();
        this.greyPanel = new GreyPanel();
        this.initialise();
    }

    public ColorPanel(AdjustmentListener adjustmentListener) {
        this.rgbPanel = new ColorRGBPanel(adjustmentListener);
        this.cmykPanel = new ColorCMYKPanel(adjustmentListener);
        this.hsbPanel = new ColorHSBPanel(adjustmentListener);
        this.greyPanel = new GreyPanel(adjustmentListener);
        this.initialise();
    }

    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.rgbPanel.addAdjustmentListener(adjustmentListener);
        this.cmykPanel.addAdjustmentListener(adjustmentListener);
        this.hsbPanel.addAdjustmentListener(adjustmentListener);
        this.greyPanel.addAdjustmentListener(adjustmentListener);
    }

    public void initialise() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabPlacement(4);
        this.tabbedPane.setAlignmentY(0.0f);
        this.add((Component)this.tabbedPane, gridBagConstraints);
        this.tabbedPane.addTab(JDRResources.getString("colour.rgb"), null, this.rgbPanel, JDRResources.getString("tooltip.rgb"));
        this.tabbedPane.addChangeListener(this);
        this.currentPanel = this.rgbPanel;
        this.tabbedPane.addTab(JDRResources.getString("colour.cmyk"), null, this.cmykPanel, JDRResources.getString("tooltip.cmyk"));
        this.tabbedPane.addTab(JDRResources.getString("colour.hsb"), null, this.hsbPanel, JDRResources.getString("tooltip.hsb"));
        this.tabbedPane.addTab(JDRResources.getString("colour.grey"), null, this.greyPanel, JDRResources.getString("tooltip.grey"));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        this.predefinedPanel = new JPanel();
        this.predefinedPanel.setAlignmentY(0.0f);
        this.add((Component)this.predefinedPanel, gridBagConstraints);
        this.predefinedPanel.setLayout(new GridLayout(4, 5));
        this.predefinedButtons = new ColorButton[20];
        this.predefined_n = 0;
        try {
            this.addPredefinedColor(Color.black, JDRResources.getString("tooltip.swatch.black"));
            this.addPredefinedColor(Color.darkGray, JDRResources.getString("tooltip.swatch.darkgrey"));
            this.addPredefinedColor(Color.gray, JDRResources.getString("tooltip.swatch.grey"));
            this.addPredefinedColor(Color.lightGray, JDRResources.getString("tooltip.swatch.lightgrey"));
            this.addPredefinedColor(Color.white, JDRResources.getString("tooltip.swatch.white"));
            this.addPredefinedColor(new Color(0, 0, 128), JDRResources.getString("tooltip.swatch.darkblue"));
            this.addPredefinedColor(Color.blue, JDRResources.getString("tooltip.swatch.blue"));
            this.addPredefinedColor(Color.cyan, JDRResources.getString("tooltip.swatch.cyan"));
            this.addPredefinedColor(Color.green, JDRResources.getString("tooltip.swatch.green"));
            this.addPredefinedColor(new Color(0, 128, 0), JDRResources.getString("tooltip.swatch.darkgreen"));
            this.addPredefinedColor(Color.yellow, JDRResources.getString("tooltip.swatch.yellow"));
            this.addPredefinedColor(new JDRColorCMYK(0.0, 0.1, 0.84, 0.0), JDRResources.getString("tooltip.swatch.goldenrod"));
            this.addPredefinedColor(Color.orange, JDRResources.getString("tooltip.swatch.orange"));
            this.addPredefinedColor(new JDRColorCMYK(0.14, 0.42, 0.56, 0.0), JDRResources.getString("tooltip.swatch.tan"));
            this.addPredefinedColor(new JDRColorCMYK(0.0, 0.72, 1.0, 0.45), JDRResources.getString("tooltip.swatch.rawsienna"));
            this.addPredefinedColor(Color.red, JDRResources.getString("tooltip.swatch.red"));
            this.addPredefinedColor(new Color(128, 0, 0), JDRResources.getString("tooltip.swatch.darkred"));
            this.addPredefinedColor(new JDRColorCMYK(0.32, 0.64, 0.0, 0.0), JDRResources.getString("tooltip.swatch.orchid"));
            this.addPredefinedColor(Color.magenta, JDRResources.getString("tooltip.swatch.magenta"));
            this.addPredefinedColor(Color.pink, JDRResources.getString("tooltip.swatch.pink"));
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
    }

    public void addPredefinedColor(Color color, String string) {
        this.predefinedButtons[this.predefined_n] = new ColorButton(color);
        this.predefinedPanel.add(this.predefinedButtons[this.predefined_n]);
        this.predefinedButtons[this.predefined_n].addActionListener(this);
        this.predefinedButtons[this.predefined_n].setToolTipText(string);
        ++this.predefined_n;
    }

    public void addPredefinedColor(JDRPaint jDRPaint, String string) {
        this.predefinedButtons[this.predefined_n] = new ColorButton(jDRPaint);
        this.predefinedPanel.add(this.predefinedButtons[this.predefined_n]);
        this.predefinedButtons[this.predefined_n].addActionListener(this);
        this.predefinedButtons[this.predefined_n].setToolTipText(string);
        ++this.predefined_n;
    }

    public void setMnemonics(char c, char c2) {
        this.tabbedPane.setMnemonicAt(0, c);
        this.tabbedPane.setMnemonicAt(1, c2);
    }

    public void setMnemonics(char c, char c2, char c3, char c4) {
        this.tabbedPane.setMnemonicAt(0, c);
        this.tabbedPane.setMnemonicAt(1, c2);
        this.tabbedPane.setMnemonicAt(2, c3);
        this.tabbedPane.setMnemonicAt(3, c4);
    }

    public boolean requestDefaultColourFocus() {
        this.currentPanel = (SingleColourSelector)((Object)this.tabbedPane.getSelectedComponent());
        return this.currentPanel.requestDefaultColourFocus();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof ColorButton) {
            this.currentPanel = (SingleColourSelector)((Object)this.tabbedPane.getSelectedComponent());
            this.currentPanel.setPaint(((ColorButton)object).getPaint());
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JDRPaint jDRPaint = this.currentPanel.getPaint();
        this.currentPanel = (SingleColourSelector)((Object)this.tabbedPane.getSelectedComponent());
        this.currentPanel.setPaint(jDRPaint);
        this.currentPanel.requestDefaultColourFocus();
    }

    public JDRPaint getPaint() {
        this.currentPanel = (SingleColourSelector)((Object)this.tabbedPane.getSelectedComponent());
        return this.currentPanel.getPaint();
    }

    public void setPaint(JDRPaint jDRPaint) {
        if (jDRPaint instanceof JDRColor) {
            this.tabbedPane.setSelectedComponent(this.rgbPanel);
            this.currentPanel = this.rgbPanel;
        } else if (jDRPaint instanceof JDRColorCMYK) {
            this.tabbedPane.setSelectedComponent(this.cmykPanel);
            this.currentPanel = this.cmykPanel;
        } else if (jDRPaint instanceof JDRColorHSB) {
            this.tabbedPane.setSelectedComponent(this.hsbPanel);
            this.currentPanel = this.hsbPanel;
        } else if (jDRPaint instanceof JDRGray) {
            this.tabbedPane.setSelectedComponent(this.greyPanel);
            this.currentPanel = this.greyPanel;
        } else {
            if (jDRPaint instanceof JDRShading) {
                this.setPaint(((JDRShading)((Object)jDRPaint)).getStartColor());
                return;
            }
            this.setPaint(jDRPaint.getJDRColor());
            return;
        }
        this.currentPanel.setPaint(jDRPaint);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.rgbPanel.setEnabled(bl);
        this.cmykPanel.setEnabled(bl);
        this.hsbPanel.setEnabled(bl);
        this.greyPanel.setEnabled(bl);
        this.tabbedPane.setEnabled(bl);
        for (int i = 0; i < this.predefined_n; ++i) {
            this.predefinedButtons[i].setVisible(bl);
        }
    }
}

