/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRColorHSB;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.IntRangeField;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.PercentageField;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.TextFieldSBarListener;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.SingleColourSelector;

public class ColorHSBPanel
extends JPanel
implements AdjustmentListener,
SingleColourSelector {
    private JScrollBar hueSB;
    private JScrollBar saturationSB;
    private JScrollBar brightnessSB;
    private JScrollBar alphaSB;
    private PercentageField saturationText;
    private PercentageField brightnessText;
    private PercentageField alphaText;
    private IntRangeField hueText;
    private JLabel hueLabel;
    private JLabel saturationLabel;
    private JLabel brightnessLabel;
    private JLabel alphaLabel;

    public ColorHSBPanel() {
        this.initialise();
    }

    public ColorHSBPanel(AdjustmentListener adjustmentListener) {
        this.initialise();
        this.addAdjustmentListener(adjustmentListener);
    }

    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.hueSB.addAdjustmentListener(adjustmentListener);
        this.saturationSB.addAdjustmentListener(adjustmentListener);
        this.brightnessSB.addAdjustmentListener(adjustmentListener);
        this.alphaSB.addAdjustmentListener(adjustmentListener);
    }

    public void initialise() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, gridBagConstraints);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weightx = 100.0;
        gridBagConstraints2.weighty = 100.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        this.hueLabel = new JLabel(JDRResources.getString("colour.hue"), 4);
        jPanel.add((Component)this.hueLabel, gridBagConstraints2);
        this.hueSB = new JScrollBar(0, 0, 0, 0, 359);
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 4;
        gridBagConstraints2.gridheight = 1;
        jPanel.add((Component)this.hueSB, gridBagConstraints2);
        gridBagConstraints2.gridx = 5;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 17;
        this.hueText = new IntRangeField(0, 0, 359);
        jPanel.add((Component)this.hueText, gridBagConstraints2);
        this.hueText.getDocument().addDocumentListener(new TextFieldSBarListener(this.hueText, this.hueSB));
        this.hueSB.setBlockIncrement(10);
        this.hueSB.addAdjustmentListener(this);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.fill = 1;
        this.saturationLabel = new JLabel(JDRResources.getString("colour.saturation"), 4);
        jPanel.add((Component)this.saturationLabel, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 3;
        this.saturationSB = new JScrollBar(0, 0, 0, 0, 100);
        jPanel.add((Component)this.saturationSB, gridBagConstraints2);
        gridBagConstraints2.gridx = 5;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 0;
        this.saturationText = new PercentageField(0);
        jPanel.add((Component)this.saturationText, gridBagConstraints2);
        this.saturationText.getDocument().addDocumentListener(new TextFieldSBarListener(this.saturationText, this.saturationSB));
        this.saturationSB.setBlockIncrement(10);
        this.saturationSB.addAdjustmentListener(this);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        this.brightnessLabel = new JLabel(JDRResources.getString("colour.brightness"), 4);
        jPanel.add((Component)this.brightnessLabel, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 4;
        this.brightnessSB = new JScrollBar(0, 0, 0, 0, 100);
        jPanel.add((Component)this.brightnessSB, gridBagConstraints2);
        gridBagConstraints2.gridx = 5;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 0;
        this.brightnessText = new PercentageField(0);
        jPanel.add((Component)this.brightnessText, gridBagConstraints2);
        this.brightnessText.getDocument().addDocumentListener(new TextFieldSBarListener(this.brightnessText, this.brightnessSB));
        this.brightnessSB.setBlockIncrement(10);
        this.brightnessSB.addAdjustmentListener(this);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.fill = 1;
        this.alphaLabel = new JLabel(JDRResources.getString("colour.alpha"), 4);
        jPanel.add((Component)this.alphaLabel, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 4;
        this.alphaSB = new JScrollBar(0, 100, 0, 0, 100);
        jPanel.add((Component)this.alphaSB, gridBagConstraints2);
        gridBagConstraints2.gridx = 5;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 0;
        this.alphaText = new PercentageField(100);
        jPanel.add((Component)this.alphaText, gridBagConstraints2);
        this.alphaText.getDocument().addDocumentListener(new TextFieldSBarListener(this.alphaText, this.alphaSB));
        this.alphaSB.setBlockIncrement(10);
        this.alphaSB.addAdjustmentListener(this);
    }

    @Override
    public boolean requestDefaultColourFocus() {
        return this.hueText.requestFocusInWindow();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.hueText.getValue() != this.hueSB.getValue()) {
            this.hueText.setValue(this.hueSB.getValue());
        }
        if (this.saturationText.getValue() != this.saturationSB.getValue()) {
            this.saturationText.setValue(this.saturationSB.getValue());
        }
        if (this.brightnessText.getValue() != this.brightnessSB.getValue()) {
            this.brightnessText.setValue(this.brightnessSB.getValue());
        }
        if (this.alphaText.getValue() != this.alphaSB.getValue()) {
            this.alphaText.setValue(this.alphaSB.getValue());
        }
    }

    @Override
    public JDRPaint getPaint() {
        JDRColorHSB jDRColorHSB = null;
        try {
            jDRColorHSB = new JDRColorHSB(this.hueSB.getValue(), (float)this.saturationSB.getValue() / 100.0f, (float)this.brightnessSB.getValue() / 100.0f, (float)this.alphaSB.getValue() / 100.0f);
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
        return jDRColorHSB;
    }

    @Override
    public void setPaint(JDRPaint jDRPaint) {
        JDRColorHSB jDRColorHSB = jDRPaint.getJDRColorHSB();
        this.hueSB.setValue((int)Math.round(jDRColorHSB.getHue()));
        this.saturationSB.setValue((int)Math.round(jDRColorHSB.getSaturation() * 100.0));
        this.brightnessSB.setValue((int)Math.round(jDRColorHSB.getBrightness() * 100.0));
        this.alphaSB.setValue((int)Math.round(jDRColorHSB.getAlpha() * 100.0));
    }

    @Override
    public void setEnabled(boolean bl) {
        this.hueSB.setEnabled(bl);
        this.saturationSB.setEnabled(bl);
        this.brightnessSB.setEnabled(bl);
        this.alphaSB.setEnabled(bl);
        this.hueText.setEnabled(bl);
        this.saturationText.setEnabled(bl);
        this.brightnessText.setEnabled(bl);
        this.alphaText.setEnabled(bl);
        this.hueLabel.setEnabled(bl);
        this.saturationLabel.setEnabled(bl);
        this.brightnessLabel.setEnabled(bl);
        this.alphaLabel.setEnabled(bl);
    }
}

