/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRColorCMYK;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.PercentageField;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.TextFieldSBarListener;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.SingleColourSelector;

public class ColorCMYKPanel
extends JPanel
implements AdjustmentListener,
SingleColourSelector {
    private JScrollBar cyanSB;
    private JScrollBar magentaSB;
    private JScrollBar yellowSB;
    private JScrollBar blackSB;
    private JScrollBar alphaSB;
    private PercentageField cyanText;
    private PercentageField magentaText;
    private PercentageField yellowText;
    private PercentageField blackText;
    private PercentageField alphaText;
    private JLabel cyanLabel;
    private JLabel magentaLabel;
    private JLabel yellowLabel;
    private JLabel blackLabel;
    private JLabel alphaLabel;

    public ColorCMYKPanel() {
        this.initialise();
    }

    public ColorCMYKPanel(AdjustmentListener adjustmentListener) {
        this.initialise();
        this.addAdjustmentListener(adjustmentListener);
    }

    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.cyanSB.addAdjustmentListener(adjustmentListener);
        this.magentaSB.addAdjustmentListener(adjustmentListener);
        this.yellowSB.addAdjustmentListener(adjustmentListener);
        this.blackSB.addAdjustmentListener(adjustmentListener);
        this.alphaSB.addAdjustmentListener(adjustmentListener);
    }

    public void initialise() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, gridBagConstraints);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weightx = 100.0;
        gridBagConstraints2.weighty = 100.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        this.cyanLabel = new JLabel(JDRResources.getString("colour.cyan"), 4);
        jPanel.add((Component)this.cyanLabel, gridBagConstraints2);
        this.cyanSB = new JScrollBar(0, 0, 0, 0, 100);
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 4;
        gridBagConstraints2.gridheight = 1;
        jPanel.add((Component)this.cyanSB, gridBagConstraints2);
        gridBagConstraints2.gridx = 5;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 17;
        this.cyanText = new PercentageField(0);
        jPanel.add((Component)this.cyanText, gridBagConstraints2);
        this.cyanText.getDocument().addDocumentListener(new TextFieldSBarListener(this.cyanText, this.cyanSB));
        this.cyanSB.setBlockIncrement(10);
        this.cyanSB.addAdjustmentListener(this);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.fill = 1;
        this.magentaLabel = new JLabel(JDRResources.getString("colour.magenta"), 4);
        jPanel.add((Component)this.magentaLabel, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 3;
        this.magentaSB = new JScrollBar(0, 0, 0, 0, 100);
        jPanel.add((Component)this.magentaSB, gridBagConstraints2);
        gridBagConstraints2.gridx = 5;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 0;
        this.magentaText = new PercentageField(0);
        jPanel.add((Component)this.magentaText, gridBagConstraints2);
        this.magentaText.getDocument().addDocumentListener(new TextFieldSBarListener(this.magentaText, this.magentaSB));
        this.magentaSB.setBlockIncrement(10);
        this.magentaSB.addAdjustmentListener(this);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        this.yellowLabel = new JLabel(JDRResources.getString("colour.yellow"), 4);
        jPanel.add((Component)this.yellowLabel, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 4;
        this.yellowSB = new JScrollBar(0, 0, 0, 0, 100);
        jPanel.add((Component)this.yellowSB, gridBagConstraints2);
        gridBagConstraints2.gridx = 5;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 0;
        this.yellowText = new PercentageField(0);
        jPanel.add((Component)this.yellowText, gridBagConstraints2);
        this.yellowText.getDocument().addDocumentListener(new TextFieldSBarListener(this.yellowText, this.yellowSB));
        this.yellowSB.setBlockIncrement(10);
        this.yellowSB.addAdjustmentListener(this);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.fill = 1;
        this.blackLabel = new JLabel(JDRResources.getString("colour.black"), 4);
        jPanel.add((Component)this.blackLabel, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 4;
        this.blackSB = new JScrollBar(0, 0, 0, 0, 100);
        jPanel.add((Component)this.blackSB, gridBagConstraints2);
        gridBagConstraints2.gridx = 5;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 0;
        this.blackText = new PercentageField(0);
        jPanel.add((Component)this.blackText, gridBagConstraints2);
        this.blackText.getDocument().addDocumentListener(new TextFieldSBarListener(this.blackText, this.blackSB));
        this.blackSB.setBlockIncrement(10);
        this.blackSB.addAdjustmentListener(this);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.fill = 1;
        this.alphaLabel = new JLabel(JDRResources.getString("colour.alpha"), 4);
        jPanel.add((Component)this.alphaLabel, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 4;
        this.alphaSB = new JScrollBar(0, 100, 0, 0, 100);
        jPanel.add((Component)this.alphaSB, gridBagConstraints2);
        gridBagConstraints2.gridx = 5;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.fill = 0;
        this.alphaText = new PercentageField(100);
        jPanel.add((Component)this.alphaText, gridBagConstraints2);
        this.alphaText.getDocument().addDocumentListener(new TextFieldSBarListener(this.alphaText, this.alphaSB));
        this.alphaSB.setBlockIncrement(10);
        this.alphaSB.addAdjustmentListener(this);
    }

    @Override
    public boolean requestDefaultColourFocus() {
        return this.cyanText.requestFocusInWindow();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.cyanText.getValue() != this.cyanSB.getValue()) {
            this.cyanText.setValue(this.cyanSB.getValue());
        }
        if (this.magentaText.getValue() != this.magentaSB.getValue()) {
            this.magentaText.setValue(this.magentaSB.getValue());
        }
        if (this.yellowText.getValue() != this.yellowSB.getValue()) {
            this.yellowText.setValue(this.yellowSB.getValue());
        }
        if (this.blackText.getValue() != this.blackSB.getValue()) {
            this.blackText.setValue(this.blackSB.getValue());
        }
        if (this.alphaText.getValue() != this.alphaSB.getValue()) {
            this.alphaText.setValue(this.alphaSB.getValue());
        }
    }

    @Override
    public JDRPaint getPaint() {
        try {
            return new JDRColorCMYK((float)this.cyanText.getValue() / 100.0f, (float)this.magentaText.getValue() / 100.0f, (float)this.yellowText.getValue() / 100.0f, (float)this.blackText.getValue() / 100.0f, (float)this.alphaText.getValue() / 100.0f);
        }
        catch (InvalidFormatException invalidFormatException) {
            return new JDRColorCMYK();
        }
    }

    @Override
    public void setPaint(JDRPaint jDRPaint) {
        JDRColorCMYK jDRColorCMYK = jDRPaint.getJDRColorCMYK();
        this.cyanSB.setValue((int)Math.round(100.0 * jDRColorCMYK.getCyan()));
        this.magentaSB.setValue((int)Math.round(100.0 * jDRColorCMYK.getMagenta()));
        this.yellowSB.setValue((int)Math.round(100.0 * jDRColorCMYK.getYellow()));
        this.blackSB.setValue((int)Math.round(100.0 * jDRColorCMYK.getKey()));
        this.alphaSB.setValue((int)Math.round(100.0 * jDRColorCMYK.getAlpha()));
    }

    @Override
    public void setEnabled(boolean bl) {
        this.cyanSB.setEnabled(bl);
        this.magentaSB.setEnabled(bl);
        this.yellowSB.setEnabled(bl);
        this.blackSB.setEnabled(bl);
        this.alphaSB.setEnabled(bl);
        this.cyanText.setEnabled(bl);
        this.magentaText.setEnabled(bl);
        this.yellowText.setEnabled(bl);
        this.blackText.setEnabled(bl);
        this.alphaText.setEnabled(bl);
        this.cyanLabel.setEnabled(bl);
        this.magentaLabel.setEnabled(bl);
        this.yellowLabel.setEnabled(bl);
        this.blackLabel.setEnabled(bl);
        this.alphaLabel.setEnabled(bl);
    }
}

