/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.CharacterButton;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.SymbolSelectorListener;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.UnicodePanel;

public class CharacterSelector
extends JDialog
implements ActionListener,
PropertyChangeListener {
    private SymbolSelectorListener symbolListener_;
    private JButton[] buttons;
    private JTextField textfield;
    private UnicodePanel unicodePanel;
    private final int MAX_BUTTONS = 2002;
    private JScrollPane scrollPane;

    public CharacterSelector(JFrame jFrame, SymbolSelectorListener symbolSelectorListener) {
        super(jFrame, JDRResources.getString("symbol.title"), true);
        this.init(symbolSelectorListener);
    }

    public CharacterSelector(Dialog dialog, SymbolSelectorListener symbolSelectorListener) {
        super(dialog, JDRResources.getString("symbol.title"), true);
        this.init(symbolSelectorListener);
    }

    private void init(SymbolSelectorListener symbolSelectorListener) {
        this.symbolListener_ = symbolSelectorListener;
        Box box = Box.createHorizontalBox();
        JLabel jLabel = new JLabel(JDRResources.getString("symbol.text"));
        jLabel.setDisplayedMnemonic(JDRResources.getChar("symbol.text.mnemonic"));
        box.add(jLabel);
        this.textfield = new JTextField(){

            @Override
            public void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHints(CharacterSelector.this.symbolListener_.getRenderingHints());
                super.paintComponent(graphics);
            }
        };
        jLabel.setLabelFor(this.textfield);
        box.add(this.textfield);
        this.getContentPane().add((Component)box, "North");
        this.unicodePanel = new UnicodePanel(this.symbolListener_, this);
        this.getContentPane().add((Component)this.unicodePanel, "East");
        JPanel jPanel = new JPanel();
        int n = 14;
        int n2 = (int)Math.ceil(2002.0 / (double)n);
        GridLayout gridLayout = new GridLayout(n2, n);
        jPanel.setLayout(gridLayout);
        this.buttons = new JButton[2002];
        for (int i = 0; i < 2002; ++i) {
            this.buttons[i] = new CharacterButton(i + 32, symbolSelectorListener);
            jPanel.add(this.buttons[i]);
            this.buttons[i].addActionListener(this);
        }
        Dimension dimension = this.buttons[0].getPreferredSize();
        int n3 = dimension.width;
        int n4 = dimension.height;
        dimension.width = dimension.width * (n + 1) + gridLayout.getHgap() * (n - 1);
        dimension.height = dimension.height * n2 + gridLayout.getVgap() * (n2 - 1);
        jPanel.setPreferredSize(dimension);
        this.scrollPane = new JScrollPane(jPanel);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.add(JDRResources.createOkayButton(this));
        jPanel2.add(JDRResources.createCancelButton(this));
        jPanel2.add(JDRResources.createHelpButton("mi:insertsymbol"));
        this.getContentPane().add((Component)jPanel2, "South");
        dimension = this.scrollPane.getPreferredSize();
        dimension.height = 400;
        dimension.width += 10;
        this.scrollPane.setSize(dimension);
        dimension.height = CharacterButton.getMaxHeight();
        this.textfield.setPreferredSize(dimension);
        this.pack();
        dimension = this.getSize();
        dimension.height = 400;
        this.setSize(dimension);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension2 = toolkit.getScreenSize();
        int n5 = dimension2.height;
        int n6 = dimension2.width;
        this.setLocation((n6 - dimension.width) / 2, (n5 - dimension.height) / 2);
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(n4);
        JScrollBar jScrollBar2 = this.scrollPane.getHorizontalScrollBar();
        jScrollBar2.setUnitIncrement(n3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                CharacterSelector.this.textfield.requestFocusInWindow();
            }
        });
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addPropertyChangeListener(this);
    }

    public void display() {
        Font font = this.symbolListener_.getSymbolButtonFont();
        this.textfield.setFont(font);
        this.textfield.setText(this.symbolListener_.getSymbolText());
        this.textfield.setCaretPosition(this.symbolListener_.getSymbolCaretPosition());
        this.textfield.requestFocusInWindow();
        Dimension dimension = this.textfield.getSize();
        this.setVisible(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("focusOwner") && propertyChangeEvent.getNewValue() instanceof CharacterButton) {
            CharacterButton characterButton = (CharacterButton)propertyChangeEvent.getNewValue();
            this.unicodePanel.setHexString(characterButton.getHexString());
        }
    }

    public void okay() {
        this.setVisible(false);
        this.symbolListener_.setText(this.textfield.getText());
        this.symbolListener_.setSymbolCaretPosition(this.textfield.getCaretPosition());
        this.symbolListener_.requestSymbolFocus();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string == null) {
            string = "";
        }
        if (string.equals("okay")) {
            this.okay();
        } else if (string.equals("cancel")) {
            this.setVisible(false);
        } else if (object instanceof CharacterButton) {
            CharacterButton characterButton = (CharacterButton)object;
            this.insertChar(characterButton.getChar());
            this.unicodePanel.setHexString(characterButton.getHexString());
            this.textfield.requestFocusInWindow();
        }
    }

    public void insertChar(char c) {
        int n = this.textfield.getCaretPosition();
        String string = this.textfield.getText();
        this.textfield.setText(string.substring(0, n) + c + string.substring(n));
        this.textfield.setCaretPosition(n + 1);
    }

    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        string2 = string2 + "CharacterSelector:" + string;
        string2 = string2 + "has focus: " + this.hasFocus() + string;
        string2 = string2 + "textfield has focus: " + this.textfield.hasFocus() + string;
        return string2 + string;
    }
}

