/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.JButton;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.SymbolSelectorListener;

public class CharacterButton
extends JButton {
    private Character character;
    private SymbolSelectorListener listener;
    private static int height = 30;

    public CharacterButton(int n, SymbolSelectorListener symbolSelectorListener) {
        this.character = new Character((char)n);
        String string = Integer.toHexString(n).toUpperCase();
        int n2 = 4 - string.length();
        for (int i = 0; i < n2; ++i) {
            string = "0" + string;
        }
        this.setToolTipText("U+" + string);
        this.setPreferredSize(new Dimension(height, height));
        this.listener = symbolSelectorListener;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Font font = graphics2D.getFont();
        Font font2 = this.listener.getSymbolButtonFont();
        if (font2 == null) {
            font2 = font;
        } else {
            graphics2D.setFont(font2);
        }
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        RenderingHints renderingHints2 = this.listener.getRenderingHints();
        if (renderingHints2 != null) {
            graphics2D.setRenderingHints(renderingHints2);
        }
        Rectangle rectangle = this.getBounds();
        int n = (int)rectangle.getWidth();
        int n2 = (int)rectangle.getHeight();
        graphics2D.setPaint(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setPaint(Color.black);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font2);
        TextLayout textLayout = new TextLayout(this.character.toString(), font2, fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        double d = 0.5 * rectangle.getWidth() - 0.5 * rectangle2D.getWidth();
        double d2 = rectangle.getHeight() - (double)fontMetrics.getMaxDescent() - 4.0;
        textLayout.draw(graphics2D, (float)d, (float)d2);
        if (this.hasFocus()) {
            graphics2D.setPaint(Color.gray);
            graphics2D.drawRect(2, 2, n - 4, n2 - 4);
        }
        graphics2D.setPaint(paint);
        if (renderingHints2 != null) {
            graphics2D.setRenderingHints(renderingHints);
        }
    }

    public char getChar() {
        return this.character.charValue();
    }

    public String getHexString() {
        return Integer.toHexString(this.getChar());
    }

    public static int getMaxHeight() {
        return height;
    }
}

