/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import uk.ac.uea.cmp.nlct.jdr.JDRBitmap;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.DoubleField;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;

public class BitmapProperties
extends JDialog
implements ActionListener {
    private JpgfDraw application_;
    private DoubleField[] field;
    private JButton browse;
    private JTextField filename;
    private JTextField latexlinkText;
    private JTextField latexCommand;
    private JDRBitmap bitmap = null;
    private JFileChooser fc_;

    public BitmapProperties(JpgfDraw jpgfDraw, JFileChooser jFileChooser) {
        super(jpgfDraw, JDRResources.getString("bitmap.properties.label"), true);
        this.setSize(550, 260);
        this.setLocationRelativeTo(jpgfDraw);
        this.application_ = jpgfDraw;
        this.fc_ = jFileChooser;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        JLabel jLabel = new JLabel(JDRResources.getString("label.filename"));
        jLabel.setDisplayedMnemonic(JDRResources.getChar("label.filename.mnemonic"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.filename = new JTextField(JDRResources.getString("error.no_filename"));
        jLabel.setLabelFor(this.filename);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.filename, gridBagConstraints);
        this.browse = new JButton(JDRResources.getString("browse.label"));
        this.browse.setMnemonic(JDRResources.getChar("browse.label.mnemonic"));
        this.browse.addActionListener(this);
        this.browse.setActionCommand("browse");
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.browse, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        JLabel jLabel2 = new JLabel(JDRResources.getString("bitmap.properties.latexfilename"));
        jLabel2.setDisplayedMnemonic(JDRResources.getChar("bitmap.properties.latexfilename.mnemonic"));
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.latexlinkText = new JTextField(JDRResources.getString("error.no_filename"));
        jLabel2.setLabelFor(this.latexlinkText);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.latexlinkText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        JLabel jLabel3 = new JLabel(JDRResources.getString("bitmap.properties.command"));
        jLabel3.setDisplayedMnemonic(JDRResources.getChar("bitmap.properties.command.mnemonic"));
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.latexCommand = new JTextField("\\pgfimage");
        jLabel3.setLabelFor(this.latexCommand);
        jPanel.add((Component)this.latexCommand, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add(Box.createGlue(), gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add(Box.createGlue(), gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add(Box.createGlue(), gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add(Box.createGlue(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        JLabel jLabel4 = new JLabel(JDRResources.getString("bitmap.properties.matrix"));
        jLabel4.setDisplayedMnemonic(JDRResources.getChar("bitmap.properties.matrix.mnemonic"));
        jPanel.add((Component)jLabel4, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(3, 3));
        this.field = new DoubleField[6];
        this.field[0] = new DoubleField(1.0);
        jPanel2.add(this.field[0]);
        jLabel4.setLabelFor(this.field[0]);
        this.field[2] = new DoubleField(0.0);
        jPanel2.add(this.field[2]);
        this.field[4] = new DoubleField(0.0);
        jPanel2.add(this.field[4]);
        this.field[1] = new DoubleField(0.0);
        jPanel2.add(this.field[1]);
        this.field[3] = new DoubleField(1.0);
        jPanel2.add(this.field[3]);
        this.field[5] = new DoubleField(0.0);
        jPanel2.add(this.field[5]);
        jPanel2.add(new JLabel("0"));
        jPanel2.add(new JLabel("0"));
        jPanel2.add(new JLabel("1"));
        for (int i = 0; i < 6; ++i) {
            this.field[i].setHorizontalAlignment(2);
        }
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.add(JDRResources.createOkayButton(this));
        jPanel3.add(JDRResources.createCancelButton(this));
        jPanel3.add(JDRResources.createHelpButton("sec:bitmapproperties"));
        this.getContentPane().add((Component)jPanel3, "South");
    }

    public void initialise() {
        JDRFrame jDRFrame = this.application_.getCurrentFrame();
        this.setProperties(jDRFrame.getSelectedBitmap());
        this.filename.requestFocusInWindow();
        this.setVisible(true);
    }

    public void browseAction() {
        int n = this.fc_.showOpenDialog(this);
        if (n == 0) {
            String string;
            String string2 = this.fc_.getSelectedFile().getAbsolutePath();
            if (File.separator.equals("\\")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "\\");
                string = stringTokenizer.nextToken();
                while (stringTokenizer.hasMoreTokens()) {
                    string = string + File.separator + stringTokenizer.nextToken();
                }
            } else {
                string = string2;
            }
            this.filename.setText(string2);
            this.latexlinkText.setText(string);
        }
    }

    public void setProperties(JDRBitmap jDRBitmap) {
        if (jDRBitmap == null) {
            JDRResources.internalError((Component)this, JDRResources.getString("internal_error.no_bitmap"));
            return;
        }
        this.bitmap = jDRBitmap;
        this.filename.setText(this.bitmap.getFilename());
        this.latexlinkText.setText(this.bitmap.getLaTeXLinkName());
        this.latexCommand.setText(this.bitmap.latexCommand);
        double[] dArray = new double[6];
        jDRBitmap.getTransformation(dArray);
        for (int i = 0; i < 6; ++i) {
            this.field[i].setValue(dArray[i]);
            this.field[i].setCaretPosition(0);
        }
    }

    public void okay() {
        String string = this.filename.getText();
        String string2 = this.latexlinkText.getText();
        String string3 = this.latexCommand.getText();
        double[] dArray = new double[6];
        for (int i = 0; i < 6; ++i) {
            dArray[i] = this.field[i].getValue();
        }
        File file = new File(string);
        if (!file.exists()) {
            JDRResources.error((Component)this, new String[]{"'" + string + "'", JDRResources.getString("error.not_found")});
        } else {
            this.setVisible(false);
            JDRFrame jDRFrame = this.application_.getCurrentFrame();
            jDRFrame.setBitmapProperties(this.bitmap, string, string2, string3, dArray);
            this.bitmap = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals("okay")) {
            this.okay();
        } else if (string.equals("cancel")) {
            this.bitmap = null;
            this.setVisible(false);
        } else if (string.equals("browse")) {
            this.browseAction();
        }
    }
}

