/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uk.ac.uea.cmp.nlct.jdr.InvalidCompositeMarkerException;
import uk.ac.uea.cmp.nlct.jdr.JDRBasicStroke;
import uk.ac.uea.cmp.nlct.jdr.marker.JDRMarker;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.MarkerPanel;

public class ArrowStylePanel
extends JPanel
implements ActionListener,
AdjustmentListener,
ListSelectionListener {
    private JDRSelector selector_;
    private MarkerPanel markerPanel1;
    private MarkerPanel markerPanel2;
    protected int type_;
    public static final int START = 0;
    public static final int MID = 1;
    public static final int END = 2;
    public static final int ALL = 3;
    private JCheckBox compositeButton;
    private JCheckBox overlayButton;
    private JTabbedPane tabbedPane;

    public ArrowStylePanel(JDRSelector jDRSelector, int n) {
        this.selector_ = jDRSelector;
        this.type_ = n;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(3));
        jPanel.setAlignmentX(0.0f);
        this.add((Component)jPanel, "North");
        this.compositeButton = new JCheckBox(JDRResources.getString("arrow.composite") + " ");
        this.compositeButton.setMnemonic(JDRResources.getChar("arrow.composite.mnemonic"));
        this.compositeButton.setToolTipText(JDRResources.getString("tooltip.arrow.composite"));
        this.compositeButton.addActionListener(this);
        jPanel.add(this.compositeButton);
        this.overlayButton = new JCheckBox(JDRResources.getString("arrow.overlay") + " ");
        this.overlayButton.setMnemonic(JDRResources.getChar("arrow.overlay.mnemonic"));
        this.overlayButton.setToolTipText(JDRResources.getString("tooltip.arrow.overlay"));
        this.overlayButton.addActionListener(this);
        jPanel.add(this.overlayButton);
        this.markerPanel1 = new MarkerPanel(jDRSelector, this);
        this.markerPanel1.setAlignmentX(0.0f);
        this.markerPanel1.addListSelectionListener(this);
        this.markerPanel1.addAdjustmentListener(this);
        this.markerPanel2 = new MarkerPanel(jDRSelector, this);
        this.markerPanel2.setAlignmentX(0.0f);
        this.markerPanel2.addAdjustmentListener(this);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add(JDRResources.getString("arrow.primary") + " ", this.markerPanel1);
        this.tabbedPane.setMnemonicAt(0, JDRResources.getChar("arrow.primary.mnemonic"));
        this.tabbedPane.add(JDRResources.getString("arrow.secondary") + " ", this.markerPanel2);
        this.tabbedPane.setMnemonicAt(1, JDRResources.getChar("arrow.secondary.mnemonic"));
        this.add((Component)this.tabbedPane, "Center");
    }

    public static String getTitle(int n) {
        String string = "Unspecified Marker";
        switch (n) {
            case 0: {
                string = JDRResources.getString("linestyle.arrow.start");
                break;
            }
            case 1: {
                string = JDRResources.getString("linestyle.arrow.mid");
                break;
            }
            case 2: {
                string = JDRResources.getString("linestyle.arrow.end");
                break;
            }
            case 3: {
                string = JDRResources.getString("linestyle.arrow.all");
            }
        }
        return string;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.selector_.repaintSample();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.compositeButton) {
            this.updatePanel();
        }
        this.selector_.repaintSample();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updatePanel();
    }

    public String getDescription() {
        String string = this.markerPanel1.getDescription();
        if (this.compositeButton.isSelected()) {
            string = string + " " + this.markerPanel2.getDescription();
        }
        return string;
    }

    public JDRBasicStroke getStroke() {
        JDRBasicStroke jDRBasicStroke;
        JDRFrame jDRFrame = this.selector_.application_.getCurrentFrame();
        if (jDRFrame == null) {
            jDRBasicStroke = new JDRBasicStroke();
        } else {
            jDRBasicStroke = (JDRBasicStroke)jDRFrame.getSelectedStroke().clone();
            if (jDRBasicStroke == null) {
                jDRBasicStroke = new JDRBasicStroke();
            }
        }
        JDRMarker jDRMarker = this.getMarker();
        switch (this.type_) {
            case 0: {
                jDRBasicStroke.setStartArrow(jDRMarker);
                break;
            }
            case 1: {
                jDRBasicStroke.setMidArrow(jDRMarker);
                break;
            }
            case 2: {
                jDRBasicStroke.setEndArrow(jDRMarker);
                break;
            }
            case 3: {
                jDRBasicStroke.setStartArrow(jDRMarker);
                jDRBasicStroke.setMidArrow(jDRMarker);
                jDRBasicStroke.setEndArrow(jDRMarker);
            }
        }
        return jDRBasicStroke;
    }

    public void setStroke(JDRBasicStroke jDRBasicStroke) {
        switch (this.type_) {
            case 0: {
                this.setMarker(jDRBasicStroke.getStartArrow());
                break;
            }
            case 1: {
                this.setMarker(jDRBasicStroke.getMidArrow());
                break;
            }
            case 2: {
                this.setMarker(jDRBasicStroke.getEndArrow());
                break;
            }
            case 3: {
                this.setMarker(jDRBasicStroke.getStartArrow());
            }
        }
    }

    public JDRMarker getMarker() {
        JDRMarker jDRMarker = this.markerPanel1.getMarker();
        if (this.compositeButton.isSelected()) {
            try {
                JDRMarker jDRMarker2 = this.markerPanel2.getMarker();
                if (jDRMarker2.getType() == 0) {
                    return jDRMarker;
                }
                jDRMarker.setCompositeMarker(jDRMarker2);
                jDRMarker.setOverlay(this.overlayButton.isSelected());
            }
            catch (InvalidCompositeMarkerException invalidCompositeMarkerException) {
                JDRResources.internalError(this, JDRResources.getString("error.invalid_arrow_composite"), invalidCompositeMarkerException);
            }
        }
        return jDRMarker;
    }

    public void updatePanel() {
        if (this.markerPanel1 == null || this.tabbedPane == null) {
            return;
        }
        JDRMarker jDRMarker = this.markerPanel1.getMarker();
        boolean bl = jDRMarker != null ? jDRMarker.getType() == 0 : true;
        if (bl) {
            this.compositeButton.setSelected(false);
            this.overlayButton.setEnabled(false);
        }
        this.compositeButton.setEnabled(!bl);
        this.overlayButton.setEnabled(!bl && this.compositeButton.isSelected());
        if (this.compositeButton.isSelected()) {
            this.tabbedPane.setEnabledAt(1, true);
        } else {
            this.tabbedPane.setSelectedIndex(0);
            this.tabbedPane.setEnabledAt(1, false);
        }
    }

    public void setMarker(JDRMarker jDRMarker) {
        this.markerPanel1.setMarker(jDRMarker);
        JDRMarker jDRMarker2 = jDRMarker.getCompositeMarker();
        if (jDRMarker2 == null) {
            this.compositeButton.setSelected(false);
            this.overlayButton.setEnabled(false);
            this.tabbedPane.setSelectedIndex(0);
            this.tabbedPane.requestFocus();
            this.tabbedPane.setEnabledAt(1, false);
        } else {
            this.compositeButton.setSelected(true);
            this.overlayButton.setEnabled(true);
            this.overlayButton.setSelected(jDRMarker.isOverlaid());
            this.tabbedPane.setEnabledAt(1, true);
            this.markerPanel2.setMarker(jDRMarker2);
        }
        this.updatePanel();
    }

    public void setDefaults() {
        this.setMarker(new JDRMarker());
    }
}

