/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import uk.ac.uea.cmp.nlct.jdr.marker.JDRMarker;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.ArrowStylePanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.JDRSelector;

public class ArrowStyleDialog
extends JDialog
implements ActionListener {
    private JDRSelector selector_;
    private ArrowStylePanel panel;
    private JButton defaultButton;
    private JDRMarker oldMarker = new JDRMarker();

    public ArrowStyleDialog(JDRSelector jDRSelector, int n) {
        super(jDRSelector, ArrowStylePanel.getTitle(n), true);
        this.selector_ = jDRSelector;
        this.setLayout(new BorderLayout());
        this.panel = new ArrowStylePanel(jDRSelector, n);
        this.panel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add((Component)this.panel, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)jPanel, "South");
        jPanel.add(JDRResources.createOkayButton(this));
        jPanel.add(JDRResources.createCancelButton(this));
        jPanel.add(JDRResources.createHelpButton("sec:markers"));
        this.defaultButton = new JButton(JDRResources.getString("label.default"));
        this.defaultButton.setMnemonic(JDRResources.getChar("label.default.mnemonic"));
        this.defaultButton.addActionListener(this);
        this.defaultButton.setActionCommand("setdefaults");
        jPanel.add(this.defaultButton);
        this.pack();
        this.setLocationRelativeTo(jDRSelector);
    }

    public void init() {
        this.oldMarker = this.getMarker();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals("okay")) {
            this.okay();
        } else if (string.equals("cancel")) {
            this.cancel();
        } else if (string.equals("setdefaults")) {
            this.setDefaults();
        }
    }

    public void okay() {
        this.setVisible(false);
    }

    public void cancel() {
        this.setMarker(this.oldMarker);
        this.setVisible(false);
    }

    public String getDescription() {
        return this.panel.getDescription();
    }

    public void setMarker(JDRMarker jDRMarker) {
        this.panel.setMarker(jDRMarker);
    }

    public JDRMarker getMarker() {
        return this.panel.getMarker();
    }

    public void setDefaults() {
        this.panel.setDefaults();
        this.selector_.repaint();
    }

    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        string2 = string2 + "ArrowStyleDialog:" + string;
        string2 = string2 + "has focus: " + this.hasFocus() + string;
        string2 = string2 + "default has focus: " + this.defaultButton.hasFocus() + string;
        string2 = string2 + "old marker: " + this.oldMarker + string;
        return string2 + string;
    }
}

