/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw.dialog;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.DoubleField;

public class AnglePanel
extends JPanel
implements ItemListener {
    private DoubleField valueField;
    private JComboBox unitBox;
    private static final int DEGREES = 0;
    private static final int RADIANS = 1;
    private int currentUnit;

    public AnglePanel(String string, char c) {
        JLabel jLabel = new JLabel(string);
        jLabel.setDisplayedMnemonic(c);
        this.add(jLabel);
        this.valueField = new DoubleField(0.0);
        jLabel.setLabelFor(this.valueField);
        this.add(this.valueField);
        jLabel.setLabelFor(this.valueField);
        String[] stringArray = new String[]{JDRResources.getString("rotate.degrees"), JDRResources.getString("rotate.radians")};
        this.unitBox = new JComboBox<String>(stringArray);
        this.unitBox.addItemListener(this);
        this.currentUnit = 0;
        this.unitBox.setSelectedIndex(this.currentUnit);
        this.add(this.unitBox);
    }

    public void requestValueFocus() {
        this.valueField.requestFocusInWindow();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (itemEvent.getStateChange() == 1 && object == this.unitBox) {
            int n = this.currentUnit;
            this.currentUnit = this.unitBox.getSelectedIndex();
            if (n != this.currentUnit) {
                double d = this.valueField.getValue();
                switch (this.currentUnit) {
                    case 0: {
                        this.valueField.setValue(Math.toDegrees(d));
                        break;
                    }
                    case 1: {
                        this.valueField.setValue(Math.toRadians(d));
                    }
                }
            }
        }
    }

    public double getRadians() {
        double d = this.valueField.getValue();
        if (this.unitBox.getSelectedIndex() == 0) {
            d = Math.toRadians(d);
        }
        return d;
    }

    public void setValue(double d) {
        double d2 = d;
        if (this.unitBox.getSelectedIndex() == 0) {
            d2 = Math.toDegrees(d2);
            double d3 = Math.floor(d2);
            double d4 = 0.001 * (double)Math.round((d2 - d3) * 1000.0);
            d2 = d3 + d4;
        }
        this.valueField.setValue(d2);
    }

    public void setDegrees(double d) {
        this.unitBox.setSelectedIndex(0);
        this.valueField.setValue(d);
    }

    public void setRadians(double d) {
        this.unitBox.setSelectedIndex(1);
        this.valueField.setValue(d);
    }
}

