/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;

public class StatusBar
extends JPanel {
    private JLabel pos;
    private JLabel modifiedLabel;
    private JLabel lockLabel;
    private JTextField infoField;
    private Icon lockIcon;
    private Icon unlockIcon;
    private Dimension posDim;
    private Dimension modDim;

    public StatusBar(int n, int n2) {
        JLabel jLabel = new JLabel("000.0,000.0 bp ");
        this.posDim = jLabel.getPreferredSize();
        jLabel = new JLabel(JDRResources.getString("info.modified") + " ");
        this.modDim = jLabel.getPreferredSize();
        jLabel = null;
        this.pos = new JLabel(){

            @Override
            public Dimension getPreferredSize() {
                return StatusBar.this.posDim;
            }

            @Override
            public Dimension getSize() {
                return StatusBar.this.posDim;
            }

            @Override
            public Dimension getMinimumSize() {
                return StatusBar.this.posDim;
            }

            @Override
            public Dimension getMaximumSize() {
                return StatusBar.this.posDim;
            }
        };
        this.pos.setText(" ");
        this.modifiedLabel = new JLabel(){

            @Override
            public Dimension getPreferredSize() {
                return StatusBar.this.modDim;
            }

            @Override
            public Dimension getSize() {
                return StatusBar.this.modDim;
            }

            @Override
            public Dimension getMinimumSize() {
                return StatusBar.this.modDim;
            }

            @Override
            public Dimension getMaximumSize() {
                return StatusBar.this.modDim;
            }
        };
        this.modifiedLabel.setText(" ");
        this.lockIcon = JDRResources.appIcon("key.png");
        this.unlockIcon = JDRResources.appIcon("keycross.png");
        this.lockLabel = new JLabel(this.unlockIcon);
        this.infoField = new JTextField();
        this.infoField.setEditable(false);
        this.infoField.setFocusable(false);
        this.infoField.setDragEnabled(false);
        this.infoField.setHighlighter(null);
        this.setAlignmentX(0.0f);
        this.pos.setAlignmentX(0.0f);
        this.modifiedLabel.setAlignmentX(0.0f);
        this.lockLabel.setAlignmentX(0.5f);
        this.infoField.setAlignmentX(0.0f);
        BoxLayout boxLayout = new BoxLayout(this, 0);
        this.setLayout(boxLayout);
        this.add(this.pos);
        this.add(this.modifiedLabel);
        this.add(this.lockLabel);
        this.add(this.infoField);
        this.setPreferredSize(new Dimension(n, n2));
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.pos.setBorder(BorderFactory.createLoweredBevelBorder());
        this.modifiedLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.lockLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.infoField.setBorder(null);
        this.infoField.setMinimumSize(new Dimension(0, 0));
    }

    public void setInfo(String string) {
        this.infoField.setText(string);
        this.infoField.setCaretPosition(0);
    }

    public String getInfo() {
        return this.infoField.getText();
    }

    public void setLock(boolean bl) {
        if (bl) {
            this.lockLabel.setIcon(this.lockIcon);
        } else {
            this.lockLabel.setIcon(this.unlockIcon);
        }
    }

    public void setPosition(String string) {
        this.pos.setEnabled(true);
        this.pos.setText(string + " ");
    }

    public void setModified(boolean bl) {
        this.modifiedLabel.setEnabled(true);
        this.modifiedLabel.setText(bl ? JDRResources.getString("info.modified") : " ");
    }

    public void enableStatus() {
        this.pos.setEnabled(true);
        this.modifiedLabel.setEnabled(true);
        this.lockLabel.setEnabled(true);
    }

    public void noFramesSelected(int n) {
        if (n == 0) {
            this.setInfo(JDRResources.getString("info.no_frames"));
        } else {
            this.setInfo(JDRResources.getString("info.no_frames_selected"));
        }
        this.pos.setEnabled(false);
        this.modifiedLabel.setEnabled(false);
        this.lockLabel.setEnabled(false);
    }
}

