/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;

class StartupProgress
extends Thread {
    private JFrame startup = null;
    private JLabel startupInfo;
    private JProgressBar startupProgress;
    private boolean running;

    public StartupProgress() {
        this.initialiseStartup();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.running = true;
        try {
            while (this.running) {
                StartupProgress startupProgress = this;
                synchronized (startupProgress) {
                    this.wait(100L);
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void toFront() {
        this.startup.toFront();
    }

    public synchronized void dismiss() {
        this.startup.setVisible(false);
        this.running = false;
    }

    private synchronized void initialiseStartup() {
        Object object;
        this.startup = new JFrame();
        this.startup.setUndecorated(true);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n = dimension.height;
        int n2 = dimension.width;
        int n3 = 550;
        int n4 = 200;
        this.startup.setIconImage(JDRResources.appIcon("jdrlogosmall.png").getImage());
        this.startup.setTitle(JDRResources.getString("startup.title"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.startup.getContentPane().add(jPanel);
        Box box = Box.createVerticalBox();
        box.add(new JLabel(JDRResources.getStringWithValue("about.version", new String[]{"Jpgfdraw", "0.5.6b"}) + " "));
        box.add(Box.createGlue());
        box.add(new JLabel(JDRResources.getString("about.copyright") + " 2006 Nicola L.C. Talbot "));
        box.add(Box.createGlue());
        box.add(new JLabel(JDRResources.getStringWithValue("about.disclaimer", "Jpgfdraw") + " "));
        box.add(new JLabel(JDRResources.getString("about.see_licence") + " "));
        box.add(Box.createGlue());
        box.add(new JLabel("http://www.dickimaw-books.com/ "));
        box.add(Box.createGlue());
        String string = JDRResources.getString("about.translator");
        if (string.length() > 0 && !string.equals("?unknown?")) {
            String string2;
            box.add(new JLabel(JDRResources.getString("about.translated_by") + " "));
            box.add(Box.createGlue());
            box.add(new JLabel(string));
            box.add(Box.createGlue());
            object = JDRResources.getString("about.translator_url");
            if (((String)object).length() > 0 && !((String)object).equals("?unknown?")) {
                box.add(new JLabel((String)object + " "));
                box.add(Box.createGlue());
            }
            if ((string2 = JDRResources.getString("about.translator_info")).length() > 0 && !string2.equals("?unknown?")) {
                box.add(new JLabel(string2 + " "));
                box.add(Box.createGlue());
            }
            n4 += 200;
        }
        this.startup.setSize(n3, n4);
        this.startup.setLocation((n2 - n3) / 2, (n - n4) / 2);
        box.add(Box.createGlue());
        this.startupInfo = new JLabel("");
        box.add(this.startupInfo);
        this.startupProgress = new JProgressBar();
        box.add(this.startupProgress);
        jPanel.add((Component)box, "Center");
        object = Box.createVerticalBox();
        ((Container)object).add(new JLabel(JDRResources.appIcon("jdrlogolarge.png")));
        ((Container)object).add(Box.createGlue());
        jPanel.add((Component)object, "East");
        this.startup.setVisible(true);
    }

    public synchronized void setInfo(String string) {
        this.startupInfo.setText(string);
    }

    public synchronized String getInfo() {
        return this.startupInfo.getText();
    }

    public synchronized void setDeterminate(int n) {
        this.startupProgress.setIndeterminate(false);
        this.startupProgress.setMaximum(n);
        this.startupProgress.setValue(0);
    }

    public synchronized void incProgress() {
        this.startupProgress.setValue(this.startupProgress.getValue() + 1);
    }

    public synchronized void setIndeterminate() {
        this.startupProgress.setIndeterminate(true);
    }
}

