/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import uk.ac.uea.cmp.nlct.jdr.EmptyPathException;
import uk.ac.uea.cmp.nlct.jdr.InvalidPathException;
import uk.ac.uea.cmp.nlct.jdr.JDRBasicStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRBitmap;
import uk.ac.uea.cmp.nlct.jdr.JDRColor;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPath;
import uk.ac.uea.cmp.nlct.jdr.JDRSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRTransparent;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.VectorizeBitmapDialog;

public class ScanImage
extends JFrame
implements Runnable {
    private JDRBitmap bitmap;
    private BufferedImage buffImage = null;
    private Dimension icSize;
    private int xInc;
    private int yInc;
    private int y0;
    private int y1;
    private Color base;
    private double tolerance;
    private boolean doSmooth = true;
    private boolean doStraighten = true;
    private Area area = null;
    private JDRPath jdrpath = null;
    private GeneralPath smoothingPath = null;
    private CubicCurve2D.Double bezier = null;
    private CubicCurve2D.Double bestBezier = null;
    private CurveFitParams[] params = null;
    private JTextField info;
    private JDRFrame frame;
    private ScanImagePanel scanImagePanel;
    private boolean abortNow = false;
    private Thread thread = null;
    private double flatness = 1.0;
    private double chi = 2.0;
    private double delta = 0.01;
    private double gamma = 0.5;
    private double rho = 1.0;
    private double sigma = 0.5;
    private double maxIter = 200.0;
    private double maxFunEvals = 1000.0;
    private double tolFun = 1.0E-6;
    private double tolX = 1.0E-6;

    public ScanImage(JDRFrame jDRFrame, JDRBitmap jDRBitmap, VectorizeBitmapDialog vectorizeBitmapDialog) {
        super(JDRResources.getString("vectorize.scanning"));
        this.frame = jDRFrame;
        this.bitmap = jDRBitmap;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ScanImage.this.abort();
            }
        });
        this.xInc = vectorizeBitmapDialog.getXInc();
        if (this.xInc <= 0) {
            throw new IllegalArgumentException("xInc must be > 0");
        }
        this.yInc = vectorizeBitmapDialog.getYInc();
        if (this.yInc <= 0) {
            throw new IllegalArgumentException("yInc must be > 0");
        }
        this.base = vectorizeBitmapDialog.getBase();
        this.doStraighten = vectorizeBitmapDialog.isStraightenSelected();
        if (this.doStraighten) {
            this.tolerance = vectorizeBitmapDialog.getStraightenTolerance();
            if (this.tolerance < 0.0) {
                throw new IllegalArgumentException("tolerance must be >= 0");
            }
        }
        this.doSmooth = vectorizeBitmapDialog.isSmoothSelected();
        if (this.doSmooth) {
            this.chi = vectorizeBitmapDialog.getChi();
            this.delta = vectorizeBitmapDialog.getDelta();
            this.gamma = vectorizeBitmapDialog.getGamma();
            this.rho = vectorizeBitmapDialog.getRho();
            this.sigma = vectorizeBitmapDialog.getSigma();
            this.tolFun = vectorizeBitmapDialog.getSmoothTolFun();
            this.tolX = vectorizeBitmapDialog.getSmoothTol();
            this.flatness = vectorizeBitmapDialog.getFlatness();
        }
        this.icSize = new Dimension(jDRBitmap.getWidth(), jDRBitmap.getHeight());
        this.scanImagePanel = new ScanImagePanel();
        this.scanImagePanel.setBackground(Color.white);
        this.getContentPane().add((Component)new JScrollPane(this.scanImagePanel), "Center");
        this.info = new JTextField(JDRResources.getString("vectorize.initializing"));
        this.info.setEditable(false);
        this.getContentPane().add((Component)this.info, "South");
        this.pack();
        this.setLocationRelativeTo(jDRFrame);
    }

    public void performScan() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public boolean isBaseRGB(int n) {
        return n == this.base.getRGB();
    }

    @Override
    public void run() {
        this.setVisible(true);
        try {
            this.doScan();
        }
        catch (InterruptedException interruptedException) {
            JDRResources.error((Component)this, JDRResources.getString("vectorize.aborted"));
        }
        catch (Exception exception) {
            JDRResources.error((Component)this, JDRResources.getString("vectorize.failed"));
        }
        this.setVisible(false);
        this.thread = null;
    }

    private void doScan() throws InvalidPathException, InterruptedException {
        Image image = this.bitmap.getImage();
        this.buffImage = new BufferedImage(this.icSize.width, this.yInc, 2);
        this.area = new Area();
        GeneralPath generalPath = new GeneralPath(1, 6);
        this.y0 = 0;
        this.y1 = this.yInc;
        Color color = new Color(255 - this.base.getRed(), 255 - this.base.getGreen(), 255 - this.base.getBlue());
        while (this.y0 < this.icSize.height) {
            int n;
            this.checkForAbort();
            if (this.y1 >= this.icSize.height) {
                this.y1 = this.icSize.height - 1;
            }
            if ((n = this.y1 - this.y0) <= 0) break;
            this.info.setText("y0=" + this.y0 + ", y1=" + this.y1);
            Graphics2D graphics2D = this.buffImage.createGraphics();
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, this.icSize.width, this.yInc);
            graphics2D.setClip(0, 0, this.icSize.width, n);
            ((Graphics)graphics2D).translate(0, -this.y0);
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
            int n2 = 0;
            int n3 = this.xInc;
            while (n2 < this.icSize.width) {
                int n4;
                this.checkForAbort();
                if (n3 >= this.icSize.width) {
                    n3 = this.icSize.width - 1;
                }
                if ((n4 = n3 - n2) <= 0) break;
                boolean bl = this.isBaseRGB(this.buffImage.getRGB(n2, 0));
                boolean bl2 = this.isBaseRGB(this.buffImage.getRGB(n3 - 1, 0));
                boolean bl3 = this.isBaseRGB(this.buffImage.getRGB(n2, n - 1));
                boolean bl4 = this.isBaseRGB(this.buffImage.getRGB(n3 - 1, n - 1));
                if (!(bl || bl2 || bl3 || bl4)) {
                    n2 = n3;
                    n3 += this.xInc;
                    continue;
                }
                generalPath.reset();
                if (bl) {
                    if (bl2) {
                        generalPath.moveTo(n2, this.y0);
                        generalPath.lineTo(n3, this.y0);
                    } else {
                        generalPath.moveTo(n2, this.y0);
                        generalPath.lineTo((float)((double)n2 + 0.5 * (double)n4), this.y0);
                    }
                } else if (bl2) {
                    generalPath.moveTo((float)((double)n2 + 0.5 * (double)n4), this.y0);
                    generalPath.lineTo(n3, this.y0);
                } else {
                    generalPath.moveTo(n2, (float)((double)this.y0 + 0.5 * (double)n));
                    generalPath.lineTo(n3, (float)((double)this.y0 + 0.5 * (double)n));
                }
                if (bl4) {
                    if (bl3) {
                        generalPath.lineTo(n3, this.y1);
                        generalPath.lineTo(n2, this.y1);
                    } else {
                        generalPath.lineTo(n3, this.y1);
                        generalPath.lineTo((float)((double)n2 + 0.5 * (double)n4), this.y1);
                    }
                } else if (bl3) {
                    generalPath.lineTo((float)((double)n2 + 0.5 * (double)n4), this.y1);
                    generalPath.lineTo(n2, this.y1);
                } else {
                    generalPath.lineTo(n3, (float)((double)this.y0 + 0.5 * (double)n4));
                    generalPath.lineTo(n2, (float)((double)this.y0 + 0.5 * (double)n4));
                }
                generalPath.closePath();
                this.checkForAbort();
                this.area.add(new Area(generalPath));
                this.repaint();
                n2 = n3;
                n3 += this.xInc;
            }
            this.y0 = this.y1;
            this.y1 += this.yInc;
        }
        this.checkForAbort();
        this.jdrpath = JDRPath.getPath(this.area.getPathIterator(null));
        this.jdrpath.setLinePaint(new JDRColor(this.base));
        this.jdrpath.setFillPaint(new JDRTransparent());
        this.jdrpath.setStroke(new JDRBasicStroke());
        if (!this.isValidPath()) {
            JDRResources.error((Component)this, JDRResources.getString("vectorize.failed"));
            this.setVisible(false);
            return;
        }
        if (this.doStraighten) {
            this.checkForAbort();
            this.info.setText(JDRResources.getString("vectorize.straightening"));
            this.jdrpath.smoothLines(this.tolerance);
            if (!this.isValidPath()) {
                JDRResources.error((Component)this, JDRResources.getString("vectorize.failed"));
                this.setVisible(false);
                return;
            }
        }
        this.area = null;
        this.scanImagePanel.repaint();
        if (this.doSmooth) {
            this.checkForAbort();
            this.info.setText(JDRResources.getString("vectorize.smoothing"));
            this.smooth();
            if (!this.isValidPath()) {
                JDRResources.error((Component)this, JDRResources.getString("vectorize.failed"));
                this.setVisible(false);
                return;
            }
        }
        this.frame.addObject(this.jdrpath, JDRResources.getString("undo.vectorize"));
    }

    private boolean isValidPath() {
        try {
            Shape shape = this.jdrpath.getStrokedPath();
            return true;
        }
        catch (IllegalPathStateException illegalPathStateException) {
            System.err.println("Invalid path");
            int n = this.jdrpath.size();
            System.err.println("size: " + n);
            for (int i = 0; i < n; ++i) {
                System.err.println(this.jdrpath.get(i));
            }
            return false;
        }
    }

    private void smooth() throws InvalidPathException, InterruptedException {
        Object object;
        int n = this.jdrpath.size();
        if (n == 0) {
            throw new EmptyPathException();
        }
        double d = Math.sqrt(this.xInc * this.xInc + this.yInc * this.yInc);
        int n2 = 1;
        JDRStroke jDRStroke = this.jdrpath.getStroke();
        if (jDRStroke != null) {
            n2 = ((JDRBasicStroke)jDRStroke).getWindingRule();
        }
        this.smoothingPath = null;
        GeneralPath generalPath = null;
        int n3 = 0;
        Object object2 = null;
        Point2D point2D = null;
        for (int i = 0; i < n; ++i) {
            this.checkForAbort();
            object = (JDRSegment)this.jdrpath.get(i);
            double d2 = ((JDRSegment)object).getStartX();
            double d3 = ((JDRSegment)object).getEndX();
            double d4 = ((JDRSegment)object).getStartY();
            double d5 = ((JDRSegment)object).getEndY();
            double d6 = d2 - d3;
            double d7 = d4 - d5;
            double d8 = Math.sqrt(d6 * d6 + d7 * d7);
            if (d8 > d || ((JDRSegment)object).isGap()) {
                if (generalPath == null) {
                    if (this.smoothingPath == null) {
                        this.smoothingPath = new GeneralPath(n2, n);
                        this.smoothingPath.moveTo((float)d2, (float)d4);
                    }
                    this.smoothingPath.lineTo((float)d3, (float)d5);
                } else if (n3 == 1) {
                    if (this.smoothingPath == null) {
                        this.smoothingPath = generalPath;
                    } else {
                        this.smoothingPath.append(generalPath, true);
                    }
                    this.smoothingPath.lineTo((float)d3, (float)d5);
                    generalPath = null;
                    n3 = 0;
                } else {
                    this.smoothSubPath(point2D, generalPath, n3);
                    generalPath = null;
                    n3 = 0;
                }
                this.scanImagePanel.repaint();
            } else {
                if (generalPath == null) {
                    generalPath = new GeneralPath();
                    generalPath.moveTo((float)d2, (float)d4);
                    n3 = 1;
                    if (object2 != null) {
                        point2D = ((JDRSegment)object2).getdP1();
                    }
                }
                generalPath.lineTo((float)d3, (float)d5);
                ++n3;
            }
            object2 = object;
        }
        if (generalPath != null) {
            this.smoothSubPath(point2D, generalPath, n3);
            generalPath = null;
        }
        if (this.jdrpath.isClosed()) {
            this.smoothingPath.closePath();
        }
        JDRPaint jDRPaint = this.jdrpath.getLinePaint();
        object = this.jdrpath.getFillPaint();
        this.jdrpath = JDRPath.getPath(this.smoothingPath.getPathIterator(null));
        this.jdrpath.setStroke(jDRStroke);
        this.jdrpath.setLinePaint(jDRPaint);
        this.jdrpath.setFillPaint((JDRPaint)object);
        this.scanImagePanel.repaint();
    }

    public void smoothSubPath(Point2D point2D, GeneralPath generalPath, int n) throws InterruptedException {
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        PathIterator pathIterator = generalPath.getPathIterator(null);
        double[] dArray3 = new double[6];
        int n2 = 0;
        while (!pathIterator.isDone()) {
            this.checkForAbort();
            int n3 = pathIterator.currentSegment(dArray3);
            dArray[n2] = dArray3[0];
            dArray2[n2] = dArray3[1];
            pathIterator.next();
            ++n2;
        }
        this.smoothSubPath(point2D, dArray, dArray2, 0, n - 1);
    }

    private void smoothSubPath(Point2D point2D, double[] dArray, double[] dArray2, int n, int n2) throws InterruptedException {
        int n3;
        this.bestBezier = null;
        int n4 = -1;
        double d = Double.MAX_VALUE;
        this.bezier = new CubicCurve2D.Double();
        for (n3 = n2; n3 > n + 1; --n3) {
            this.checkForAbort();
            double d2 = this.fitBezier(point2D, dArray, dArray2, n, n3);
            if (d2 < d) {
                n4 = n3;
                d = d2;
                if (this.bestBezier == null) {
                    this.bestBezier = new CubicCurve2D.Double();
                }
                this.bestBezier.setCurve(this.bezier);
                this.scanImagePanel.repaint();
            }
            this.info.setText("best=" + d + ", current=" + d2);
        }
        this.bezier = null;
        if (this.bestBezier == null || n4 == -1) {
            for (n3 = n; n3 <= n2; ++n3) {
                this.checkForAbort();
                if (this.smoothingPath == null) {
                    this.smoothingPath = new GeneralPath();
                    this.smoothingPath.moveTo((float)dArray[n3], (float)dArray2[n3]);
                    continue;
                }
                this.smoothingPath.lineTo((float)dArray[n3], (float)dArray2[n3]);
            }
            return;
        }
        if (this.smoothingPath == null) {
            this.smoothingPath = new GeneralPath(this.bestBezier);
        } else {
            this.smoothingPath.append(this.bestBezier, true);
        }
        this.scanImagePanel.repaint();
        if (n4 < n2) {
            this.smoothSubPath(point2D, dArray, dArray2, n4, n2);
        }
    }

    private double bezierFitFunction(Point2D point2D, double d, double d2, double d3, double d4, double[] dArray, double[] dArray2, int n, int n2) throws InterruptedException {
        int n3;
        double d5 = dArray[n];
        double d6 = dArray2[n];
        double d7 = dArray[n2];
        double d8 = dArray2[n2];
        GeneralPath generalPath = new GeneralPath(1, 3);
        generalPath.moveTo((float)d5, (float)d6);
        generalPath.curveTo((float)d, (float)d2, (float)d3, (float)d4, (float)d7, (float)d8);
        this.checkForAbort();
        PathIterator pathIterator = generalPath.getPathIterator(null, this.flatness);
        double d9 = 0.0;
        double[] dArray3 = new double[6];
        while (!pathIterator.isDone()) {
            this.checkForAbort();
            n3 = pathIterator.currentSegment(dArray3);
            pathIterator.next();
            if (n3 != 1) continue;
            if (pathIterator.isDone()) break;
            double d10 = Double.MAX_VALUE;
            double d11 = dArray3[0];
            double d12 = dArray3[1];
            for (int i = n + 1; i < n2; ++i) {
                this.checkForAbort();
                double d13 = d11 - dArray[i];
                double d14 = d12 - dArray2[i];
                double d15 = d13 * d13 + d14 * d14;
                if (!(d15 < d10)) continue;
                d10 = d15;
            }
            d9 += d10;
        }
        if (point2D != null) {
            double d16 = 3.0 * (d - d5) - point2D.getX();
            double d17 = 3.0 * (d2 - d6) - point2D.getY();
            d9 *= d16 * d16 + d17 * d17;
        }
        n3 = n2 - n + 1;
        n3 = n3 * n3 * n3 * n3;
        return d9 / (double)n3;
    }

    private double fitBezier(Point2D point2D, double[] dArray, double[] dArray2, int n, int n2) throws InterruptedException {
        double d;
        double d2 = dArray[n];
        double d3 = dArray2[n];
        double d4 = dArray[n2];
        double d5 = dArray2[n2];
        int n3 = (int)Math.round(0.5 * (double)(n2 - n)) + n;
        if (n3 > n2) {
            n3 = n2;
        }
        if (n3 < n) {
            n3 = n;
        }
        this.bezier.setCurve(d2, d3, dArray[n3], dArray2[n3], dArray[n3], dArray2[n3], d4, d5);
        this.params = new CurveFitParams[5];
        this.params[4] = new CurveFitParams(this.bezier);
        this.params[4].computeY(point2D, dArray, dArray2, n, n2);
        for (int i = 0; i < 4; ++i) {
            double[] dArray3 = new double[4];
            this.params[4].getParams(dArray3);
            int n4 = i;
            dArray3[n4] = dArray3[n4] + this.delta;
            this.params[i] = new CurveFitParams(dArray3);
            this.params[i].computeY(point2D, dArray, dArray2, n, n2);
        }
        double[] dArray4 = new double[4];
        double[] dArray5 = new double[4];
        double[] dArray6 = new double[4];
        double[] dArray7 = new double[4];
        int n5 = 0;
        int n6 = 0;
        n6 = 2;
        while ((double)n6 <= this.maxIter) {
            int n7;
            int n8;
            this.checkForAbort();
            Arrays.sort(this.params);
            for (n8 = 0; n8 < 4; ++n8) {
                dArray4[n8] = this.params[n8].getMean();
                dArray5[n8] = dArray4[n8] + this.rho * (dArray4[n8] - this.params[4].x[n8]);
            }
            double d6 = this.bezierFitFunction(point2D, dArray5[0], dArray5[1], dArray5[2], dArray5[3], dArray, dArray2, n, n2);
            if (d6 >= this.params[0].y && d6 < this.params[3].y) {
                this.params[4].setParams(dArray5);
                this.params[4].y = d6;
            } else if (d6 < this.params[0].y) {
                for (n8 = 0; n8 < 4; ++n8) {
                    dArray6[n8] = dArray4[n8] + this.chi * (dArray5[n8] - dArray4[n8]);
                }
                double d7 = this.bezierFitFunction(point2D, dArray6[0], dArray6[1], dArray6[2], dArray6[3], dArray, dArray2, n, n2);
                if (d7 < d6) {
                    this.params[4].setParams(dArray6);
                    this.params[4].y = d7;
                } else {
                    this.params[4].setParams(dArray5);
                    this.params[4].y = d6;
                }
            } else {
                double d8;
                int n9;
                n8 = 0;
                if (this.params[3].y <= d6 && d6 < this.params[4].y) {
                    for (n9 = 0; n9 < 4; ++n9) {
                        dArray7[n9] = dArray4[n9] + this.gamma * (dArray5[n9] - dArray4[n9]);
                    }
                    d8 = this.bezierFitFunction(point2D, dArray7[0], dArray7[1], dArray7[2], dArray7[3], dArray, dArray2, n, n2);
                    if (d8 <= d6) {
                        this.params[4].setParams(dArray7);
                        this.params[4].y = d8;
                    } else {
                        n8 = 1;
                    }
                } else {
                    for (n9 = 0; n9 < 4; ++n9) {
                        dArray7[n9] = dArray4[n9] + this.gamma * (dArray4[n9] - this.params[4].x[n9]);
                    }
                    d8 = this.bezierFitFunction(point2D, dArray7[0], dArray7[1], dArray7[2], dArray7[3], dArray, dArray2, n, n2);
                    if (d8 <= this.params[4].y) {
                        this.params[4].setParams(dArray7);
                        this.params[4].y = d8;
                    } else {
                        n8 = 1;
                    }
                }
                if (n8 != 0) {
                    for (n9 = 1; n9 < 5; ++n9) {
                        for (int i = 0; i < 4; ++i) {
                            this.params[n9].x[i] = this.params[0].x[i] + this.sigma * (this.params[n9].x[i] - this.params[0].x[i]);
                        }
                        this.params[n9].computeY(point2D, dArray, dArray2, n, n2);
                    }
                }
            }
            d = 0.0;
            double d9 = Double.MAX_VALUE;
            for (int i = 0; i < 5; ++i) {
                if (this.params[i].y > d) {
                    d = this.params[i].y;
                }
                if (!(this.params[i].y < d9)) continue;
                d9 = this.params[i].y;
                n5 = i;
            }
            double d10 = 0.0;
            for (n7 = 0; n7 < 4; ++n7) {
                double d11;
                double d12 = d11 = this.params[0].x[n7];
                for (int i = 1; i < 5; ++i) {
                    if (this.params[i].x[n7] < d11) {
                        d11 = this.params[i].x[n7];
                    }
                    if (!(this.params[i].x[n7] > d12)) continue;
                    d12 = this.params[i].x[n7];
                }
                double d13 = Math.abs(d11 - d12);
                if (!(d13 > d10)) continue;
                d10 = d13;
            }
            if (d10 < this.tolX || Math.abs(d - d9) / d < this.tolFun) break;
            for (n7 = 0; n7 < 5; ++n7) {
                this.params[n7].updateBezier();
                this.scanImagePanel.repaint();
            }
            ++n6;
        }
        if ((double)n6 == this.maxIter) {
            System.err.println("Exceeded maximum iterations");
        }
        this.params[n5].updateBezier();
        d = this.params[n5].y;
        this.params = null;
        return d;
    }

    public synchronized void abort() {
        int n = JOptionPane.showConfirmDialog(this, JDRResources.getString("vectorize.confirm_abort"), JDRResources.getString("warning.title"), 0, 2);
        if (n != 0) {
            return;
        }
        this.abortNow = true;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    protected void checkForAbort() throws InterruptedException {
        if (this.abortNow) {
            throw new InterruptedException("Process Aborted");
        }
    }

    class ScanImagePanel
    extends JPanel {
        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics.setColor(Color.black);
            if (ScanImage.this.area != null) {
                graphics2D.draw(ScanImage.this.area);
            }
            if (ScanImage.this.smoothingPath != null) {
                graphics2D.draw(ScanImage.this.smoothingPath);
            }
            if (ScanImage.this.bestBezier != null) {
                graphics.setColor(Color.green);
                graphics2D.draw(ScanImage.this.bestBezier);
            }
            if (ScanImage.this.params != null) {
                graphics.setColor(Color.blue);
                for (int i = 0; ScanImage.this.params != null && i < ScanImage.this.params.length; ++i) {
                    CurveFitParams curveFitParams = ScanImage.this.params[i];
                    if (curveFitParams == null) continue;
                    curveFitParams.draw(graphics);
                }
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return ScanImage.this.icSize;
        }
    }

    class CurveFitParams
    implements Comparable {
        protected double[] x;
        protected double y;

        public CurveFitParams(double[] dArray) {
            this.x = dArray;
        }

        public CurveFitParams(double d, double d2, double d3, double d4) {
            this.x = new double[4];
            this.x[0] = d;
            this.x[1] = d2;
            this.x[2] = d3;
            this.x[3] = d4;
        }

        public CurveFitParams(CubicCurve2D.Double double_) {
            this(double_.ctrlx1, double_.ctrly1, double_.ctrlx2, double_.ctrly2);
        }

        public void getParams(double[] dArray) {
            for (int i = 0; i < 4; ++i) {
                dArray[i] = this.x[i];
            }
        }

        public void setParams(double[] dArray) {
            for (int i = 0; i < 4; ++i) {
                this.x[i] = dArray[i];
            }
        }

        public int compareTo(Object object) {
            CurveFitParams curveFitParams = (CurveFitParams)object;
            if (this.y == curveFitParams.y) {
                return 0;
            }
            return this.y < curveFitParams.y ? -1 : 1;
        }

        public void updateBezier() {
            ((ScanImage)ScanImage.this).bezier.ctrlx1 = this.x[0];
            ((ScanImage)ScanImage.this).bezier.ctrly1 = this.x[1];
            ((ScanImage)ScanImage.this).bezier.ctrlx2 = this.x[2];
            ((ScanImage)ScanImage.this).bezier.ctrly2 = this.x[3];
        }

        public void draw(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.draw(new CubicCurve2D.Double(((ScanImage)ScanImage.this).bezier.x1, ((ScanImage)ScanImage.this).bezier.y1, this.x[0], this.x[1], this.x[2], this.x[3], ((ScanImage)ScanImage.this).bezier.x2, ((ScanImage)ScanImage.this).bezier.y2));
        }

        public void computeY(Point2D point2D, double[] dArray, double[] dArray2, int n, int n2) throws InterruptedException {
            this.y = ScanImage.this.bezierFitFunction(point2D, this.x[0], this.x[1], this.x[2], this.x[3], dArray, dArray2, n, n2);
        }

        public double getMean() {
            double d = 0.0;
            for (int i = 0; i < this.x.length; ++i) {
                d += this.x[i];
            }
            return d / (double)this.x.length;
        }
    }
}

