/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw;

import java.awt.Component;
import java.awt.Cursor;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import uk.ac.uea.cmp.nlct.jdr.CanvasSettings;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;

public class SaveJdr
implements Runnable {
    private String fileName;
    private float jdrVersion;
    private JDRGroup jdrImage;
    private JDRFrame jdrFrame;
    private CanvasSettings canvasSettings;

    private SaveJdr() {
    }

    public SaveJdr(JDRFrame jDRFrame, String string, float f, JDRGroup jDRGroup) {
        this(jDRFrame, string, f, jDRGroup, null);
    }

    public SaveJdr(JDRFrame jDRFrame, String string, float f, JDRGroup jDRGroup, CanvasSettings canvasSettings) {
        this.jdrFrame = jDRFrame;
        this.fileName = string;
        this.jdrVersion = f;
        this.jdrImage = jDRGroup;
        this.canvasSettings = canvasSettings;
    }

    @Override
    public void run() {
        DataOutputStream dataOutputStream;
        this.jdrFrame.setIoInProgress(true);
        boolean bl = false;
        Cursor cursor = this.jdrFrame.getCursor();
        this.jdrFrame.setCursor(Cursor.getPredefinedCursor(3));
        JpgfDraw jpgfDraw = this.jdrFrame.getApplication();
        JpgfDraw.showMessageFrame(JDRResources.getStringWithValue("info.saving", this.fileName));
        jpgfDraw.setStatusInfo(JDRResources.getStringWithValue("info.saving", this.fileName));
        try {
            dataOutputStream = new DataOutputStream(new FileOutputStream(this.fileName));
        }
        catch (IOException iOException) {
            JDRResources.error((Component)this.jdrFrame, new String[]{JDRResources.getStringWithValue("error.io.open", this.fileName), iOException.getMessage()});
            this.jdrFrame.setIoInProgress(false);
            jpgfDraw.hideMessageFrame();
            this.jdrFrame.setCursor(cursor);
            jpgfDraw.setTool(this.jdrFrame.currentTool());
            return;
        }
        try {
            if (this.canvasSettings != null) {
                JDR.save(this.jdrImage, this.canvasSettings, dataOutputStream, this.jdrVersion);
            } else {
                JDR.save(this.jdrImage, dataOutputStream, this.jdrVersion);
            }
            bl = true;
        }
        catch (IOException iOException) {
            JDRResources.error((Component)this.jdrFrame, new String[]{JDRResources.getString("error.io.save"), iOException.getMessage()});
        }
        catch (Exception exception) {
            JDRResources.internalError((Component)this.jdrFrame, exception);
        }
        this.jdrFrame.setIoInProgress(false);
        jpgfDraw.hideMessageFrame();
        try {
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            JDRResources.error((Component)this.jdrFrame, new String[]{JDRResources.getString("error.io.close"), iOException.getMessage()});
        }
        if (bl) {
            this.jdrFrame.setFilename(this.fileName);
            this.jdrFrame.markAsSaved();
            this.jdrFrame.addRecentFile(this.fileName);
        }
        this.jdrFrame.setCursor(cursor);
        jpgfDraw.setTool(this.jdrFrame.currentTool());
    }
}

