/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw;

import java.awt.Component;
import java.awt.Cursor;
import java.io.IOException;
import javax.swing.JOptionPane;
import uk.ac.uea.cmp.nlct.jdr.InvalidShapeException;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.MissingTypeBlockException;
import uk.ac.uea.cmp.nlct.jdr.MissplacedTypeBlockException;
import uk.ac.uea.cmp.nlct.jdr.io.FLF;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;

public class SaveFlf
implements Runnable {
    private String fileName;
    private JDRGroup image;
    private JDRFrame jdrFrame;

    private SaveFlf() {
    }

    public SaveFlf(JDRFrame jDRFrame, String string, JDRGroup jDRGroup) {
        this.jdrFrame = jDRFrame;
        this.fileName = string;
        this.image = jDRGroup;
    }

    @Override
    public void run() {
        this.jdrFrame.setIoInProgress(true);
        Cursor cursor = this.jdrFrame.getCursor();
        this.jdrFrame.setCursor(Cursor.getPredefinedCursor(3));
        JpgfDraw jpgfDraw = this.jdrFrame.getApplication();
        JpgfDraw.showMessageFrame(JDRResources.getStringWithValue("info.saving", this.fileName));
        jpgfDraw.setStatusInfo(JDRResources.getStringWithValue("info.saving", this.fileName));
        try {
            String[] stringArray = new String[2];
            stringArray[0] = "Jpgfdraw";
            stringArray[1] = "0.5.6b";
            FLF.save(this.image, this.fileName, this.jdrFrame.getPaper(), this.jdrFrame.getLaTeXFonts(), JDRResources.getStringWithValue("tex.comment.created_by", stringArray), this.jdrFrame.getFilename());
            if (!this.image.anyFlowFrameData()) {
                JDRResources.warning((Component)this.jdrFrame, JDRResources.getString("warning.no_flowframe_data"));
            }
        }
        catch (MissingTypeBlockException missingTypeBlockException) {
            JDRResources.error((Component)this.jdrFrame, JDRResources.getString("error.no_typeblock"));
        }
        catch (MissplacedTypeBlockException missplacedTypeBlockException) {
            JDRResources.internalError(this.jdrFrame, JDRResources.getString("error.invalid_frame_type"), missplacedTypeBlockException);
        }
        catch (InvalidShapeException invalidShapeException) {
            JOptionPane.showMessageDialog(this.jdrFrame, new String[]{JDRResources.getString("error.parshape.convert"), invalidShapeException.getMessage()}, JDRResources.getString("error.shape.incompatible"), 0);
        }
        catch (IOException iOException) {
            JDRResources.error(this.jdrFrame, JDRResources.getString("error.io.save") + "\n" + iOException.getMessage(), iOException);
        }
        this.jdrFrame.setCursor(cursor);
        jpgfDraw.setTool(this.jdrFrame.currentTool());
        this.jdrFrame.setIoInProgress(false);
        jpgfDraw.hideMessageFrame();
    }
}

