/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw;

import java.awt.Component;
import java.awt.Cursor;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;

public class SaveEps
implements Runnable {
    private String fileName;
    private JDRGroup image;
    private JDRFrame jdrFrame;

    private SaveEps() {
    }

    public SaveEps(JDRFrame jDRFrame, String string, JDRGroup jDRGroup) {
        this.jdrFrame = jDRFrame;
        this.fileName = string;
        this.image = jDRGroup;
    }

    @Override
    public void run() {
        PrintWriter printWriter;
        this.jdrFrame.setIoInProgress(true);
        Cursor cursor = this.jdrFrame.getCursor();
        this.jdrFrame.setCursor(Cursor.getPredefinedCursor(3));
        JpgfDraw jpgfDraw = this.jdrFrame.getApplication();
        JpgfDraw.showMessageFrame(JDRResources.getStringWithValue("info.saving", this.fileName));
        jpgfDraw.setStatusInfo(JDRResources.getStringWithValue("info.saving", this.fileName));
        try {
            printWriter = new PrintWriter(new FileWriter(this.fileName));
        }
        catch (IOException iOException) {
            JDRResources.error((Component)this.jdrFrame, new String[]{JDRResources.getStringWithValue("error.io.open", this.fileName), iOException.getMessage()});
            this.jdrFrame.setCursor(cursor);
            jpgfDraw.setTool(this.jdrFrame.currentTool());
            this.jdrFrame.setIoInProgress(false);
            jpgfDraw.hideMessageFrame();
            return;
        }
        try {
            String[] stringArray = new String[2];
            stringArray[0] = "Jpgfdraw";
            stringArray[1] = "0.5.6b";
            EPS.save(this.image, printWriter, JDRResources.getStringWithValue("about.version", stringArray));
        }
        catch (IOException iOException) {
            JDRResources.error(this.jdrFrame, JDRResources.getString("error.io.save") + "\n" + iOException.getMessage(), iOException);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            JDRResources.error((Component)this.jdrFrame, JDRResources.getString("error.out_of_memory"));
        }
        printWriter.close();
        this.jdrFrame.setCursor(cursor);
        jpgfDraw.setTool(this.jdrFrame.currentTool());
        this.jdrFrame.setIoInProgress(false);
        jpgfDraw.hideMessageFrame();
    }
}

