/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw;

import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import uk.ac.uea.cmp.nlct.jdr.CanvasSettings;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;

public class SaveAjr
implements Runnable {
    private String fileName;
    private float ajrVersion;
    private JDRGroup ajrImage;
    private JDRFrame jdrFrame;
    private CanvasSettings canvasSettings;

    private SaveAjr() {
    }

    public SaveAjr(JDRFrame jDRFrame, String string, float f, JDRGroup jDRGroup) {
        this(jDRFrame, string, f, jDRGroup, null);
    }

    public SaveAjr(JDRFrame jDRFrame, String string, float f, JDRGroup jDRGroup, CanvasSettings canvasSettings) {
        this.jdrFrame = jDRFrame;
        this.fileName = string;
        this.ajrVersion = f;
        this.ajrImage = jDRGroup;
        this.canvasSettings = canvasSettings;
    }

    @Override
    public void run() {
        PrintWriter printWriter;
        this.jdrFrame.setIoInProgress(true);
        boolean bl = false;
        JpgfDraw jpgfDraw = this.jdrFrame.getApplication();
        JpgfDraw.showMessageFrame(JDRResources.getStringWithValue("info.saving", this.fileName));
        Cursor cursor = this.jdrFrame.getCursor();
        this.jdrFrame.setCursor(Cursor.getPredefinedCursor(3));
        jpgfDraw.setStatusInfo(JDRResources.getStringWithValue("info.saving", this.fileName));
        try {
            printWriter = new PrintWriter(new File(this.fileName));
        }
        catch (IOException iOException) {
            JDRResources.error((Component)this.jdrFrame, new String[]{JDRResources.getStringWithValue("error.io.open", this.fileName), iOException.getMessage()});
            this.jdrFrame.setIoInProgress(false);
            jpgfDraw.hideMessageFrame();
            this.jdrFrame.setCursor(cursor);
            jpgfDraw.setTool(this.jdrFrame.currentTool());
            return;
        }
        try {
            if (this.canvasSettings != null) {
                AJR.save(this.ajrImage, this.canvasSettings, printWriter, this.ajrVersion);
            } else {
                AJR.save(this.ajrImage, printWriter, this.ajrVersion);
            }
            bl = true;
        }
        catch (IOException iOException) {
            JDRResources.error((Component)this.jdrFrame, new String[]{JDRResources.getString("error.io.save"), iOException.getMessage()});
        }
        catch (Exception exception) {
            JDRResources.internalError((Component)this.jdrFrame, exception);
        }
        this.jdrFrame.setIoInProgress(false);
        jpgfDraw.hideMessageFrame();
        printWriter.close();
        if (bl) {
            this.jdrFrame.setFilename(this.fileName);
            this.jdrFrame.markAsSaved();
            this.jdrFrame.addRecentFile(this.fileName);
        }
        this.jdrFrame.setCursor(cursor);
        jpgfDraw.setTool(this.jdrFrame.currentTool());
    }
}

