/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import uk.ac.uea.cmp.nlct.jdr.JDRGrid;
import uk.ac.uea.cmp.nlct.jdr.JDRUnit;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRCanvas;

public class RulerPanel
extends JPanel
implements SwingConstants,
MouseMotionListener {
    private int direction;
    public static final int MARKER_WIDTH = 10;
    public static final int MARKER_HEIGHT = 10;
    private Point2D oldP;
    private JDRCanvas canvas_;
    private double mag_;

    public RulerPanel(int n, int n2, int n3, JDRCanvas jDRCanvas) {
        this.direction = n;
        this.canvas_ = jDRCanvas;
        this.setPreferredSize(new Dimension(n2, n3));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
            }
        });
        this.addMouseMotionListener(this);
        this.oldP = new Point2D.Double(-10.0, -10.0);
        this.mag_ = 1.0;
    }

    public void update(double d, double d2) {
        double d3 = this.getNormalizedMagnification();
        this.oldP.setLocation(d3 * d, d3 * d2);
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        double d = this.getNormalizedMagnification();
        Point2D point2D = this.canvas_.getNearestTic(mouseEvent.getX(), mouseEvent.getY());
        this.oldP.setLocation(d * point2D.getX(), d * point2D.getY());
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        double d = this.getNormalizedMagnification();
        Point2D point2D = this.canvas_.getNearestTic(mouseEvent.getX(), mouseEvent.getY());
        this.oldP.setLocation(d * point2D.getX(), d * point2D.getY());
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        double d = this.getNormalizedMagnification();
        Point2D point2D = this.canvas_.getNearestTic(mouseEvent.getX(), mouseEvent.getY());
        this.oldP.setLocation(d * point2D.getX(), d * point2D.getY());
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        double d = this.getNormalizedMagnification();
        Dimension dimension = this.getPreferredSize();
        JDRGrid jDRGrid = this.canvas_.getGrid();
        Point2D point2D = jDRGrid.getMajorTicDistance();
        Point2D point2D2 = jDRGrid.getMinorTicDistance();
        JDRUnit jDRUnit = jDRGrid.getMainUnit();
        if (this.direction == 0) {
            double d2 = jDRUnit.fromBp(point2D.getX());
            dimension.width = (int)((double)dimension.width / d);
            int n = 0;
            int n2 = 0;
            if (point2D2.getX() > 0.0) {
                while (n2 <= dimension.width) {
                    graphics.drawLine((int)(d * (double)n2), 0, (int)(d * (double)n2), dimension.height * 4 / 10);
                    n2 = (int)((double)(++n) * point2D2.getX());
                }
            }
            n = 0;
            n2 = 0;
            while (n2 <= dimension.width) {
                graphics.drawLine((int)(d * (double)n2), 0, (int)(d * (double)n2), dimension.height * 8 / 10);
                graphics.drawString("" + (double)n * d2, (int)(d * (double)n2) + 2, dimension.height * 8 / 10);
                n2 = (int)((double)(++n) * point2D.getX());
            }
        } else {
            double d3 = jDRUnit.fromBp(point2D.getY());
            dimension.height = (int)((double)dimension.height / d);
            int n = 0;
            int n3 = 0;
            if (point2D2.getY() > 0.0) {
                while (n3 <= dimension.height) {
                    graphics.drawLine(0, (int)(d * (double)n3), dimension.width * 4 / 10, (int)(d * (double)n3));
                    n3 = (int)((double)(++n) * point2D2.getY());
                }
            }
            n = 0;
            n3 = 0;
            while (n3 <= dimension.height) {
                graphics.drawLine(0, (int)(d * (double)n3), dimension.width * 8 / 10, (int)(d * (double)n3));
                graphics.drawString("" + (double)n * d3, 2, (int)(d * (double)n3));
                n3 = (int)((double)(++n) * point2D.getY());
            }
        }
        this.drawMarker(graphics, this.oldP.getX(), this.oldP.getY());
    }

    public void drawMarker(Graphics graphics, double d, double d2) {
        if (this.direction == 0) {
            Polygon polygon = new Polygon();
            polygon.addPoint((int)Math.round(d - 5.0), 0);
            polygon.addPoint((int)Math.round(d + 5.0), 0);
            polygon.addPoint((int)Math.round(d), 10);
            graphics.fillPolygon(polygon);
        } else {
            Polygon polygon = new Polygon();
            polygon.addPoint(0, (int)Math.round(d2 - 5.0));
            polygon.addPoint(0, (int)Math.round(d2 + 5.0));
            polygon.addPoint(10, (int)Math.round(d2));
            graphics.fillPolygon(polygon);
        }
    }

    public double getMagnification() {
        return this.mag_;
    }

    public double getNormalizedMagnification() {
        return this.mag_ * JDRUnit.getNormalizingFactor();
    }

    public void setMagnification(double d) {
        this.mag_ = d;
    }
}

