/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.geom.NoninvertibleTransformException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;
import uk.ac.uea.cmp.nlct.jdrresources.JDRGuiMessage;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;

public class LoadEps
implements Runnable {
    private File epsFile;
    private JDRFrame jdrFrame;
    private double normalSize;

    private LoadEps() {
    }

    public LoadEps(JDRFrame jDRFrame, File file, double d) {
        this.jdrFrame = jDRFrame;
        this.normalSize = d;
        this.epsFile = file;
    }

    @Override
    public void run() {
        BufferedReader bufferedReader;
        this.jdrFrame.setIoInProgress(true);
        JDRGroup jDRGroup = null;
        JDRGuiMessage jDRGuiMessage = null;
        if (JDR.messageSystem instanceof JDRGuiMessage) {
            jDRGuiMessage = (JDRGuiMessage)JDR.messageSystem;
            jDRGuiMessage.displayMessages();
        }
        JpgfDraw jpgfDraw = this.jdrFrame.getApplication();
        Cursor cursor = this.jdrFrame.getCursor();
        this.jdrFrame.setCursor(Cursor.getPredefinedCursor(3));
        jpgfDraw.setStatusInfo(JDRResources.getStringWithValue("info.loading", this.epsFile.getAbsolutePath()));
        try {
            bufferedReader = new BufferedReader(new FileReader(this.epsFile));
        }
        catch (IOException iOException) {
            JDRResources.error((Component)this.jdrFrame, new String[]{JDRResources.getStringWithValue("error.io.open", this.epsFile.getAbsolutePath()), iOException.getMessage()});
            this.jdrFrame.setCursor(cursor);
            jpgfDraw.setTool(this.jdrFrame.currentTool());
            this.jdrFrame.setIoInProgress(false);
            if (jDRGuiMessage != null) {
                jDRGuiMessage.hideMessages();
            }
            return;
        }
        String string = this.epsFile.getAbsolutePath();
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string = string.substring(0, n);
        }
        try {
            jDRGroup = EPS.load(bufferedReader, string + "Img", 1, this.normalSize);
            JDR.messageSystem.messageln("Image loaded");
            if (jDRGroup.anyDraftBitmaps()) {
                JDRResources.warning((Component)this.jdrFrame, JDRResources.getString("warning.draft_bitmaps"));
            }
        }
        catch (IOException iOException) {
            JDR.messageSystem.messageln("Failed to load EPS image.");
            JDRResources.error((Component)this.jdrFrame, new String[]{JDRResources.getString("error.io.load"), iOException.getMessage()});
        }
        catch (InvalidFormatException invalidFormatException) {
            JDR.messageSystem.messageln("Failed to load EPS image. (This function is still experimental)");
            JDRResources.error((Component)this.jdrFrame, invalidFormatException);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            JDR.messageSystem.messageln("Failed to load EPS image.");
            JDRResources.error((Component)this.jdrFrame, noninvertibleTransformException);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            JDR.messageSystem.messageln("Failed to load EPS image: out of memory");
            JDRResources.error((Component)this.jdrFrame, JDRResources.getString("error.out_of_memory"));
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            JDRResources.error((Component)this.jdrFrame, new String[]{JDRResources.getString("error.io.close"), iOException.getMessage()});
        }
        if (jDRGroup != null) {
            this.jdrFrame.setImage(jDRGroup);
            this.jdrFrame.setFilename(string);
            this.jdrFrame.markAsModified();
        }
        this.jdrFrame.setCursor(cursor);
        jpgfDraw.setTool(this.jdrFrame.currentTool());
        this.jdrFrame.setIoInProgress(false);
        if (jDRGuiMessage != null) {
            jDRGuiMessage.hideMessages();
        }
    }
}

