/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw;

import java.awt.Component;
import java.awt.Cursor;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import uk.ac.uea.cmp.nlct.jdr.CanvasSettings;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRFrame;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;

public class LoadAjr
implements Runnable {
    private String fileName;
    private JDRFrame jdrFrame;

    private LoadAjr() {
    }

    public LoadAjr(JDRFrame jDRFrame, String string) {
        this.jdrFrame = jDRFrame;
        this.fileName = string;
    }

    @Override
    public void run() {
        BufferedReader bufferedReader;
        this.jdrFrame.setIoInProgress(true);
        JDRGroup jDRGroup = null;
        JpgfDraw jpgfDraw = this.jdrFrame.getApplication();
        Cursor cursor = this.jdrFrame.getCursor();
        this.jdrFrame.setCursor(Cursor.getPredefinedCursor(3));
        JpgfDraw.showMessageFrame(JDRResources.getStringWithValue("info.loading", this.fileName));
        try {
            bufferedReader = new BufferedReader(new FileReader(this.fileName));
        }
        catch (IOException iOException) {
            JDRResources.error((Component)this.jdrFrame, new String[]{JDRResources.getStringWithValue("error.io.open", this.fileName), iOException.getMessage()});
            this.jdrFrame.setIoInProgress(false);
            jpgfDraw.hideMessageFrame();
            return;
        }
        try {
            CanvasSettings canvasSettings = (CanvasSettings)this.jdrFrame.settings.clone();
            jDRGroup = AJR.load(bufferedReader, canvasSettings);
            this.jdrFrame.applySettingsIfRequired(canvasSettings);
            float f = AJR.getLastLoadedVersion();
            if (this.jdrFrame.warnOnOldJdr() && f < 1.6f) {
                JDRResources.warning((Component)this.jdrFrame, JDRResources.getStringWithValue("warning.load.ajr", "" + f));
            }
            if (jDRGroup.anyDraftBitmaps()) {
                JDRResources.warning((Component)this.jdrFrame, JDRResources.getString("warning.draft_bitmaps"));
            }
        }
        catch (IOException iOException) {
            JDRResources.error((Component)this.jdrFrame, new String[]{JDRResources.getString("error.io.load"), iOException.getMessage()});
        }
        catch (InvalidFormatException invalidFormatException) {
            JDRResources.error((Component)this.jdrFrame, invalidFormatException);
        }
        catch (Exception exception) {
            JDRResources.internalError((Component)this.jdrFrame, exception);
        }
        this.jdrFrame.setCursor(cursor);
        this.jdrFrame.setIoInProgress(false);
        jpgfDraw.hideMessageFrame();
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            JDRResources.error((Component)this.jdrFrame, new String[]{JDRResources.getString("error.io.close"), iOException.getMessage()});
        }
        if (jDRGroup != null) {
            this.jdrFrame.setImage(jDRGroup);
            this.jdrFrame.setFilename(this.fileName);
            this.jdrFrame.addRecentFile(this.fileName);
            if (JDR.bitmapReplaced) {
                this.jdrFrame.markAsModified();
            }
        }
        jpgfDraw.setTool(this.jdrFrame.currentTool());
    }
}

