/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.RenderingHints;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.print.PageFormat;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.ButtonGroup;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.undo.UndoableEdit;
import uk.ac.uea.cmp.nlct.jdr.CanvasSettings;
import uk.ac.uea.cmp.nlct.jdr.DashPattern;
import uk.ac.uea.cmp.nlct.jdr.FlowFrame;
import uk.ac.uea.cmp.nlct.jdr.InvalidToolException;
import uk.ac.uea.cmp.nlct.jdr.JDRBasicStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRBitmap;
import uk.ac.uea.cmp.nlct.jdr.JDRCompleteObject;
import uk.ac.uea.cmp.nlct.jdr.JDRGrid;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPaper;
import uk.ac.uea.cmp.nlct.jdr.JDRPath;
import uk.ac.uea.cmp.nlct.jdr.JDRPattern;
import uk.ac.uea.cmp.nlct.jdr.JDRText;
import uk.ac.uea.cmp.nlct.jdr.JDRTextual;
import uk.ac.uea.cmp.nlct.jdr.JDRUnit;
import uk.ac.uea.cmp.nlct.jdr.LaTeXFontBase;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;
import uk.ac.uea.cmp.nlct.jdr.marker.JDRMarker;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jdrresources.JDRTransferHandler;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRCanvas;
import uk.ac.uea.cmp.nlct.jpgfdraw.JpgfDraw;
import uk.ac.uea.cmp.nlct.jpgfdraw.RulerPanel;
import uk.ac.uea.cmp.nlct.jpgfdraw.dialog.DiscardDialogBox;

public class JDRFrame
extends JInternalFrame
implements ActionListener,
InternalFrameListener,
FocusListener {
    public JScrollPane scrollPane;
    private RulerPanel vRuler;
    private RulerPanel hRuler;
    private JpgfDraw application_;
    private String currentFilename;
    public CanvasSettings settings;
    public boolean newImage;
    private boolean saved = true;
    private JDRCanvas canvas;
    public static int count = 0;
    private JMenu menu_;
    public JMenuItem menuItem;
    private JLabel unitLabel;
    public LaTeXFontBase latexFonts;
    private boolean ioInProgress = false;

    public JDRFrame(String string, CanvasSettings canvasSettings, JMenu jMenu, ButtonGroup buttonGroup, JpgfDraw jpgfDraw) {
        super("JpgfDraw", true, true, true, true);
        this.settings = canvasSettings;
        this.application_ = jpgfDraw;
        this.addInternalFrameListener(this);
        this.setBackground(Color.white);
        this.setAutoscrolls(true);
        this.newImage = true;
        this.menu_ = jMenu;
        this.menuItem = new JRadioButtonMenuItem(this.currentFilename);
        this.menuItem.addActionListener(this);
        this.menu_.insert(this.menuItem, 0);
        buttonGroup.add(this.menuItem);
        this.setDefaultCloseOperation(0);
        this.canvas = new JDRCanvas(this);
        this.canvas.setTransferHandler(new JDRTransferHandler());
        this.scrollPane = new JScrollPane(this.canvas);
        this.hRuler = new RulerPanel(0, this.canvas.getPreferredSize().width, 25, this.canvas);
        this.vRuler = new RulerPanel(1, 25, this.canvas.getPreferredSize().height, this.canvas);
        this.unitLabel = new JLabel("pt");
        this.scrollPane.setColumnHeaderView(this.hRuler);
        this.scrollPane.setRowHeaderView(this.vRuler);
        this.scrollPane.setCorner("UPPER_LEFT_CORNER", this.unitLabel);
        this.scrollPane.getViewport().addChangeListener(this.canvas);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.canvas.addMouseMotionListener(this.hRuler);
        this.canvas.addMouseMotionListener(this.vRuler);
        this.addFocusListener(this);
        this.scrollPane.getActionMap().getParent().clear();
        this.latexFonts = new LaTeXFontBase(10.0);
        if (string != null) {
            this.load(string);
        }
        if (string == null) {
            String string2 = "";
            string2 = JDRResources.getString("label.untitled");
            if (++count > 1) {
                string2 = string2 + count;
            }
            this.setFilename(string2);
        }
        this.applySettings(this.settings);
    }

    public void setImage(JDRGroup jDRGroup) {
        this.canvas.setImage(jDRGroup);
        this.newImage = false;
    }

    public void selectThisFrame() {
        try {
            this.setSelected(true);
            if (this.isIcon()) {
                this.setIcon(false);
                this.setMaximum(true);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.moveToFront();
    }

    public void updateTextAreaBounds() {
        this.canvas.updateTextAreaBounds();
    }

    public void setFilename(String string) {
        this.currentFilename = string;
        int n = string.lastIndexOf(File.separator);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        this.updateTitle();
        this.application_.setCurrentFile(this.currentFilename, !this.saved);
        this.application_.updateWindowMenu();
    }

    public void updateTitle() {
        int n = this.canvas.getNumberOfHiddenObjects();
        if (n == 0) {
            this.setTitle(this.currentFilename);
        } else if (n == 1) {
            this.setTitle(this.currentFilename + " (" + JDRResources.getStringWithValue("label.hidden_object", "1") + ")");
        } else {
            this.setTitle(this.currentFilename + " (" + JDRResources.getStringWithValue("label.hidden_objects", n) + ")");
        }
    }

    public String getFilename() {
        return this.currentFilename;
    }

    public boolean hasFileName() {
        return !this.currentFilename.matches(JDRResources.getString("label.untitled", "Untitled") + "\\d*");
    }

    public void addRecentFile(String string) {
        this.application_.addRecentFile(string);
    }

    public void saveString(String string) {
        this.application_.saveString(string);
    }

    public void applySettings(CanvasSettings canvasSettings) {
        this.settings = canvasSettings;
        this.application_.setTool(canvasSettings.getTool());
        this.setAction(canvasSettings.getTool());
        this.setNormalSize(canvasSettings.normalsize);
        this.showRulers(canvasSettings.showRulers);
        this.application_.setLockGrid(canvasSettings.grid_lock);
        this.application_.setGridDisplay(canvasSettings.display_grid);
        this.setGrid(canvasSettings.getGrid(), false);
        this.setPaperSize(canvasSettings.paper, false);
        this.setMagnification(this.application_.getMagnification());
    }

    public void setGrid(JDRGrid jDRGrid) {
        this.setGrid(jDRGrid, true);
    }

    public void setGrid(JDRGrid jDRGrid, boolean bl) {
        this.settings.setGrid(jDRGrid);
        this.unitLabel.setText(jDRGrid.getUnitLabel());
        if (bl) {
            this.canvas.setBackgroundImage(true);
        }
        this.vRuler.repaint();
        this.hRuler.repaint();
        if (bl) {
            this.canvas.repaint();
        }
    }

    public void showGrid(boolean bl) {
        this.settings.setDisplayGrid(bl);
        this.canvas.setBackgroundImage(true);
        this.canvas.repaint();
    }

    public void setMagnification(double d) {
        this.setMagnification(d, true);
    }

    public void setMagnification(double d, boolean bl) {
        this.hRuler.setMagnification(d);
        this.vRuler.setMagnification(d);
        Dimension dimension = new Dimension((int)(d * JDRUnit.getNormalizingFactor() * this.settings.paper.getWidth()), (int)(d * JDRUnit.getNormalizingFactor() * this.settings.paper.getHeight()));
        this.setPreferredSize(dimension);
        this.canvas.setPreferredSize(dimension);
        this.revalidate();
        this.scrollPane.setPreferredSize(dimension);
        this.scrollPane.revalidate();
        Dimension dimension2 = this.hRuler.getPreferredSize();
        dimension2.width = dimension.width;
        this.hRuler.setPreferredSize(dimension2);
        this.hRuler.revalidate();
        dimension2 = this.vRuler.getPreferredSize();
        dimension2.height = dimension.height;
        this.vRuler.setPreferredSize(dimension2);
        this.vRuler.revalidate();
        this.vRuler.repaint();
        this.hRuler.repaint();
        if (bl) {
            this.canvas.setBackgroundImage(true);
        }
        this.canvas.updateTextFieldBounds();
        if (bl) {
            this.canvas.repaint();
        }
    }

    public void zoomWidth() {
        int n;
        double d = JDRUnit.getNormalizingFactor() * this.settings.paper.getWidth();
        double d2 = JDRUnit.getNormalizingFactor() * this.settings.paper.getHeight();
        Dimension dimension = this.scrollPane.getViewport().getExtentSize();
        int n2 = dimension.width;
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        if (!jScrollBar.isVisible()) {
            n = dimension.height;
            dimension = jScrollBar.getSize();
            if (d2 * (double)(n2 - dimension.width) / d > (double)n) {
                n2 -= dimension.width;
            }
        } else if (this.scrollPane.getVerticalScrollBarPolicy() == 20) {
            n = dimension.height;
            dimension = jScrollBar.getSize();
            if (d2 * (double)(n2 + dimension.width) / d < (double)n) {
                n2 += dimension.width;
            }
        }
        double d3 = (double)n2 / d;
        if (d3 != 0.0) {
            this.setMagnification(d3);
        }
    }

    public void zoomHeight() {
        double d;
        double d2 = JDRUnit.getNormalizingFactor() * this.settings.paper.getWidth();
        double d3 = JDRUnit.getNormalizingFactor() * this.settings.paper.getHeight();
        Dimension dimension = this.scrollPane.getViewport().getExtentSize();
        int n = dimension.width;
        int n2 = dimension.height;
        JScrollBar jScrollBar = this.scrollPane.getHorizontalScrollBar();
        if (!jScrollBar.isVisible()) {
            dimension = jScrollBar.getSize();
            if (d2 * (double)(n2 - dimension.height) / d3 > (double)n) {
                n2 -= dimension.height;
            }
        } else if (this.scrollPane.getHorizontalScrollBarPolicy() == 30) {
            dimension = jScrollBar.getSize();
            if (d2 * (double)(n2 + dimension.height) / d3 < (double)n) {
                n2 += dimension.height;
            }
        }
        if ((d = (double)n2 / d3) != 0.0) {
            this.setMagnification(d);
        }
    }

    public void zoomPage() {
        double d;
        JScrollBar jScrollBar;
        double d2 = JDRUnit.getNormalizingFactor() * this.settings.paper.getWidth();
        double d3 = JDRUnit.getNormalizingFactor() * this.settings.paper.getHeight();
        Dimension dimension = this.scrollPane.getViewport().getExtentSize();
        int n = dimension.width;
        double d4 = (double)n / d2;
        int n2 = dimension.height;
        double d5 = (double)n2 / d3;
        if (d4 < d5) {
            jScrollBar = this.scrollPane.getVerticalScrollBar();
            if (jScrollBar.isVisible() && this.scrollPane.getVerticalScrollBarPolicy() == 20) {
                dimension = jScrollBar.getSize();
                if (d3 * (double)(n + dimension.width) / d2 < (double)n2) {
                    d4 = (double)(n += dimension.width) / d2;
                }
            }
        } else {
            jScrollBar = this.scrollPane.getHorizontalScrollBar();
            if (jScrollBar.isVisible() && this.scrollPane.getHorizontalScrollBarPolicy() == 30) {
                dimension = jScrollBar.getSize();
                if (d2 * (double)(n2 + dimension.height) / d3 < (double)n) {
                    d5 = (double)(n2 += dimension.height) / d3;
                }
            }
        }
        double d6 = d = d4 < d5 ? d4 : d5;
        if (d != 0.0) {
            this.setMagnification(d);
        }
    }

    public void setOrientation(boolean bl) {
        JDRPaper jDRPaper = this.settings.paper.getPaper(bl);
        if (jDRPaper != this.settings.paper) {
            this.setPaperSize(jDRPaper);
            this.canvas.setBackgroundImage(true);
        }
    }

    public void setPaperSize(JDRPaper jDRPaper) {
        this.setPaperSize(jDRPaper, true);
    }

    public void setPaperSize(JDRPaper jDRPaper, boolean bl) {
        this.settings.paper = jDRPaper;
        double d = this.getMagnification();
        Dimension dimension = new Dimension((int)(d * JDRUnit.getNormalizingFactor() * this.settings.paper.getWidth()), (int)(d * JDRUnit.getNormalizingFactor() * this.settings.paper.getHeight()));
        this.canvas.setPreferredSize(dimension);
        this.canvas.revalidate();
        this.scrollPane.setPreferredSize(dimension);
        this.scrollPane.revalidate();
        Dimension dimension2 = this.hRuler.getPreferredSize();
        dimension2.width = dimension.width;
        this.hRuler.setPreferredSize(dimension2);
        this.hRuler.revalidate();
        dimension2 = this.vRuler.getPreferredSize();
        dimension2.height = dimension.height;
        this.vRuler.setPreferredSize(dimension2);
        this.vRuler.revalidate();
        this.vRuler.repaint();
        this.hRuler.repaint();
        if (bl) {
            this.canvas.setBackgroundImage(true);
        }
        this.canvas.resetTextField();
        if (bl) {
            this.repaint();
        }
        this.application_.setPaperSize(jDRPaper);
    }

    public void setMargins(PageFormat pageFormat) {
        this.settings.setMargins(pageFormat);
        this.application_.setPaperSize(this.getPaper());
        this.canvas.setBackgroundImage(true);
        this.repaint();
    }

    public void setMargins() {
        this.application_.setPaperSize(this.getPaper());
        this.canvas.setBackgroundImage(true);
        this.repaint();
    }

    public void updateBackground() {
        this.canvas.setBackgroundImage(true);
        this.repaint();
    }

    public boolean showMargins() {
        return this.application_.showMargins();
    }

    public void showRulers(boolean bl) {
        this.settings.showRulers = bl;
        this.scrollPane.getColumnHeader().setVisible(bl);
        this.scrollPane.getRowHeader().setVisible(bl);
        this.application_.setRulers(bl);
    }

    public CanvasSettings getSettings() {
        return this.settings;
    }

    public void goToCoordinate(double d, double d2) {
        this.canvas.goToCoordinate(d, d2);
    }

    public RenderingHints getRenderingHints() {
        return this.application_.getRenderingHints();
    }

    public Font getCurrentFont() {
        return this.application_.getCurrentFont();
    }

    public JDRBasicStroke getCurrentStroke() {
        return this.application_.getCurrentStroke();
    }

    public JDRPaint getCurrentLinePaint() {
        return this.application_.getCurrentLinePaint();
    }

    public JDRPaint getCurrentFillPaint() {
        return this.application_.getCurrentFillPaint();
    }

    public JDRPaint getCurrentTextPaint() {
        return this.application_.getCurrentTextPaint();
    }

    public String getCurrentFontFamily() {
        return this.application_.getCurrentFontFamily();
    }

    public String getCurrentLaTeXFontFamily() {
        return this.application_.getCurrentLaTeXFontFamily();
    }

    public int getCurrentFontSize() {
        return this.application_.getCurrentFontSize();
    }

    public int getCurrentFontSeries() {
        return this.application_.getCurrentFontSeries();
    }

    public int getCurrentFontShape() {
        return this.application_.getCurrentFontShape();
    }

    public int getCurrentPGFHAlign() {
        return this.application_.getCurrentPGFHAlign();
    }

    public int getCurrentPGFVAlign() {
        return this.application_.getCurrentPGFVAlign();
    }

    public String getCurrentLaTeXFontSize() {
        return this.application_.getCurrentLaTeXFontSize();
    }

    public String getCurrentLaTeXFontSeries() {
        return this.application_.getCurrentLaTeXFontSeries();
    }

    public String getCurrentLaTeXFontShape() {
        return this.application_.getCurrentLaTeXFontShape();
    }

    public int getSelectedFontSeries() {
        return this.canvas.getSelectedFontSeries();
    }

    public int getSelectedFontSize() {
        return this.canvas.getSelectedFontSize();
    }

    public int getSelectedFontShape() {
        return this.canvas.getSelectedFontShape();
    }

    public int getSelectedHalign() {
        return this.canvas.getSelectedHalign();
    }

    public int getSelectedValign() {
        return this.canvas.getSelectedValign();
    }

    public String getSelectedFontName() {
        return this.canvas.getSelectedFontName();
    }

    public JDRPaint getSelectedLinePaint() {
        return this.canvas.getSelectedLinePaint();
    }

    public JDRPaint getSelectedFillPaint() {
        return this.canvas.getSelectedFillPaint();
    }

    public JDRPaint getSelectedTextPaint() {
        return this.canvas.getSelectedTextPaint();
    }

    public Font getSymbolButtonFont() {
        return this.canvas.getSymbolButtonFont();
    }

    public JDRBasicStroke getSelectedStroke() {
        return this.canvas.getSelectedBasicStroke();
    }

    public JDRTextual getSelectedText() {
        return this.canvas.getSelectedText();
    }

    public JDRTextual getSelectedFont() {
        return this.canvas.getSelectedFont();
    }

    public JDRBitmap getSelectedBitmap() {
        return this.canvas.getSelectedBitmap();
    }

    public JDRCompleteObject getSelectedObject() {
        return this.canvas.getSelectedObject();
    }

    public JDRCompleteObject getObject(int n) {
        return this.canvas.getObject(n);
    }

    public JDRPath getSelectedPath() {
        return this.canvas.getSelectedPath();
    }

    public int getSelectedPatternIndex() {
        return this.canvas.getSelectedPatternIndex();
    }

    public void reduceToGrey() {
        this.canvas.reduceToGrey();
    }

    public void fade(double d) {
        this.canvas.fade(d);
    }

    public void setSelectedTextPaint(JDRPaint jDRPaint) {
        this.canvas.setSelectedTextPaint(jDRPaint);
    }

    public void setSelectedLinePaint(JDRPaint jDRPaint) {
        this.canvas.setSelectedLinePaint(jDRPaint);
    }

    public void setSelectedFillPaint(JDRPaint jDRPaint) {
        this.canvas.setSelectedFillPaint(jDRPaint);
    }

    public void setSelectedStroke(JDRBasicStroke jDRBasicStroke) {
        this.canvas.setSelectedStroke(jDRBasicStroke);
    }

    public void setSelectedLineWidth(double d) {
        this.canvas.setSelectedLineWidth(d);
    }

    public void setSelectedDashPattern(DashPattern dashPattern) {
        this.canvas.setSelectedDashPattern(dashPattern);
    }

    public void setSelectedCapStyle(int n) {
        this.canvas.setSelectedCapStyle(n);
    }

    public void setSelectedJoinStyle(int n) {
        this.canvas.setSelectedJoinStyle(n);
    }

    public void setSelectedJoinStyle(int n, double d) {
        this.canvas.setSelectedJoinStyle(n, d);
    }

    public void setSelectedStartArrow(JDRMarker jDRMarker) {
        this.canvas.setSelectedStartArrow(jDRMarker);
    }

    public void setSelectedMidArrow(JDRMarker jDRMarker) {
        this.canvas.setSelectedMidArrow(jDRMarker);
    }

    public void setSelectedEndArrow(JDRMarker jDRMarker) {
        this.canvas.setSelectedEndArrow(jDRMarker);
    }

    public void setSelectedMarkers(JDRMarker jDRMarker) {
        this.canvas.setSelectedMarkers(jDRMarker);
    }

    public void setSelectedWindingRule(int n) {
        this.canvas.setSelectedWindingRule(n);
    }

    public void setSelectedHalign(int n) {
        this.canvas.setSelectedHalign(n);
    }

    public void setSelectedValign(int n) {
        this.canvas.setSelectedValign(n);
    }

    public void setSelectedAnchor(int n, int n2) {
        this.canvas.setSelectedAnchor(n, n2);
    }

    public void setSelectedText(String string) {
        this.canvas.setSelectedText(string);
    }

    public void setSelectedText(String string, String string2) {
        this.canvas.setSelectedText(string, string2);
    }

    public void setSelectedFont(JDRText jDRText) {
        this.canvas.setSelectedFont(jDRText);
    }

    public void setSelectedFontFamily(String string, String string2) {
        this.canvas.setSelectedFontFamily(string, string2);
    }

    public void setSelectedFontSize(int n, String string) {
        this.canvas.setSelectedFontSize(n, string);
    }

    public void setSelectedFontShape(int n, String string) {
        this.canvas.setSelectedFontShape(n, string);
    }

    public void setSelectedFontSeries(int n, String string) {
        this.canvas.setSelectedFontSeries(n, string);
    }

    public void setBitmapProperties(JDRBitmap jDRBitmap, String string, String string2, String string3, double[] dArray) {
        this.canvas.setBitmapProperties(jDRBitmap, string, string2, string3, dArray);
    }

    public LaTeXFontBase getLaTeXFonts() {
        return this.latexFonts;
    }

    public void setNormalSize(int n) {
        this.settings.normalsize = n;
        this.latexFonts.setNormalSize(n);
    }

    public int getNormalSize() {
        return this.settings.normalsize;
    }

    public void postEdit(UndoableEdit undoableEdit) {
        this.application_.postEdit(undoableEdit);
    }

    public void disableUndoRedo() {
        this.application_.disableUndoRedo();
    }

    public void refreshUndoRedo() {
        this.application_.refreshUndoRedo();
    }

    public void enableTools() {
        this.canvas.enableTools();
    }

    public void enableTools(int n, int[] nArray, boolean[] blArray) {
        this.application_.enableTools(this.currentTool(), n, nArray, blArray);
    }

    public void enableEditTools(boolean bl, boolean bl2) {
        this.application_.enableEditTools(bl, bl2);
    }

    public void enableEditTools(boolean bl) {
        this.application_.enableEditTools(bl);
    }

    public int currentTool() {
        return this.settings.getTool();
    }

    public void setTool(int n) {
        try {
            this.settings.setTool(n);
        }
        catch (InvalidToolException invalidToolException) {
            JDRResources.internalError((Component)this, invalidToolException);
        }
        this.application_.setTool(n);
        this.canvas.enableTools();
    }

    public void lockGrid(boolean bl) {
        this.settings.setGridLock(bl);
    }

    public boolean isPathEdited() {
        return this.application_.isPathEdited();
    }

    public void setAction(int n) {
        this.canvas.setAction(n);
    }

    public void refresh() {
        double d = JDRUnit.getNormalizingFactor();
        JDR.bitmapReplaced = false;
        this.canvas.refresh();
        if (JDR.bitmapReplaced) {
            this.markAsModified();
        }
        if (d != JDRUnit.getNormalizingFactor()) {
            this.setMagnification(this.getMagnification());
        }
    }

    public void insertBitmap(String string) {
        this.canvas.insertBitmap(string);
    }

    public void finishPath() {
        this.canvas.finishPath();
    }

    public void abandonPath() {
        this.canvas.abandonPath();
    }

    public void gap() {
        this.canvas.gap();
    }

    public void resetGapButton() {
        this.application_.resetGapButton();
    }

    public void bottomAlign() {
        this.canvas.bottomAlign();
    }

    public void middleAlign() {
        this.canvas.middleAlign();
    }

    public void topAlign() {
        this.canvas.topAlign();
    }

    public void rightAlign() {
        this.canvas.rightAlign();
    }

    public void centreAlign() {
        this.canvas.centreAlign();
    }

    public void leftAlign() {
        this.canvas.leftAlign();
    }

    public void group() {
        this.canvas.group();
    }

    public void ungroup() {
        this.canvas.ungroup();
    }

    public void mergePaths() {
        this.canvas.mergePaths();
    }

    public void xorPaths() {
        this.canvas.xorPaths();
    }

    public void pathIntersect() {
        this.canvas.pathIntersect();
    }

    public void subtractPaths() {
        this.canvas.subtractPaths();
    }

    public void pathUnion() {
        this.canvas.pathUnion();
    }

    public void splitText() {
        this.canvas.splitText();
    }

    public void convertToPath() {
        this.canvas.convertToPath();
    }

    public void convertToFullPath() {
        this.canvas.convertToFullPath();
    }

    public void convertToTextPath() {
        this.canvas.convertToTextPath();
    }

    public void separate() {
        this.canvas.separate();
    }

    public void reverseSelectedPaths() {
        this.canvas.reverseSelectedPaths();
    }

    public void unsetAllFlowFrames() {
        this.canvas.unsetAllFlowFrames();
    }

    public void rotateSelectedPaths(double d) {
        this.canvas.rotateSelectedPaths(d);
    }

    public void scaleXSelectedPaths(double d) {
        this.canvas.scaleXSelectedPaths(d);
    }

    public void scaleYSelectedPaths(double d) {
        this.canvas.scaleYSelectedPaths(d);
    }

    public void scaleSelectedPaths(double d) {
        this.canvas.scaleSelectedPaths(d);
    }

    public void shearSelectedPaths(double d, double d2) {
        this.canvas.shearSelectedPaths(d, d2);
    }

    public void shapepar(boolean bl) {
        this.canvas.shapepar(bl);
    }

    public void parshape(boolean bl) {
        this.canvas.parshape(bl);
    }

    public void resetTextField() {
        this.canvas.resetTextField();
    }

    public void setCurrentPosition(String string) {
        this.application_.setCurrentPosition(string);
    }

    public boolean isUniqueLabel(int n, JDRCompleteObject jDRCompleteObject, String string) {
        return this.canvas.isUniqueLabel(n, jDRCompleteObject, string);
    }

    public void setFlowFrame(JDRCompleteObject jDRCompleteObject, FlowFrame flowFrame) {
        this.canvas.setFlowFrame(jDRCompleteObject, flowFrame);
    }

    public void setTypeblock(double d, double d2, double d3, double d4) {
        this.canvas.setTypeblock(d, d2, d3, d4);
    }

    public FlowFrame getTypeblock() {
        return this.canvas.getTypeblock();
    }

    public void editPath() {
        this.canvas.editPath();
    }

    public void finishEditPath() {
        this.canvas.finishEditPath();
    }

    public void selectAll() {
        this.canvas.selectAll();
    }

    public void deselectAll() {
        this.canvas.deselectAll();
    }

    public void markAsSaved() {
        this.saved = true;
        this.newImage = false;
        this.application_.setModified(false);
    }

    public void markAsModified() {
        this.saved = false;
        this.newImage = false;
        this.application_.setModified(true);
    }

    public boolean isModified() {
        return !this.saved;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void print() {
        this.canvas.print();
    }

    public void load(String string) {
        this.canvas.load(string);
    }

    public void save(boolean bl) {
        this.save(this.currentFilename, 1.6f, bl);
    }

    public void save(String string, float f, boolean bl) {
        this.canvas.save(string, f, bl);
    }

    public void save(File file, float f, boolean bl) {
        this.canvas.save(file.getAbsolutePath(), f, bl);
    }

    public void saveAJR(boolean bl) {
        this.canvas.saveAJR(this.currentFilename, 1.6f, bl);
    }

    public void saveAJR(String string, float f, boolean bl) {
        this.canvas.saveAJR(string, f, bl);
    }

    public void savePGF(String string) {
        this.canvas.savePGF(string);
    }

    public void savePGFDoc(String string) {
        this.canvas.savePGFDoc(string);
    }

    public void saveFlowFrame(String string) {
        this.canvas.saveFlowFrame(string);
    }

    public void savePNG(String string) {
        this.canvas.savePNG(string);
    }

    public void saveEPS(String string) {
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.canvas.saveEPS(string);
        this.setCursor(cursor);
    }

    public void saveSVG(String string) {
        this.canvas.saveSVG(string);
    }

    public DiscardDialogBox getDiscardDialogBox() {
        return this.application_.getDiscardDialogBox();
    }

    public boolean discard() {
        if (this.isIoInProgress()) {
            JDRResources.error((Component)this, JDRResources.getString("error.io.in_progress"));
            return false;
        }
        boolean bl = this.canvas.discard();
        if (bl) {
            this.discardWithoutSaving();
        }
        this.newImage = false;
        return bl;
    }

    public boolean saveAndDiscard() {
        if (this.hasFileName()) {
            this.save(false);
        } else if (!this.application_.promptAndSave(this, false)) {
            return false;
        }
        this.discardWithoutSaving();
        return true;
    }

    public void discardWithoutSaving() {
        this.setVisible(false);
        this.application_.removeFrame(this);
        this.menu_.remove(this.menuItem);
        this.application_.updateWindowMenu();
        this.newImage = true;
        this.dispose();
        this.application_.discardAllEdits();
        this.canvas.discardImage();
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        this.discard();
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        this.application_.updateStatus();
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        this.menuItem.setSelected(true);
        this.applySettings(this.settings);
        this.application_.setCurrentFile(this.currentFilename, !this.saved);
        this.application_.enableFrameRelatedItems(true);
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        this.abandonPath();
        this.application_.enableFrameRelatedItems(this.application_.getSelectedFrame() != null);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.canvas == null) {
            return;
        }
        if (this.canvas.isTextFieldVisible() && !focusEvent.isTemporary()) {
            this.canvas.requestSymbolFocus();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.menuItem) {
            this.selectThisFrame();
        }
    }

    public void moveDrawObjectToFront() {
        this.canvas.moveToFront();
    }

    public void moveDrawObjectToBack() {
        this.canvas.moveToBack();
    }

    public void convertSelectedToPattern(JDRPattern jDRPattern) {
        this.canvas.convertSelectedToPattern(jDRPattern);
    }

    public void updatePattern(int n, JDRPattern jDRPattern) {
        this.canvas.updatePattern(n, jDRPattern);
    }

    public void removePattern() {
        this.canvas.removeSelectedPattern();
    }

    public double getMagnification() {
        if (this.hRuler == null) {
            return 1.0;
        }
        return this.hRuler.getMagnification();
    }

    public JDRGrid getGrid() {
        return this.settings.getGrid();
    }

    public JDRUnit getUnit() {
        return this.settings.getGrid().getMainUnit();
    }

    public double getAbsoluteMinorDistance(int n, int n2, JDRUnit jDRUnit) {
        double d = jDRUnit.toBp(n);
        double d2 = n2;
        d2 = d2 > 0.0 ? d / d2 : 0.0;
        return d2 * this.getMagnification();
    }

    public void updateRulers(double d, double d2) {
        this.vRuler.update(d, d2);
        this.hRuler.update(d, d2);
    }

    public double getPaperWidth() {
        return this.settings.paper.getWidth();
    }

    public double getPaperHeight() {
        return this.settings.paper.getHeight();
    }

    public boolean getGridLock() {
        return this.settings.isGridLocked();
    }

    public void setGridLock(boolean bl) {
        this.settings.setGridLock(bl);
    }

    public boolean showGrid() {
        return this.settings.isGridDisplayed();
    }

    public boolean saveJDRsettings() {
        return this.application_.saveJDRsettings();
    }

    public void applySettingsIfRequired(CanvasSettings canvasSettings) {
        if (this.application_.useJDRsettings()) {
            this.applySettings(canvasSettings);
        }
    }

    public boolean warnOnOldJdr() {
        return this.application_.warnOnOldJdr();
    }

    public JDRPaper getPaper() {
        return this.settings.paper;
    }

    public void pasteSelectedPaths() {
        Clipboard clipboard = this.getClipboard();
        Transferable transferable = clipboard.getContents(clipboard);
        if (transferable != null && transferable.isDataFlavorSupported(new DataFlavor(new JDRGroup().getClass(), "JDRGroup"))) {
            TransferHandler transferHandler = this.canvas.getTransferHandler();
            transferHandler.importData(this.canvas, transferable);
            this.repaint();
        }
    }

    public void copySelectedPaths() {
        TransferHandler transferHandler = this.canvas.getTransferHandler();
        transferHandler.exportToClipboard(this.canvas, this.getClipboard(), 1);
    }

    public void cutSelectedPaths() {
        TransferHandler transferHandler = this.canvas.getTransferHandler();
        transferHandler.exportToClipboard(this.canvas, this.getClipboard(), 2);
        this.canvas.deleteSelection();
        this.canvas.repaint();
    }

    public Clipboard getClipboard() {
        return this.application_.clipboard;
    }

    public JDRCanvas getCanvas() {
        return this.canvas;
    }

    public JpgfDraw getApplication() {
        return this.application_;
    }

    public void setEditPathButton(boolean bl) {
        this.application_.setEditPathButton(bl);
        this.canvas.enableTools();
    }

    public void setDisplayPage(int n) {
        this.canvas.setDisplayPage(n);
    }

    public int getDisplayPage() {
        return this.canvas.getDisplayPage();
    }

    public JDRGroup getAllPaths() {
        return this.canvas.getAllPaths();
    }

    public void selectObjectAndScroll(JDRCompleteObject jDRCompleteObject) {
        this.canvas.selectObjectAndScroll(jDRCompleteObject);
    }

    public void updateLaTeXFontSize() {
        this.canvas.updateLaTeXFontSize(this.latexFonts);
    }

    public void addObject(JDRCompleteObject jDRCompleteObject, String string) {
        this.canvas.addObject(jDRCompleteObject, string);
    }

    public void printInfo(PrintWriter printWriter) throws IOException {
        printWriter.println("is saved: " + this.saved);
        printWriter.println("new image: " + this.newImage);
        printWriter.println("current filename: " + this.currentFilename);
        printWriter.println(this.latexFonts);
        printWriter.println("Image:");
        this.canvas.printInfo(printWriter);
        printWriter.println(this);
    }

    public String getSelectedInfo() {
        return this.canvas.getSelectedInfo();
    }

    public void setIoInProgress(boolean bl) {
        this.ioInProgress = bl;
    }

    public boolean isIoInProgress() {
        return this.ioInProgress;
    }
}

