/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractAction;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.JDRColor;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRCanvas;

class CanvasTextField
extends JTextField
implements CaretListener,
DocumentListener,
MouseListener {
    private Point pos = new Point(0, 0);
    private JDRCanvas canvas;
    private Paint background = new Color(255, 255, 0, 40);
    private JDRPaint foreground = new JDRColor();
    private UndoableEditListener el = null;
    public static String widestChar = "M";

    public CanvasTextField(JDRCanvas jDRCanvas, UndoableEditListener undoableEditListener) {
        super(64);
        this.canvas = jDRCanvas;
        this.setOpaque(false);
        this.setHorizontalAlignment(10);
        this.setBorder(null);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.addCaretListener(this);
        this.getDocument().addDocumentListener(this);
        this.addMouseListener(this);
        this.el = undoableEditListener;
        this.getDocument().addUndoableEditListener(this.el);
        this.updateBounds();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CanvasTextField.this.moveLeft();
            }
        };
        this.getInputMap(0).put(KeyStroke.getKeyStroke(37, 0), "moveLeft");
        this.getActionMap().put("moveLeft", abstractAction);
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CanvasTextField.this.moveRight();
            }
        };
        this.getInputMap(0).put(KeyStroke.getKeyStroke(39, 0), "moveRight");
        this.getActionMap().put("moveRight", abstractAction);
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CanvasTextField.this.shiftLeft();
            }
        };
        this.getInputMap(0).put(KeyStroke.getKeyStroke(37, 1), "shiftLeft");
        this.getActionMap().put("shiftLeft", abstractAction);
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CanvasTextField.this.shiftRight();
            }
        };
        this.getInputMap(0).put(KeyStroke.getKeyStroke(39, 1), "shiftRight");
        this.getActionMap().put("shiftRight", abstractAction);
    }

    public void setNoUndoText(String string) {
        if (this.el != null) {
            this.getDocument().removeUndoableEditListener(this.el);
            this.setText(string);
            this.getDocument().addUndoableEditListener(this.el);
        } else {
            this.setText(string);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.repaint();
    }

    public void moveLeft() {
        String string = this.getSelectedText();
        int n = this.getCaretPosition() - 1;
        if (n < 0) {
            n = 0;
        }
        this.setCaretPosition(n);
        if (string != null) {
            this.repaint();
        }
    }

    public void moveRight() {
        String string = this.getSelectedText();
        int n = this.getText().length();
        if (n == 0) {
            return;
        }
        int n2 = this.getCaretPosition() + 1;
        if (n2 > n) {
            n2 = n;
        }
        this.setCaretPosition(n2);
        if (string != null) {
            this.repaint();
        }
    }

    public void shiftLeft() {
        int n = this.getCaretPosition() - 1;
        if (n < 0) {
            return;
        }
        this.moveCaretPosition(n);
    }

    public void shiftRight() {
        int n = this.getText().length();
        if (n == 0) {
            return;
        }
        int n2 = this.getCaretPosition() + 1;
        if (n2 > n) {
            return;
        }
        this.moveCaretPosition(n2);
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        int n = caretEvent.getDot();
        int n2 = caretEvent.getMark();
        try {
            Rectangle rectangle = this.modelToView(n);
            Rectangle rectangle2 = this.getBounds();
            double d = rectangle2.getX() + rectangle.getX();
            double d2 = rectangle2.getY() + rectangle.getY();
            double d3 = rectangle.getWidth();
            double d4 = rectangle2.getHeight();
            rectangle2.setBounds((int)d, (int)d2, (int)d3, (int)d4);
            Rectangle rectangle3 = this.canvas.getVisibleRect();
            double d5 = rectangle3.getX();
            double d6 = rectangle3.getY();
            double d7 = d5 + rectangle3.getWidth();
            double d8 = d6 + rectangle3.getHeight();
            if (!rectangle3.contains(rectangle2)) {
                if (d6 < d2 && d2 + d4 <= d8) {
                    if (d7 < d && d < d7 + rectangle3.getWidth()) {
                        this.canvas.blockScrollRight();
                    } else if (d5 - rectangle3.getWidth() < d && d + d3 < d5) {
                        this.canvas.blockScrollLeft();
                    } else {
                        this.canvas.scrollToPixel(d, d2);
                    }
                } else if (d5 < d && d + d3 <= d7) {
                    if (d8 <= d2 + d4 && d2 < d8 + rectangle3.getHeight()) {
                        this.canvas.blockScrollDown();
                    } else if (d6 - rectangle3.getHeight() < d2 && d2 < d6) {
                        this.canvas.blockScrollUp();
                    } else {
                        this.canvas.scrollToPixel(d, d2);
                    }
                } else {
                    this.canvas.scrollToPixel(d, d2);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            System.out.println(badLocationException);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.repaint(this.getSelectedArea());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.canvas.markAsModified();
        this.updateBounds();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.canvas.markAsModified();
        this.updateBounds();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.canvas.markAsModified();
        this.updateBounds();
    }

    public void setPosition(int n, int n2) {
        this.pos.x = n;
        this.pos.y = n2;
        this.updateBounds();
    }

    public void setPositionY(int n) {
        this.pos.y = n;
        this.updateBounds();
    }

    public Point getPosition() {
        return this.pos;
    }

    @Override
    public void setFont(Font font) {
        AffineTransform affineTransform = new AffineTransform();
        if (this.canvas != null) {
            double d = this.canvas.getMagnification();
            affineTransform.scale(d, d);
        }
        super.setFont(font.deriveFont(affineTransform));
        this.updateBounds();
    }

    public void updateBounds() {
        Object object;
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (graphics2D == null) {
            return;
        }
        Dimension dimension = this.getSize();
        if (dimension == null) {
            return;
        }
        double d = this.canvas.getMagnification();
        graphics2D.setRenderingHints(this.canvas.getRenderingHints());
        Font font = this.getFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.getDescent();
        dimension.height = n + n2;
        try {
            object = this.getCaret();
            Rectangle rectangle = this.modelToView(object.getDot());
            dimension.width = (int)rectangle.getWidth();
        }
        catch (BadLocationException badLocationException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        object = this.getText();
        int n3 = ((String)object).length();
        object = (String)object + widestChar;
        if (!((String)object).equals("")) {
            if (((String)object).startsWith(" ")) {
                object = widestChar + ((String)object).substring(1);
            }
            TextLayout textLayout = new TextLayout((String)object, font, fontRenderContext);
            Rectangle2D rectangle2D = textLayout.getBounds();
            dimension.width += (int)Math.ceil(rectangle2D.getWidth()) + 1;
        }
        graphics2D.dispose();
        int n4 = fontMetrics.getMaxAscent();
        int n5 = fontMetrics.getMaxDescent();
        this.setBounds((int)Math.round((double)this.pos.x * d), (int)Math.round((double)this.pos.y * d - (double)n4), (int)Math.round(dimension.getWidth()), Math.round(n4 + n5));
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        int n2;
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = this.getVisibleRect();
        Paint paint = graphics2D.getPaint();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.setPaint(this.background);
        graphics2D.fill(rectangle);
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        double d = this.canvas.getMagnification();
        TextLayout textLayout = null;
        if (!this.getText().equals("")) {
            graphics2D.setRenderingHints(this.canvas.getRenderingHints());
            object = this.getFont();
            FontMetrics fontMetrics = graphics2D.getFontMetrics((Font)object);
            n2 = fontMetrics.getMaxDescent();
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            textLayout = new TextLayout(this.getText(), (Font)object, fontRenderContext);
            BBox bBox = new BBox(textLayout.getBounds());
            double d2 = fontMetrics.getMaxAscent();
            graphics2D.translate(0.0, d2);
            graphics2D.setPaint(this.foreground.getPaint(bBox));
            textLayout.draw(graphics2D, 0.0f, 0.0f);
            graphics2D.translate(0.0, -d2);
        }
        graphics2D.setRenderingHints(renderingHints);
        object = this.getCaret();
        graphics.setColor(this.getCaretColor());
        object.paint(graphics);
        graphics2D.setTransform(affineTransform);
        if (textLayout != null && (n = this.getSelectionStart()) != (n2 = this.getSelectionEnd())) {
            graphics2D.setXORMode(this.foreground.getColor());
            graphics2D.setColor(this.getSelectedTextColor());
            graphics2D.fill(this.getSelectedArea());
            graphics2D.setPaintMode();
        }
        graphics2D.setPaint(paint);
    }

    public Rectangle getSelectedArea() {
        Rectangle rectangle;
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        int n3 = 0;
        int n4 = 0;
        try {
            rectangle = this.modelToView(n);
            n3 = rectangle.x;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        try {
            rectangle = this.modelToView(n2);
            n4 = rectangle.x + rectangle.width;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        rectangle = new Rectangle(n3, 0, n4 - n3, this.getHeight());
        return rectangle;
    }

    @Override
    public Color getForeground() {
        return null;
    }

    public void setTextPaint(JDRPaint jDRPaint) {
        this.foreground = jDRPaint;
    }

    public JDRPaint getTextPaint() {
        return this.foreground;
    }
}

