/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jpgfdraw;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import uk.ac.uea.cmp.nlct.jdrresources.JDRAction;
import uk.ac.uea.cmp.nlct.jdrresources.JDRActionEvent;
import uk.ac.uea.cmp.nlct.jdrresources.JDRCheckBoxMenuItem;
import uk.ac.uea.cmp.nlct.jdrresources.JDRMenuItem;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jpgfdraw.JDRCanvas;

public class CanvasAction
extends JDRAction {
    private static KeyStroke KEY_NEXT = KeyStroke.getKeyStroke(117, 0);
    private static KeyStroke KEY_PREV = KeyStroke.getKeyStroke(117, 1);
    private static KeyStroke KEY_DELETE = KeyStroke.getKeyStroke(127, 0);
    private static KeyStroke KEY_ADD = KeyStroke.getKeyStroke(155, 0);
    private static KeyStroke KEY_MOVE = KeyStroke.getKeyStroke(118, 0);
    private JDRCanvas canvas;
    public static final int ACTION_TO_LINE = 0;
    public static final int ACTION_TO_CURVE = 1;
    public static final int ACTION_TO_MOVE = 2;
    public static final int ACTION_NEXT = 3;
    public static final int ACTION_PREV = 4;
    public static final int ACTION_BREAK = 5;
    public static final int ACTION_INSERT = 6;
    public static final int ACTION_DELETE_POINT = 7;
    public static final int ACTION_SYMMETRY_HAS = 8;
    public static final int ACTION_SYMMETRY_ANCHOR = 9;
    public static final int ACTION_SYMMETRY_CLOSE = 10;
    public static final int ACTION_CONTINUOUS = 11;
    public static final int ACTION_OPEN_REMOVE = 12;
    public static final int ACTION_OPEN_KEEP = 13;
    public static final int ACTION_CLOSE_LINE = 14;
    public static final int ACTION_CLOSE_CONT = 15;
    public static final int ACTION_CLOSE_MERGE = 16;
    public static final int ACTION_MOVE = 17;
    public static final int ACTION_SNAP = 18;
    public static final int ACTION_FINISH = 19;
    public static final int ACTION_ABANDON = 20;
    public static final int ACTION_SHOW_POPUP = 21;
    public static final int ACTION_CONSTRUCT_CLICK = 22;
    public static final int ACTION_MOVE_LEFT = 23;
    public static final int ACTION_MOVE_RIGHT = 24;
    public static final int ACTION_MOVE_UP = 25;
    public static final int ACTION_MOVE_DOWN = 26;
    public static final int ACTION_SCROLL_HOME_UP = 27;
    public static final int ACTION_SCROLL_HOME_LEFT = 28;
    public static final int ACTION_SCROLL_END_DOWN = 29;
    public static final int ACTION_SCROLL_END_RIGHT = 30;
    public static final int ACTION_BLOCK_SCROLL_UP = 31;
    public static final int ACTION_BLOCK_SCROLL_DOWN = 32;
    public static final int ACTION_BLOCK_SCROLL_LEFT = 33;
    public static final int ACTION_BLOCK_SCROLL_RIGHT = 34;
    public static final int ACTION_DELETE_LAST = 35;

    public CanvasAction(JDRCanvas jDRCanvas) {
        this.canvas = jDRCanvas;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.getActionId();
        if (n == -1 && actionEvent instanceof JDRActionEvent) {
            n = ((JDRActionEvent)actionEvent).getActionId();
        }
        if (n == -1) {
            return;
        }
        int n2 = this.canvas.getCurrentTool();
        int n3 = actionEvent.getModifiers();
        switch (n) {
            case 0: {
                this.canvas.convertToLine();
                return;
            }
            case 1: {
                this.canvas.convertToCurve();
                return;
            }
            case 2: {
                this.canvas.convertToMove();
                return;
            }
            case 3: {
                if (n2 != 0) {
                    return;
                }
                this.canvas.skipObjOrNextPt();
                return;
            }
            case 4: {
                if (n2 != 0) {
                    return;
                }
                this.canvas.addNextObjOrPrevPt();
                return;
            }
            case 5: {
                this.canvas.breakPath();
                return;
            }
            case 6: {
                this.canvas.insertControlOrSymbol();
                return;
            }
            case 7: {
                this.canvas.deleteCurrentControlPoint();
                return;
            }
            case 8: {
                this.canvas.setSymmetry();
                return;
            }
            case 9: {
                this.canvas.anchorSymmetry();
                return;
            }
            case 10: {
                this.canvas.closeAnchorSymmetry();
                return;
            }
            case 11: {
                this.canvas.makeContinuous();
                return;
            }
            case 12: {
                this.canvas.openPath(true);
                return;
            }
            case 13: {
                this.canvas.openPath(false);
                return;
            }
            case 14: {
                this.canvas.closePath(0);
                return;
            }
            case 15: {
                this.canvas.closePath(1);
                return;
            }
            case 16: {
                this.canvas.closePath(2);
                return;
            }
            case 17: {
                if (n2 != 0) {
                    return;
                }
                this.canvas.moveControlOrObject();
                return;
            }
            case 18: {
                this.canvas.snapToGrid();
                return;
            }
            case 19: {
                this.canvas.finish();
                return;
            }
            case 20: {
                this.canvas.abandonPath();
                return;
            }
            case 21: {
                this.canvas.showPopup();
                return;
            }
            case 22: {
                this.canvas.doConstructMouseClick();
                return;
            }
            case 23: {
                this.canvas.moveLeft(n3);
                return;
            }
            case 24: {
                this.canvas.moveRight(n3);
                return;
            }
            case 25: {
                this.canvas.moveUp(n3);
                return;
            }
            case 26: {
                this.canvas.moveDown(n3);
                return;
            }
            case 27: {
                this.canvas.scrollHomeUp();
                return;
            }
            case 28: {
                this.canvas.scrollHomeLeft();
                return;
            }
            case 29: {
                this.canvas.scrollEndDown();
                return;
            }
            case 30: {
                this.canvas.scrollEndRight();
                return;
            }
            case 31: {
                this.canvas.blockScrollUp();
                return;
            }
            case 32: {
                this.canvas.blockScrollDown();
                return;
            }
            case 33: {
                this.canvas.blockScrollLeft();
                return;
            }
            case 34: {
                this.canvas.blockScrollRight();
                return;
            }
            case 35: {
                this.canvas.deleteLast();
                return;
            }
        }
    }

    public static CanvasAction getFinishAction(JDRCanvas jDRCanvas) {
        CanvasAction canvasAction = new CanvasAction(jDRCanvas);
        canvasAction.setActionId(19);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        Integer n = new Integer(canvasAction.getActionId());
        jDRCanvas.getInputMap(2).put(keyStroke, n);
        jDRCanvas.getActionMap().put(n, canvasAction);
        return canvasAction;
    }

    public static CanvasAction getAbandonAction(JDRCanvas jDRCanvas) {
        CanvasAction canvasAction = new CanvasAction(jDRCanvas);
        canvasAction.setActionId(20);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        Integer n = new Integer(canvasAction.getActionId());
        jDRCanvas.getInputMap(2).put(keyStroke, n);
        jDRCanvas.getActionMap().put(n, canvasAction);
        return canvasAction;
    }

    public static CanvasAction getNextAction(JDRCanvas jDRCanvas) {
        CanvasAction canvasAction = new CanvasAction(jDRCanvas);
        canvasAction.setActionId(3);
        KeyStroke keyStroke = KEY_NEXT;
        Integer n = new Integer(canvasAction.getActionId());
        jDRCanvas.getInputMap(2).put(keyStroke, n);
        jDRCanvas.getActionMap().put(n, canvasAction);
        return canvasAction;
    }

    public static CanvasAction getPrevAction(JDRCanvas jDRCanvas) {
        CanvasAction canvasAction = new CanvasAction(jDRCanvas);
        canvasAction.setActionId(4);
        KeyStroke keyStroke = KEY_PREV;
        Integer n = new Integer(canvasAction.getActionId());
        jDRCanvas.getInputMap(2).put(keyStroke, n);
        jDRCanvas.getActionMap().put(n, canvasAction);
        return canvasAction;
    }

    public static CanvasAction getDeletePointAction(JDRCanvas jDRCanvas) {
        CanvasAction canvasAction = new CanvasAction(jDRCanvas);
        canvasAction.setActionId(7);
        KeyStroke keyStroke = KEY_DELETE;
        Integer n = new Integer(canvasAction.getActionId());
        jDRCanvas.getInputMap(2).put(keyStroke, n);
        jDRCanvas.getActionMap().put(n, canvasAction);
        return canvasAction;
    }

    public static CanvasAction getInsertAction(JDRCanvas jDRCanvas) {
        CanvasAction canvasAction = new CanvasAction(jDRCanvas);
        canvasAction.setActionId(6);
        KeyStroke keyStroke = KEY_ADD;
        Integer n = new Integer(canvasAction.getActionId());
        jDRCanvas.getInputMap(2).put(keyStroke, n);
        jDRCanvas.getActionMap().put(n, canvasAction);
        return canvasAction;
    }

    public static CanvasAction getMoveAction(JDRCanvas jDRCanvas) {
        CanvasAction canvasAction = new CanvasAction(jDRCanvas);
        canvasAction.setActionId(17);
        KeyStroke keyStroke = KEY_MOVE;
        Integer n = new Integer(canvasAction.getActionId());
        jDRCanvas.getInputMap(2).put(keyStroke, n);
        jDRCanvas.getActionMap().put(n, canvasAction);
        return canvasAction;
    }

    public static CanvasAction getShowPopupAction(JDRCanvas jDRCanvas) {
        CanvasAction canvasAction = new CanvasAction(jDRCanvas);
        canvasAction.setActionId(21);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(114, 0);
        Integer n = new Integer(canvasAction.getActionId());
        jDRCanvas.getInputMap(2).put(keyStroke, n);
        jDRCanvas.getInputMap(2).put(KeyStroke.getKeyStroke(525, 0), n);
        jDRCanvas.getActionMap().put(n, canvasAction);
        return canvasAction;
    }

    public static CanvasAction getConstructClickAction(JDRCanvas jDRCanvas) {
        CanvasAction canvasAction = new CanvasAction(jDRCanvas);
        canvasAction.setActionId(22);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(115, 0);
        Integer n = new Integer(canvasAction.getActionId());
        jDRCanvas.getInputMap(2).put(keyStroke, n);
        jDRCanvas.getActionMap().put(n, canvasAction);
        return canvasAction;
    }

    public static CanvasAction getMoveLeftAction(JDRCanvas jDRCanvas) {
        CanvasAction canvasAction = new CanvasAction(jDRCanvas);
        canvasAction.setActionId(23);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(37, 0);
        Integer n = new Integer(canvasAction.getActionId());
        jDRCanvas.getInputMap(2).put(keyStroke, n);
        jDRCanvas.getActionMap().put(n, canvasAction);
        return canvasAction;
    }

    public static CanvasAction getMoveRightAction(JDRCanvas jDRCanvas) {
        CanvasAction canvasAction = new CanvasAction(jDRCanvas);
        canvasAction.setActionId(24);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(39, 0);
        Integer n = new Integer(canvasAction.getActionId());
        jDRCanvas.getInputMap(2).put(keyStroke, n);
        jDRCanvas.getActionMap().put(n, canvasAction);
        return canvasAction;
    }

    public static CanvasAction getMoveUpAction(JDRCanvas jDRCanvas) {
        CanvasAction canvasAction = new CanvasAction(jDRCanvas);
        canvasAction.setActionId(25);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(38, 0);
        Integer n = new Integer(canvasAction.getActionId());
        jDRCanvas.getInputMap(2).put(keyStroke, n);
        jDRCanvas.getActionMap().put(n, canvasAction);
        return canvasAction;
    }

    public static CanvasAction getMoveDownAction(JDRCanvas jDRCanvas) {
        CanvasAction canvasAction = new CanvasAction(jDRCanvas);
        canvasAction.setActionId(26);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(40, 0);
        Integer n = new Integer(canvasAction.getActionId());
        jDRCanvas.getInputMap(2).put(keyStroke, n);
        jDRCanvas.getActionMap().put(n, canvasAction);
        return canvasAction;
    }

    public static CanvasAction getScrollHomeUpAction(JDRCanvas jDRCanvas) {
        CanvasAction canvasAction = new CanvasAction(jDRCanvas);
        canvasAction.setActionId(27);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(36, 0);
        Integer n = new Integer(canvasAction.getActionId());
        jDRCanvas.getInputMap(2).put(keyStroke, n);
        jDRCanvas.getActionMap().put(n, canvasAction);
        return canvasAction;
    }

    public static CanvasAction getScrollHomeLeftAction(JDRCanvas jDRCanvas) {
        CanvasAction canvasAction = new CanvasAction(jDRCanvas);
        canvasAction.setActionId(28);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(36, 2);
        Integer n = new Integer(canvasAction.getActionId());
        jDRCanvas.getInputMap(2).put(keyStroke, n);
        jDRCanvas.getActionMap().put(n, canvasAction);
        return canvasAction;
    }

    public static CanvasAction getScrollEndDownAction(JDRCanvas jDRCanvas) {
        CanvasAction canvasAction = new CanvasAction(jDRCanvas);
        canvasAction.setActionId(29);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(35, 0);
        Integer n = new Integer(canvasAction.getActionId());
        jDRCanvas.getInputMap(2).put(keyStroke, n);
        jDRCanvas.getActionMap().put(n, canvasAction);
        return canvasAction;
    }

    public static CanvasAction getScrollEndRightAction(JDRCanvas jDRCanvas) {
        CanvasAction canvasAction = new CanvasAction(jDRCanvas);
        canvasAction.setActionId(30);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(35, 2);
        Integer n = new Integer(canvasAction.getActionId());
        jDRCanvas.getInputMap(2).put(keyStroke, n);
        jDRCanvas.getActionMap().put(n, canvasAction);
        return canvasAction;
    }

    public static CanvasAction getBlockScrollDownAction(JDRCanvas jDRCanvas) {
        CanvasAction canvasAction = new CanvasAction(jDRCanvas);
        canvasAction.setActionId(32);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(34, 0);
        Integer n = new Integer(canvasAction.getActionId());
        jDRCanvas.getInputMap(2).put(keyStroke, n);
        jDRCanvas.getActionMap().put(n, canvasAction);
        return canvasAction;
    }

    public static CanvasAction getBlockScrollRightAction(JDRCanvas jDRCanvas) {
        CanvasAction canvasAction = new CanvasAction(jDRCanvas);
        canvasAction.setActionId(34);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(34, 2);
        Integer n = new Integer(canvasAction.getActionId());
        jDRCanvas.getInputMap(2).put(keyStroke, n);
        jDRCanvas.getActionMap().put(n, canvasAction);
        return canvasAction;
    }

    public static CanvasAction getBlockScrollUpAction(JDRCanvas jDRCanvas) {
        CanvasAction canvasAction = new CanvasAction(jDRCanvas);
        canvasAction.setActionId(31);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(33, 0);
        Integer n = new Integer(canvasAction.getActionId());
        jDRCanvas.getInputMap(2).put(keyStroke, n);
        jDRCanvas.getActionMap().put(n, canvasAction);
        return canvasAction;
    }

    public static CanvasAction getBlockScrollLeftAction(JDRCanvas jDRCanvas) {
        CanvasAction canvasAction = new CanvasAction(jDRCanvas);
        canvasAction.setActionId(33);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(33, 2);
        Integer n = new Integer(canvasAction.getActionId());
        jDRCanvas.getInputMap(2).put(keyStroke, n);
        jDRCanvas.getActionMap().put(n, canvasAction);
        return canvasAction;
    }

    public static CanvasAction getDeleteLastAction(JDRCanvas jDRCanvas) {
        CanvasAction canvasAction = new CanvasAction(jDRCanvas);
        canvasAction.setActionId(35);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(8, 0);
        Integer n = new Integer(canvasAction.getActionId());
        jDRCanvas.getInputMap(2).put(keyStroke, n);
        jDRCanvas.getActionMap().put(n, canvasAction);
        return canvasAction;
    }

    public JDRMenuItem createNextPointItem() {
        JDRMenuItem jDRMenuItem = new JDRMenuItem(JDRResources.getString("editpath.next"), JDRResources.getChar("editpath.next.mnemonic"));
        jDRMenuItem.setToolTipText(JDRResources.getString("tooltip.next_control"));
        jDRMenuItem.setAccelerator(KEY_NEXT);
        jDRMenuItem.addActionListener(this);
        jDRMenuItem.setActionId(3);
        return jDRMenuItem;
    }

    public JDRMenuItem createPrevPointItem() {
        JDRMenuItem jDRMenuItem = new JDRMenuItem(JDRResources.getString("editpath.prev"), JDRResources.getChar("editpath.prev.mnemonic"));
        jDRMenuItem.setToolTipText(JDRResources.getString("tooltip.prev_control"));
        jDRMenuItem.setAccelerator(KEY_PREV);
        jDRMenuItem.addActionListener(this);
        jDRMenuItem.setActionId(4);
        return jDRMenuItem;
    }

    public JDRMenuItem createDelPointItem() {
        JDRMenuItem jDRMenuItem = new JDRMenuItem(JDRResources.getString("editpath.delete"), JDRResources.getChar("editpath.delete.mnemonic"));
        jDRMenuItem.setToolTipText(JDRResources.getString("tooltip.delete_control"));
        jDRMenuItem.setAccelerator(KEY_DELETE);
        jDRMenuItem.addActionListener(this);
        jDRMenuItem.setActionId(7);
        return jDRMenuItem;
    }

    public JDRMenuItem createAddPointItem() {
        JDRMenuItem jDRMenuItem = new JDRMenuItem(JDRResources.getString("editpath.add"), JDRResources.getChar("editpath.add.mnemonic"));
        jDRMenuItem.setToolTipText(JDRResources.getString("tooltip.add_point"));
        jDRMenuItem.setAccelerator(KEY_ADD);
        jDRMenuItem.addActionListener(this);
        jDRMenuItem.setActionId(6);
        return jDRMenuItem;
    }

    public JDRMenuItem createConvertToLineItem() {
        JDRMenuItem jDRMenuItem = new JDRMenuItem(JDRResources.getString("editpath.line"), JDRResources.getChar("editpath.line.mnemonic"));
        jDRMenuItem.setToolTipText(JDRResources.getString("tooltip.convert_to_line"));
        jDRMenuItem.addActionListener(this);
        jDRMenuItem.setActionId(0);
        return jDRMenuItem;
    }

    public JDRMenuItem createConvertToCurveItem() {
        JDRMenuItem jDRMenuItem = new JDRMenuItem(JDRResources.getString("editpath.curve"), JDRResources.getChar("editpath.curve.mnemonic"));
        jDRMenuItem.setToolTipText(JDRResources.getString("tooltip.convert_to_curve"));
        jDRMenuItem.addActionListener(this);
        jDRMenuItem.setActionId(1);
        return jDRMenuItem;
    }

    public JDRMenuItem createConvertToMoveItem() {
        JDRMenuItem jDRMenuItem = new JDRMenuItem(JDRResources.getString("editpath.move"), JDRResources.getChar("editpath.move.mnemonic"));
        jDRMenuItem.setToolTipText(JDRResources.getString("tooltip.convert_to_move"));
        jDRMenuItem.addActionListener(this);
        jDRMenuItem.setActionId(2);
        return jDRMenuItem;
    }

    public JDRCheckBoxMenuItem createHasSymmetryItem() {
        JDRCheckBoxMenuItem jDRCheckBoxMenuItem = new JDRCheckBoxMenuItem(JDRResources.getString("editpath.symmetry.has"), JDRResources.getChar("editpath.symmetry.has.mnemonic"), false);
        jDRCheckBoxMenuItem.setToolTipText(JDRResources.getString("tooltip.symmetry.has"));
        jDRCheckBoxMenuItem.addActionListener(this);
        jDRCheckBoxMenuItem.setActionId(8);
        return jDRCheckBoxMenuItem;
    }

    public JDRCheckBoxMenuItem createSymmetryAnchorItem() {
        JDRCheckBoxMenuItem jDRCheckBoxMenuItem = new JDRCheckBoxMenuItem(JDRResources.getString("editpath.symmetry.join_anchor"), JDRResources.getChar("editpath.symmetry.join_anchor.mnemonic"), false);
        jDRCheckBoxMenuItem.setToolTipText(JDRResources.getString("tooltip.symmetry.join_anchor"));
        jDRCheckBoxMenuItem.addActionListener(this);
        jDRCheckBoxMenuItem.setActionId(9);
        return jDRCheckBoxMenuItem;
    }

    public JDRCheckBoxMenuItem createSymmetryCloseItem() {
        JDRCheckBoxMenuItem jDRCheckBoxMenuItem = new JDRCheckBoxMenuItem(JDRResources.getString("editpath.symmetry.close_anchor"), JDRResources.getChar("editpath.symmetry.close_anchor.mnemonic"), false);
        jDRCheckBoxMenuItem.setToolTipText(JDRResources.getString("tooltip.symmetry.close_anchor"));
        jDRCheckBoxMenuItem.addActionListener(this);
        jDRCheckBoxMenuItem.setActionId(10);
        return jDRCheckBoxMenuItem;
    }

    public JDRMenuItem createContinuousItem() {
        JDRMenuItem jDRMenuItem = new JDRMenuItem(JDRResources.getString("editpath.continuous"), JDRResources.getChar("editpath.continuous.mnemonic"));
        jDRMenuItem.setToolTipText(JDRResources.getString("tooltip.continuous"));
        jDRMenuItem.addActionListener(this);
        jDRMenuItem.setActionId(11);
        return jDRMenuItem;
    }

    public JDRMenuItem createOpenRemoveItem() {
        JDRMenuItem jDRMenuItem = new JDRMenuItem(JDRResources.getString("editpath.open.remove_last"), JDRResources.getChar("editpath.open.remove_last.mnemonic"));
        jDRMenuItem.setToolTipText(JDRResources.getString("tooltip.open_path.remove_last"));
        jDRMenuItem.addActionListener(this);
        jDRMenuItem.setActionId(12);
        return jDRMenuItem;
    }

    public JDRMenuItem createOpenKeepItem() {
        JDRMenuItem jDRMenuItem = new JDRMenuItem(JDRResources.getString("editpath.open.keep_last"), JDRResources.getChar("editpath.open.keep_last.mnemonic"));
        jDRMenuItem.setToolTipText(JDRResources.getString("tooltip.open_path.keep_last"));
        jDRMenuItem.addActionListener(this);
        jDRMenuItem.setActionId(13);
        return jDRMenuItem;
    }

    public JDRMenuItem createCloseLineItem() {
        JDRMenuItem jDRMenuItem = new JDRMenuItem(JDRResources.getString("editpath.close.line"), JDRResources.getChar("editpath.close.line.mnemonic"));
        jDRMenuItem.setToolTipText(JDRResources.getString("tooltip.close_path.line"));
        jDRMenuItem.addActionListener(this);
        jDRMenuItem.setActionId(14);
        return jDRMenuItem;
    }

    public JDRMenuItem createCloseContItem() {
        JDRMenuItem jDRMenuItem = new JDRMenuItem(JDRResources.getString("editpath.close.cont"), JDRResources.getChar("editpath.close.cont.mnemonic"));
        jDRMenuItem.setToolTipText(JDRResources.getString("tooltip.close_path.cont"));
        jDRMenuItem.addActionListener(this);
        jDRMenuItem.setActionId(15);
        return jDRMenuItem;
    }

    public JDRMenuItem createCloseMergeItem() {
        JDRMenuItem jDRMenuItem = new JDRMenuItem(JDRResources.getString("editpath.close.merge"), JDRResources.getChar("editpath.close.merge.mnemonic"));
        jDRMenuItem.setToolTipText(JDRResources.getString("tooltip.close_path.merge"));
        jDRMenuItem.addActionListener(this);
        jDRMenuItem.setActionId(16);
        return jDRMenuItem;
    }

    public JDRMenuItem createMovePointItem() {
        JDRMenuItem jDRMenuItem = new JDRMenuItem(JDRResources.getString("editpath.coordinates"), JDRResources.getChar("editpath.coordinates.mnemonic"));
        jDRMenuItem.setToolTipText(JDRResources.getString("tooltip.coordinates"));
        jDRMenuItem.addActionListener(this);
        jDRMenuItem.setActionId(17);
        jDRMenuItem.setAccelerator(KEY_MOVE);
        return jDRMenuItem;
    }

    public JDRMenuItem createSnapItem() {
        JDRMenuItem jDRMenuItem = new JDRMenuItem(JDRResources.getString("editpath.snap"), JDRResources.getChar("editpath.snap.mnemonic"));
        jDRMenuItem.setToolTipText(JDRResources.getString("tooltip.snap"));
        jDRMenuItem.addActionListener(this);
        jDRMenuItem.setActionId(18);
        return jDRMenuItem;
    }

    public JDRMenuItem createBreakPathItem() {
        JDRMenuItem jDRMenuItem = new JDRMenuItem(JDRResources.getString("editpath.break"), JDRResources.getChar("editpath.break.mnemonic"));
        jDRMenuItem.setToolTipText(JDRResources.getString("tooltip.break_path"));
        jDRMenuItem.addActionListener(this);
        jDRMenuItem.setActionId(5);
        return jDRMenuItem;
    }
}

