/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.ajr2tex;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import uk.ac.uea.cmp.nlct.jdr.CanvasSettings;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.LaTeXFontBase;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;
import uk.ac.uea.cmp.nlct.jdr.io.PGF;

public class Ajr2Tex {
    public static void appVersion() {
        System.err.println("ajr2tex 1.5");
        System.err.println("Copyright (C) 2007 Nicola L C Talbot");
        System.err.println("This is free software distributed under the GNU General Public License.");
        System.err.println("There is NO WARRANTY. See accompanying licence file for details.");
    }

    public static void syntax(int n) {
        System.err.println("Syntax: ajr2tex [-version] [-doc] <ajr file> <tex file>");
        System.exit(n);
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        boolean bl = false;
        JDR.messageSystem.suspend();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-version")) {
                Ajr2Tex.appVersion();
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-doc")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-help")) {
                Ajr2Tex.syntax(0);
                continue;
            }
            if (stringArray[i].startsWith("-")) {
                System.err.println("Unknown switch '" + stringArray[i] + "'");
                Ajr2Tex.syntax(1);
                continue;
            }
            if (string == null) {
                string = stringArray[i];
                continue;
            }
            if (string2 == null) {
                string2 = stringArray[i];
                continue;
            }
            System.err.println("Too many file names specified");
            Ajr2Tex.syntax(1);
        }
        if (string == null) {
            System.err.println("Missing input file");
            Ajr2Tex.syntax(1);
        } else if (string2 == null) {
            System.err.println("Missing output file");
            Ajr2Tex.syntax(1);
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (IOException iOException) {
            System.err.println("Unable to open " + iOException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
        String string3 = "";
        CanvasSettings canvasSettings = new CanvasSettings();
        JDRGroup jDRGroup = null;
        try {
            jDRGroup = AJR.load(bufferedReader, canvasSettings);
        }
        catch (InvalidFormatException invalidFormatException) {
            System.err.println(invalidFormatException.getMessage());
            System.exit(1);
        }
        catch (EOFException eOFException) {
            System.err.println("Unexpected EOF. (File corrupt?)");
            System.exit(1);
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new File(string2));
        }
        catch (IOException iOException) {
            System.err.println("Unable to open " + iOException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
        try {
            if (bl) {
                PGF.saveDoc(jDRGroup, canvasSettings.paper, new LaTeXFontBase(canvasSettings.normalsize), "", printWriter, "ajr2tex");
            } else {
                PGF.save(jDRGroup, printWriter, "ajr2tex");
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
        try {
            printWriter.close();
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
    }
}

