/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.marker;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.BufferOverflowException;
import java.util.Enumeration;
import java.util.Hashtable;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.InvalidCompositeMarkerException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidMarkerTypeException;
import uk.ac.uea.cmp.nlct.jdr.InvalidRepeatValueException;
import uk.ac.uea.cmp.nlct.jdr.JDRBasicStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRBezier;
import uk.ac.uea.cmp.nlct.jdr.JDRGradient;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPaintLoader;
import uk.ac.uea.cmp.nlct.jdr.JDRPartialBezier;
import uk.ac.uea.cmp.nlct.jdr.JDRPartialSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRPathSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRRadial;
import uk.ac.uea.cmp.nlct.jdr.JDRShape;
import uk.ac.uea.cmp.nlct.jdr.JDRTransparent;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;
import uk.ac.uea.cmp.nlct.jdr.io.PGF;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowAltBar;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowAltBrace;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowAltRound;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowAltSingle;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowAltSingleOpen;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowAltSquare;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowAsterisk;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowBallCap;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowBar;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowBoxFilled;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowBoxOpen;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowBrace;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowBulgeCap;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowChevronCap;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowCircle;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowCircleOpen;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowClubCap;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowCross;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowCusp;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowCutoutBulgeCap;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowDiamond;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowDiamondOpen;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowDotFilled;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowDotOpen;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowEquilateralFilled;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowEquilateralOpen;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowFastCap;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowHalfCuspDown;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowHalfCuspUp;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowHalfPointed45Down;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowHalfPointed45Up;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowHalfPointed60Down;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowHalfPointed60Up;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowHalfPointedDown;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowHalfPointedUp;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowHeartFilled;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowHeartOpen;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowHeartRightFilled;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowHeartRightOpen;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowHexagonFilled;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowHexagonOpen;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowHookDown;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowHookUp;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowHooks;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowInvertChevronCap;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowInvertFastCap;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowInvertTriangleCap;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowLeaf2BackCap;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowLeaf2Cap;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowLeaf2ForCap;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowLeaf3BackCap;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowLeaf3Cap;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowLeaf3ForCap;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowLeafCap;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowOctagonFilled;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowOctagonOpen;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowPentagonFilled;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowPentagonOpen;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowPlus;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowPointed;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowPointed45;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowPointed60;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowRectangleCap;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowRhombusFilled;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowRhombusOpen;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowRound;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowRoundCap;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowScissorsDownFilled;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowScissorsDownOpen;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowScissorsUpFilled;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowScissorsUpOpen;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowSemiCircleFilled;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowSemiCircleOpen;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowSingle;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowSnowflake;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowSquare;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowStar;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowStar5Filled;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowStar5Open;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowStar6Filled;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowStar6Open;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowStarChevronFilled;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowStarChevronOpen;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowTriangle;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowTriangleCap;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowTriangleDownFilled;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowTriangleDownOpen;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowTriangleOpen;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowTriangleUpFilled;
import uk.ac.uea.cmp.nlct.jdr.marker.ArrowTriangleUpOpen;

public class JDRMarker
implements Serializable,
Cloneable {
    protected boolean autoOrient_ = true;
    protected double angle_ = 0.0;
    public JDRPaint fillPaint = null;
    protected double penWidth = 1.0;
    protected int repeated = 1;
    protected boolean reversed = false;
    protected double size = 5.0;
    protected JDRMarker composite = null;
    protected JDRMarker parent = null;
    protected boolean overlay = false;
    private double offset_ = 0.0;
    private boolean userOffset = false;
    private double repeatOffset = 0.0;
    private boolean userRepeatOffset = false;
    protected int type = 0;
    public static final int ARROW_NONE = 0;
    public static final int ARROW_POINTED = 1;
    public static final int ARROW_TRIANGLE = 2;
    public static final int ARROW_CIRCLE = 3;
    public static final int ARROW_DIAMOND = 4;
    public static final int ARROW_SQUARE = 5;
    public static final int ARROW_BAR = 6;
    public static final int ARROW_SINGLE = 7;
    public static final int ARROW_ROUND = 8;
    public static final int ARROW_DOTFILLED = 9;
    public static final int ARROW_DOTOPEN = 10;
    public static final int ARROW_BOXFILLED = 11;
    public static final int ARROW_BOXOPEN = 12;
    public static final int ARROW_CROSS = 13;
    public static final int ARROW_PLUS = 14;
    public static final int ARROW_STAR = 15;
    public static final int ARROW_TRIANGLE_UP_FILLED = 16;
    public static final int ARROW_TRIANGLE_UP_OPEN = 17;
    public static final int ARROW_TRIANGLE_DOWN_FILLED = 18;
    public static final int ARROW_TRIANGLE_DOWN_OPEN = 19;
    public static final int ARROW_RHOMBUS_FILLED = 20;
    public static final int ARROW_RHOMBUS_OPEN = 21;
    public static final int ARROW_PENTAGON_FILLED = 22;
    public static final int ARROW_PENTAGON_OPEN = 23;
    public static final int ARROW_HEXAGON_FILLED = 24;
    public static final int ARROW_HEXAGON_OPEN = 25;
    public static final int ARROW_OCTAGON_FILLED = 26;
    public static final int ARROW_OCTAGON_OPEN = 27;
    public static final int ARROW_POINTED60 = 28;
    public static final int ARROW_POINTED45 = 29;
    public static final int ARROW_HOOKS = 30;
    public static final int ARROW_HOOK_UP = 31;
    public static final int ARROW_HOOK_DOWN = 32;
    public static final int ARROW_HALF_POINTED_UP = 33;
    public static final int ARROW_HALF_POINTED_DOWN = 34;
    public static final int ARROW_HALF_POINTED60_UP = 35;
    public static final int ARROW_HALF_POINTED60_DOWN = 36;
    public static final int ARROW_HALF_POINTED45_UP = 37;
    public static final int ARROW_HALF_POINTED45_DOWN = 38;
    public static final int ARROW_CUSP = 39;
    public static final int ARROW_HALF_CUSP_UP = 40;
    public static final int ARROW_HALF_CUSP_DOWN = 41;
    public static final int ARROW_ALT_SINGLE = 42;
    public static final int ARROW_ALT_SINGLE_OPEN = 43;
    public static final int ARROW_TRIANGLE_OPEN = 44;
    public static final int ARROW_CIRCLE_OPEN = 45;
    public static final int ARROW_DIAMOND_OPEN = 46;
    public static final int ARROW_BRACE = 47;
    public static final int ARROW_RECTANGLE_CAP = 48;
    public static final int ARROW_CHEVRON_CAP = 49;
    public static final int ARROW_FAST_CAP = 50;
    public static final int ARROW_ROUND_CAP = 51;
    public static final int ARROW_TRIANGLE_CAP = 52;
    public static final int ARROW_INVERT_TRIANGLE_CAP = 53;
    public static final int ARROW_INVERT_CHEVRON_CAP = 54;
    public static final int ARROW_INVERT_FAST_CAP = 55;
    public static final int ARROW_ALT_BAR = 56;
    public static final int ARROW_ALT_ROUND = 57;
    public static final int ARROW_ALT_SQUARE = 58;
    public static final int ARROW_ALT_BRACE = 59;
    public static final int ARROW_SEMICIRCLE_OPEN = 60;
    public static final int ARROW_SEMICIRCLE_FILLED = 61;
    public static final int ARROW_STAR5_OPEN = 62;
    public static final int ARROW_STAR5_FILLED = 63;
    public static final int ARROW_ASTERISK = 64;
    public static final int ARROW_SCISSORS_DOWN_FILLED = 65;
    public static final int ARROW_SCISSORS_UP_FILLED = 66;
    public static final int ARROW_SCISSORS_DOWN_OPEN = 67;
    public static final int ARROW_SCISSORS_UP_OPEN = 68;
    public static final int ARROW_HEART_RIGHT_FILLED = 69;
    public static final int ARROW_HEART_RIGHT_OPEN = 70;
    public static final int ARROW_HEART_FILLED = 71;
    public static final int ARROW_HEART_OPEN = 72;
    public static final int ARROW_SNOWFLAKE = 73;
    public static final int ARROW_STAR_CHEVRON_OPEN = 74;
    public static final int ARROW_STAR_CHEVRON_FILLED = 75;
    public static final int ARROW_STAR6_FILLED = 76;
    public static final int ARROW_STAR6_OPEN = 77;
    public static final int ARROW_EQUILATERAL_FILLED = 78;
    public static final int ARROW_EQUILATERAL_OPEN = 79;
    public static final int NUM_ARROWS1_6 = 91;
    public static final int NUM_ARROWS1_4 = 80;
    public static final int NUM_ARROWS1_1 = 22;
    public static final int NUM_ARROWS1_0 = 8;
    public static final int ARROW_BALL_CAP = 80;
    public static final int ARROW_LEAF_CAP = 81;
    public static final int ARROW_LEAF2_CAP = 82;
    public static final int ARROW_LEAF3_CAP = 83;
    public static final int ARROW_CLUB_CAP = 84;
    public static final int ARROW_LEAF3FOR_CAP = 85;
    public static final int ARROW_LEAF3BACK_CAP = 86;
    public static final int ARROW_LEAF2FOR_CAP = 87;
    public static final int ARROW_LEAF2BACK_CAP = 88;
    public static final int ARROW_BULGE_CAP = 89;
    public static final int ARROW_CUTOUTBULGE_CAP = 90;
    private boolean isStart_ = false;
    public static final double HALF_PI = 1.5707963267948966;
    public static final double QUARTER_PI = 0.7853981633974483;
    public static final double THREEQUARTER_PI = 2.356194490192345;
    public static final double HALF_ROOT_3 = 0.866025404;
    public static final double ROOT_3 = 1.732050808;
    public static final double ONE_OVER_ROOT_3 = 0.577350269;

    public JDRMarker(double d, int n, boolean bl) throws InvalidRepeatValueException {
        if (n < 1) {
            throw new InvalidRepeatValueException(n);
        }
        this.repeated = n;
        this.reversed = bl;
        this.penWidth = d;
        this.offset_ = 0.0;
        this.repeatOffset = 7.0 * this.penWidth;
    }

    public JDRMarker(double d, int n, boolean bl, double d2) throws InvalidRepeatValueException {
        this(d, n, bl);
        this.size = d2;
    }

    public JDRMarker() {
        this.repeated = 1;
        this.reversed = false;
        this.penWidth = 1.0;
        this.offset_ = 0.0;
        this.repeatOffset = 7.0;
    }

    public void draw(Graphics graphics, double d, JDRPathSegment jDRPathSegment, boolean bl) {
        this.penWidth = d;
        if (!this.userRepeatOffset) {
            this.repeatOffset = 7.0 * this.penWidth;
        }
        this.draw(graphics, jDRPathSegment, bl);
    }

    public void draw(Graphics graphics, JDRPathSegment jDRPathSegment, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(1.0f));
        Shape shape = this.getShape(jDRPathSegment, bl);
        Paint paint = null;
        if (this.fillPaint != null) {
            paint = graphics2D.getPaint();
            BBox bBox = this.getBBox();
            graphics2D.setPaint(this.fillPaint.getPaint(bBox));
        }
        graphics2D.fill(shape);
        graphics2D.setStroke(stroke);
        if (this.fillPaint != null) {
            graphics2D.setPaint(paint);
        }
        if (this.composite != null) {
            this.composite.draw(graphics, jDRPathSegment, bl);
        }
    }

    public void saveEPS(double d, JDRPaint jDRPaint, BBox bBox, JDRPathSegment jDRPathSegment, boolean bl, PrintWriter printWriter) throws IOException {
        this.penWidth = d;
        if (!this.userRepeatOffset) {
            this.repeatOffset = 7.0 * this.penWidth;
        }
        this.saveEPS(jDRPaint, bBox, jDRPathSegment, bl, printWriter);
    }

    public void saveEPS(JDRPaint jDRPaint, BBox bBox, JDRPathSegment jDRPathSegment, boolean bl, PrintWriter printWriter) throws IOException {
        printWriter.println("gsave");
        Shape shape = this.getShape(jDRPathSegment, bl);
        JDRPaint jDRPaint2 = jDRPaint;
        if (this.fillPaint != null) {
            jDRPaint2 = this.fillPaint;
        }
        jDRPaint2.saveEPS(printWriter, bBox);
        EPS.savePath(shape, printWriter);
        if (jDRPaint2 instanceof JDRGradient || jDRPaint2 instanceof JDRRadial) {
            printWriter.println("clip shfill");
        } else {
            printWriter.println("fill");
        }
        printWriter.println("grestore");
        if (this.composite != null) {
            this.composite.saveEPS(jDRPaint, bBox, jDRPathSegment, bl, printWriter);
        }
    }

    public Shape getShape(JDRPathSegment jDRPathSegment, boolean bl) {
        Object object;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (bl) {
            if (jDRPathSegment instanceof JDRBezier) {
                object = (JDRBezier)jDRPathSegment;
                d3 = jDRPathSegment.getStart().x;
                d4 = jDRPathSegment.getStart().y;
                d = 3.0 * ((JDRBezier)object).getControl1().x - 2.0 * d3;
                d2 = 3.0 * ((JDRBezier)object).getControl1().y - 2.0 * d4;
            } else {
                d = jDRPathSegment.getEnd().x;
                d2 = jDRPathSegment.getEnd().y;
                d3 = jDRPathSegment.getStart().x;
                d4 = jDRPathSegment.getStart().y;
            }
        } else if (jDRPathSegment instanceof JDRBezier) {
            object = (JDRBezier)jDRPathSegment;
            d3 = jDRPathSegment.getEnd().x;
            d4 = jDRPathSegment.getEnd().y;
            d = 3.0 * ((JDRBezier)object).getControl2().x - 2.0 * d3;
            d2 = 3.0 * ((JDRBezier)object).getControl2().y - 2.0 * d4;
        } else if (jDRPathSegment instanceof JDRPartialBezier) {
            object = (JDRPartialBezier)jDRPathSegment;
            JDRPoint jDRPoint = ((JDRPartialSegment)object).getEnd();
            d3 = jDRPoint.getX();
            d4 = jDRPoint.getY();
            Point2D point2D = ((JDRPartialBezier)object).getControl2();
            d = 3.0 * point2D.getX() - 2.0 * d3;
            d2 = 3.0 * point2D.getY() - 2.0 * d4;
        } else {
            object = jDRPathSegment.getEnd();
            d3 = ((JDRPoint)object).getX();
            d4 = ((JDRPoint)object).getY();
            d = jDRPathSegment.getStart().x;
            d2 = jDRPathSegment.getStart().y;
        }
        object = this.getShape(d, d2, d3, d4, bl && !this.hasXAxisSymmetry());
        return object;
    }

    public Shape getCompleteShape(JDRPathSegment jDRPathSegment, boolean bl) {
        GeneralPath generalPath = new GeneralPath(this.getShape(jDRPathSegment, bl));
        if (this.composite != null) {
            generalPath.append(this.composite.getCompleteShape(jDRPathSegment, bl), false);
        }
        return generalPath;
    }

    public boolean hasXAxisSymmetry() {
        return true;
    }

    private Shape getShape(double d, double d2, double d3, double d4, boolean bl) {
        AffineTransform affineTransform = new AffineTransform();
        GeneralPath generalPath = this.getPrimaryGeneralPath();
        double d5 = 0.0;
        if (this.autoOrient_) {
            if (bl) {
                affineTransform.scale(1.0, -1.0);
                generalPath.transform(affineTransform);
                affineTransform.setToIdentity();
            }
            double d6 = d3 - d;
            double d7 = d4 - d2;
            if (d7 == 0.0) {
                d5 = d6 < 0.0 ? Math.PI : 0.0;
            } else if (d6 == 0.0) {
                d5 = d7 < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
            } else {
                d5 = Math.atan(d7 / d6);
                if (d6 < 0.0) {
                    d5 += Math.PI;
                }
            }
        } else {
            d5 = this.angle_;
        }
        affineTransform.rotate(d5);
        Point2D.Double double_ = new Point2D.Double(this.offset_, 0.0);
        Point2D.Double double_2 = new Point2D.Double(this.offset_, 0.0);
        affineTransform.transform(double_, double_2);
        affineTransform.preConcatenate(AffineTransform.getTranslateInstance(d3 - ((Point2D)double_2).getX(), d4 - ((Point2D)double_2).getY()));
        Shape shape = generalPath.createTransformedShape(affineTransform);
        double[] dArray = new double[6];
        return shape;
    }

    public String pgfShape(JDRPaint jDRPaint, BBox bBox, JDRPathSegment jDRPathSegment, boolean bl, AffineTransform affineTransform) {
        if (this.getType() == 0) {
            return "";
        }
        String string = System.getProperty("line.separator", "\n");
        Shape shape = this.getShape(jDRPathSegment, bl);
        PathIterator pathIterator = shape.getPathIterator(affineTransform);
        double[] dArray = new double[6];
        String string2 = "% marker type " + this.getType() + string;
        string2 = string2 + "{\\begin{pgfscope}" + string;
        string2 = this.fillPaint != null ? string2 + this.fillPaint.pgffillcolor(null) : string2 + jDRPaint.pgffillcolor(null);
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(dArray)) {
                case 0: {
                    string2 = string2 + "\\pgfpathqmoveto{" + PGF.format(dArray[0]) + "bp}{" + PGF.format(dArray[1]) + "bp}";
                    break;
                }
                case 1: {
                    string2 = string2 + "\\pgfpathqlineto{" + PGF.format(dArray[0]) + "bp}{" + PGF.format(dArray[1]) + "bp}";
                    break;
                }
                case 3: {
                    string2 = string2 + "\\pgfpathqcurveto{" + PGF.format(dArray[0]) + "bp}{" + PGF.format(dArray[1]) + "bp}{" + PGF.format(dArray[2]) + "bp}{" + PGF.format(dArray[3]) + "bp}{" + PGF.format(dArray[4]) + "bp}{" + PGF.format(dArray[5]) + "bp}";
                    break;
                }
                case 4: {
                    string2 = string2 + "\\pgfclosepath";
                }
            }
            pathIterator.next();
            string2 = string2 + string;
        }
        string2 = string2 + "\\pgfusepathqfill" + string;
        string2 = string2 + "\\end{pgfscope}}" + string;
        if (this.composite != null) {
            string2 = string2 + "% composite" + string;
            string2 = string2 + this.composite.pgfShape(jDRPaint, bBox, jDRPathSegment, bl, affineTransform);
        }
        return string2;
    }

    public double getWidth() {
        GeneralPath generalPath = this.getCompleteGeneralPath();
        return generalPath.getBounds2D().getWidth();
    }

    public BBox getBBox() {
        GeneralPath generalPath = this.getCompleteGeneralPath();
        return new BBox(generalPath.getBounds2D());
    }

    public GeneralPath getGeneralPath() {
        return new GeneralPath();
    }

    public GeneralPath getPrimaryGeneralPath() {
        GeneralPath generalPath;
        AffineTransform affineTransform;
        GeneralPath generalPath2 = this.getGeneralPath();
        if (this.reversed) {
            affineTransform = new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            generalPath = new GeneralPath(affineTransform.createTransformedShape(generalPath2));
        } else {
            affineTransform = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            generalPath = new GeneralPath(generalPath2);
        }
        for (int i = 2; i <= this.repeated; ++i) {
            affineTransform.translate(-this.repeatOffset, 0.0);
            generalPath.append(affineTransform.createTransformedShape(generalPath2), false);
        }
        return generalPath;
    }

    public GeneralPath getCompleteGeneralPath() {
        return this.getCompleteGeneralPath(false);
    }

    public GeneralPath getCompleteGeneralPath(boolean bl) {
        GeneralPath generalPath = this.getGeneralPath();
        GeneralPath generalPath2 = this.getPrimaryGeneralPath();
        if (this.composite != null) {
            generalPath2.append(this.composite.getCompleteGeneralPath(), false);
        }
        return generalPath2;
    }

    public boolean isResizable() {
        return false;
    }

    public boolean usesLineWidth() {
        return false;
    }

    public void svgDef(PrintWriter printWriter, String string) throws IOException {
        if (this.penWidth == 0.0 || this.type == 0) {
            return;
        }
        GeneralPath generalPath = this.getCompleteGeneralPath(this.isStart_);
        AffineTransform affineTransform = new AffineTransform(1.0 / this.penWidth, 0.0, 0.0, 1.0 / this.penWidth, 0.0, 0.0);
        Shape shape = generalPath.createTransformedShape(affineTransform);
        Rectangle2D rectangle2D = shape.getBounds2D();
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        printWriter.println("      <marker id=\"" + string + "\" ");
        printWriter.println("         markerWidth=\"" + d3 + "\" " + "         markerHeight=\"" + d4 + "\"");
        printWriter.println("         viewBox=\"0 0 " + d3 + " " + d4 + "\" refX=\"" + -d + "\" refY=\"" + -d2 + "\"");
        printWriter.println("         markerUnits=\"strokeWidth\"");
        printWriter.println("         orient=\"" + (this.autoOrient_ ? "auto" : Double.valueOf(this.angle_)) + "rad\" >");
        printWriter.print("        <path d=\"");
        PathIterator pathIterator = shape.getPathIterator(null);
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(dArray)) {
                case 0: {
                    printWriter.print("M " + (dArray[0] - d) + " " + (dArray[1] - d2) + " ");
                    break;
                }
                case 1: {
                    printWriter.print("L " + (dArray[0] - d) + " " + (dArray[1] - d2) + " ");
                    break;
                }
                case 2: {
                    printWriter.print("S " + (dArray[0] - d) + " " + (dArray[1] - d2) + " " + (dArray[2] - d) + " " + (dArray[3] - d2));
                    break;
                }
                case 3: {
                    printWriter.print("C " + (dArray[0] - d) + " " + (dArray[1] - d2) + " " + (dArray[2] - d) + " " + (dArray[3] - d2) + " " + (dArray[4] - d) + " " + (dArray[5] - d2));
                    break;
                }
                case 4: {
                    printWriter.print("Z ");
                }
            }
            pathIterator.next();
        }
        printWriter.println("\"");
        if (this.fillPaint != null) {
            printWriter.print(this.fillPaint.svgFill());
        }
        printWriter.println("/>");
        printWriter.println("      </marker>");
    }

    protected String pgfarrow() {
        return "";
    }

    private String pgfdoarrow() {
        String string = "";
        String string2 = this.pgfarrow();
        if (this.reversed) {
            string = string + "\\pgfarrowswap{";
        }
        switch (this.repeated) {
            case 1: {
                string = string + string2;
                break;
            }
            case 2: {
                string = string + "\\pgfarrowdouble{" + string2 + "}";
                break;
            }
            case 3: {
                string = string + "\\pgfarrowtriple{" + string2 + "}";
            }
        }
        if (this.reversed) {
            string = string + "}";
        }
        return string;
    }

    public String pgf(boolean bl) {
        return bl ? "\\pgfsetstartarrow{}" : "\\pgfsetendarrow{}";
    }

    public static JDRMarker getPredefinedMarker(int n) throws InvalidMarkerTypeException {
        JDRMarker jDRMarker = null;
        try {
            jDRMarker = JDRMarker.getPredefinedMarker(n, 1.0, 1, false, 5.0);
        }
        catch (InvalidRepeatValueException invalidRepeatValueException) {
            // empty catch block
        }
        return jDRMarker;
    }

    public static JDRMarker getPredefinedMarker(int n, double d, int n2, boolean bl) throws InvalidMarkerTypeException, InvalidRepeatValueException {
        return JDRMarker.getPredefinedMarker(n, d, n2, bl, 5.0);
    }

    public static JDRMarker getPredefinedMarker(int n, double d, int n2, boolean bl, double d2) throws InvalidMarkerTypeException, InvalidRepeatValueException {
        switch (n) {
            case 0: {
                return new JDRMarker(d, n2, bl, d2);
            }
            case 1: {
                return new ArrowPointed(d, n2, bl, d2);
            }
            case 2: {
                return new ArrowTriangle(d, n2, bl, d2);
            }
            case 3: {
                return new ArrowCircle(d, n2, bl, d2);
            }
            case 4: {
                return new ArrowDiamond(d, n2, bl);
            }
            case 5: {
                return new ArrowSquare(d, n2, bl);
            }
            case 6: {
                return new ArrowBar(d, n2, bl);
            }
            case 7: {
                return new ArrowSingle(d, n2, bl);
            }
            case 8: {
                return new ArrowRound(d, n2, bl);
            }
            case 9: {
                return new ArrowDotFilled(d, n2, bl, d2);
            }
            case 10: {
                return new ArrowDotOpen(d, n2, bl, d2);
            }
            case 11: {
                return new ArrowBoxFilled(d, n2, bl, d2);
            }
            case 12: {
                return new ArrowBoxOpen(d, n2, bl, d2);
            }
            case 13: {
                return new ArrowCross(d, n2, bl, d2);
            }
            case 14: {
                return new ArrowPlus(d, n2, bl, d2);
            }
            case 15: {
                return new ArrowStar(d, n2, bl, d2);
            }
            case 16: {
                return new ArrowTriangleUpFilled(d, n2, bl, d2);
            }
            case 17: {
                return new ArrowTriangleUpOpen(d, n2, bl, d2);
            }
            case 18: {
                return new ArrowTriangleDownFilled(d, n2, bl, d2);
            }
            case 19: {
                return new ArrowTriangleDownOpen(d, n2, bl, d2);
            }
            case 20: {
                return new ArrowRhombusFilled(d, n2, bl, d2);
            }
            case 21: {
                return new ArrowRhombusOpen(d, n2, bl, d2);
            }
            case 22: {
                return new ArrowPentagonFilled(d, n2, bl, d2);
            }
            case 23: {
                return new ArrowPentagonOpen(d, n2, bl, d2);
            }
            case 24: {
                return new ArrowHexagonFilled(d, n2, bl, d2);
            }
            case 25: {
                return new ArrowHexagonOpen(d, n2, bl, d2);
            }
            case 26: {
                return new ArrowOctagonFilled(d, n2, bl, d2);
            }
            case 27: {
                return new ArrowOctagonOpen(d, n2, bl, d2);
            }
            case 28: {
                return new ArrowPointed60(d, n2, bl, d2);
            }
            case 29: {
                return new ArrowPointed45(d, n2, bl, d2);
            }
            case 30: {
                return new ArrowHooks(d, n2, bl, d2);
            }
            case 31: {
                return new ArrowHookUp(d, n2, bl, d2);
            }
            case 32: {
                return new ArrowHookDown(d, n2, bl, d2);
            }
            case 33: {
                return new ArrowHalfPointedUp(d, n2, bl, d2);
            }
            case 34: {
                return new ArrowHalfPointedDown(d, n2, bl, d2);
            }
            case 35: {
                return new ArrowHalfPointed60Up(d, n2, bl, d2);
            }
            case 36: {
                return new ArrowHalfPointed60Down(d, n2, bl, d2);
            }
            case 37: {
                return new ArrowHalfPointed45Up(d, n2, bl, d2);
            }
            case 38: {
                return new ArrowHalfPointed45Down(d, n2, bl, d2);
            }
            case 39: {
                return new ArrowCusp(d, n2, bl, d2);
            }
            case 40: {
                return new ArrowHalfCuspUp(d, n2, bl, d2);
            }
            case 41: {
                return new ArrowHalfCuspDown(d, n2, bl, d2);
            }
            case 42: {
                return new ArrowAltSingle(d, n2, bl, d2);
            }
            case 43: {
                return new ArrowAltSingleOpen(d, n2, bl, d2);
            }
            case 44: {
                return new ArrowTriangleOpen(d, n2, bl, d2);
            }
            case 45: {
                return new ArrowCircleOpen(d, n2, bl, d2);
            }
            case 46: {
                return new ArrowDiamondOpen(d, n2, bl);
            }
            case 47: {
                return new ArrowBrace(d, n2, bl);
            }
            case 48: {
                return new ArrowRectangleCap(d, n2, bl, d2);
            }
            case 80: {
                return new ArrowBallCap(d, n2, bl, d2);
            }
            case 81: {
                return new ArrowLeafCap(d, n2, bl, d2);
            }
            case 82: {
                return new ArrowLeaf2Cap(d, n2, bl, d2);
            }
            case 83: {
                return new ArrowLeaf3Cap(d, n2, bl, d2);
            }
            case 84: {
                return new ArrowClubCap(d, n2, bl, d2);
            }
            case 85: {
                return new ArrowLeaf3ForCap(d, n2, bl, d2);
            }
            case 86: {
                return new ArrowLeaf3BackCap(d, n2, bl, d2);
            }
            case 87: {
                return new ArrowLeaf2ForCap(d, n2, bl, d2);
            }
            case 88: {
                return new ArrowLeaf2BackCap(d, n2, bl, d2);
            }
            case 89: {
                return new ArrowBulgeCap(d, n2, bl, d2);
            }
            case 90: {
                return new ArrowCutoutBulgeCap(d, n2, bl, d2);
            }
            case 49: {
                return new ArrowChevronCap(d, n2, bl, d2);
            }
            case 50: {
                return new ArrowFastCap(d, n2, bl, d2);
            }
            case 51: {
                return new ArrowRoundCap(d, n2, bl, d2);
            }
            case 52: {
                return new ArrowTriangleCap(d, n2, bl, d2);
            }
            case 53: {
                return new ArrowInvertTriangleCap(d, n2, bl, d2);
            }
            case 54: {
                return new ArrowInvertChevronCap(d, n2, bl, d2);
            }
            case 55: {
                return new ArrowInvertFastCap(d, n2, bl, d2);
            }
            case 56: {
                return new ArrowAltBar(d, n2, bl, d2);
            }
            case 57: {
                return new ArrowAltRound(d, n2, bl, d2);
            }
            case 58: {
                return new ArrowAltSquare(d, n2, bl, d2);
            }
            case 59: {
                return new ArrowAltBrace(d, n2, bl, d2);
            }
            case 60: {
                return new ArrowSemiCircleOpen(d, n2, bl, d2);
            }
            case 61: {
                return new ArrowSemiCircleFilled(d, n2, bl, d2);
            }
            case 62: {
                return new ArrowStar5Open(d, n2, bl, d2);
            }
            case 63: {
                return new ArrowStar5Filled(d, n2, bl, d2);
            }
            case 64: {
                return new ArrowAsterisk(d, n2, bl, d2);
            }
            case 65: {
                return new ArrowScissorsDownFilled(d, n2, bl, d2);
            }
            case 66: {
                return new ArrowScissorsUpFilled(d, n2, bl, d2);
            }
            case 67: {
                return new ArrowScissorsDownOpen(d, n2, bl, d2);
            }
            case 68: {
                return new ArrowScissorsUpOpen(d, n2, bl, d2);
            }
            case 69: {
                return new ArrowHeartRightFilled(d, n2, bl, d2);
            }
            case 70: {
                return new ArrowHeartRightOpen(d, n2, bl, d2);
            }
            case 71: {
                return new ArrowHeartFilled(d, n2, bl, d2);
            }
            case 72: {
                return new ArrowHeartOpen(d, n2, bl, d2);
            }
            case 73: {
                return new ArrowSnowflake(d, n2, bl, d2);
            }
            case 74: {
                return new ArrowStarChevronOpen(d, n2, bl, d2);
            }
            case 75: {
                return new ArrowStarChevronFilled(d, n2, bl, d2);
            }
            case 77: {
                return new ArrowStar6Open(d, n2, bl, d2);
            }
            case 76: {
                return new ArrowStar6Filled(d, n2, bl, d2);
            }
            case 78: {
                return new ArrowEquilateralFilled(d, n2, bl, d2);
            }
            case 79: {
                return new ArrowEquilateralOpen(d, n2, bl, d2);
            }
        }
        throw new InvalidMarkerTypeException(n);
    }

    public Object clone() {
        JDRMarker jDRMarker = null;
        try {
            jDRMarker = new JDRMarker(this.penWidth, this.repeated, this.reversed, this.size);
            jDRMarker.makeEqual(this);
        }
        catch (InvalidRepeatValueException invalidRepeatValueException) {
            // empty catch block
        }
        return jDRMarker;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JDRMarker)) {
            return false;
        }
        JDRMarker jDRMarker = (JDRMarker)object;
        if (this.penWidth != jDRMarker.penWidth) {
            return false;
        }
        if (this.repeated != jDRMarker.repeated) {
            return false;
        }
        if (this.reversed != jDRMarker.reversed) {
            return false;
        }
        if (this.size != jDRMarker.size) {
            return false;
        }
        if (this.autoOrient_ != jDRMarker.autoOrient_) {
            return false;
        }
        if (this.angle_ != jDRMarker.angle_) {
            return false;
        }
        if (this.overlay != jDRMarker.overlay) {
            return false;
        }
        if (this.offset_ != jDRMarker.offset_) {
            return false;
        }
        if (this.repeatOffset != jDRMarker.repeatOffset) {
            return false;
        }
        if (this.userOffset != jDRMarker.userOffset) {
            return false;
        }
        if (this.userRepeatOffset != jDRMarker.userRepeatOffset) {
            return false;
        }
        if (this.fillPaint == null ? jDRMarker.fillPaint != null : !this.fillPaint.equals(jDRMarker.fillPaint)) {
            return false;
        }
        return !(this.composite == null ? jDRMarker.composite != null : !this.composite.equals(jDRMarker.composite));
    }

    public void makeEqual(JDRMarker jDRMarker) {
        if (this.fillPaint != null) {
            jDRMarker.fillPaint = (JDRPaint)this.fillPaint.clone();
        }
        jDRMarker.repeated = this.repeated;
        jDRMarker.reversed = this.reversed;
        jDRMarker.size = this.size;
        jDRMarker.autoOrient_ = this.autoOrient_;
        jDRMarker.angle_ = this.angle_;
        jDRMarker.overlay = this.overlay;
        jDRMarker.offset_ = this.offset_;
        jDRMarker.penWidth = this.penWidth;
        jDRMarker.repeatOffset = this.repeatOffset;
        jDRMarker.userOffset = this.userOffset;
        jDRMarker.userRepeatOffset = this.userRepeatOffset;
        if (this.composite == null) {
            jDRMarker.composite = null;
        } else {
            jDRMarker.composite = (JDRMarker)this.composite.clone();
            jDRMarker.composite.parent = this;
        }
    }

    public int getType() {
        return this.type;
    }

    public void save(DataOutputStream dataOutputStream, float f) throws IOException {
        if (f == 1.0f) {
            if (this.type >= 8) {
                dataOutputStream.writeByte(0);
                return;
            }
            dataOutputStream.writeByte((byte)this.type);
            if (this.type != 0) {
                dataOutputStream.writeFloat((float)this.size);
                dataOutputStream.writeBoolean(this.repeated == 2);
                dataOutputStream.writeBoolean(this.reversed);
            }
        } else {
            if (f < 1.4f && this.type >= 22) {
                dataOutputStream.writeByte(0);
                return;
            }
            dataOutputStream.writeByte((byte)this.type);
            if (this.type != 0) {
                dataOutputStream.writeFloat((float)this.size);
                dataOutputStream.writeByte((byte)this.repeated);
                dataOutputStream.writeBoolean(this.reversed);
                dataOutputStream.writeBoolean(this.autoOrient_);
                if (!this.autoOrient_) {
                    dataOutputStream.writeFloat((float)this.angle_);
                }
                JDRPaintLoader jDRPaintLoader = JDR.getPaintLoader();
                jDRPaintLoader.saveJDR(this.fillPaint == null ? new JDRTransparent() : this.fillPaint, dataOutputStream, f);
                dataOutputStream.writeBoolean(this.overlay);
                if (f >= 1.4f && !this.overlay) {
                    dataOutputStream.writeBoolean(this.userOffset);
                    if (this.userOffset) {
                        dataOutputStream.writeFloat((float)this.offset_);
                    }
                    dataOutputStream.writeBoolean(this.userRepeatOffset);
                    if (this.userRepeatOffset) {
                        dataOutputStream.writeFloat((float)this.repeatOffset);
                    }
                }
                if (this.composite == null) {
                    dataOutputStream.writeByte(0);
                } else {
                    this.composite.save(dataOutputStream, f);
                }
            }
        }
    }

    public static JDRMarker read(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        Object object;
        byte by;
        if (f == 1.0f) {
            byte by2 = dataInputStream.readByte();
            if (by2 < 0 || by2 >= 8) {
                throw new InvalidMarkerTypeException(by2);
            }
            double d = 5.0;
            boolean bl = false;
            boolean bl2 = false;
            if (by2 != 0) {
                d = dataInputStream.readFloat();
                bl = dataInputStream.readBoolean();
                bl2 = dataInputStream.readBoolean();
            }
            return JDRMarker.getPredefinedMarker(by2, 1.0, bl ? 2 : 1, bl2, d);
        }
        byte by3 = dataInputStream.readByte();
        byte by4 = f < 1.4f ? (byte)22 : (by = f < 1.6f ? (byte)80 : 91);
        if (by3 < 0 || by3 >= by) {
            throw new InvalidMarkerTypeException(by3);
        }
        double d = 5.0;
        int n = 1;
        boolean bl = false;
        boolean bl3 = true;
        double d2 = 0.0;
        boolean bl4 = false;
        boolean bl5 = false;
        float f2 = 0.0f;
        float f3 = 0.0f;
        boolean bl6 = false;
        JDRPaint jDRPaint = null;
        JDRMarker jDRMarker = null;
        if (by3 != 0) {
            d = dataInputStream.readFloat();
            n = dataInputStream.readByte();
            bl = dataInputStream.readBoolean();
            bl3 = dataInputStream.readBoolean();
            if (!bl3) {
                d2 = dataInputStream.readFloat();
            }
            if ((jDRPaint = ((JDRPaintLoader)(object = JDR.getPaintLoader())).loadJDR(dataInputStream, f)) instanceof JDRTransparent) {
                jDRPaint = null;
            }
            bl4 = dataInputStream.readBoolean();
            if (f >= 1.4f && !bl4) {
                bl5 = dataInputStream.readBoolean();
                if (bl5) {
                    f2 = dataInputStream.readFloat();
                }
                if (bl6 = dataInputStream.readBoolean()) {
                    f3 = dataInputStream.readFloat();
                }
            }
            if ((jDRMarker = JDRMarker.read(dataInputStream, f)).getType() == 0) {
                jDRMarker = null;
            }
        }
        object = JDRMarker.getPredefinedMarker(by3, 1.0, n, bl, d);
        ((JDRMarker)object).fillPaint = jDRPaint;
        ((JDRMarker)object).setCompositeMarker(jDRMarker);
        ((JDRMarker)object).setOrient(bl3, d2);
        ((JDRMarker)object).setOverlay(bl4);
        ((JDRMarker)object).enableUserRepeatOffset(bl6);
        if (bl6) {
            ((JDRMarker)object).setRepeatOffset(f3);
        }
        ((JDRMarker)object).enableUserOffset(bl5);
        if (bl5) {
            ((JDRMarker)object).setOffset(f2);
        }
        return object;
    }

    public void saveAJR(PrintWriter printWriter, float f) throws IOException, InvalidFormatException {
        if (f == 1.0f) {
            int n = this.type >= 8 ? 0 : this.type;
            AJR.writeInt(printWriter, n);
            if (n != 0) {
                AJR.writeFloat(printWriter, (float)this.size);
                AJR.writeInt(printWriter, this.repeated);
                AJR.writeBoolean(printWriter, this.reversed);
            }
            printWriter.println();
        } else {
            if (f < 1.4f && this.type >= 22) {
                AJR.writeInt(printWriter, 0);
                return;
            }
            AJR.writeInt(printWriter, this.type);
            if (this.type != 0) {
                AJR.writeFloat(printWriter, (float)this.size);
                AJR.writeInt(printWriter, this.repeated);
                AJR.writeBoolean(printWriter, this.reversed);
                AJR.writeBoolean(printWriter, this.autoOrient_);
                if (!this.autoOrient_) {
                    AJR.writeFloat(printWriter, (float)this.angle_);
                }
                JDRPaintLoader jDRPaintLoader = AJR.getPaintLoader();
                jDRPaintLoader.saveAJR(this.fillPaint == null ? new JDRTransparent() : this.fillPaint, printWriter, f);
                AJR.writeBoolean(printWriter, this.overlay);
                if (f >= 1.4f && !this.overlay) {
                    AJR.writeBoolean(printWriter, this.userOffset);
                    if (this.userOffset) {
                        AJR.writeFloat(printWriter, (float)this.offset_);
                    }
                    AJR.writeBoolean(printWriter, this.userRepeatOffset);
                    if (this.userRepeatOffset) {
                        AJR.writeFloat(printWriter, (float)this.repeatOffset);
                    }
                }
                if (this.composite == null) {
                    AJR.writeInt(printWriter, 0);
                    printWriter.println();
                } else {
                    this.composite.saveAJR(printWriter, f);
                }
            }
        }
    }

    public static JDRMarker readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        Object object;
        int n;
        if (f == 1.0f) {
            int n2 = AJR.readInt(bufferedReader);
            if (n2 < 0 || n2 >= 8) {
                throw new InvalidMarkerTypeException(n2, AJR.getLineNum());
            }
            double d = 5.0;
            boolean bl = false;
            boolean bl2 = false;
            if (n2 != 0) {
                d = AJR.readFloat(bufferedReader);
                bl = AJR.readBoolean(bufferedReader);
                bl2 = AJR.readBoolean(bufferedReader);
            }
            return JDRMarker.getPredefinedMarker(n2, 1.0, bl ? 2 : 1, bl2, d);
        }
        int n3 = AJR.readInt(bufferedReader);
        int n4 = f < 1.4f ? 22 : (n = f < 1.6f ? 80 : 91);
        if (n3 < 0 || n3 >= n) {
            throw new InvalidMarkerTypeException(n3, AJR.getLineNum());
        }
        double d = 5.0;
        int n5 = 1;
        boolean bl = false;
        boolean bl3 = true;
        double d2 = 0.0;
        boolean bl4 = false;
        boolean bl5 = false;
        double d3 = 0.0;
        boolean bl6 = false;
        double d4 = 0.0;
        JDRPaint jDRPaint = null;
        JDRMarker jDRMarker = null;
        if (n3 != 0) {
            d = AJR.readFloat(bufferedReader);
            n5 = AJR.readInt(bufferedReader);
            bl = AJR.readBoolean(bufferedReader);
            bl3 = AJR.readBoolean(bufferedReader);
            if (!bl3) {
                d2 = AJR.readFloat(bufferedReader);
            }
            if ((jDRPaint = ((JDRPaintLoader)(object = AJR.getPaintLoader())).loadAJR(bufferedReader, f)) instanceof JDRTransparent) {
                jDRPaint = null;
            }
            bl4 = AJR.readBoolean(bufferedReader);
            if (f >= 1.4f && !bl4) {
                bl5 = AJR.readBoolean(bufferedReader);
                if (bl5) {
                    d3 = AJR.readFloat(bufferedReader);
                }
                if (bl6 = AJR.readBoolean(bufferedReader)) {
                    d4 = AJR.readFloat(bufferedReader);
                }
            }
            if ((jDRMarker = JDRMarker.readAJR(bufferedReader, f)).getType() == 0) {
                jDRMarker = null;
            }
        }
        object = JDRMarker.getPredefinedMarker(n3, 1.0, n5, bl, d);
        ((JDRMarker)object).fillPaint = jDRPaint;
        ((JDRMarker)object).setCompositeMarker(jDRMarker);
        ((JDRMarker)object).setOrient(bl3, d2);
        ((JDRMarker)object).setOverlay(bl4);
        ((JDRMarker)object).enableUserRepeatOffset(bl6);
        if (bl6) {
            ((JDRMarker)object).setRepeatOffset(d4);
        }
        ((JDRMarker)object).enableUserOffset(bl5);
        if (bl5) {
            ((JDRMarker)object).setOffset(d3);
        }
        return object;
    }

    public String getID() {
        return "none";
    }

    public String getID(boolean bl) {
        return this.getID(bl, this.fillPaint);
    }

    public String getID(boolean bl, JDRPaint jDRPaint) {
        if (bl) {
            this.reversed = !this.reversed;
        }
        String string = this.getID();
        if (bl) {
            boolean bl2 = this.reversed = !this.reversed;
        }
        if (this.fillPaint == null) {
            if (jDRPaint != null) {
                string = string + jDRPaint.getID();
            }
        } else {
            string = string + this.fillPaint.getID();
        }
        return string;
    }

    public String svgStartMarker(JDRPaint jDRPaint) {
        if (this.type == 0) {
            return "marker-start=\"none\"";
        }
        return "marker-start=\"url(#" + this.getID(true, jDRPaint) + ")\"";
    }

    public String svgMidMarker(JDRPaint jDRPaint) {
        if (this.type == 0) {
            return "marker-mid=\"none\"";
        }
        return "marker-mid=\"url(#" + this.getID(false, jDRPaint) + ")\"";
    }

    public String svgEndMarker(JDRPaint jDRPaint) {
        if (this.type == 0) {
            return "marker-end=\"none\"";
        }
        return "marker-end=\"url(#" + this.getID(false, jDRPaint) + ")\"";
    }

    public static void svgDefs(PrintWriter printWriter, JDRGroup jDRGroup) throws IOException {
        Cloneable cloneable;
        Hashtable<String, JDRMarker> hashtable = new Hashtable<String, JDRMarker>();
        int n = jDRGroup.size();
        for (int i = 0; i < n; ++i) {
            cloneable = jDRGroup.get(i);
            if (!(cloneable instanceof JDRShape) || !(((JDRShape)cloneable).getStroke() instanceof JDRBasicStroke)) continue;
            JDRBasicStroke jDRBasicStroke = (JDRBasicStroke)((JDRShape)cloneable).getStroke();
            JDRPaint jDRPaint = ((JDRShape)cloneable).getLinePaint();
            JDRMarker jDRMarker = (JDRMarker)jDRBasicStroke.getStartArrow().clone();
            if (jDRMarker.fillPaint == null) {
                jDRMarker.fillPaint = jDRPaint;
            }
            String string = jDRMarker.getID(true, jDRPaint);
            jDRMarker.reversed = !jDRMarker.reversed;
            jDRMarker.isStart_ = true;
            if (!string.equals("none")) {
                hashtable.put(string, jDRMarker);
            }
            JDRMarker jDRMarker2 = (JDRMarker)jDRBasicStroke.getMidArrow().clone();
            if (jDRMarker2.fillPaint == null) {
                jDRMarker2.fillPaint = jDRPaint;
            }
            jDRMarker2.isStart_ = false;
            string = jDRMarker2.getID(false, jDRPaint);
            if (!string.equals("none")) {
                hashtable.put(string, jDRMarker2);
            }
            JDRMarker jDRMarker3 = (JDRMarker)jDRBasicStroke.getEndArrow().clone();
            if (jDRMarker3.fillPaint == null) {
                jDRMarker3.fillPaint = jDRPaint;
            }
            jDRMarker3.isStart_ = false;
            string = jDRMarker3.getID(false, jDRPaint);
            if (string.equals("none")) continue;
            hashtable.put(string, jDRMarker3);
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            cloneable = (JDRMarker)hashtable.get(string);
            ((JDRMarker)cloneable).svgDef(printWriter, string);
        }
    }

    public boolean getAutoOrient() {
        return this.autoOrient_;
    }

    public double getAngle() {
        return this.angle_;
    }

    public void setAngle(double d) {
        this.angle_ = d;
    }

    public void setOrient(boolean bl) {
        this.autoOrient_ = bl;
    }

    public void setOrient(boolean bl, double d) {
        this.autoOrient_ = bl;
        this.angle_ = d;
    }

    public JDRMarker getCompositeMarker() {
        return this.composite;
    }

    public JDRMarker getParentMarker() {
        return this.parent;
    }

    public void setCompositeMarker(JDRMarker jDRMarker) throws InvalidCompositeMarkerException {
        if (jDRMarker == null) {
            this.composite = null;
            return;
        }
        if (jDRMarker.getType() == 0) {
            this.composite = null;
            return;
        }
        if (this.getType() == 0) {
            throw new InvalidCompositeMarkerException();
        }
        this.composite = jDRMarker;
        this.composite.setPenWidth(this.penWidth);
        this.composite.parent = this;
        this.updateCompositeOffset();
    }

    public void setPenWidth(double d) {
        this.penWidth = d;
        if (!this.userRepeatOffset) {
            this.repeatOffset = 7.0 * this.penWidth;
        }
        if (this.composite != null) {
            this.composite.setPenWidth(d);
        }
        this.updateCompositeOffset();
    }

    public double getPenWidth() {
        return this.penWidth;
    }

    public void setFillPaint(JDRPaint jDRPaint) {
        this.fillPaint = jDRPaint instanceof JDRTransparent ? null : jDRPaint;
    }

    public JDRPaint getFillPaint() {
        return this.fillPaint;
    }

    public void fade(double d) {
        if (this.fillPaint != null) {
            this.fillPaint.fade(d);
        }
    }

    public void setRepeated(int n) throws InvalidRepeatValueException {
        if (n < 1) {
            throw new InvalidRepeatValueException(n);
        }
        this.repeated = n;
        this.updateCompositeOffset();
    }

    public int getRepeated() {
        return this.repeated;
    }

    public void setReversed(boolean bl) {
        this.reversed = bl;
        this.updateCompositeOffset();
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setSize(double d) {
        this.size = d;
        this.updateCompositeOffset();
    }

    public double getSize() {
        return this.size;
    }

    public void setOverlay(boolean bl) {
        this.overlay = bl;
        this.updateCompositeOffset();
    }

    public boolean isOverlaid() {
        return this.overlay;
    }

    private void updateCompositeOffset() {
        if (this.composite != null) {
            if (this.composite.userOffset) {
                return;
            }
            if (this.overlay) {
                this.composite.offset_ = this.offset_;
            } else if (!this.userOffset) {
                this.composite.offset_ = this.getPrimaryGeneralPath().getBounds2D().getWidth() + this.repeatOffset - this.offset_ - this.getGeneralPath().getBounds2D().getWidth();
            }
        }
    }

    public void enableUserOffset(boolean bl) {
        this.userOffset = bl;
        if (!this.userOffset) {
            if (this.parent == null) {
                this.offset_ = 0.0;
            } else {
                this.parent.updateCompositeOffset();
            }
            this.updateCompositeOffset();
        }
    }

    public void enableUserRepeatOffset(boolean bl) {
        this.userRepeatOffset = bl;
        if (!this.userRepeatOffset) {
            this.repeatOffset = 7.0 * this.penWidth;
            this.updateCompositeOffset();
        }
    }

    public boolean isUserOffsetEnabled() {
        return this.userOffset;
    }

    public boolean isUserRepeatOffsetEnabled() {
        return this.userRepeatOffset;
    }

    public void setOffset(double d) {
        if (this.userOffset) {
            this.offset_ = d;
        }
    }

    public double getOffset() {
        return this.offset_;
    }

    public void setRepeatOffset(double d) {
        if (this.userRepeatOffset) {
            this.repeatOffset = d;
        }
    }

    public double getRepeatOffset() {
        return this.repeatOffset;
    }

    public static int maxMarkers() {
        return 91;
    }
}

