/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.marker;

import java.awt.BasicStroke;
import java.awt.geom.GeneralPath;
import uk.ac.uea.cmp.nlct.jdr.InvalidRepeatValueException;
import uk.ac.uea.cmp.nlct.jdr.marker.JDRMarker;

public class ArrowTriangleOpen
extends JDRMarker {
    public ArrowTriangleOpen(double d, int n, boolean bl, double d2) throws InvalidRepeatValueException {
        super(d, n, bl, d2);
        this.type = 44;
    }

    @Override
    public String getID() {
        return this.reversed ? "arrow-r" + this.repeated + "triangleopen-" + this.size + "-" + this.penWidth : "arrow-" + this.repeated + "triangleopen-" + this.size + "-" + this.penWidth;
    }

    @Override
    public GeneralPath getGeneralPath() {
        GeneralPath generalPath = new GeneralPath();
        double d = this.size;
        double d2 = d + 0.7 * this.penWidth;
        double d3 = 0.577 * d + 0.7 * this.penWidth;
        generalPath.moveTo((float)(-d2), (float)(-d3));
        generalPath.lineTo((float)(d * this.penWidth * 0.65), 0.0f);
        generalPath.lineTo((float)(-d2), (float)d3);
        generalPath.closePath();
        BasicStroke basicStroke = new BasicStroke(1.0f);
        return new GeneralPath(basicStroke.createStrokedShape(generalPath));
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public boolean usesLineWidth() {
        return true;
    }

    @Override
    protected String pgfarrow() {
        return "";
    }

    @Override
    public Object clone() {
        ArrowTriangleOpen arrowTriangleOpen = null;
        try {
            arrowTriangleOpen = new ArrowTriangleOpen(this.penWidth, this.repeated, this.reversed, this.size);
            this.makeEqual(arrowTriangleOpen);
        }
        catch (InvalidRepeatValueException invalidRepeatValueException) {
            // empty catch block
        }
        return arrowTriangleOpen;
    }
}

