/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.marker;

import java.awt.geom.GeneralPath;
import uk.ac.uea.cmp.nlct.jdr.InvalidRepeatValueException;
import uk.ac.uea.cmp.nlct.jdr.io.PGF;
import uk.ac.uea.cmp.nlct.jdr.marker.JDRMarker;

public class ArrowTriangle
extends JDRMarker {
    public ArrowTriangle(double d, int n, boolean bl, double d2) throws InvalidRepeatValueException {
        super(d, n, bl, d2);
        this.type = 2;
    }

    @Override
    public String getID() {
        return this.reversed ? "arrow-r" + this.repeated + "triangle-" + this.size + "-" + this.penWidth : "arrow-" + this.repeated + "triangle-" + this.size + "-" + this.penWidth;
    }

    @Override
    public GeneralPath getGeneralPath() {
        GeneralPath generalPath = new GeneralPath();
        double d = this.size + 0.7 * this.penWidth;
        double d2 = 0.577 * this.size + 0.7 * this.penWidth;
        generalPath.moveTo((float)(-d), (float)(-d2));
        generalPath.lineTo((float)(this.size * this.penWidth * 0.65), 0.0f);
        generalPath.lineTo((float)(-d), (float)d2);
        generalPath.closePath();
        return generalPath;
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public boolean usesLineWidth() {
        return true;
    }

    @Override
    protected String pgfarrow() {
        return "\\pgfarrowtriangle{" + PGF.format(this.size) + "bp}";
    }

    @Override
    public Object clone() {
        ArrowTriangle arrowTriangle = null;
        try {
            arrowTriangle = new ArrowTriangle(this.penWidth, this.repeated, this.reversed, this.size);
            this.makeEqual(arrowTriangle);
        }
        catch (InvalidRepeatValueException invalidRepeatValueException) {
            // empty catch block
        }
        return arrowTriangle;
    }
}

