/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.marker;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import uk.ac.uea.cmp.nlct.jdr.InvalidRepeatValueException;
import uk.ac.uea.cmp.nlct.jdr.io.PGF;
import uk.ac.uea.cmp.nlct.jdr.marker.JDRMarker;

public class ArrowStar
extends JDRMarker {
    public ArrowStar(double d, int n, boolean bl, double d2) throws InvalidRepeatValueException {
        super(d, n, bl, d2);
        this.type = 15;
    }

    @Override
    public String getID() {
        return this.reversed ? "arrow-r" + this.repeated + "star" : "arrow-" + this.repeated + "star";
    }

    @Override
    public GeneralPath getGeneralPath() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)(-this.size), 0.0f);
        generalPath.lineTo((float)this.size, 0.0f);
        generalPath.moveTo(0.0f, (float)this.size);
        generalPath.lineTo(0.0f, (float)(-this.size));
        double d = this.size * 0.707107;
        generalPath.moveTo((float)(-d), (float)(-d));
        generalPath.lineTo((float)d, (float)d);
        generalPath.moveTo((float)d, (float)(-d));
        generalPath.lineTo((float)(-d), (float)d);
        BasicStroke basicStroke = new BasicStroke(2.0f);
        Shape shape = basicStroke.createStrokedShape(generalPath);
        return new GeneralPath(shape);
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public boolean usesLineWidth() {
        return false;
    }

    @Override
    protected String pgfarrow() {
        double d = this.size * 0.707107;
        return "\\pgfsetdash{}{0pt}\\pgfsetlinewidth{2bp}\\pgfpathqmoveto{" + PGF.format(-this.size) + "bp}{0bp}" + "\\pgfpathqlineto{" + PGF.format(this.size) + "bp}{0bp}" + "\\pgfpathqmoveto{0bp}{" + PGF.format(this.size) + "bp}" + "\\pgfpathqlineto{0bp}{" + PGF.format(-this.size) + "bp}" + "\\pgfpathqmoveto{" + PGF.format(-d) + "bp}{" + PGF.format(-d) + "bp}" + "\\pgfpathqlineto{" + PGF.format(d) + "bp}{" + PGF.format(d) + "bp}" + "\\pgfpathqmoveto{" + PGF.format(d) + "bp}{" + PGF.format(-d) + "bp}" + "\\pgfpathqlineto{" + PGF.format(-d) + "bp}{" + PGF.format(d) + "bp}" + "\\pgfusepathqstroke";
    }

    @Override
    public Object clone() {
        ArrowStar arrowStar = null;
        try {
            arrowStar = new ArrowStar(this.penWidth, this.repeated, this.reversed, this.size);
            this.makeEqual(arrowStar);
        }
        catch (InvalidRepeatValueException invalidRepeatValueException) {
            // empty catch block
        }
        return arrowStar;
    }
}

