/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.marker;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import uk.ac.uea.cmp.nlct.jdr.InvalidRepeatValueException;
import uk.ac.uea.cmp.nlct.jdr.marker.JDRMarker;

public class ArrowSquare
extends JDRMarker {
    public ArrowSquare(double d, int n, boolean bl) throws InvalidRepeatValueException {
        super(d, n, bl);
        this.type = 5;
    }

    @Override
    public String getID() {
        return this.reversed ? "arrow-r" + this.repeated + "square" : "arrow-" + this.repeated + "square";
    }

    @Override
    public GeneralPath getGeneralPath() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)(-3.0 * this.penWidth), (float)(-5.0 * this.penWidth));
        generalPath.lineTo(0.0f, (float)(-5.0 * this.penWidth));
        generalPath.lineTo(0.0f, (float)(5.0 * this.penWidth));
        generalPath.lineTo((float)(-3.0 * this.penWidth), (float)(5.0 * this.penWidth));
        BasicStroke basicStroke = new BasicStroke((float)this.penWidth);
        Shape shape = basicStroke.createStrokedShape(generalPath);
        return new GeneralPath(shape);
    }

    @Override
    public boolean isResizable() {
        return false;
    }

    @Override
    public boolean usesLineWidth() {
        return true;
    }

    @Override
    protected String pgfarrow() {
        return "\\pgfarrowsquare";
    }

    @Override
    public Object clone() {
        ArrowSquare arrowSquare = null;
        try {
            arrowSquare = new ArrowSquare(this.penWidth, this.repeated, this.reversed);
            this.makeEqual(arrowSquare);
        }
        catch (InvalidRepeatValueException invalidRepeatValueException) {
            // empty catch block
        }
        return arrowSquare;
    }
}

