/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.marker;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import uk.ac.uea.cmp.nlct.jdr.InvalidRepeatValueException;
import uk.ac.uea.cmp.nlct.jdr.marker.JDRMarker;

public class ArrowRound
extends JDRMarker {
    public ArrowRound(double d, int n, boolean bl) throws InvalidRepeatValueException {
        super(d, n, bl);
        this.type = 8;
    }

    @Override
    public String getID() {
        return this.reversed ? "arrow-r" + this.repeated + "round" : "arrow-" + this.repeated + "round";
    }

    @Override
    public GeneralPath getGeneralPath() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)(-2.0 * this.penWidth), (float)(-5.0 * this.penWidth));
        generalPath.curveTo((float)this.penWidth, (float)(-3.0 * this.penWidth), (float)this.penWidth, (float)(3.0 * this.penWidth), (float)(-2.0 * this.penWidth), (float)(5.0 * this.penWidth));
        BasicStroke basicStroke = new BasicStroke((float)this.penWidth);
        Shape shape = basicStroke.createStrokedShape(generalPath);
        return new GeneralPath(shape);
    }

    @Override
    public boolean isResizable() {
        return false;
    }

    @Override
    public boolean usesLineWidth() {
        return true;
    }

    @Override
    protected String pgfarrow() {
        return "\\pgfarrowround";
    }

    @Override
    public Object clone() {
        ArrowRound arrowRound = null;
        try {
            arrowRound = new ArrowRound(this.penWidth, this.repeated, this.reversed);
            this.makeEqual(arrowRound);
        }
        catch (InvalidRepeatValueException invalidRepeatValueException) {
            // empty catch block
        }
        return arrowRound;
    }
}

