/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.marker;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import uk.ac.uea.cmp.nlct.jdr.InvalidRepeatValueException;
import uk.ac.uea.cmp.nlct.jdr.marker.JDRMarker;

public class ArrowPentagonOpen
extends JDRMarker {
    protected static final double cosAngle = Math.cos(1.2566370614359172);
    protected static final double sinAngle = Math.sin(1.2566370614359172);
    protected static final double cosHalfAngle = Math.cos(0.6283185307179586);
    protected static final double sinHalfAngle = Math.sin(0.6283185307179586);

    public ArrowPentagonOpen(double d, int n, boolean bl, double d2) throws InvalidRepeatValueException {
        super(d, n, bl, d2);
        this.type = 23;
    }

    @Override
    public String getID() {
        return this.reversed ? "arrow-r" + this.repeated + "pentopen" : "arrow-" + this.repeated + "pentopen";
    }

    @Override
    public GeneralPath getGeneralPath() {
        GeneralPath generalPath = new GeneralPath();
        double d = this.size - 1.0;
        float f = (float)(d * sinAngle);
        float f2 = (float)(d * cosAngle);
        float f3 = (float)(d * sinHalfAngle);
        float f4 = (float)(d * cosHalfAngle);
        generalPath.moveTo(0.0f, -((float)d));
        generalPath.lineTo(-f, -f2);
        generalPath.lineTo(-f3, f4);
        generalPath.lineTo(f3, f4);
        generalPath.lineTo(f, -f2);
        generalPath.closePath();
        BasicStroke basicStroke = new BasicStroke(2.0f);
        Shape shape = basicStroke.createStrokedShape(generalPath);
        return new GeneralPath(shape);
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public boolean usesLineWidth() {
        return false;
    }

    @Override
    protected String pgfarrow() {
        return "";
    }

    @Override
    public Object clone() {
        ArrowPentagonOpen arrowPentagonOpen = null;
        try {
            arrowPentagonOpen = new ArrowPentagonOpen(this.penWidth, this.repeated, this.reversed, this.size);
            this.makeEqual(arrowPentagonOpen);
        }
        catch (InvalidRepeatValueException invalidRepeatValueException) {
            // empty catch block
        }
        return arrowPentagonOpen;
    }

    @Override
    public boolean hasXAxisSymmetry() {
        return false;
    }
}

