/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.marker;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import uk.ac.uea.cmp.nlct.jdr.InvalidRepeatValueException;
import uk.ac.uea.cmp.nlct.jdr.io.PGF;
import uk.ac.uea.cmp.nlct.jdr.marker.JDRMarker;

public class ArrowDotOpen
extends JDRMarker {
    public ArrowDotOpen(double d, int n, boolean bl, double d2) throws InvalidRepeatValueException {
        super(d, n, bl, d2);
        this.type = 10;
    }

    @Override
    public String getID() {
        return this.reversed ? "arrow-r" + this.repeated + "dotopen" : "arrow-" + this.repeated + "dotopen";
    }

    @Override
    public GeneralPath getGeneralPath() {
        double d = this.size - 1.0;
        GeneralPath generalPath = new GeneralPath(new Ellipse2D.Float((float)(-d), (float)(-d), (float)(2.0 * d), (float)(2.0 * d)));
        BasicStroke basicStroke = new BasicStroke(2.0f);
        Shape shape = basicStroke.createStrokedShape(generalPath);
        return new GeneralPath(shape);
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public boolean usesLineWidth() {
        return false;
    }

    @Override
    protected String pgfarrow() {
        return "\\pgfsetdash{}{0pt}\\pgfsetlinewidth{2bp}\\pgfpathqcircle{" + PGF.format(this.size) + "bp}\\pgfusepathqstroke";
    }

    @Override
    public Object clone() {
        ArrowDotOpen arrowDotOpen = null;
        try {
            arrowDotOpen = new ArrowDotOpen(this.penWidth, this.repeated, this.reversed, this.size);
            this.makeEqual(arrowDotOpen);
        }
        catch (InvalidRepeatValueException invalidRepeatValueException) {
            // empty catch block
        }
        return arrowDotOpen;
    }
}

