/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.marker;

import java.awt.geom.GeneralPath;
import uk.ac.uea.cmp.nlct.jdr.InvalidRepeatValueException;
import uk.ac.uea.cmp.nlct.jdr.marker.JDRMarker;

public class ArrowDiamond
extends JDRMarker {
    public ArrowDiamond(double d, int n, boolean bl) throws InvalidRepeatValueException {
        super(d, n, bl);
        this.type = 4;
    }

    @Override
    public String getID() {
        return this.reversed ? "arrow-r" + this.repeated + "diamond" : "arrow-" + this.repeated + "diamond";
    }

    @Override
    public GeneralPath getGeneralPath() {
        GeneralPath generalPath = new GeneralPath();
        double d = 1.2 * this.penWidth;
        generalPath.moveTo((float)(2.0 * d), 0.0f);
        generalPath.lineTo((float)(-5.0 * d + d), (float)(3.0 * d));
        generalPath.lineTo((float)(-11.0 * d + d), 0.0f);
        generalPath.lineTo((float)(-5.0 * d + d), (float)(-3.0 * d));
        generalPath.closePath();
        return generalPath;
    }

    @Override
    public boolean isResizable() {
        return false;
    }

    @Override
    public boolean usesLineWidth() {
        return true;
    }

    @Override
    protected String pgfarrow() {
        return "\\pgfarrowdiamond";
    }

    @Override
    public Object clone() {
        ArrowDiamond arrowDiamond = null;
        try {
            arrowDiamond = new ArrowDiamond(this.penWidth, this.repeated, this.reversed);
            this.makeEqual(arrowDiamond);
        }
        catch (InvalidRepeatValueException invalidRepeatValueException) {
            // empty catch block
        }
        return arrowDiamond;
    }
}

