/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.marker;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import uk.ac.uea.cmp.nlct.jdr.InvalidRepeatValueException;
import uk.ac.uea.cmp.nlct.jdr.io.PGF;
import uk.ac.uea.cmp.nlct.jdr.marker.JDRMarker;

public class ArrowCross
extends JDRMarker {
    public ArrowCross(double d, int n, boolean bl, double d2) throws InvalidRepeatValueException {
        super(d, n, bl, d2);
        this.type = 13;
    }

    @Override
    public String getID() {
        return this.reversed ? "arrow-r" + this.repeated + "cross" : "arrow-" + this.repeated + "cross";
    }

    @Override
    public GeneralPath getGeneralPath() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)(-this.size), (float)(-this.size));
        generalPath.lineTo((float)this.size, (float)this.size);
        generalPath.moveTo((float)(-this.size), (float)this.size);
        generalPath.lineTo((float)this.size, (float)(-this.size));
        BasicStroke basicStroke = new BasicStroke(2.0f);
        Shape shape = basicStroke.createStrokedShape(generalPath);
        return new GeneralPath(shape);
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public boolean usesLineWidth() {
        return false;
    }

    @Override
    protected String pgfarrow() {
        return "\\pgfsetdash{}{0pt}\\pgfsetlinewidth{2bp}\\pgfpathqmoveto{" + PGF.format(-this.size) + "bp}{" + PGF.format(-this.size) + "bp}" + "\\pgfpathqlineto{" + PGF.format(this.size) + "bp}{" + PGF.format(this.size) + "bp}" + "\\pgfpathqmoveto{" + PGF.format(-this.size) + "bp}{" + PGF.format(this.size) + "bp}" + "\\pgfpathqlineto{" + PGF.format(this.size) + "bp}{" + PGF.format(-this.size) + "bp}" + "\\pgfusepathqstroke";
    }

    @Override
    public Object clone() {
        ArrowCross arrowCross = null;
        try {
            arrowCross = new ArrowCross(this.penWidth, this.repeated, this.reversed, this.size);
            this.makeEqual(arrowCross);
        }
        catch (InvalidRepeatValueException invalidRepeatValueException) {
            // empty catch block
        }
        return arrowCross;
    }
}

