/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.marker;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import uk.ac.uea.cmp.nlct.jdr.InvalidRepeatValueException;
import uk.ac.uea.cmp.nlct.jdr.io.PGF;
import uk.ac.uea.cmp.nlct.jdr.marker.JDRMarker;

public class ArrowBoxOpen
extends JDRMarker {
    public ArrowBoxOpen(double d, int n, boolean bl, double d2) throws InvalidRepeatValueException {
        super(d, n, bl, d2);
        this.type = 12;
    }

    @Override
    public String getID() {
        return this.reversed ? "arrow-r" + this.repeated + "boxopen" : "arrow-" + this.repeated + "boxopen";
    }

    @Override
    public GeneralPath getGeneralPath() {
        double d = this.size - 1.0;
        GeneralPath generalPath = new GeneralPath(new Rectangle2D.Float((float)(-d), (float)(-d), (float)(2.0 * d), (float)(2.0 * d)));
        BasicStroke basicStroke = new BasicStroke(2.0f);
        Shape shape = basicStroke.createStrokedShape(generalPath);
        return new GeneralPath(shape);
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public boolean usesLineWidth() {
        return false;
    }

    @Override
    protected String pgfarrow() {
        return "\\pgfsetdash{}{0pt}\\pgfsetlinewidth{2bp}\\pgfpathrectangle{\\pgfpoint{" + PGF.format(-this.size) + "bp}{" + PGF.format(-this.size) + "bp}}{\\pgfpoint{" + PGF.format(2.0 * this.size) + "bp}{" + PGF.format(2.0 * this.size) + "bp}}" + "\\pgfusepathqstroke";
    }

    @Override
    public Object clone() {
        ArrowBoxOpen arrowBoxOpen = null;
        try {
            arrowBoxOpen = new ArrowBoxOpen(this.penWidth, this.repeated, this.reversed, this.size);
            this.makeEqual(arrowBoxOpen);
        }
        catch (InvalidRepeatValueException invalidRepeatValueException) {
            // empty catch block
        }
        return arrowBoxOpen;
    }
}

