/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.io.eps.operators;

import java.awt.geom.NoninvertibleTransformException;
import java.io.File;
import java.io.IOException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSFile;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSObject;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSOperator;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSStack;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSString;

public class EPSStatus
extends EPSOperator {
    public EPSStatus() {
        super("status");
    }

    @Override
    public void execute(EPSStack ePSStack, EPS ePS) throws InvalidFormatException, NoninvertibleTransformException, IOException {
        EPSObject ePSObject = ePSStack.popObject();
        if (ePSObject instanceof EPSFile) {
            EPSFile ePSFile = (EPSFile)ePSObject;
            ePSStack.pushBoolean(ePSFile.status());
        } else if (ePSObject instanceof EPSString) {
            EPSString ePSString = (EPSString)ePSObject;
            File file = new File(ePSString.value());
            if (file.exists()) {
                ePS.warning("(status) storage space and creation date not implemented");
                ePSStack.pushInteger(0);
                ePSStack.pushLong(file.length());
                long l = file.lastModified();
                ePSStack.pushLong(l);
                ePSStack.pushLong(l);
                ePSStack.pushBoolean(true);
            } else {
                ePSStack.pushBoolean(false);
            }
        } else {
            throw new InvalidFormatException("(status) invalid parameter", ePS.getLineNum());
        }
    }
}

