/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.io.eps.operators;

import java.awt.geom.NoninvertibleTransformException;
import java.io.IOException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRColor;
import uk.ac.uea.cmp.nlct.jdr.JDRColorCMYK;
import uk.ac.uea.cmp.nlct.jdr.JDRColorHSB;
import uk.ac.uea.cmp.nlct.jdr.JDRGray;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSArray;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSName;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSObject;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSOperator;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSStack;
import uk.ac.uea.cmp.nlct.jdr.io.eps.GraphicsState;

public class EPSSetColorSpace
extends EPSOperator {
    public EPSSetColorSpace() {
        super("setcolorspace");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(EPSStack ePSStack, EPS ePS) throws InvalidFormatException, NoninvertibleTransformException, IOException {
        String string;
        GraphicsState graphicsState = ePS.getCurrentGraphicsState();
        EPSObject ePSObject = ePSStack.popObject();
        int n = 1;
        EPSArray ePSArray = null;
        if (ePSObject instanceof EPSName) {
            string = ((EPSName)ePSObject).toString();
        } else {
            ePSArray = (EPSArray)ePSObject;
            if (!(ePSArray.get(0) instanceof EPSName)) {
                throw new InvalidFormatException("(setcolorspace) color space missing", ePS.getLineNum());
            }
            string = ((EPSName)ePSArray.get(0)).toString();
            n = ePSArray.size();
        }
        if (string.equals("/DeviceRGB")) {
            if (n == 1) {
                graphicsState.setPaint(new JDRColor());
                return;
            } else {
                if (n != 4) throw new InvalidFormatException("invalid number of parameters to setcolorspace array", ePS.getLineNum());
                double d = ePSArray.getDouble(1);
                double d2 = ePSArray.getDouble(2);
                double d3 = ePSArray.getDouble(3);
                if (d3 > 1.0) {
                    d3 = 1.0;
                } else if (d3 < 0.0) {
                    d3 = 0.0;
                }
                if (d2 > 1.0) {
                    d2 = 1.0;
                } else if (d2 < 0.0) {
                    d2 = 0.0;
                }
                if (d > 1.0) {
                    d = 1.0;
                } else if (d < 0.0) {
                    d = 0.0;
                }
                graphicsState.setPaint(new JDRColor(d, d2, d3));
            }
            return;
        } else if (string.equals("/DeviceCMYK")) {
            if (n == 1) {
                graphicsState.setPaint(new JDRColorCMYK());
                return;
            } else {
                if (n != 5) throw new InvalidFormatException("invalid number of parameters to setcolorspace array", ePS.getLineNum());
                double d = ePSArray.getDouble(1);
                double d4 = ePSArray.getDouble(2);
                double d5 = ePSArray.getDouble(3);
                double d6 = ePSArray.getDouble(4);
                if (d6 > 1.0) {
                    d6 = 1.0;
                } else if (d6 < 0.0) {
                    d6 = 0.0;
                }
                if (d5 > 1.0) {
                    d5 = 1.0;
                } else if (d5 < 0.0) {
                    d5 = 0.0;
                }
                if (d4 > 1.0) {
                    d4 = 1.0;
                } else if (d4 < 0.0) {
                    d4 = 0.0;
                }
                if (d > 1.0) {
                    d = 1.0;
                } else if (d < 0.0) {
                    d = 0.0;
                }
                graphicsState.setPaint(new JDRColorCMYK(d, d4, d5, d6));
            }
            return;
        } else if (string.equals("/DeviceGray")) {
            if (n == 1) {
                graphicsState.setPaint(new JDRGray());
                return;
            } else {
                if (n != 2) throw new InvalidFormatException("invalid number of parameters to setcolorspace array", ePS.getLineNum());
                double d = ePSArray.getDouble(1);
                if (d > 1.0) {
                    d = 1.0;
                } else if (d < 0.0) {
                    d = 0.0;
                }
                graphicsState.setPaint(new JDRGray(d));
            }
            return;
        } else {
            if (!string.equals("/DeviceHSB")) throw new InvalidFormatException("color space " + string + " not implemented", ePS.getLineNum());
            if (n == 1) {
                graphicsState.setPaint(new JDRColorHSB());
                return;
            } else {
                if (n != 4) return;
                double d = ePSArray.getDouble(1);
                double d7 = ePSArray.getDouble(2);
                double d8 = ePSArray.getDouble(3);
                if (d >= 1.0 || d < 0.0) {
                    d = 0.0;
                }
                if (d7 > 1.0) {
                    d7 = 1.0;
                } else if (d7 < 0.0) {
                    d7 = 0.0;
                }
                if (d8 > 1.0) {
                    d8 = 1.0;
                } else if (d8 < 0.0) {
                    d8 = 0.0;
                }
                graphicsState.setPaint(new JDRColorHSB(d * 360.0, d7, d8));
            }
        }
    }
}

