/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.io.eps.operators;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidPaintException;
import uk.ac.uea.cmp.nlct.jdr.JDRBitmap;
import uk.ac.uea.cmp.nlct.jdr.JDRColor;
import uk.ac.uea.cmp.nlct.jdr.JDRColorCMYK;
import uk.ac.uea.cmp.nlct.jdr.JDRColorHSB;
import uk.ac.uea.cmp.nlct.jdr.JDRGray;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSArray;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSDict;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSFile;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSFilter;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSObject;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSOperator;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSProc;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSReadable;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSStack;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSString;
import uk.ac.uea.cmp.nlct.jdr.io.eps.GraphicsState;
import uk.ac.uea.cmp.nlct.jdr.io.eps.InvalidEPSObjectException;

public class EPSImage
extends EPSOperator {
    public EPSImage() {
        super("image");
    }

    @Override
    public void execute(EPSStack ePSStack, EPS ePS) throws InvalidFormatException, NoninvertibleTransformException, IOException {
        Object object;
        GraphicsState graphicsState = ePS.getCurrentGraphicsState();
        EPSObject ePSObject = ePSStack.popObject();
        BufferedImage bufferedImage = null;
        EPSArray ePSArray = null;
        if (ePSObject instanceof EPSProc) {
            object = (EPSProc)ePSObject;
            ePSArray = ePSStack.popEPSMatrix();
            int n = ePSStack.popInteger();
            int n2 = ePSStack.popInteger();
            int n3 = ePSStack.popInteger();
            bufferedImage = this.getGreyImage(n3, n2, n, 0.0, 1.0, (EPSObject)object, ePSStack, ePS);
        } else if (ePSObject instanceof EPSDict) {
            object = (EPSDict)ePSObject;
            bufferedImage = this.getImage((EPSDict)object, graphicsState, ePSStack, ePS);
            ePSArray = ((EPSDict)object).getArray("ImageMatrix");
        } else {
            throw new InvalidEPSObjectException("invalid parameter to image", ePS.getLineNum());
        }
        object = ePS.getNextBitmapName("png");
        ePS.printlnMessage("Saving '" + (String)object + "'");
        File file = new File((String)object);
        ImageIO.write((RenderedImage)bufferedImage, "png", file);
        JDRBitmap jDRBitmap = new JDRBitmap(file.getCanonicalPath());
        AffineTransform affineTransform = ePSArray.getTransform().createInverse();
        AffineTransform affineTransform2 = graphicsState.getTransform();
        affineTransform.preConcatenate(affineTransform2);
        jDRBitmap.setTransformation(affineTransform);
        ePS.addJDRObject(jDRBitmap);
    }

    private BufferedImage getImage(EPSDict ePSDict, GraphicsState graphicsState, EPSStack ePSStack, EPS ePS) throws InvalidFormatException, IOException, NoninvertibleTransformException {
        JDRPaint jDRPaint;
        int n = ePSDict.getInt("ImageType");
        if (n != 1) {
            throw new InvalidFormatException("Image type " + n + " not supported", ePS.getLineNum());
        }
        int n2 = ePSDict.getInt("Width");
        int n3 = ePSDict.getInt("Height");
        int n4 = ePSDict.getInt("BitsPerComponent");
        EPSArray ePSArray = ePSDict.getArray("Decode");
        EPSObject ePSObject = ePSDict.get("DataSource");
        boolean bl = false;
        if (ePSDict.containsKey("MultipleDataSources")) {
            bl = ePSDict.getBoolean("MultipleDataSources");
        }
        boolean bl2 = false;
        if (ePSDict.containsKey("Interpolate")) {
            bl2 = ePSDict.getBoolean("Interpolate");
        }
        if ((jDRPaint = graphicsState.getPaint()) instanceof JDRColor) {
            if (ePSArray.length() != 6) {
                throw new InvalidFormatException("(image) decode array requires 6 elements for RGB space", ePS.getLineNum());
            }
            if (bl) {
                if (!(ePSObject instanceof EPSArray)) {
                    throw new InvalidFormatException("(image) array data source expected for multiple data sources", ePS.getLineNum());
                }
                EPSArray ePSArray2 = (EPSArray)ePSObject;
                if (ePSArray2.length() != 3) {
                    throw new InvalidFormatException("(image) RGB array data source for multiple data sources requires 3 components " + ePSArray2.length() + " found", ePS.getLineNum());
                }
                return this.getRGBImage(n2, n3, n4, ePSArray.getDouble(0), ePSArray.getDouble(1), ePSArray.getDouble(2), ePSArray.getDouble(3), ePSArray.getDouble(4), ePSArray.getDouble(5), ePSArray2.get(0), ePSArray2.get(1), ePSArray2.get(2), ePSStack, ePS);
            }
            return this.getRGBImage(n2, n3, n4, ePSArray.getDouble(0), ePSArray.getDouble(1), ePSArray.getDouble(2), ePSArray.getDouble(3), ePSArray.getDouble(4), ePSArray.getDouble(5), ePSObject, ePSStack, ePS);
        }
        if (jDRPaint instanceof JDRColorCMYK) {
            if (ePSArray.length() != 8) {
                throw new InvalidFormatException("(image) decode array requires 8 elements for CMYK space", ePS.getLineNum());
            }
            if (bl) {
                if (!(ePSObject instanceof EPSArray)) {
                    throw new InvalidFormatException("(image) array data source expected for multiple data sources", ePS.getLineNum());
                }
                EPSArray ePSArray3 = (EPSArray)ePSObject;
                if (ePSArray3.length() != 4) {
                    throw new InvalidFormatException("(image) CMYK array data source for multiple data sources requires 4 components " + ePSArray3.length() + " found", ePS.getLineNum());
                }
                return this.getCMYKImage(n2, n3, n4, ePSArray.getDouble(0), ePSArray.getDouble(1), ePSArray.getDouble(2), ePSArray.getDouble(3), ePSArray.getDouble(4), ePSArray.getDouble(5), ePSArray.getDouble(6), ePSArray.getDouble(7), ePSArray3.get(0), ePSArray3.get(1), ePSArray3.get(2), ePSArray3.get(3), ePSStack, ePS);
            }
            return this.getCMYKImage(n2, n3, n4, ePSArray.getDouble(0), ePSArray.getDouble(1), ePSArray.getDouble(2), ePSArray.getDouble(3), ePSArray.getDouble(4), ePSArray.getDouble(5), ePSArray.getDouble(6), ePSArray.getDouble(7), ePSObject, ePSStack, ePS);
        }
        if (jDRPaint instanceof JDRColorHSB) {
            if (ePSArray.length() != 6) {
                throw new InvalidFormatException("(image) decode array requires 6 elements for HSB space", ePS.getLineNum());
            }
            if (bl) {
                if (!(ePSObject instanceof EPSArray)) {
                    throw new InvalidFormatException("(image) array data source expected for multiple data sources", ePS.getLineNum());
                }
                EPSArray ePSArray4 = (EPSArray)ePSObject;
                if (ePSArray4.length() != 3) {
                    throw new InvalidFormatException("(image) HSB array data source for multiple data sources requires 3 components " + ePSArray4.length() + " found", ePS.getLineNum());
                }
                return this.getHSBImage(n2, n3, n4, ePSArray.getDouble(0), ePSArray.getDouble(1), ePSArray.getDouble(2), ePSArray.getDouble(3), ePSArray.getDouble(4), ePSArray.getDouble(5), ePSArray4.get(0), ePSArray4.get(1), ePSArray4.get(2), ePSStack, ePS);
            }
            return this.getHSBImage(n2, n3, n4, ePSArray.getDouble(0), ePSArray.getDouble(1), ePSArray.getDouble(2), ePSArray.getDouble(3), ePSArray.getDouble(4), ePSArray.getDouble(5), ePSObject, ePSStack, ePS);
        }
        if (jDRPaint instanceof JDRGray) {
            if (bl) {
                throw new InvalidFormatException("(image) grey can't have multiple sources", ePS.getLineNum());
            }
            if (ePSArray.length() != 2) {
                throw new InvalidFormatException("(image) decode array requires 2 elements for grey space", ePS.getLineNum());
            }
            return this.getGreyImage(n2, n3, n4, ePSArray.getDouble(0), ePSArray.getDouble(1), ePSObject, ePSStack, ePS);
        }
        throw new InvalidPaintException("Invalid paint type for image", ePS.getLineNum());
    }

    private BufferedImage getRGBImage(int n, int n2, int n3, double d, double d2, double d3, double d4, double d5, double d6, EPSObject ePSObject, EPSObject ePSObject2, EPSObject ePSObject3, EPSStack ePSStack, EPS ePS) throws InvalidFormatException, IOException, NoninvertibleTransformException {
        double d7;
        int n4;
        int n5;
        Object object;
        WritableRaster writableRaster = ColorModel.getRGBdefault().createCompatibleWritableRaster(n, n2);
        ePS.printlnMessage("extracting RGB image");
        int n6 = n * n2 * 4;
        int[] nArray = new int[n6];
        if (ePSObject instanceof EPSString) {
            object = (EPSString)ePSObject;
            n5 = 0;
            for (n4 = 0; n4 < n6; n4 += 4) {
                char c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length()) {
                    n5 = 0;
                }
                d7 = d + (double)c * (d2 - d) / ((double)(2 >> n3) - 1.0);
                nArray[n4] = (int)(d7 * 255.0);
                nArray[n4 + 3] = 255;
            }
        } else if (ePSObject instanceof EPSProc) {
            ePSStack.execProc((EPSProc)ePSObject);
            object = ePSStack.popEPSString();
            n5 = 0;
            for (n4 = 0; n4 < n6; n4 += 4) {
                char c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length() && n4 + 4 < n6) {
                    n5 = 0;
                    ePSStack.execProc((EPSProc)ePSObject);
                    object = ePSStack.popEPSString();
                }
                d7 = d + (double)c * (d2 - d) / ((double)(2 >> n3) - 1.0);
                nArray[n4] = (int)(d7 * 255.0);
                nArray[n4 + 3] = 255;
            }
        } else if (ePSObject instanceof EPSFilter || ePSObject instanceof EPSFile) {
            object = ePSObject instanceof EPSFilter ? ((EPSFilter)ePSObject).getFile(ePSStack) : (EPSFile)ePSObject;
            for (n4 = 0; n4 < n6; n4 += 4) {
                n5 = ((EPSFile)object).read();
                if (n5 == -1 && n4 + 4 < n6) {
                    ((EPSFile)object).restart();
                }
                double d8 = d + (double)n5 * (d2 - d) / ((double)(2 >> n3) - 1.0);
                nArray[n4] = (int)(d8 * 255.0);
                nArray[n4 + 3] = 255;
            }
        } else {
            throw new InvalidEPSObjectException("image data source invalid", ePS.getLineNum());
        }
        if (ePSObject2 instanceof EPSString) {
            object = (EPSString)ePSObject2;
            n5 = 0;
            for (n4 = 0; n4 < n6; n4 += 4) {
                char c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length()) {
                    n5 = 0;
                }
                d7 = d3 + (double)c * (d4 - d3) / ((double)(2 >> n3) - 1.0);
                nArray[n4 + 1] = (int)(d7 * 255.0);
            }
        } else if (ePSObject2 instanceof EPSProc) {
            ePSStack.execProc((EPSProc)ePSObject2);
            object = ePSStack.popEPSString();
            n5 = 0;
            for (n4 = 0; n4 < n6; n4 += 4) {
                char c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length() && n4 + 4 < n6) {
                    n5 = 0;
                    ePSStack.execProc((EPSProc)ePSObject2);
                    object = ePSStack.popEPSString();
                }
                d7 = d3 + (double)c * (d4 - d3) / ((double)(2 >> n3) - 1.0);
                nArray[n4 + 1] = (int)(d7 * 255.0);
            }
        } else if (ePSObject2 instanceof EPSFilter || ePSObject2 instanceof EPSFile) {
            object = ePSObject2 instanceof EPSFilter ? ((EPSFilter)ePSObject2).getFile(ePSStack) : (EPSFile)ePSObject2;
            for (n4 = 0; n4 < n6; n4 += 4) {
                n5 = ((EPSFile)object).read();
                if (n5 == -1 && n4 + 4 < n6) {
                    ((EPSFile)object).restart();
                }
                double d9 = d3 + (double)n5 * (d4 - d3) / ((double)(2 >> n3) - 1.0);
                nArray[n4 + 1] = (int)(d9 * 255.0);
            }
        } else {
            throw new InvalidEPSObjectException("image data source invalid", ePS.getLineNum());
        }
        if (ePSObject3 instanceof EPSString) {
            object = (EPSString)ePSObject3;
            n5 = 0;
            for (n4 = 0; n4 < n6; n4 += 4) {
                char c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length()) {
                    n5 = 0;
                }
                d7 = d5 + (double)c * (d6 - d5) / ((double)(2 >> n3) - 1.0);
                nArray[n4 + 2] = (int)(d7 * 255.0);
            }
        } else if (ePSObject3 instanceof EPSProc) {
            ePSStack.execProc((EPSProc)ePSObject3);
            object = ePSStack.popEPSString();
            n5 = 0;
            for (n4 = 0; n4 < n6; n4 += 4) {
                char c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length() && n4 + 4 < n6) {
                    n5 = 0;
                    ePSStack.execProc((EPSProc)ePSObject3);
                    object = ePSStack.popEPSString();
                }
                d7 = d5 + (double)c * (d6 - d5) / ((double)(2 >> n3) - 1.0);
                nArray[n4 + 2] = (int)(d7 * 255.0);
            }
        } else if (ePSObject3 instanceof EPSFilter || ePSObject3 instanceof EPSFile) {
            object = ePSObject3 instanceof EPSFilter ? ((EPSFilter)ePSObject3).getFile(ePSStack) : (EPSFile)ePSObject3;
            for (n4 = 0; n4 < n6; n4 += 4) {
                n5 = ((EPSFile)object).read();
                if (n5 == -1 && n4 + 4 < n6) {
                    ((EPSFile)object).restart();
                }
                double d10 = d5 + (double)n5 * (d6 - d5) / ((double)(2 >> n3) - 1.0);
                nArray[n4 + 2] = (int)(d10 * 255.0);
            }
        } else {
            throw new InvalidEPSObjectException("image data source invalid", ePS.getLineNum());
        }
        writableRaster.setPixels(0, 0, n, n2, nArray);
        object = new BufferedImage(n, n2, 2);
        ((BufferedImage)object).setData(writableRaster);
        return object;
    }

    private BufferedImage getRGBImage(int n, int n2, int n3, double d, double d2, double d3, double d4, double d5, double d6, EPSObject ePSObject, EPSStack ePSStack, EPS ePS) throws InvalidFormatException, IOException, NoninvertibleTransformException {
        Object object;
        WritableRaster writableRaster = ColorModel.getRGBdefault().createCompatibleWritableRaster(n, n2);
        ePS.printlnMessage("extracting RGB image");
        int n4 = n * n2 * 4;
        int[] nArray = new int[n4];
        if (ePSObject instanceof EPSString) {
            object = (EPSString)ePSObject;
            int n5 = 0;
            for (int i = 0; i < n4; i += 4) {
                char c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length()) {
                    n5 = 0;
                }
                double d7 = d + (double)c * (d2 - d) / ((double)(2 >> n3) - 1.0);
                nArray[i] = (int)(d7 * 255.0);
                c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length()) {
                    n5 = 0;
                }
                d7 = d3 + (double)c * (d4 - d3) / ((double)(2 >> n3) - 1.0);
                nArray[i + 1] = (int)(d7 * 255.0);
                c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length()) {
                    n5 = 0;
                }
                d7 = d5 + (double)c * (d6 - d5) / ((double)(2 >> n3) - 1.0);
                nArray[i + 2] = (int)(d7 * 255.0);
                nArray[i + 3] = 255;
            }
        } else if (ePSObject instanceof EPSProc) {
            ePSStack.execProc((EPSProc)ePSObject);
            object = ePSStack.popEPSString();
            int n6 = 0;
            for (int i = 0; i < n4; i += 4) {
                char c = ((EPSString)object).get(n6++);
                if (n6 == ((EPSString)object).length() && i + 4 < n4) {
                    n6 = 0;
                    ePSStack.execProc((EPSProc)ePSObject);
                    object = ePSStack.popEPSString();
                }
                double d8 = d + (double)c * (d2 - d) / ((double)(2 >> n3) - 1.0);
                nArray[i] = (int)(d8 * 255.0);
                c = ((EPSString)object).get(n6++);
                if (n6 == ((EPSString)object).length() && i + 4 < n4) {
                    n6 = 0;
                    ePSStack.execProc((EPSProc)ePSObject);
                    object = ePSStack.popEPSString();
                }
                d8 = d3 + (double)c * (d4 - d3) / ((double)(2 >> n3) - 1.0);
                nArray[i + 1] = (int)(d8 * 255.0);
                c = ((EPSString)object).get(n6++);
                if (n6 == ((EPSString)object).length() && i + 4 < n4) {
                    n6 = 0;
                    ePSStack.execProc((EPSProc)ePSObject);
                    object = ePSStack.popEPSString();
                }
                d8 = d5 + (double)c * (d6 - d5) / ((double)(2 >> n3) - 1.0);
                nArray[i + 2] = (int)(d8 * 255.0);
                nArray[i + 3] = 255;
            }
        } else if (ePSObject instanceof EPSFilter || ePSObject instanceof EPSFile) {
            object = ePSObject instanceof EPSFilter ? ((EPSFilter)ePSObject).getFile(ePSStack) : (EPSFile)ePSObject;
            for (int i = 0; i < n4; i += 4) {
                int n7 = ((EPSFile)object).read();
                if (n7 == -1 && i + 4 < n4) {
                    ((EPSFile)object).restart();
                }
                double d9 = d + (double)n7 * (d2 - d) / ((double)(2 >> n3) - 1.0);
                nArray[i] = (int)(d9 * 255.0);
                n7 = ((EPSFile)object).read();
                if (n7 == -1 && i + 4 < n4) {
                    ((EPSFile)object).restart();
                }
                d9 = d3 + (double)n7 * (d4 - d3) / ((double)(2 >> n3) - 1.0);
                nArray[i + 1] = (int)(d9 * 255.0);
                n7 = ((EPSFile)object).read();
                if (n7 == -1 && i + 4 < n4) {
                    ((EPSFile)object).restart();
                }
                d9 = d5 + (double)n7 * (d6 - d5) / ((double)(2 >> n3) - 1.0);
                nArray[i + 2] = (int)(d9 * 255.0);
                nArray[i + 3] = 255;
            }
        } else {
            throw new InvalidEPSObjectException("image data source invalid", ePS.getLineNum());
        }
        writableRaster.setPixels(0, 0, n, n2, nArray);
        object = new BufferedImage(n, n2, 2);
        ((BufferedImage)object).setData(writableRaster);
        return object;
    }

    private BufferedImage getHSBImage(int n, int n2, int n3, double d, double d2, double d3, double d4, double d5, double d6, EPSObject ePSObject, EPSObject ePSObject2, EPSObject ePSObject3, EPSStack ePSStack, EPS ePS) throws InvalidFormatException, IOException, NoninvertibleTransformException {
        double d7;
        int n4;
        int n5;
        Object object;
        WritableRaster writableRaster = ColorModel.getRGBdefault().createCompatibleWritableRaster(n, n2);
        ePS.printlnMessage("extracting HSB image");
        int n6 = n * n2;
        JDRColorHSB[] jDRColorHSBArray = new JDRColorHSB[n6];
        if (ePSObject instanceof EPSString) {
            object = (EPSString)ePSObject;
            n5 = 0;
            for (n4 = 0; n4 < n6; ++n4) {
                char c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length()) {
                    n5 = 0;
                }
                d7 = d + (double)c * (d2 - d) / ((double)(2 >> n3) - 1.0);
                jDRColorHSBArray[n4] = new JDRColorHSB();
                jDRColorHSBArray[n4].setHue(d7);
            }
        } else if (ePSObject instanceof EPSProc) {
            ePSStack.execProc((EPSProc)ePSObject);
            object = ePSStack.popEPSString();
            n5 = 0;
            for (n4 = 0; n4 < n6; ++n4) {
                char c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length() && n4 + 1 < n6) {
                    n5 = 0;
                    ePSStack.execProc((EPSProc)ePSObject);
                    object = ePSStack.popEPSString();
                }
                d7 = d + (double)c * (d2 - d) / ((double)(2 >> n3) - 1.0);
                jDRColorHSBArray[n4] = new JDRColorHSB();
                jDRColorHSBArray[n4].setHue(d7);
            }
        } else if (ePSObject instanceof EPSFilter || ePSObject instanceof EPSFile) {
            object = ePSObject instanceof EPSFilter ? ((EPSFilter)ePSObject).getFile(ePSStack) : (EPSFile)ePSObject;
            for (n4 = 0; n4 < n6; ++n4) {
                n5 = ((EPSFile)object).read();
                if (n5 == -1 && n4 + 1 < n6) {
                    ((EPSFile)object).restart();
                }
                double d8 = d + (double)n5 * (d2 - d) / ((double)(2 >> n3) - 1.0);
                jDRColorHSBArray[n4] = new JDRColorHSB();
                jDRColorHSBArray[n4].setHue(d8);
            }
        } else {
            throw new InvalidEPSObjectException("image data source invalid", ePS.getLineNum());
        }
        if (ePSObject2 instanceof EPSString) {
            object = (EPSString)ePSObject2;
            n5 = 0;
            for (n4 = 0; n4 < n6; ++n4) {
                char c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length()) {
                    n5 = 0;
                }
                d7 = d3 + (double)c * (d4 - d3) / ((double)(2 >> n3) - 1.0);
                jDRColorHSBArray[n4].setSaturation(d7);
            }
        } else if (ePSObject2 instanceof EPSProc) {
            ePSStack.execProc((EPSProc)ePSObject2);
            object = ePSStack.popEPSString();
            n5 = 0;
            for (n4 = 0; n4 < n6; ++n4) {
                char c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length() && n4 + 1 < n6) {
                    n5 = 0;
                    ePSStack.execProc((EPSProc)ePSObject2);
                    object = ePSStack.popEPSString();
                }
                d7 = d3 + (double)c * (d4 - d3) / ((double)(2 >> n3) - 1.0);
                jDRColorHSBArray[n4].setSaturation(d7);
            }
        } else if (ePSObject2 instanceof EPSFilter || ePSObject2 instanceof EPSFile) {
            object = ePSObject2 instanceof EPSFilter ? ((EPSFilter)ePSObject2).getFile(ePSStack) : (EPSFile)ePSObject2;
            for (n4 = 0; n4 < n6; ++n4) {
                n5 = ((EPSFile)object).read();
                if (n5 == -1 && n4 + 1 < n6) {
                    ((EPSFile)object).restart();
                }
                double d9 = d3 + (double)n5 * (d4 - d3) / ((double)(2 >> n3) - 1.0);
                jDRColorHSBArray[n4].setSaturation(d9);
            }
        } else {
            throw new InvalidEPSObjectException("image data source invalid", ePS.getLineNum());
        }
        if (ePSObject3 instanceof EPSString) {
            object = (EPSString)ePSObject3;
            n5 = 0;
            for (n4 = 0; n4 < n6; ++n4) {
                char c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length()) {
                    n5 = 0;
                }
                d7 = d5 + (double)c * (d6 - d5) / ((double)(2 >> n3) - 1.0);
                jDRColorHSBArray[n4].setBrightness(d7);
            }
        } else if (ePSObject3 instanceof EPSProc) {
            ePSStack.execProc((EPSProc)ePSObject3);
            object = ePSStack.popEPSString();
            n5 = 0;
            for (n4 = 0; n4 < n6; ++n4) {
                char c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length() && n4 + 1 < n6) {
                    n5 = 0;
                    ePSStack.execProc((EPSProc)ePSObject3);
                    object = ePSStack.popEPSString();
                }
                d7 = d5 + (double)c * (d6 - d5) / ((double)(2 >> n3) - 1.0);
                jDRColorHSBArray[n4].setBrightness(d7);
            }
        } else if (ePSObject3 instanceof EPSFilter || ePSObject3 instanceof EPSFile) {
            object = ePSObject3 instanceof EPSFilter ? ((EPSFilter)ePSObject3).getFile(ePSStack) : (EPSFile)ePSObject3;
            for (n4 = 0; n4 < n6; ++n4) {
                n5 = ((EPSFile)object).read();
                if (n5 == -1 && n4 + 1 < n6) {
                    ((EPSFile)object).restart();
                }
                double d10 = d5 + (double)n5 * (d6 - d5) / ((double)(2 >> n3) - 1.0);
                jDRColorHSBArray[n4].setBrightness(d10);
            }
        } else {
            throw new InvalidEPSObjectException("image data source invalid", ePS.getLineNum());
        }
        object = new int[n6 * 4];
        n5 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            JDRColor jDRColor = jDRColorHSBArray[n4].getJDRColor();
            object[n5++] = (int)Math.round(jDRColor.getRed() * 255.0);
            object[n5++] = (int)Math.round(jDRColor.getGreen() * 255.0);
            object[n5++] = (int)Math.round(jDRColor.getBlue() * 255.0);
            object[n5++] = 255;
        }
        writableRaster.setPixels(0, 0, n, n2, (int[])object);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    private BufferedImage getHSBImage(int n, int n2, int n3, double d, double d2, double d3, double d4, double d5, double d6, EPSObject ePSObject, EPSStack ePSStack, EPS ePS) throws InvalidFormatException, IOException, NoninvertibleTransformException {
        Object object;
        WritableRaster writableRaster = ColorModel.getRGBdefault().createCompatibleWritableRaster(n, n2);
        ePS.printlnMessage("extracting HSB image");
        int n4 = n * n2 * 4;
        int[] nArray = new int[n4];
        if (ePSObject instanceof EPSString) {
            object = (EPSString)ePSObject;
            int n5 = 0;
            for (int i = 0; i < n4; i += 4) {
                char c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length()) {
                    n5 = 0;
                }
                double d7 = d + (double)c * (d2 - d) / ((double)(2 >> n3) - 1.0);
                c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length()) {
                    n5 = 0;
                }
                double d8 = d3 + (double)c * (d4 - d3) / ((double)(2 >> n3) - 1.0);
                c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length()) {
                    n5 = 0;
                }
                double d9 = d5 + (double)c * (d6 - d5) / ((double)(2 >> n3) - 1.0);
                JDRColorHSB jDRColorHSB = new JDRColorHSB(d7, d8, d9);
                JDRColor jDRColor = jDRColorHSB.getJDRColor();
                nArray[i] = (int)Math.round(jDRColor.getRed() * 255.0);
                nArray[i + 1] = (int)Math.round(jDRColor.getGreen() * 255.0);
                nArray[i + 2] = (int)Math.round(jDRColor.getBlue() * 255.0);
                nArray[i + 3] = 255;
            }
        } else if (ePSObject instanceof EPSProc) {
            ePSStack.execProc((EPSProc)ePSObject);
            object = ePSStack.popEPSString();
            int n6 = 0;
            for (int i = 0; i < n4; i += 4) {
                char c = ((EPSString)object).get(n6++);
                if (n6 == ((EPSString)object).length() && i + 4 < n4) {
                    n6 = 0;
                    ePSStack.execProc((EPSProc)ePSObject);
                    object = ePSStack.popEPSString();
                }
                double d10 = d + (double)c * (d2 - d) / ((double)(2 >> n3) - 1.0);
                c = ((EPSString)object).get(n6++);
                if (n6 == ((EPSString)object).length() && i + 4 < n4) {
                    n6 = 0;
                    ePSStack.execProc((EPSProc)ePSObject);
                    object = ePSStack.popEPSString();
                }
                double d11 = d3 + (double)c * (d4 - d3) / ((double)(2 >> n3) - 1.0);
                c = ((EPSString)object).get(n6++);
                if (n6 == ((EPSString)object).length() && i + 4 < n4) {
                    n6 = 0;
                    ePSStack.execProc((EPSProc)ePSObject);
                    object = ePSStack.popEPSString();
                }
                double d12 = d5 + (double)c * (d6 - d5) / ((double)(2 >> n3) - 1.0);
                JDRColorHSB jDRColorHSB = new JDRColorHSB(d10, d11, d12);
                JDRColor jDRColor = jDRColorHSB.getJDRColor();
                nArray[i] = (int)Math.round(jDRColor.getRed() * 255.0);
                nArray[i + 1] = (int)Math.round(jDRColor.getGreen() * 255.0);
                nArray[i + 2] = (int)Math.round(jDRColor.getBlue() * 255.0);
                nArray[i + 3] = 255;
            }
        } else if (ePSObject instanceof EPSFilter || ePSObject instanceof EPSFile) {
            object = ePSObject instanceof EPSFilter ? ((EPSFilter)ePSObject).getFile(ePSStack) : (EPSFile)ePSObject;
            for (int i = 0; i < n4; i += 4) {
                int n7 = ((EPSFile)object).read();
                if (n7 == -1 && i + 4 < n4) {
                    ((EPSFile)object).restart();
                }
                double d13 = d + (double)n7 * (d2 - d) / ((double)(2 >> n3) - 1.0);
                n7 = ((EPSFile)object).read();
                if (n7 == -1 && i + 4 < n4) {
                    ((EPSFile)object).restart();
                }
                double d14 = d3 + (double)n7 * (d4 - d3) / ((double)(2 >> n3) - 1.0);
                n7 = ((EPSFile)object).read();
                if (n7 == -1 && i + 4 < n4) {
                    ((EPSFile)object).restart();
                }
                double d15 = d5 + (double)n7 * (d6 - d5) / ((double)(2 >> n3) - 1.0);
                JDRColorHSB jDRColorHSB = new JDRColorHSB(d13, d14, d15);
                JDRColor jDRColor = jDRColorHSB.getJDRColor();
                nArray[i] = (int)Math.round(jDRColor.getRed() * 255.0);
                nArray[i + 1] = (int)Math.round(jDRColor.getGreen() * 255.0);
                nArray[i + 2] = (int)Math.round(jDRColor.getBlue() * 255.0);
                nArray[i + 3] = 255;
            }
        } else {
            throw new InvalidEPSObjectException("image data source invalid", ePS.getLineNum());
        }
        writableRaster.setPixels(0, 0, n, n2, nArray);
        object = new BufferedImage(n, n2, 2);
        ((BufferedImage)object).setData(writableRaster);
        return object;
    }

    private BufferedImage getGreyImage(int n, int n2, int n3, double d, double d2, EPSObject ePSObject, EPSStack ePSStack, EPS ePS) throws InvalidFormatException, IOException, NoninvertibleTransformException {
        int n4;
        int n5;
        int n6;
        EPSReadable ePSReadable;
        WritableRaster writableRaster = ColorModel.getRGBdefault().createCompatibleWritableRaster(n, n2);
        ePS.printlnMessage("extracting grey image");
        EPSProc ePSProc = ePS.getCurrentGraphicsState().getTransfer();
        int n7 = n * n2;
        int[] nArray = new int[n7];
        if (ePSObject instanceof EPSString) {
            ePSReadable = (EPSString)ePSObject;
            n6 = 0;
            for (n5 = 0; n5 < n7; ++n5) {
                n4 = ((EPSString)ePSReadable).get(n6++);
                if (n6 == ((EPSString)ePSReadable).length()) {
                    n6 = 0;
                }
                double d3 = d + (double)n4 * (d2 - d) / ((double)(2 >> n3) - 1.0);
                nArray[n5] = (int)Math.round(d3 * 255.0);
            }
        } else if (ePSObject instanceof EPSProc) {
            ePSStack.execProc((EPSProc)ePSObject);
            ePSReadable = ePSStack.popEPSString();
            n6 = 0;
            for (n5 = 0; n5 < n7; ++n5) {
                int n8;
                double d4;
                if (((EPSString)ePSReadable).isEmpty()) {
                    d4 = 1.0;
                    if (ePSProc != null) {
                        ePSStack.pushDouble(d4);
                        ePSStack.execProc(ePSProc);
                        d4 = ePSStack.popDouble();
                    }
                    nArray[n5] = (int)Math.round(d4 * 255.0);
                    continue;
                }
                char c = ((EPSString)ePSReadable).get(n6++);
                if (n6 == ((EPSString)ePSReadable).length() && n5 < n7) {
                    n6 = 0;
                    ePSStack.execProc((EPSProc)ePSObject);
                    ePSReadable = ePSStack.popEPSString();
                }
                if (n3 == 1) {
                    for (n8 = 128; n8 > 0 && n5 < n7; n8 >>= 1, ++n5) {
                        d4 = (c & n8) > 0 ? 1 : 0;
                        if (ePSProc != null) {
                            ePSStack.pushDouble(d4);
                            ePSStack.execProc(ePSProc);
                            d4 = ePSStack.popDouble();
                        }
                        nArray[n5] = (int)Math.round(d4 * 255.0);
                    }
                    --n5;
                    continue;
                }
                if (n3 == 2) {
                    n8 = 192;
                    int n9 = 6;
                    while (n8 > 0 && n5 < n7) {
                        d4 = (double)((c & n8) >> n9) / 3.0;
                        if (ePSProc != null) {
                            ePSStack.pushDouble(d4);
                            ePSStack.execProc(ePSProc);
                            d4 = ePSStack.popDouble();
                        }
                        nArray[n5] = (int)Math.round(d4 * 255.0);
                        n8 >>= 2;
                        ++n5;
                        n9 -= 2;
                    }
                    --n5;
                    continue;
                }
                if (n3 == 4) {
                    d4 = (double)((c & 0xF0) >> 4) / 15.0;
                    if (ePSProc != null) {
                        ePSStack.pushDouble(d4);
                        ePSStack.execProc(ePSProc);
                        d4 = ePSStack.popDouble();
                    }
                    nArray[n5] = (int)Math.round(d4 * 255.0);
                    ++n5;
                    d4 = (double)(c & 0xF) / 15.0;
                    if (ePSProc != null) {
                        ePSStack.pushDouble(d4);
                        ePSStack.execProc(ePSProc);
                        d4 = ePSStack.popDouble();
                    }
                    nArray[n5] = (int)Math.round(d4 * 255.0);
                    continue;
                }
                d4 = (double)c / 255.0;
                if (ePSProc != null) {
                    ePSStack.pushDouble(d4);
                    ePSStack.execProc(ePSProc);
                    d4 = ePSStack.popDouble();
                }
                nArray[n5] = (int)Math.round(d4 * 255.0);
            }
        } else if (ePSObject instanceof EPSFilter || ePSObject instanceof EPSFile) {
            ePSReadable = ePSObject instanceof EPSFilter ? ((EPSFilter)ePSObject).getFile(ePSStack) : (EPSFile)ePSObject;
            for (n5 = 0; n5 < n7; ++n5) {
                n6 = ((EPSFile)ePSReadable).read();
                if (n6 == -1 && n5 < n7) {
                    ((EPSFile)ePSReadable).restart();
                }
                double d5 = d + (double)n6 * (d2 - d) / ((double)(2 >> n3) - 1.0);
                nArray[n5] = (int)Math.round(d5 * 255.0);
            }
        } else {
            throw new InvalidEPSObjectException("image data source invalid", ePS.getLineNum());
        }
        int n10 = n * n2 * 4;
        int[] nArray2 = new int[n10];
        n4 = 0;
        for (n6 = 0; n6 < n7; ++n6) {
            nArray2[n4++] = nArray[n6];
            nArray2[n4++] = nArray[n6];
            nArray2[n4++] = nArray[n6];
            nArray2[n4++] = 255;
        }
        writableRaster.setPixels(0, 0, n, n2, nArray2);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    private BufferedImage getCMYKImage(int n, int n2, int n3, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, EPSObject ePSObject, EPSObject ePSObject2, EPSObject ePSObject3, EPSObject ePSObject4, EPSStack ePSStack, EPS ePS) throws InvalidFormatException, IOException, NoninvertibleTransformException {
        double d9;
        int n4;
        int n5;
        Object object;
        WritableRaster writableRaster = ColorModel.getRGBdefault().createCompatibleWritableRaster(n, n2);
        ePS.printlnMessage("extracting CMYK image");
        int n6 = n * n2;
        JDRColorCMYK[] jDRColorCMYKArray = new JDRColorCMYK[n6];
        if (ePSObject instanceof EPSString) {
            object = (EPSString)ePSObject;
            n5 = 0;
            for (n4 = 0; n4 < n6; ++n4) {
                char c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length()) {
                    n5 = 0;
                }
                d9 = d + (double)c * (d2 - d) / ((double)(2 >> n3) - 1.0);
                jDRColorCMYKArray[n4] = new JDRColorCMYK();
                jDRColorCMYKArray[n4].setCyan(d9);
            }
        } else if (ePSObject instanceof EPSProc) {
            ePSStack.execProc((EPSProc)ePSObject);
            object = ePSStack.popEPSString();
            n5 = 0;
            for (n4 = 0; n4 < n6; ++n4) {
                char c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length() && n4 + 1 < n6) {
                    n5 = 0;
                    ePSStack.execProc((EPSProc)ePSObject);
                    object = ePSStack.popEPSString();
                }
                d9 = d + (double)c * (d2 - d) / ((double)(2 >> n3) - 1.0);
                jDRColorCMYKArray[n4] = new JDRColorCMYK();
                jDRColorCMYKArray[n4].setCyan(d9);
            }
        } else if (ePSObject instanceof EPSFilter || ePSObject instanceof EPSFile) {
            object = ePSObject instanceof EPSFilter ? ((EPSFilter)ePSObject).getFile(ePSStack) : (EPSFile)ePSObject;
            for (n4 = 0; n4 < n6; ++n4) {
                n5 = ((EPSFile)object).read();
                if (n5 == -1 && n4 + 1 < n6) {
                    ((EPSFile)object).restart();
                }
                double d10 = d + (double)n5 * (d2 - d) / ((double)(2 >> n3) - 1.0);
                jDRColorCMYKArray[n4] = new JDRColorCMYK();
                jDRColorCMYKArray[n4].setCyan(d10);
            }
        } else {
            throw new InvalidEPSObjectException("image data source invalid", ePS.getLineNum());
        }
        if (ePSObject2 instanceof EPSString) {
            object = (EPSString)ePSObject2;
            n5 = 0;
            for (n4 = 0; n4 < n6; ++n4) {
                char c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length()) {
                    n5 = 0;
                }
                d9 = d3 + (double)c * (d4 - d3) / ((double)(2 >> n3) - 1.0);
                jDRColorCMYKArray[n4].setMagenta(d9);
            }
        } else if (ePSObject2 instanceof EPSProc) {
            ePSStack.execProc((EPSProc)ePSObject2);
            object = ePSStack.popEPSString();
            n5 = 0;
            for (n4 = 0; n4 < n6; ++n4) {
                char c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length() && n4 + 1 < n6) {
                    n5 = 0;
                    ePSStack.execProc((EPSProc)ePSObject2);
                    object = ePSStack.popEPSString();
                }
                d9 = d3 + (double)c * (d4 - d3) / ((double)(2 >> n3) - 1.0);
                jDRColorCMYKArray[n4].setMagenta(d9);
            }
        } else if (ePSObject2 instanceof EPSFilter || ePSObject2 instanceof EPSFile) {
            object = ePSObject2 instanceof EPSFilter ? ((EPSFilter)ePSObject2).getFile(ePSStack) : (EPSFile)ePSObject2;
            for (n4 = 0; n4 < n6; ++n4) {
                n5 = ((EPSFile)object).read();
                if (n5 == -1 && n4 + 1 < n6) {
                    ((EPSFile)object).restart();
                }
                double d11 = d3 + (double)n5 * (d4 - d3) / ((double)(2 >> n3) - 1.0);
                jDRColorCMYKArray[n4].setMagenta(d11);
            }
        } else {
            throw new InvalidEPSObjectException("image data source invalid", ePS.getLineNum());
        }
        if (ePSObject3 instanceof EPSString) {
            object = (EPSString)ePSObject3;
            n5 = 0;
            for (n4 = 0; n4 < n6; ++n4) {
                char c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length()) {
                    n5 = 0;
                }
                d9 = d5 + (double)c * (d6 - d5) / ((double)(2 >> n3) - 1.0);
                jDRColorCMYKArray[n4].setYellow(d9);
            }
        } else if (ePSObject3 instanceof EPSProc) {
            ePSStack.execProc((EPSProc)ePSObject3);
            object = ePSStack.popEPSString();
            n5 = 0;
            for (n4 = 0; n4 < n6; ++n4) {
                char c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length() && n4 + 1 < n6) {
                    n5 = 0;
                    ePSStack.execProc((EPSProc)ePSObject3);
                    object = ePSStack.popEPSString();
                }
                d9 = d5 + (double)c * (d6 - d5) / ((double)(2 >> n3) - 1.0);
                jDRColorCMYKArray[n4].setYellow(d9);
            }
        } else if (ePSObject3 instanceof EPSFilter || ePSObject3 instanceof EPSFile) {
            object = ePSObject3 instanceof EPSFilter ? ((EPSFilter)ePSObject3).getFile(ePSStack) : (EPSFile)ePSObject3;
            for (n4 = 0; n4 < n6; ++n4) {
                n5 = ((EPSFile)object).read();
                if (n5 == -1 && n4 + 1 < n6) {
                    ((EPSFile)object).restart();
                }
                double d12 = d5 + (double)n5 * (d6 - d5) / ((double)(2 >> n3) - 1.0);
                jDRColorCMYKArray[n4].setYellow(d12);
            }
        } else {
            throw new InvalidEPSObjectException("image data source invalid", ePS.getLineNum());
        }
        if (ePSObject4 instanceof EPSString) {
            object = (EPSString)ePSObject4;
            n5 = 0;
            for (n4 = 0; n4 < n6; ++n4) {
                char c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length()) {
                    n5 = 0;
                }
                d9 = d7 + (double)c * (d8 - d7) / ((double)(2 >> n3) - 1.0);
                jDRColorCMYKArray[n4].setKey(d9);
            }
        } else if (ePSObject4 instanceof EPSProc) {
            ePSStack.execProc((EPSProc)ePSObject4);
            object = ePSStack.popEPSString();
            n5 = 0;
            for (n4 = 0; n4 < n6; ++n4) {
                char c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length() && n4 + 1 < n6) {
                    n5 = 0;
                    ePSStack.execProc((EPSProc)ePSObject4);
                    object = ePSStack.popEPSString();
                }
                d9 = d7 + (double)c * (d8 - d7) / ((double)(2 >> n3) - 1.0);
                jDRColorCMYKArray[n4].setKey(d9);
            }
        } else if (ePSObject4 instanceof EPSFilter || ePSObject4 instanceof EPSFile) {
            object = ePSObject4 instanceof EPSFilter ? ((EPSFilter)ePSObject4).getFile(ePSStack) : (EPSFile)ePSObject4;
            for (n4 = 0; n4 < n6; ++n4) {
                n5 = ((EPSFile)object).read();
                if (n5 == -1 && n4 + 1 < n6) {
                    ((EPSFile)object).restart();
                }
                double d13 = d7 + (double)n5 * (d8 - d7) / ((double)(2 >> n3) - 1.0);
                jDRColorCMYKArray[n4].setKey(d13);
            }
        } else {
            throw new InvalidEPSObjectException("image data source invalid", ePS.getLineNum());
        }
        object = new int[n6 * 4];
        n5 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            JDRColor jDRColor = jDRColorCMYKArray[n4].getJDRColor();
            object[n5++] = (int)Math.round(jDRColor.getRed() * 255.0);
            object[n5++] = (int)Math.round(jDRColor.getGreen() * 255.0);
            object[n5++] = (int)Math.round(jDRColor.getBlue() * 255.0);
            object[n5++] = 255;
        }
        writableRaster.setPixels(0, 0, n, n2, (int[])object);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    private BufferedImage getCMYKImage(int n, int n2, int n3, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, EPSObject ePSObject, EPSStack ePSStack, EPS ePS) throws InvalidFormatException, IOException, NoninvertibleTransformException {
        Object object;
        WritableRaster writableRaster = ColorModel.getRGBdefault().createCompatibleWritableRaster(n, n2);
        ePS.printlnMessage("extracting CMYK image");
        int n4 = n * n2 * 4;
        int[] nArray = new int[n4];
        if (ePSObject instanceof EPSString) {
            object = (EPSString)ePSObject;
            int n5 = 0;
            for (int i = 0; i < n4; i += 4) {
                char c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length()) {
                    n5 = 0;
                }
                double d9 = d + (double)c * (d2 - d) / ((double)(2 >> n3) - 1.0);
                c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length()) {
                    n5 = 0;
                }
                double d10 = d3 + (double)c * (d4 - d3) / ((double)(2 >> n3) - 1.0);
                c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length()) {
                    n5 = 0;
                }
                double d11 = d5 + (double)c * (d6 - d5) / ((double)(2 >> n3) - 1.0);
                c = ((EPSString)object).get(n5++);
                if (n5 == ((EPSString)object).length()) {
                    n5 = 0;
                }
                double d12 = d7 + (double)c * (d8 - d7) / ((double)(2 >> n3) - 1.0);
                JDRColorCMYK jDRColorCMYK = new JDRColorCMYK(d9, d10, d11, d12);
                JDRColor jDRColor = jDRColorCMYK.getJDRColor();
                nArray[i] = (int)Math.round(jDRColor.getRed() * 255.0);
                nArray[i + 1] = (int)Math.round(jDRColor.getGreen() * 255.0);
                nArray[i + 2] = (int)Math.round(jDRColor.getBlue() * 255.0);
                nArray[i + 3] = 255;
            }
        } else if (ePSObject instanceof EPSProc) {
            ePSStack.execProc((EPSProc)ePSObject);
            object = ePSStack.popEPSString();
            int n6 = 0;
            for (int i = 0; i < n4; i += 4) {
                char c = ((EPSString)object).get(n6++);
                if (n6 == ((EPSString)object).length() && i + 4 < n4) {
                    n6 = 0;
                    ePSStack.execProc((EPSProc)ePSObject);
                    object = ePSStack.popEPSString();
                }
                double d13 = d + (double)c * (d2 - d) / ((double)(2 >> n3) - 1.0);
                c = ((EPSString)object).get(n6++);
                if (n6 == ((EPSString)object).length() && i + 4 < n4) {
                    n6 = 0;
                    ePSStack.execProc((EPSProc)ePSObject);
                    object = ePSStack.popEPSString();
                }
                double d14 = d3 + (double)c * (d4 - d3) / ((double)(2 >> n3) - 1.0);
                c = ((EPSString)object).get(n6++);
                if (n6 == ((EPSString)object).length() && i + 4 < n4) {
                    n6 = 0;
                    ePSStack.execProc((EPSProc)ePSObject);
                    object = ePSStack.popEPSString();
                }
                double d15 = d5 + (double)c * (d6 - d5) / ((double)(2 >> n3) - 1.0);
                c = ((EPSString)object).get(n6++);
                if (n6 == ((EPSString)object).length() && i + 4 < n4) {
                    n6 = 0;
                    ePSStack.execProc((EPSProc)ePSObject);
                    object = ePSStack.popEPSString();
                }
                double d16 = d7 + (double)c * (d8 - d7) / ((double)(2 >> n3) - 1.0);
                JDRColorCMYK jDRColorCMYK = new JDRColorCMYK(d13, d14, d15, d16);
                JDRColor jDRColor = jDRColorCMYK.getJDRColor();
                nArray[i] = (int)Math.round(jDRColor.getRed() * 255.0);
                nArray[i + 1] = (int)Math.round(jDRColor.getGreen() * 255.0);
                nArray[i + 2] = (int)Math.round(jDRColor.getBlue() * 255.0);
                nArray[i + 3] = 255;
            }
        } else if (ePSObject instanceof EPSFilter || ePSObject instanceof EPSFile) {
            object = ePSObject instanceof EPSFilter ? ((EPSFilter)ePSObject).getFile(ePSStack) : (EPSFile)ePSObject;
            for (int i = 0; i < n4; i += 4) {
                int n7 = ((EPSFile)object).read();
                if (n7 == -1 && i + 4 < n4) {
                    ((EPSFile)object).restart();
                }
                double d17 = d + (double)n7 * (d2 - d) / ((double)(2 >> n3) - 1.0);
                n7 = ((EPSFile)object).read();
                if (n7 == -1 && i + 4 < n4) {
                    ((EPSFile)object).restart();
                }
                double d18 = d3 + (double)n7 * (d4 - d3) / ((double)(2 >> n3) - 1.0);
                n7 = ((EPSFile)object).read();
                if (n7 == -1 && i + 4 < n4) {
                    ((EPSFile)object).restart();
                }
                double d19 = d5 + (double)n7 * (d6 - d5) / ((double)(2 >> n3) - 1.0);
                n7 = ((EPSFile)object).read();
                if (n7 == -1 && i + 4 < n4) {
                    ((EPSFile)object).restart();
                }
                double d20 = d7 + (double)n7 * (d8 - d7) / ((double)(2 >> n3) - 1.0);
                JDRColorCMYK jDRColorCMYK = new JDRColorCMYK(d17, d18, d19, d20);
                JDRColor jDRColor = jDRColorCMYK.getJDRColor();
                nArray[i] = (int)Math.round(jDRColor.getRed() * 255.0);
                nArray[i + 1] = (int)Math.round(jDRColor.getGreen() * 255.0);
                nArray[i + 2] = (int)Math.round(jDRColor.getBlue() * 255.0);
                nArray[i + 3] = 255;
            }
        } else {
            throw new InvalidEPSObjectException("image data source invalid", ePS.getLineNum());
        }
        writableRaster.setPixels(0, 0, n, n2, nArray);
        object = new BufferedImage(n, n2, 2);
        ((BufferedImage)object).setData(writableRaster);
        return object;
    }

    protected static BufferedImage getGreyImage(int n, int n2, int n3, String string, EPS ePS) throws InvalidFormatException {
        WritableRaster writableRaster = ColorModel.getRGBdefault().createCompatibleWritableRaster(n, n2);
        ePS.printlnMessage("extracting gray image");
        int n4 = n * n2 * 4;
        int[] nArray = new int[n4];
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            int n7;
            int n8;
            if (n6 >= string.length()) {
                n6 = 0;
            }
            char c = string.charAt(n6);
            if (n3 == 1) {
                for (n8 = 7; n8 >= 0 && n5 < n4; --n8) {
                    n7 = ((c & 1 << n8) >> n8) * 255;
                    nArray[n5++] = n7;
                    nArray[n5++] = n7;
                    nArray[n5++] = n7;
                    nArray[n5++] = 255;
                }
            } else if (n3 == 2) {
                for (n8 = 6; n8 >= 0 && n5 < n4; n8 -= 2) {
                    n7 = (c >> n8 & 3) * 255 / 3;
                    nArray[n5++] = n7;
                    nArray[n5++] = n7;
                    nArray[n5++] = n7;
                    nArray[n5++] = 255;
                }
            } else if (n3 == 4) {
                for (n8 = 4; n8 >= 0 && n5 < n4; n8 -= 4) {
                    n7 = (c >> n8 & 0xF) * 255 / 15;
                    nArray[n5++] = n7;
                    nArray[n5++] = n7;
                    nArray[n5++] = n7;
                    nArray[n5++] = 255;
                }
            } else if (n3 == 8) {
                nArray[n5++] = c;
                nArray[n5++] = c;
                nArray[n5++] = c;
                nArray[n5++] = 255;
            } else {
                throw new InvalidFormatException("invalid nBits value " + n3);
            }
            ++n6;
        }
        writableRaster.setPixels(0, 0, n, n2, nArray);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }
}

