/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.io.eps.operators;

import java.awt.geom.NoninvertibleTransformException;
import java.io.IOException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSDouble;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSNumber;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSObject;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSOperator;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSStack;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSString;
import uk.ac.uea.cmp.nlct.jdr.io.eps.InvalidEPSObjectException;

public class EPSCvi
extends EPSOperator {
    public EPSCvi() {
        super("cvi");
    }

    @Override
    public void execute(EPSStack ePSStack, EPS ePS) throws InvalidFormatException, NoninvertibleTransformException, IOException {
        EPSObject ePSObject = ePSStack.popObject();
        if (ePSObject instanceof EPSNumber) {
            EPSNumber ePSNumber = (EPSNumber)ePSObject;
            if (ePSNumber instanceof EPSDouble) {
                ePSStack.pushInteger(ePSNumber.intValue());
            } else {
                ePSStack.add(ePSNumber);
            }
        } else if (ePSObject instanceof EPSString) {
            try {
                String[] stringArray = ((EPSString)ePSObject).value().split(" ", 2);
                String string = stringArray[0];
                stringArray = string.split("#", 2);
                if (stringArray.length == 1) {
                    ePSStack.pushInteger((int)Double.parseDouble(string));
                }
                ePSStack.pushInteger(Integer.parseInt(stringArray[1], Integer.parseInt(stringArray[0])));
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidEPSObjectException("(cvi) invalid string", ePS.getLineNum());
            }
        } else {
            throw new InvalidEPSObjectException("(cvi) invalid type", ePS.getLineNum());
        }
    }
}

