/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.io.eps.operators;

import java.awt.geom.NoninvertibleTransformException;
import java.io.IOException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRColor;
import uk.ac.uea.cmp.nlct.jdr.JDRColorCMYK;
import uk.ac.uea.cmp.nlct.jdr.JDRColorHSB;
import uk.ac.uea.cmp.nlct.jdr.JDRGray;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSOperator;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSStack;

public class EPSCurrentColor
extends EPSOperator {
    public EPSCurrentColor() {
        super("currentcolor");
    }

    @Override
    public void execute(EPSStack ePSStack, EPS ePS) throws InvalidFormatException, NoninvertibleTransformException, IOException {
        JDRPaint jDRPaint = ePS.getCurrentGraphicsState().getPaint();
        if (jDRPaint instanceof JDRColor) {
            JDRColor jDRColor = (JDRColor)jDRPaint;
            ePSStack.pushDouble(jDRColor.getRed());
            ePSStack.pushDouble(jDRColor.getGreen());
            ePSStack.pushDouble(jDRColor.getBlue());
        } else if (jDRPaint instanceof JDRColorCMYK) {
            JDRColorCMYK jDRColorCMYK = (JDRColorCMYK)jDRPaint;
            ePSStack.pushDouble(jDRColorCMYK.getCyan());
            ePSStack.pushDouble(jDRColorCMYK.getMagenta());
            ePSStack.pushDouble(jDRColorCMYK.getYellow());
            ePSStack.pushDouble(jDRColorCMYK.getKey());
        } else if (jDRPaint instanceof JDRColorHSB) {
            JDRColorHSB jDRColorHSB = (JDRColorHSB)jDRPaint;
            ePSStack.pushDouble(jDRColorHSB.getHue() / 360.0);
            ePSStack.pushDouble(jDRColorHSB.getSaturation());
            ePSStack.pushDouble(jDRColorHSB.getBrightness());
        } else if (jDRPaint instanceof JDRGray) {
            JDRGray jDRGray = (JDRGray)jDRPaint;
            ePSStack.pushDouble(jDRGray.getGray());
        }
    }
}

