/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.io.eps.operators;

import java.awt.geom.NoninvertibleTransformException;
import java.io.IOException;
import java.util.Vector;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSComposite;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSNumber;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSObject;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSOperator;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSStack;
import uk.ac.uea.cmp.nlct.jdr.io.eps.GraphicsState;

public class EPSCopy
extends EPSOperator {
    public EPSCopy() {
        super("copy");
    }

    @Override
    public void execute(EPSStack ePSStack, EPS ePS) throws InvalidFormatException, NoninvertibleTransformException, IOException {
        EPSObject ePSObject = (EPSObject)ePSStack.lastElement();
        if (ePSObject instanceof EPSNumber) {
            int n = ePSStack.popInteger();
            int n2 = ePSStack.size();
            if (n2 < n) {
                throw new InvalidFormatException("(copy) not enough elements in stack", ePS.getLineNum());
            }
            Vector<EPSObject> vector = new Vector<EPSObject>(n);
            for (int i = n - 1; i >= 0; --i) {
                vector.add((EPSObject)ePSStack.get(n2 - 1 - i));
            }
            ePSStack.pushObjects(vector);
        } else if (ePSObject instanceof GraphicsState) {
            GraphicsState graphicsState = ePSStack.popGraphicsState();
            GraphicsState graphicsState2 = ePSStack.popGraphicsState();
            graphicsState.copy(graphicsState2);
            ePSStack.add(graphicsState);
        } else {
            EPSComposite ePSComposite = ePSStack.popEPSComposite();
            EPSComposite ePSComposite2 = ePSStack.popEPSComposite();
            ePSComposite.copy(ePSComposite2);
            ePSStack.add(ePSComposite);
        }
    }
}

