/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.io.eps.operators;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRBitmap;
import uk.ac.uea.cmp.nlct.jdr.JDRColorCMYK;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSArray;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSOperator;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSProc;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSStack;
import uk.ac.uea.cmp.nlct.jdr.io.eps.GraphicsState;
import uk.ac.uea.cmp.nlct.jdr.io.eps.operators.EPSImage;

public class EPSColorImage
extends EPSOperator {
    public EPSColorImage() {
        super("colorimage");
    }

    @Override
    public void execute(EPSStack ePSStack, EPS ePS) throws InvalidFormatException, NoninvertibleTransformException, IOException {
        String[] stringArray;
        GraphicsState graphicsState = ePS.getCurrentGraphicsState();
        int n = ePSStack.popInteger();
        boolean bl = ePSStack.popBoolean().booleanValue();
        if (bl) {
            stringArray = new String[n];
            for (int i = n - 1; i >= 0; --i) {
                EPSProc ePSProc = ePSStack.popEPSProc();
                ePSStack.execProc(ePSProc);
                stringArray[i] = ePSStack.popString();
            }
        } else {
            stringArray = new String[1];
            EPSProc ePSProc = ePSStack.popEPSProc();
            ePSStack.execProc(ePSProc);
            stringArray[0] = ePSStack.popString();
        }
        EPSArray ePSArray = ePSStack.popEPSMatrix();
        int n2 = ePSStack.popInteger();
        int n3 = ePSStack.popInteger();
        int n4 = ePSStack.popInteger();
        BufferedImage bufferedImage = bl ? this.getColourImage(n4, n3, n2, stringArray, ePS) : this.getColourImage(n4, n3, n2, stringArray[0], n, ePS);
        String string = ePS.getNextBitmapName("png");
        ePS.printlnMessage("Saving '" + string + "'");
        File file = new File(string);
        ImageIO.write((RenderedImage)bufferedImage, "png", file);
        JDRBitmap jDRBitmap = new JDRBitmap(file.getCanonicalPath());
        AffineTransform affineTransform = ePSArray.getTransform().createInverse();
        AffineTransform affineTransform2 = graphicsState.getTransform();
        affineTransform.preConcatenate(affineTransform2);
        jDRBitmap.setTransformation(affineTransform);
        ePS.addJDRObject(jDRBitmap);
    }

    private BufferedImage getColourRGBImage(int n, int n2, int n3, String string, EPS ePS) throws InvalidFormatException {
        int n4;
        WritableRaster writableRaster = ColorModel.getRGBdefault().createCompatibleWritableRaster(n, n2);
        ePS.printlnMessage("extracting RGB image");
        int n5 = n * n2 * 4;
        int[] nArray = new int[n5];
        int n6 = 0;
        if (n3 == 1) {
            n4 = 0;
            int n7 = 0;
            while (n4 < n5) {
                if (n7 >= string.length()) {
                    n7 = 0;
                }
                char c = string.charAt(n7++);
                for (int i = 7; i >= 0 && n4 < n5; --i) {
                    nArray[n4++] = ((c & 1 << i) >> i) * 255;
                    if (++n6 != 3) continue;
                    nArray[n4++] = 255;
                    n6 = 0;
                }
            }
        } else if (n3 == 2) {
            n4 = 0;
            int n8 = 0;
            while (n4 < n5) {
                if (n8 >= string.length()) {
                    n8 = 0;
                }
                char c = string.charAt(n8++);
                for (int i = 6; i >= 0 && n4 < n5; i -= 2) {
                    nArray[n4++] = (c >> i & 3) * 255 / 3;
                    if (++n6 != 3) continue;
                    nArray[n4++] = 255;
                    n6 = 0;
                }
            }
        } else if (n3 == 4) {
            n4 = 0;
            int n9 = 0;
            while (n4 < n5) {
                if (n9 >= string.length()) {
                    n9 = 0;
                }
                char c = string.charAt(n9++);
                for (int i = 4; i >= 0 && n4 < n5; i -= 4) {
                    nArray[n4++] = (c >> i & 0xF) * 255 / 15;
                    if (++n6 != 3) continue;
                    nArray[n4++] = 255;
                    n6 = 0;
                }
            }
        } else if (n3 == 8) {
            n4 = 0;
            int n10 = 0;
            while (n4 < n5) {
                if (n10 >= string.length()) {
                    n10 = 0;
                }
                char c = string.charAt(n10++);
                if (n10 >= string.length()) {
                    n10 = 0;
                }
                char c2 = string.charAt(n10++);
                if (n10 >= string.length()) {
                    n10 = 0;
                }
                char c3 = string.charAt(n10++);
                nArray[n4++] = c;
                nArray[n4++] = c2;
                nArray[n4++] = c3;
                nArray[n4++] = 255;
            }
        } else {
            throw new InvalidFormatException("invalid nBits value " + n3);
        }
        writableRaster.setPixels(0, 0, n, n2, nArray);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    private BufferedImage getColourRGBImage(int n, int n2, int n3, String string, String string2, String string3, EPS ePS) throws InvalidFormatException {
        int n4;
        WritableRaster writableRaster = ColorModel.getRGBdefault().createCompatibleWritableRaster(n, n2);
        ePS.printlnMessage("extracting RGB image");
        int n5 = n * n2 * 4;
        int[] nArray = new int[n5];
        if (n3 == 1) {
            n4 = 0;
            int n6 = 0;
            while (n4 < n5) {
                if (n6 >= string.length()) {
                    n6 = 0;
                }
                char c = string.charAt(n6);
                char c2 = string2.charAt(n6);
                char c3 = string3.charAt(n6);
                ++n6;
                for (int i = 7; i >= 0 && n4 < n5; --i) {
                    nArray[n4++] = ((c & 1 << i) >> i) * 255;
                    nArray[n4++] = ((c2 & 1 << i) >> i) * 255;
                    nArray[n4++] = ((c3 & 1 << i) >> i) * 255;
                    nArray[n4++] = 255;
                }
            }
        } else if (n3 == 2) {
            n4 = 0;
            int n7 = 0;
            while (n4 < n5) {
                if (n7 >= string.length()) {
                    n7 = 0;
                }
                char c = string.charAt(n7);
                char c4 = string2.charAt(n7);
                char c5 = string3.charAt(n7);
                ++n7;
                for (int i = 6; i >= 0 && n4 < n5; i -= 2) {
                    nArray[n4++] = (c >> i & 3) * 255 / 3;
                    nArray[n4++] = (c4 >> i & 3) * 255 / 3;
                    nArray[n4++] = (c5 >> i & 3) * 255 / 3;
                    nArray[n4++] = 255;
                }
            }
        } else if (n3 == 4) {
            n4 = 0;
            int n8 = 0;
            while (n4 < n5) {
                if (n8 >= string.length()) {
                    n8 = 0;
                }
                char c = string.charAt(n8);
                char c6 = string2.charAt(n8);
                char c7 = string3.charAt(n8);
                ++n8;
                for (int i = 4; i >= 0 && n4 < n5; i -= 4) {
                    nArray[n4++] = (c >> i & 0xF) * 255 / 15;
                    nArray[n4++] = (c6 >> i & 0xF) * 255 / 15;
                    nArray[n4++] = (c7 >> i & 0xF) * 255 / 15;
                    nArray[n4++] = 255;
                }
            }
        } else if (n3 == 8) {
            n4 = 0;
            int n9 = 0;
            while (n4 < n5) {
                if (n9 >= string.length()) {
                    n9 = 0;
                }
                char c = string.charAt(n9);
                char c8 = string2.charAt(n9);
                char c9 = string3.charAt(n9);
                ++n9;
                nArray[n4++] = c;
                nArray[n4++] = c8;
                nArray[n4++] = c9;
                nArray[n4++] = 255;
            }
        } else {
            throw new InvalidFormatException("invalid nBits value " + n3, ePS.getLineNum());
        }
        writableRaster.setPixels(0, 0, n, n2, nArray);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    private BufferedImage getColourCMYKImage(int n, int n2, int n3, String string, EPS ePS) throws InvalidFormatException {
        int n4;
        WritableRaster writableRaster = ColorModel.getRGBdefault().createCompatibleWritableRaster(n, n2);
        ePS.printlnMessage("extracting CMYK image");
        int n5 = n * n2 * 4;
        int[] nArray = new int[n5];
        int n6 = 0;
        double[] dArray = new double[4];
        if (n3 == 1) {
            n4 = 0;
            int n7 = 0;
            while (n4 < n5) {
                if (n7 >= string.length()) {
                    n7 = 0;
                }
                char c = string.charAt(n7++);
                for (int i = 7; i >= 0 && n4 < n5; --i) {
                    dArray[n6++] = (c & 1 << i) >> i;
                    if (n6 != 4) continue;
                    JDRColorCMYK jDRColorCMYK = new JDRColorCMYK(dArray[0], dArray[1], dArray[2], dArray[3]);
                    Color color = jDRColorCMYK.getColor();
                    nArray[n4++] = color.getRed();
                    nArray[n4++] = color.getGreen();
                    nArray[n4++] = color.getBlue();
                    nArray[n4++] = 255;
                    n6 = 0;
                }
            }
        } else if (n3 == 2) {
            n4 = 0;
            int n8 = 0;
            while (n4 < n5) {
                if (n8 >= string.length()) {
                    n8 = 0;
                }
                char c = string.charAt(n8++);
                for (int i = 6; i >= 0 && n4 < n5; i -= 2) {
                    dArray[n6++] = (double)(c >> i & 3) / 3.0;
                    if (n6 != 4) continue;
                    JDRColorCMYK jDRColorCMYK = new JDRColorCMYK(dArray[0], dArray[1], dArray[2], dArray[3]);
                    Color color = jDRColorCMYK.getColor();
                    nArray[n4++] = color.getRed();
                    nArray[n4++] = color.getGreen();
                    nArray[n4++] = color.getBlue();
                    nArray[n4++] = 255;
                    n6 = 0;
                }
            }
        } else if (n3 == 4) {
            n4 = 0;
            int n9 = 0;
            while (n4 < n5) {
                if (n9 >= string.length()) {
                    n9 = 0;
                }
                char c = string.charAt(n9++);
                for (int i = 4; i >= 0 && n4 < n5; i -= 4) {
                    dArray[n6++] = (double)(c >> i & 0xF) / 15.0;
                    if (n6 != 4) continue;
                    JDRColorCMYK jDRColorCMYK = new JDRColorCMYK(dArray[0], dArray[1], dArray[2], dArray[3]);
                    Color color = jDRColorCMYK.getColor();
                    nArray[n4++] = color.getRed();
                    nArray[n4++] = color.getGreen();
                    nArray[n4++] = color.getBlue();
                    nArray[n4++] = 255;
                    n6 = 0;
                }
            }
        } else if (n3 == 8) {
            n4 = 0;
            int n10 = 0;
            while (n4 < n5) {
                if (n10 >= string.length()) {
                    n10 = 0;
                }
                double d = (double)string.charAt(n10++) / 255.0;
                if (n10 >= string.length()) {
                    n10 = 0;
                }
                double d2 = (double)string.charAt(n10++) / 255.0;
                if (n10 >= string.length()) {
                    n10 = 0;
                }
                double d3 = (double)string.charAt(n10++) / 255.0;
                if (n10 >= string.length()) {
                    n10 = 0;
                }
                double d4 = (double)string.charAt(n10++) / 255.0;
                JDRColorCMYK jDRColorCMYK = new JDRColorCMYK(d, d2, d3, d4);
                Color color = jDRColorCMYK.getColor();
                int n11 = color.getRed();
                int n12 = color.getGreen();
                int n13 = color.getBlue();
                nArray[n4++] = n11;
                nArray[n4++] = n12;
                nArray[n4++] = n13;
                nArray[n4++] = 255;
            }
        } else {
            throw new InvalidFormatException("invalid nBits value " + n3, ePS.getLineNum());
        }
        writableRaster.setPixels(0, 0, n, n2, nArray);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    private BufferedImage getColourCMYKImage(int n, int n2, int n3, String string, String string2, String string3, String string4, EPS ePS) throws InvalidFormatException {
        int n4;
        WritableRaster writableRaster = ColorModel.getRGBdefault().createCompatibleWritableRaster(n, n2);
        ePS.printlnMessage("extracting CMYK image");
        int n5 = n * n2 * 4;
        int[] nArray = new int[n5];
        if (n3 == 1) {
            n4 = 0;
            int n6 = 0;
            while (n4 < n5) {
                if (n6 >= string.length()) {
                    n6 = 0;
                }
                char c = string.charAt(n6);
                char c2 = string2.charAt(n6);
                char c3 = string3.charAt(n6);
                char c4 = string4.charAt(n6);
                ++n6;
                for (int i = 7; i >= 0 && n4 < n5; --i) {
                    double d = (c & 1 << i) >> i;
                    double d2 = (c2 & 1 << i) >> i;
                    double d3 = (c3 & 1 << i) >> i;
                    double d4 = (c4 & 1 << i) >> i;
                    JDRColorCMYK jDRColorCMYK = new JDRColorCMYK(d, d2, d3, d4);
                    Color color = jDRColorCMYK.getColor();
                    nArray[n4++] = color.getRed();
                    nArray[n4++] = color.getGreen();
                    nArray[n4++] = color.getBlue();
                    nArray[n4++] = 255;
                }
            }
        } else if (n3 == 2) {
            n4 = 0;
            int n7 = 0;
            while (n4 < n5) {
                if (n7 >= string.length()) {
                    n7 = 0;
                }
                char c = string.charAt(n7);
                char c5 = string2.charAt(n7);
                char c6 = string3.charAt(n7);
                char c7 = string4.charAt(n7);
                ++n7;
                for (int i = 6; i >= 0 && n4 < n5; i -= 2) {
                    double d = (double)(c >> i & 3) / 3.0;
                    double d5 = (double)(c5 >> i & 3) / 3.0;
                    double d6 = (double)(c6 >> i & 3) / 3.0;
                    double d7 = (double)(c7 >> i & 3) / 3.0;
                    JDRColorCMYK jDRColorCMYK = new JDRColorCMYK(d, d5, d6, d7);
                    Color color = jDRColorCMYK.getColor();
                    nArray[n4++] = color.getRed();
                    nArray[n4++] = color.getGreen();
                    nArray[n4++] = color.getBlue();
                    nArray[n4++] = 255;
                }
            }
        } else if (n3 == 4) {
            n4 = 0;
            int n8 = 0;
            while (n4 < n5) {
                if (n8 >= string.length()) {
                    n8 = 0;
                }
                char c = string.charAt(n8);
                char c8 = string2.charAt(n8);
                char c9 = string3.charAt(n8);
                char c10 = string4.charAt(n8);
                ++n8;
                for (int i = 4; i >= 0 && n4 < n5; i -= 4) {
                    double d = (double)(c >> i & 0xF) / 15.0;
                    double d8 = (double)(c8 >> i & 0xF) / 15.0;
                    double d9 = (double)(c9 >> i & 0xF) / 15.0;
                    double d10 = (double)(c10 >> i & 0xF) / 15.0;
                    JDRColorCMYK jDRColorCMYK = new JDRColorCMYK(d, d8, d9, d10);
                    Color color = jDRColorCMYK.getColor();
                    nArray[n4++] = color.getRed();
                    nArray[n4++] = color.getGreen();
                    nArray[n4++] = color.getBlue();
                    nArray[n4++] = 255;
                }
            }
        } else if (n3 == 8) {
            n4 = 0;
            int n9 = 0;
            while (n4 < n5) {
                if (n9 >= string.length()) {
                    n9 = 0;
                }
                char c = string.charAt(n9);
                char c11 = string2.charAt(n9);
                char c12 = string3.charAt(n9);
                char c13 = string4.charAt(n9);
                ++n9;
                double d = (double)c / 255.0;
                double d11 = (double)c11 / 255.0;
                double d12 = (double)c12 / 255.0;
                double d13 = (double)c13 / 255.0;
                JDRColorCMYK jDRColorCMYK = new JDRColorCMYK(d, d11, d12, d13);
                Color color = jDRColorCMYK.getColor();
                int n10 = color.getRed();
                int n11 = color.getGreen();
                int n12 = color.getBlue();
                nArray[n4++] = n10;
                nArray[n4++] = n11;
                nArray[n4++] = n12;
                nArray[n4++] = 255;
            }
        } else {
            throw new InvalidFormatException("invalid nBits value " + n3, ePS.getLineNum());
        }
        writableRaster.setPixels(0, 0, n, n2, nArray);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    private BufferedImage getColourImage(int n, int n2, int n3, String string, int n4, EPS ePS) throws InvalidFormatException {
        if (n4 == 1) {
            return EPSImage.getGreyImage(n, n2, n3, string, ePS);
        }
        if (n4 == 3) {
            return this.getColourRGBImage(n, n2, n3, string, ePS);
        }
        if (n4 == 4) {
            return this.getColourCMYKImage(n, n2, n3, string, ePS);
        }
        throw new InvalidFormatException("(colorimage) invalid nComp value " + n4, ePS.getLineNum());
    }

    private BufferedImage getColourImage(int n, int n2, int n3, String[] stringArray, EPS ePS) throws InvalidFormatException {
        int n4 = stringArray.length;
        if (n4 == 1) {
            return EPSImage.getGreyImage(n, n2, n3, stringArray[0], ePS);
        }
        if (n4 == 3) {
            return this.getColourRGBImage(n, n2, n3, stringArray[0], stringArray[1], stringArray[2], ePS);
        }
        if (n4 == 4) {
            return this.getColourCMYKImage(n, n2, n3, stringArray[0], stringArray[1], stringArray[2], stringArray[3], ePS);
        }
        throw new InvalidFormatException("(colorimage) invalid nComp value " + n4, ePS.getLineNum());
    }
}

