/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.io.eps;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.DashPattern;
import uk.ac.uea.cmp.nlct.jdr.EmptyPathException;
import uk.ac.uea.cmp.nlct.jdr.IllFittingPathException;
import uk.ac.uea.cmp.nlct.jdr.InvalidCapStyleException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidJoinStyleException;
import uk.ac.uea.cmp.nlct.jdr.InvalidMitreLimitException;
import uk.ac.uea.cmp.nlct.jdr.InvalidPaintException;
import uk.ac.uea.cmp.nlct.jdr.InvalidPathException;
import uk.ac.uea.cmp.nlct.jdr.InvalidPenWidthException;
import uk.ac.uea.cmp.nlct.jdr.InvalidWindingRuleException;
import uk.ac.uea.cmp.nlct.jdr.JDRBasicStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRColor;
import uk.ac.uea.cmp.nlct.jdr.JDRColorCMYK;
import uk.ac.uea.cmp.nlct.jdr.JDRGradient;
import uk.ac.uea.cmp.nlct.jdr.JDRGray;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPath;
import uk.ac.uea.cmp.nlct.jdr.JDRRadial;
import uk.ac.uea.cmp.nlct.jdr.JDRStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRText;
import uk.ac.uea.cmp.nlct.jdr.JDRTransparent;
import uk.ac.uea.cmp.nlct.jdr.MissingMoveException;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSDict;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSFile;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSFont;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSName;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSObject;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSProc;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSStack;
import uk.ac.uea.cmp.nlct.jdr.io.eps.NoCurrentPointException;

public class GraphicsState
implements EPSObject {
    private AffineTransform af;
    private double lineWidth = 1.0;
    private double mitreLimit;
    private int cap;
    private int join;
    private float[] dashPattern;
    private float dashOffset;
    private JDRPaint paint;
    private GeneralPath path;
    private GeneralPath clippingPath;
    private EPSFont font;
    private EPSProc[] transfer;
    public static final int JOIN_MITRE = 0;
    public static final int JOIN_ROUND = 1;
    public static final int JOIN_BEVEL = 2;
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 2;
    private boolean flatten_ = false;
    private double flatness = 1.0;
    private EPS eps_;

    public GraphicsState(EPS ePS) {
        this.af = new AffineTransform();
        this.lineWidth = 1.0;
        this.dashPattern = null;
        this.dashOffset = 0.0f;
        this.cap = 0;
        this.join = 0;
        this.mitreLimit = 10.0;
        this.paint = new JDRColor(Color.black);
        this.path = new GeneralPath();
        this.clippingPath = null;
        this.font = new EPSFont("Times-Roman", ePS.getLaTeXFontBase());
        this.flatten_ = false;
        this.flatness = 1.0;
        this.eps_ = ePS;
        this.transfer = new EPSProc[4];
        for (int i = 0; i < 4; ++i) {
            this.transfer[i] = null;
        }
    }

    private GraphicsState() {
        this.af = new AffineTransform();
        this.lineWidth = 1.0;
        this.dashPattern = null;
        this.dashOffset = 0.0f;
        this.cap = 0;
        this.join = 0;
        this.mitreLimit = 10.0;
        this.paint = new JDRColor(Color.black);
        this.path = new GeneralPath();
        this.clippingPath = null;
        this.flatten_ = false;
        this.flatness = 1.0;
        this.transfer = new EPSProc[4];
        for (int i = 0; i < 4; ++i) {
            this.transfer[i] = null;
        }
    }

    public GraphicsState(EPS ePS, double[] dArray) {
        this.eps_ = ePS;
        this.af = new AffineTransform(dArray);
        this.lineWidth = 1.0;
        this.dashPattern = null;
        this.dashOffset = 0.0f;
        this.cap = 0;
        this.join = 0;
        this.mitreLimit = 10.0;
        this.paint = new JDRColor(Color.black);
        this.path = new GeneralPath();
        this.clippingPath = null;
        this.font = new EPSFont("Times-Roman", ePS.getLaTeXFontBase());
        this.flatten_ = false;
        this.flatness = 1.0;
        this.transfer = new EPSProc[4];
        for (int i = 0; i < 4; ++i) {
            this.transfer[i] = null;
        }
    }

    @Override
    public Object clone() {
        int n;
        GraphicsState graphicsState = new GraphicsState();
        graphicsState.af = (AffineTransform)this.af.clone();
        graphicsState.lineWidth = this.lineWidth;
        graphicsState.cap = this.cap;
        graphicsState.join = this.join;
        if (this.dashPattern != null) {
            n = this.dashPattern.length;
            graphicsState.dashPattern = new float[n];
            for (int i = 0; i < n; ++i) {
                graphicsState.dashPattern[i] = this.dashPattern[i];
            }
        }
        graphicsState.dashOffset = this.dashOffset;
        graphicsState.paint = (JDRPaint)this.paint.clone();
        graphicsState.mitreLimit = this.mitreLimit;
        graphicsState.path = (GeneralPath)this.path.clone();
        graphicsState.clippingPath = this.clippingPath == null ? null : (GeneralPath)this.clippingPath.clone();
        graphicsState.font = (EPSFont)this.font.clone();
        graphicsState.flatten_ = this.flatten_;
        graphicsState.flatness = this.flatness;
        graphicsState.eps_ = this.eps_;
        graphicsState.transfer = new EPSProc[4];
        for (n = 0; n < 4; ++n) {
            graphicsState.transfer[n] = this.transfer[n];
        }
        return graphicsState;
    }

    public void copy(GraphicsState graphicsState) {
        this.af = graphicsState.af;
        this.lineWidth = graphicsState.lineWidth;
        this.cap = graphicsState.cap;
        this.join = graphicsState.join;
        this.dashPattern = graphicsState.dashPattern;
        this.dashOffset = graphicsState.dashOffset;
        this.paint = graphicsState.paint;
        this.mitreLimit = graphicsState.mitreLimit;
        this.path = graphicsState.path;
        this.clippingPath = graphicsState.clippingPath;
        this.font = graphicsState.font;
        this.flatten_ = graphicsState.flatten_;
        this.flatness = graphicsState.flatness;
        this.transfer = graphicsState.transfer;
        this.eps_ = graphicsState.eps_;
    }

    public void reversePath() throws MissingMoveException, EmptyPathException, IllFittingPathException {
        JDRPath jDRPath = (JDRPath)JDRPath.getPath(this.path.getPathIterator(null)).reverse();
        this.path = jDRPath.getGeneralPath();
    }

    public void strokePath() throws MissingMoveException, EmptyPathException, IllFittingPathException {
        JDRPath jDRPath = JDRPath.getPath(this.path.getPathIterator(null));
        this.path = new GeneralPath(jDRPath.getStrokedArea());
    }

    public EPSFont getCurrentFont() {
        return this.font;
    }

    public void setCurrentFont(EPSFont ePSFont) {
        this.font = ePSFont;
    }

    public JDRText getJDRText(String string) throws NoCurrentPointException, NoninvertibleTransformException, InvalidFormatException, IOException {
        Point2D point2D = this.getCurrentPoint();
        if (point2D == null) {
            throw new NoCurrentPointException();
        }
        Point2D.Double double_ = new Point2D.Double();
        this.itransform(point2D, double_);
        Point2D.Double double_2 = new Point2D.Double();
        BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        JDRText jDRText = this.font.getJDRText(graphics2D, string, this.af, double_, double_2);
        graphics2D.dispose();
        this.path.moveTo((float)(point2D.getX() + ((Point2D)double_2).getX()), (float)(point2D.getY() + ((Point2D)double_2).getY()));
        jDRText.setTextPaint(this.getPaint());
        return jDRText;
    }

    public Point2D getTextWidth(String string) throws NoninvertibleTransformException {
        Point2D point2D = this.getCurrentPoint();
        if (point2D == null) {
            point2D = new Point2D.Double(0.0, 0.0);
        }
        Point2D.Double double_ = new Point2D.Double();
        BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        JDRText jDRText = this.font.getJDRText(graphics2D, string, this.af, point2D, double_);
        graphics2D.dispose();
        this.idtransform(double_, double_);
        return double_;
    }

    public void charPath(String string, boolean bl) throws NoninvertibleTransformException, NoCurrentPointException {
        Point2D point2D = this.getCurrentPoint();
        if (point2D == null) {
            throw new NoCurrentPointException();
        }
        Point2D.Double double_ = new Point2D.Double();
        this.itransform(point2D, double_);
        Point2D.Double double_2 = new Point2D.Double();
        BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        JDRText jDRText = this.font.getJDRText(graphics2D, string, this.af, double_, double_2);
        Shape shape = jDRText.getOutline(graphics2D.getFontRenderContext());
        graphics2D.dispose();
        this.appendPath(new GeneralPath(shape));
    }

    public void setLineWidth(double d) {
        this.lineWidth = d;
    }

    public void flatten() {
        this.flatten_ = true;
    }

    public void setFlatness(double d) {
        this.flatness = d;
    }

    public double getFlatness() {
        return this.flatness;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setCap(int n) throws InvalidCapStyleException {
        if (n < 0 || n > 3) {
            throw new InvalidCapStyleException(n);
        }
        this.cap = n;
    }

    public int getCap() {
        return this.cap;
    }

    public void setJoin(int n) throws InvalidJoinStyleException {
        if (n < 0 || n > 3) {
            throw new InvalidJoinStyleException(n);
        }
        this.join = n;
    }

    public int getJoin() {
        return this.join;
    }

    public void setPaint(JDRPaint jDRPaint) {
        this.paint = jDRPaint;
    }

    public void setTransfer(EPSProc ePSProc) {
        for (int i = 0; i < 4; ++i) {
            this.transfer[i] = ePSProc;
        }
    }

    public void setColorTransfer(EPSProc ePSProc, EPSProc ePSProc2, EPSProc ePSProc3, EPSProc ePSProc4) {
        this.transfer[0] = ePSProc;
        this.transfer[1] = ePSProc2;
        this.transfer[2] = ePSProc3;
        this.transfer[3] = ePSProc4;
    }

    public EPSProc[] getColorTransfer() {
        return this.transfer;
    }

    public EPSProc getTransfer() {
        return this.transfer[3];
    }

    public JDRPaint getPaint() throws InvalidFormatException, NoninvertibleTransformException, IOException {
        EPSStack ePSStack = this.eps_.getStack();
        if (this.paint instanceof JDRGray) {
            if (this.transfer[3] == null) {
                return this.paint;
            }
            double d = ((JDRGray)this.paint).getGray();
            ePSStack.pushDouble(d);
            ePSStack.execProc(this.transfer[3]);
            d = ePSStack.popDouble();
            return new JDRGray(d);
        }
        if (this.paint instanceof JDRColor) {
            JDRColor jDRColor = (JDRColor)this.paint;
            if (this.transfer[0] == null && this.transfer[1] == null && this.transfer[2] == null) {
                return this.paint;
            }
            double d = jDRColor.getRed();
            double d2 = jDRColor.getGreen();
            double d3 = jDRColor.getBlue();
            if (this.transfer[0] != null) {
                ePSStack.pushDouble(d);
                ePSStack.execObject(this.transfer[0]);
                d = ePSStack.popDouble();
            }
            if (this.transfer[1] != null) {
                ePSStack.pushDouble(d2);
                ePSStack.execObject(this.transfer[1]);
                d2 = ePSStack.popDouble();
            }
            if (this.transfer[2] != null) {
                ePSStack.pushDouble(d3);
                ePSStack.execObject(this.transfer[2]);
                d3 = ePSStack.popDouble();
            }
            return new JDRColor(d, d2, d3);
        }
        if (this.paint instanceof JDRColorCMYK) {
            JDRColorCMYK jDRColorCMYK = (JDRColorCMYK)this.paint;
            double d = jDRColorCMYK.getCyan();
            double d4 = jDRColorCMYK.getYellow();
            double d5 = jDRColorCMYK.getMagenta();
            double d6 = jDRColorCMYK.getKey();
            if (this.transfer[0] != null) {
                ePSStack.pushDouble(d);
                ePSStack.execObject(this.transfer[0]);
                d = ePSStack.popDouble();
            }
            if (this.transfer[1] != null) {
                ePSStack.pushDouble(d4);
                ePSStack.execObject(this.transfer[1]);
                d4 = ePSStack.popDouble();
            }
            if (this.transfer[2] != null) {
                ePSStack.pushDouble(d5);
                ePSStack.execObject(this.transfer[2]);
                d5 = ePSStack.popDouble();
            }
            if (this.transfer[3] != null) {
                ePSStack.pushDouble(d6);
                ePSStack.execObject(this.transfer[2]);
                d6 = ePSStack.popDouble();
            }
            return new JDRColorCMYK(d, d4, d5, d6);
        }
        return this.paint;
    }

    public void setMitreLimit(double d) throws InvalidMitreLimitException {
        if (d < 1.0) {
            throw new InvalidMitreLimitException(d);
        }
        this.mitreLimit = d;
    }

    public double getMitreLimit() {
        return this.mitreLimit;
    }

    public void setDashPattern(double[] dArray, double d) {
        if (dArray == null || dArray.length == 0) {
            this.dashPattern = null;
        } else {
            double d2 = 0.0;
            this.dashPattern = new float[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                this.dashPattern[i] = (float)dArray[i];
                d2 += dArray[i] * dArray[i];
            }
            if (d2 == 0.0) {
                this.dashPattern = null;
            }
        }
        this.dashOffset = (float)d;
    }

    public DashPattern getDashPattern() {
        return new DashPattern(this.dashPattern, this.dashOffset);
    }

    public JDRStroke getStroke() {
        try {
            return this.getStroke(1);
        }
        catch (InvalidWindingRuleException invalidWindingRuleException) {
            return null;
        }
    }

    public JDRStroke getStroke(int n) throws InvalidWindingRuleException {
        int n2 = 0;
        switch (this.cap) {
            case 0: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 1;
            }
        }
        int n3 = 0;
        switch (this.join) {
            case 2: {
                n3 = 2;
                break;
            }
            case 0: {
                n3 = 0;
                break;
            }
            case 1: {
                n3 = 1;
            }
        }
        double d = (Math.abs(this.af.getScaleX()) + Math.abs(this.af.getScaleY())) * 0.5;
        try {
            return new JDRBasicStroke(Math.max(1.0, Math.abs(this.lineWidth * d)), n2, n3, this.mitreLimit, this.getDashPattern(), n);
        }
        catch (InvalidCapStyleException invalidCapStyleException) {
        }
        catch (InvalidJoinStyleException invalidJoinStyleException) {
        }
        catch (InvalidMitreLimitException invalidMitreLimitException) {
        }
        catch (InvalidPenWidthException invalidPenWidthException) {
            // empty catch block
        }
        return null;
    }

    public void setTransform(double[] dArray) {
        this.af.setTransform(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
    }

    public AffineTransform getTransform() {
        return this.af;
    }

    public void translate(double d, double d2) {
        this.af.translate(d, d2);
    }

    public void scale(double d, double d2) {
        this.af.scale(d, d2);
    }

    public void rotate(double d) {
        this.af.rotate(d);
    }

    public void concat(double[] dArray) {
        AffineTransform affineTransform = new AffineTransform(dArray);
        this.af.concatenate(affineTransform);
    }

    public void transform(Point2D point2D, Point2D point2D2) {
        this.af.transform(point2D, point2D2);
    }

    public void dtransform(Point2D point2D, Point2D point2D2) {
        this.af.deltaTransform(point2D, point2D2);
    }

    public void itransform(Point2D point2D, Point2D point2D2) throws NoninvertibleTransformException {
        this.af.inverseTransform(point2D, point2D2);
    }

    public void idtransform(Point2D point2D, Point2D point2D2) throws NoninvertibleTransformException {
        this.af.createInverse().deltaTransform(point2D, point2D2);
    }

    public void appendPath(GeneralPath generalPath) {
        PathIterator pathIterator = generalPath.getPathIterator(null);
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    this.path.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    this.path.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 3: {
                    this.path.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 2: {
                    Point2D point2D = this.getCurrentPoint();
                    Point2D.Double double_ = new Point2D.Double(fArray[0], fArray[1]);
                    Point2D.Double double_2 = new Point2D.Double(fArray[2], fArray[3]);
                    double d = (2.0 * ((Point2D)double_).getX() + point2D.getX()) / 3.0;
                    double d2 = (2.0 * ((Point2D)double_).getY() + point2D.getY()) / 3.0;
                    double d3 = (((Point2D)double_2).getX() + 2.0 * ((Point2D)double_).getX()) / 3.0;
                    double d4 = (((Point2D)double_2).getY() + 2.0 * ((Point2D)double_).getY()) / 3.0;
                    this.path.curveTo((float)d, (float)d2, (float)d3, (float)d4, (float)((Point2D)double_2).getX(), (float)((Point2D)double_2).getY());
                    break;
                }
                case 4: {
                    this.path.closePath();
                }
            }
            pathIterator.next();
        }
    }

    public void setGeneralPath(GeneralPath generalPath) {
        this.path = generalPath;
    }

    public GeneralPath getGeneralPath() {
        return this.path;
    }

    public JDRPath rectFill(double d, double d2, double d3, double d4) throws InvalidFormatException, IOException, NoninvertibleTransformException {
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        JDRPath jDRPath = null;
        jDRPath = JDRPath.getPath(double_.getPathIterator(this.af, this.flatness));
        JDRPaint jDRPaint = this.getPaint();
        JDRTransparent jDRTransparent = new JDRTransparent();
        jDRPath.setLinePaint(jDRTransparent);
        jDRPath.setFillPaint(jDRPaint);
        return jDRPath;
    }

    public JDRPath rectStroke(double d, double d2, double d3, double d4) throws InvalidFormatException, IOException, NoninvertibleTransformException {
        JDRPath jDRPath = null;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        jDRPath = JDRPath.getPath(double_.getPathIterator(this.af, this.flatness));
        JDRPaint jDRPaint = this.getPaint();
        JDRTransparent jDRTransparent = new JDRTransparent();
        jDRPath.setLinePaint(jDRPaint);
        jDRPath.setFillPaint(jDRTransparent);
        return jDRPath;
    }

    public void newPath() {
        this.path = new GeneralPath();
    }

    public Point2D getCurrentPoint() {
        return this.path.getCurrentPoint();
    }

    public void moveTo(double d, double d2) {
        Point2D.Double double_ = new Point2D.Double(d, d2);
        this.af.transform(double_, double_);
        this.path.moveTo((float)double_.getX(), (float)double_.getY());
    }

    public void rmoveTo(double d, double d2) throws NoCurrentPointException {
        Point2D point2D = this.getCurrentPoint();
        if (point2D == null) {
            throw new NoCurrentPointException();
        }
        double d3 = point2D.getX();
        double d4 = point2D.getY();
        Point2D.Double double_ = new Point2D.Double(d, d2);
        this.af.deltaTransform(double_, double_);
        this.path.moveTo((float)(d3 + double_.getX()), (float)(d4 + double_.getY()));
    }

    public void lineTo(double d, double d2) throws NoCurrentPointException {
        if (this.getCurrentPoint() == null) {
            throw new NoCurrentPointException();
        }
        Point2D.Double double_ = new Point2D.Double(d, d2);
        this.af.transform(double_, double_);
        this.path.lineTo((float)double_.getX(), (float)double_.getY());
    }

    public void rlineTo(double d, double d2) throws NoCurrentPointException {
        Point2D point2D = this.getCurrentPoint();
        if (point2D == null) {
            throw new NoCurrentPointException();
        }
        double d3 = point2D.getX();
        double d4 = point2D.getY();
        Point2D.Double double_ = new Point2D.Double(d, d2);
        this.af.deltaTransform(double_, double_);
        this.path.lineTo((float)(d3 + double_.getX()), (float)(d4 + double_.getY()));
    }

    public void curveTo(double d, double d2, double d3, double d4, double d5, double d6) throws NoCurrentPointException {
        if (this.getCurrentPoint() == null) {
            throw new NoCurrentPointException();
        }
        Point2D.Double double_ = new Point2D.Double(d, d2);
        this.af.transform(double_, double_);
        Point2D.Double double_2 = new Point2D.Double(d3, d4);
        this.af.transform(double_2, double_2);
        Point2D.Double double_3 = new Point2D.Double(d5, d6);
        this.af.transform(double_3, double_3);
        this.path.curveTo((float)double_.getX(), (float)double_.getY(), (float)double_2.getX(), (float)double_2.getY(), (float)double_3.getX(), (float)double_3.getY());
    }

    public void rcurveTo(double d, double d2, double d3, double d4, double d5, double d6) throws NoCurrentPointException {
        Point2D point2D = this.getCurrentPoint();
        if (point2D == null) {
            throw new NoCurrentPointException();
        }
        double d7 = point2D.getX();
        double d8 = point2D.getY();
        Point2D.Double double_ = new Point2D.Double(d, d2);
        this.af.deltaTransform(double_, double_);
        Point2D.Double double_2 = new Point2D.Double(d3, d4);
        this.af.deltaTransform(double_2, double_2);
        Point2D.Double double_3 = new Point2D.Double(d5, d6);
        this.af.deltaTransform(double_3, double_3);
        this.path.curveTo((float)(d7 + double_.getX()), (float)(d8 + double_.getY()), (float)(d7 + double_2.getX()), (float)(d8 + double_2.getY()), (float)(d7 + double_3.getX()), (float)(d8 + double_3.getY()));
    }

    public void quadTo(double d, double d2, double d3, double d4) throws NoCurrentPointException {
        Point2D point2D = this.getCurrentPoint();
        if (point2D == null) {
            throw new NoCurrentPointException();
        }
        Point2D.Double double_ = new Point2D.Double(d, d2);
        this.af.transform(double_, double_);
        Point2D.Double double_2 = new Point2D.Double(d3, d4);
        this.af.transform(double_2, double_2);
        this.path.quadTo((float)double_.getX(), (float)double_.getY(), (float)double_2.getX(), (float)double_2.getY());
        double d5 = (2.0 * d + point2D.getX()) / 3.0;
        double d6 = (2.0 * d2 + point2D.getY()) / 3.0;
        double d7 = (d3 + 2.0 * d) / 3.0;
        double d8 = (d4 + 2.0 * d2) / 3.0;
        this.path.curveTo((float)d5, (float)d6, (float)d7, (float)d8, (float)d3, (float)d4);
    }

    public void rquadTo(float f, float f2, float f3, float f4) throws NoCurrentPointException {
        Point2D point2D = this.getCurrentPoint();
        if (point2D == null) {
            throw new NoCurrentPointException();
        }
        Point2D.Double double_ = new Point2D.Double(f, f2);
        this.af.deltaTransform(double_, double_);
        Point2D.Double double_2 = new Point2D.Double(f3, f4);
        this.af.deltaTransform(double_2, double_2);
        this.path.quadTo((float)(point2D.getX() + double_.getX()), (float)(point2D.getY() + double_.getY()), (float)(point2D.getX() + double_2.getX()), (float)(point2D.getY() + double_2.getY()));
    }

    public void arc(double d, double d2, double d3, double d4, double d5) {
        if (d4 < 0.0) {
            d4 = (double)(360 * ((int)(-d4) / 360 + 1)) + d4;
        } else if (d4 > 360.0) {
            d4 -= (double)(360 * ((int)d4 / 360));
        }
        if (d5 < 0.0) {
            d5 = (double)(360 * ((int)(-d5) / 360 + 1)) + d5;
        } else if (d5 > 360.0) {
            d5 -= (double)(360 * ((int)d5 / 360));
        }
        double d6 = Math.abs(d4 - d5);
        if (d4 > d5) {
            d6 = 360.0 - d6;
        }
        Arc2D.Double double_ = new Arc2D.Double(new Rectangle2D.Double(-d3, -d3, 2.0 * d3, 2.0 * d3), d4, d6, 0);
        AffineTransform affineTransform = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
        affineTransform.translate(d, -d2);
        Point2D point2D = this.getCurrentPoint();
        PathIterator pathIterator = double_.getPathIterator(affineTransform);
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    if (point2D == null) {
                        this.moveTo(fArray[0], fArray[1]);
                        break;
                    }
                    try {
                        this.lineTo(fArray[0], fArray[1]);
                    }
                    catch (NoCurrentPointException noCurrentPointException) {
                        // empty catch block
                    }
                    point2D = null;
                    break;
                }
                case 1: {
                    try {
                        this.lineTo(fArray[0], fArray[1]);
                    }
                    catch (NoCurrentPointException noCurrentPointException) {}
                    break;
                }
                case 3: {
                    try {
                        this.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    }
                    catch (NoCurrentPointException noCurrentPointException) {}
                    break;
                }
                case 2: {
                    try {
                        this.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                    }
                    catch (NoCurrentPointException noCurrentPointException) {}
                    break;
                }
                case 4: {
                    this.closePath();
                }
            }
            pathIterator.next();
        }
    }

    public void arcn(double d, double d2, double d3, double d4, double d5) {
        if (d4 < 0.0) {
            d4 = (double)(360 * ((int)(-d4) / 360 + 1)) + d4;
        } else if (d4 > 360.0) {
            d4 -= (double)(360 * ((int)d4 / 360));
        }
        if (d5 < 0.0) {
            d5 = (double)(360 * ((int)(-d5) / 360 + 1)) + d5;
        } else if (d5 > 360.0) {
            d5 -= (double)(360 * ((int)d5 / 360));
        }
        double d6 = Math.abs(d4 - d5);
        if (d4 < d5) {
            d6 = 360.0 - d6;
        }
        Arc2D.Double double_ = new Arc2D.Double(new Rectangle2D.Double(-d3, -d3, 2.0 * d3, 2.0 * d3), d4, -d6, 0);
        AffineTransform affineTransform = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
        affineTransform.translate(d, -d2);
        Point2D point2D = this.getCurrentPoint();
        PathIterator pathIterator = double_.getPathIterator(affineTransform);
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    if (point2D == null) {
                        this.moveTo(fArray[0], fArray[1]);
                        break;
                    }
                    try {
                        this.lineTo(fArray[0], fArray[1]);
                    }
                    catch (NoCurrentPointException noCurrentPointException) {
                        // empty catch block
                    }
                    point2D = null;
                    break;
                }
                case 1: {
                    try {
                        this.lineTo(fArray[0], fArray[1]);
                    }
                    catch (NoCurrentPointException noCurrentPointException) {}
                    break;
                }
                case 3: {
                    try {
                        this.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    }
                    catch (NoCurrentPointException noCurrentPointException) {}
                    break;
                }
                case 2: {
                    try {
                        this.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                    }
                    catch (NoCurrentPointException noCurrentPointException) {}
                    break;
                }
                case 4: {
                    this.closePath();
                }
            }
            pathIterator.next();
        }
    }

    public void arcTo(double d, double d2, double d3, double d4, double d5, Point2D point2D, Point2D point2D2) throws NoCurrentPointException {
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        Point2D point2D3 = this.getCurrentPoint();
        if (point2D3 == null) {
            throw new NoCurrentPointException();
        }
        double d16 = point2D3.getX();
        double d17 = point2D3.getY();
        double d18 = d - d16;
        double d19 = d2 - d17;
        double d20 = d3 - d;
        double d21 = d4 - d2;
        int n = 0;
        int n2 = 0;
        try {
            d15 = 1.0 / d19;
            if (d15 == Double.POSITIVE_INFINITY || d15 == Double.NEGATIVE_INFINITY) {
                n = 1;
            }
        }
        catch (ArithmeticException arithmeticException) {
            n = 1;
        }
        try {
            d15 = 1.0 / d21;
            if (d15 == Double.POSITIVE_INFINITY || d15 == Double.NEGATIVE_INFINITY) {
                n2 = 1;
            }
        }
        catch (ArithmeticException arithmeticException) {
            n2 = 1;
        }
        try {
            double d22 = 1.0 / d18;
            if (d22 == Double.POSITIVE_INFINITY || d22 == Double.NEGATIVE_INFINITY) {
                n = -1;
            }
        }
        catch (ArithmeticException arithmeticException) {
            n = -1;
        }
        try {
            double d23 = 1.0 / d20;
            if (d23 == Double.POSITIVE_INFINITY || d23 == Double.NEGATIVE_INFINITY) {
                n2 = -1;
            }
        }
        catch (ArithmeticException arithmeticException) {
            n2 = -1;
        }
        if (n == -1 && n2 == -1 || n == 1 && n2 == 1) {
            this.lineTo(d, d2);
            point2D.setLocation(d, d2);
            point2D2.setLocation(d, d2);
            return;
        }
        if (n == 1 && n2 == -1) {
            d14 = d + Math.signum(d16 - d) * d5;
            d13 = d2;
            d12 = d;
            d11 = d2 + Math.signum(d4 - d2) * d5;
            d10 = d14;
            d9 = d11;
        } else if (n == -1 && n2 == 1) {
            d14 = d;
            d13 = d2 + Math.signum(d17 - d2) * d5;
            d12 = d + Math.signum(d3 - d) * d5;
            d11 = d2;
            d10 = d12;
            d9 = d13;
        } else if (n == -1) {
            d8 = d21 / d20;
            d7 = -Math.signum(d3 - d) * d5;
            double d24 = d5 / Math.sqrt(d8 * d8 + 1.0);
            double d25 = d4 - d8 * d3;
            d10 = d - d7;
            d14 = d;
            d12 = -d8 * d24 + d + Math.signum(d3 - d) * d5;
            d13 = d9 = -d8 * d8 * d24 + d25 - d24 + d8 * d14;
            d11 = d9 + d24;
            double d26 = (d13 - d17) / (d2 - d17);
            double d27 = (d11 - d2) / (d4 - d2);
            if (d26 > 1.0 && d27 >= 0.0 && d27 <= 1.0) {
                d24 = -d24;
                d12 = -d8 * d24 + d + Math.signum(d3 - d) * d5;
                d13 = d9 = -d8 * d8 * d24 + d25 - d24 + d8 * d14;
                d11 = d9 + d24;
            }
        } else if (n2 == -1) {
            d8 = d19 / d18;
            d7 = -Math.signum(d17 - d4) * d5;
            double d28 = d5 / Math.sqrt(d8 * d8 + 1.0);
            double d29 = -d8 * d28;
            double d30 = d2 - d8 * d;
            d12 = d;
            d10 = d - d7;
            d14 = d10 + d29;
            d13 = d30 + d8 * d29 - d8 * d7;
            d11 = d9 = d13 + (d14 - d10) / d8;
            double d31 = (d13 - d17) / (d2 - d17);
            double d32 = (d11 - d2) / (d4 - d2);
            if (d32 < 0.0 && d31 >= 0.0 && d31 <= 1.0) {
                d28 = -d28;
                d29 = -d8 * d28;
                d14 = d10 + d29;
                d13 = d30 + d8 * d29 - d8 * d7;
                d11 = d9 = d13 + (d14 - d10) / d8;
            }
        } else {
            d8 = d19 / d18;
            d7 = d21 / d20;
            double d33 = d8 - d7;
            double d34 = d2 - d8 * d;
            double d35 = d4 - d7 * d3;
            double d36 = d5 / Math.sqrt(d7 * d7 + 1.0);
            double d37 = -d7 * d36;
            double d38 = d5 / Math.sqrt(d8 * d8 + 1.0);
            double d39 = -d8 * d38;
            d13 = d7 * (d8 * d37 - d8 * d39 - d34) / d33 + d8 * (d35 - d36 + d38) / d33;
            d14 = (d13 - d34) / d8;
            d9 = -d7 * d39 + d7 * d37 + d35 - d36 + d7 * d14;
            d11 = d9 + d36;
            d10 = d14 - d39;
            d12 = d37 + d10;
            double d40 = (d13 - d17) / (d2 - d17);
            double d41 = (d11 - d2) / (d4 - d2);
            boolean bl = false;
            if (d40 > 1.0 && d41 < 0.0) {
                d38 = -d38;
                d36 = -d36;
                bl = true;
            } else if (d40 > 1.0 && d41 >= 0.0 && d41 <= 1.0) {
                d36 = -d36;
                bl = true;
            } else if (d41 < 0.0 && d40 >= 0.0 && d40 <= 1.0) {
                d38 = -d38;
                bl = true;
            }
            if (bl) {
                d37 = -d7 * d36;
                d39 = -d8 * d38;
                d13 = d7 * (d8 * d37 - d8 * d39 - d34) / d33 + d8 * (d35 - d36 + d38) / d33;
                d14 = (d13 - d34) / d8;
                d9 = -d7 * d39 + d7 * d37 + d35 - d36 + d7 * d14;
                d11 = d9 + d36;
                d10 = d14 - d39;
                d12 = d37 + d10;
            }
        }
        d18 = d14 - d10;
        d19 = d13 - d9;
        boolean bl = false;
        try {
            d6 = 1.0 / d18;
            if (d6 == Double.POSITIVE_INFINITY || d6 == Double.NEGATIVE_INFINITY) {
                bl = true;
            }
        }
        catch (ArithmeticException arithmeticException) {
            bl = true;
        }
        d8 = bl ? (d9 < d13 ? 1.5707963267948966 : 4.71238898038469) : Math.atan2(d19, d18);
        d18 = d12 - d10;
        d19 = d11 - d9;
        bl = false;
        try {
            d6 = 1.0 / d18;
            if (d6 == Double.POSITIVE_INFINITY || d6 == Double.NEGATIVE_INFINITY) {
                bl = true;
            }
        }
        catch (ArithmeticException arithmeticException) {
            bl = true;
        }
        double d42 = bl ? (d9 < d11 ? 1.5707963267948966 : 4.71238898038469) : Math.atan2(d19, d18);
        if ((d11 - d13) / (d12 - d14) > 0.0) {
            this.arcn(d10, d9, d5, Math.toDegrees(d8), Math.toDegrees(d42));
        } else {
            this.arc(d10, d9, d5, Math.toDegrees(d8), Math.toDegrees(d42));
        }
        point2D.setLocation(d14, d13);
        point2D2.setLocation(d12, d11);
    }

    public void closePath() {
        this.path.closePath();
    }

    public void append(Shape shape, boolean bl) {
        this.path.append(shape, bl);
    }

    public void clip() {
        this.clippingPath = new GeneralPath(this.path);
        this.clippingPath.setWindingRule(1);
    }

    public void eoclip() {
        this.clippingPath = new GeneralPath(this.path);
        this.clippingPath.setWindingRule(0);
    }

    public void clipRect(double d, double d2, double d3, double d4) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        this.clip(double_);
    }

    public void clip(Shape shape) {
        if (this.clippingPath == null) {
            this.clippingPath = new GeneralPath(this.af.createTransformedShape(shape));
        } else {
            Area area = new Area(this.clippingPath);
            area.intersect(new Area(this.af.createTransformedShape(shape)));
            this.clippingPath = new GeneralPath(area);
        }
    }

    public JDRPath createShadedPath(EPSFile ePSFile, EPSDict ePSDict) throws InvalidFormatException {
        int n;
        JDRPath jDRPath = JDRPath.getPath(this.clippingPath.getPathIterator(null));
        jDRPath.getStroke().setWindingRule(this.clippingPath.getWindingRule());
        BBox bBox = jDRPath.getBBox();
        try {
            n = ePSDict.getInt("/ShadingType");
        }
        catch (Exception exception) {
            throw new InvalidPaintException("Number required for /ShadingType");
        }
        String string = ePSDict.getProc("/ColorSpace").toString();
        if (string == null) {
            EPS.warning(ePSFile, "No /ColorSpace found, no fill colour set");
            return jDRPath;
        }
        double[] dArray = ePSDict.getDoubleArray("/Coords");
        if (dArray == null) {
            throw new InvalidPaintException("No /Coords found");
        }
        EPSDict ePSDict2 = ePSDict.getDict("/Function");
        if (ePSDict2 == null) {
            EPS.warning(ePSFile, "No /Function found, no fill colour set");
            return jDRPath;
        }
        int n2 = ePSDict2.getInt("/FunctionType");
        if (n2 != 2) {
            EPS.warning(ePSFile, "Don't know how to deal with function type " + n2);
            return jDRPath;
        }
        double[] dArray2 = ePSDict2.getDoubleArray("/C0");
        if (dArray2 == null) {
            EPS.warning(ePSFile, "Can't find /C0 in /Function");
            return jDRPath;
        }
        double[] dArray3 = ePSDict2.getDoubleArray("/C1");
        if (dArray3 == null) {
            EPS.warning(ePSFile, "Can't find /C1 in /Function");
            return jDRPath;
        }
        JDRPaint jDRPaint = null;
        JDRPaint jDRPaint2 = null;
        if (string.equals("/DeviceRGB")) {
            jDRPaint = new JDRColor(dArray2[0], dArray2[1], dArray2[2]);
            jDRPaint2 = new JDRColor(dArray3[0], dArray3[1], dArray3[2]);
        } else if (string.equals("/DeviceCMYK")) {
            jDRPaint = new JDRColorCMYK(dArray2[0], dArray2[1], dArray2[2], dArray2[3]);
            jDRPaint2 = new JDRColorCMYK(dArray3[0], dArray3[1], dArray3[2], dArray3[3]);
        } else if (string.equals("/DeviceGray")) {
            double d = dArray2[0];
            double d2 = dArray3[0];
            jDRPaint = new JDRColor(d, d, d);
            jDRPaint2 = new JDRColor(d2, d2, d2);
        } else {
            EPS.warning(ePSFile, "Don't know what to do with colour space " + string);
            return jDRPath;
        }
        JDRPaint jDRPaint3 = null;
        if (n == 2) {
            int n3;
            double d;
            double d3;
            double d4;
            double d5;
            try {
                d5 = dArray[0];
                d4 = dArray[1];
                d3 = dArray[2];
                d = dArray[3];
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidPaintException("Can't parse shading co-ordinates");
            }
            double d6 = d5 - d3;
            double d7 = d4 - d;
            if (d6 == 0.0) {
                n3 = d4 > d ? 0 : 4;
            } else {
                double d8 = d7 / d6;
                double d9 = Math.abs(d8);
                n3 = d5 < d3 ? 2 : 6;
                double d10 = Math.abs(d8 - 1.0);
                if (d10 < d9) {
                    n3 = d5 < d3 ? 1 : 5;
                    d9 = d10;
                }
                if ((d10 = Math.abs(d8 + 1.0)) < d9) {
                    n3 = d5 < d3 ? 3 : 7;
                }
            }
            jDRPaint3 = new JDRGradient(n3, jDRPaint, jDRPaint2);
        } else if (n == 3) {
            double d;
            double d11;
            double d12;
            double d13;
            try {
                d13 = dArray[0];
                d12 = dArray[1];
                double d14 = dArray[2];
                d11 = dArray[3];
                d = dArray[4];
                double d15 = dArray[5];
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidPaintException("Can't parse shading co-ordinates");
            }
            Point2D.Double double_ = new Point2D.Double(0.5 * (d13 + d11), 0.5 * (d12 + d));
            int n4 = 8;
            double d16 = bBox.getWidth() / 3.0;
            double d17 = bBox.getHeight() / 3.0;
            d13 = bBox.getMinX() + d16;
            d12 = bBox.getMinY() + d17;
            d11 = bBox.getMinX() + 2.0 * d16;
            d = bBox.getMinY() + 2.0 * d17;
            this.af.transform(double_, double_);
            double d18 = ((Point2D)double_).getY();
            double d19 = ((Point2D)double_).getX();
            if (d18 < d12) {
                n4 = d19 < d13 ? 5 : (d19 > d11 ? 3 : 4);
            } else if (d18 > d) {
                n4 = d19 < d13 ? 7 : (d19 > d11 ? 1 : 0);
            } else if (d19 < d13) {
                n4 = 6;
            } else if (d19 > d11) {
                n4 = 2;
            }
            jDRPaint3 = new JDRRadial(n4, jDRPaint, jDRPaint2);
        } else {
            EPS.warning(ePSFile, "Unable to implement shading type " + n);
        }
        if (jDRPaint3 != null) {
            jDRPath.setLinePaint(new JDRTransparent());
            jDRPath.setFillPaint(jDRPaint3);
        }
        return jDRPath;
    }

    public PathIterator getPathIterator() {
        return this.getPathIterator(null);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        if (this.flatten_) {
            return this.path.getPathIterator(affineTransform, this.flatness);
        }
        return this.path.getPathIterator(affineTransform);
    }

    public static void printPath(PathIterator pathIterator) {
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    JDR.messageSystem.messageln("M: (" + fArray[0] + ", " + fArray[1] + ")");
                    break;
                }
                case 1: {
                    JDR.messageSystem.messageln("L: (" + fArray[0] + ", " + fArray[1] + ")");
                    break;
                }
                case 3: {
                    JDR.messageSystem.messageln("C: (" + fArray[0] + ", " + fArray[1] + ")(" + fArray[2] + ", " + fArray[3] + ")(" + fArray[4] + ", " + fArray[5] + ")");
                    break;
                }
                case 2: {
                    JDR.messageSystem.messageln("Q: (" + fArray[0] + ", " + fArray[1] + ")(" + fArray[2] + ", " + fArray[3] + ")");
                    break;
                }
                case 4: {
                    JDR.messageSystem.messageln("Z");
                }
            }
            pathIterator.next();
        }
    }

    public static void printPath(Shape shape) {
        GraphicsState.printPath(shape.getPathIterator(null));
    }

    public void printCurrentPath() {
        GraphicsState.printPath(this.getPathIterator());
    }

    public JDRPath createStrokedPath() throws InvalidFormatException, NoninvertibleTransformException, IOException {
        return this.createStrokedPath(1);
    }

    public JDRPath createStrokedPath(int n) throws InvalidFormatException, NoninvertibleTransformException, IOException {
        JDRPath jDRPath;
        JDRStroke jDRStroke = this.getStroke(n);
        if (this.clippingPath == null) {
            try {
                jDRPath = JDRPath.getPath(this.getPathIterator());
                jDRPath.setStroke(jDRStroke);
            }
            catch (EmptyPathException emptyPathException) {
                return null;
            }
        }
        Area area = new Area(this.clippingPath);
        Shape shape = jDRStroke.createStrokedShape(this.path);
        Area area2 = new Area(shape);
        area.intersect(area2);
        try {
            jDRPath = JDRPath.getPath(area.getPathIterator(null));
        }
        catch (EmptyPathException emptyPathException) {
            return null;
        }
        jDRPath.setFillPaint(new JDRTransparent());
        jDRPath.setLinePaint(this.getPaint());
        return jDRPath;
    }

    public JDRPath createFilledPath(int n) throws InvalidPathException, InvalidWindingRuleException, InvalidFormatException, NoninvertibleTransformException, IOException {
        JDRPath jDRPath = this.createStrokedPath(n);
        if (jDRPath == null) {
            return null;
        }
        JDRPaint jDRPaint = jDRPath.getLinePaint();
        JDRPaint jDRPaint2 = jDRPath.getFillPaint();
        jDRPath.setLinePaint(jDRPaint2);
        jDRPath.setFillPaint(jDRPaint);
        return jDRPath;
    }

    public JDRPath createFilledPath() throws InvalidPathException, InvalidWindingRuleException, InvalidFormatException, NoninvertibleTransformException, IOException {
        return this.createFilledPath(1);
    }

    public Rectangle2D getBounds2D() {
        return this.path.getBounds2D();
    }

    public Rectangle2D getBBox() throws NoCurrentPointException, NoninvertibleTransformException {
        if (this.getCurrentPoint() == null) {
            throw new NoCurrentPointException();
        }
        Rectangle2D rectangle2D = this.path.createTransformedShape(this.af.createInverse()).getBounds2D();
        return rectangle2D;
    }

    @Override
    public EPSName pstype() {
        return new EPSName("gstate");
    }

    public String toString() {
        String string = "GraphicsState[af=" + this.af + ",linewidth=" + this.lineWidth + ",mitrelimit=" + this.mitreLimit + ",cap=" + this.cap + ",join=" + this.join + ",dashoffset=" + this.dashOffset + ",dashpattern=(";
        if (this.dashPattern != null) {
            for (int i = 0; i < this.dashPattern.length; ++i) {
                if (i != 0) {
                    string = string + ",";
                }
                string = string + "" + this.dashPattern[i];
            }
        }
        string = string + "),paint=" + this.paint + ",path=" + this.path + ",clip=" + this.clippingPath + ",font=" + this.font + ",currentpoint=" + this.getCurrentPoint();
        string = string + "]";
        return string;
    }
}

