/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.io.eps;

import java.awt.geom.NoninvertibleTransformException;
import java.io.IOException;
import java.util.Vector;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSArray;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSComposite;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSDictMark;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSDouble;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSIndexComposite;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSInteger;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSMark;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSName;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSNumber;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSObject;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSProc;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSReadable;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSRelational;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSStack;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSWriteable;
import uk.ac.uea.cmp.nlct.jdr.io.eps.InvalidEPSObjectException;
import uk.ac.uea.cmp.nlct.jdr.io.eps.NoReadAccessException;
import uk.ac.uea.cmp.nlct.jdr.io.eps.NoWriteAccessException;

public class EPSString
implements EPSIndexComposite,
EPSReadable,
EPSWriteable,
EPSRelational {
    private char[] chars_;
    private int idx_ = 0;
    private boolean hasReadAccess_ = true;
    private boolean hasWriteAccess_ = true;

    public EPSString(String string) {
        this.chars_ = string.toCharArray();
    }

    public EPSString(char[] cArray) {
        this.chars_ = new char[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            this.chars_[i] = cArray[i];
        }
    }

    public EPSString(int n) {
        this.chars_ = new char[n];
        for (int i = 0; i < n; ++i) {
            this.chars_[i] = '\u0000';
        }
    }

    public boolean isEmpty() {
        return this.value().equals("");
    }

    @Override
    public void forall(EPSStack ePSStack, EPSProc ePSProc) throws InvalidFormatException, NoninvertibleTransformException, IOException {
        int n = this.chars_.length;
        for (int i = 0; i < n; ++i) {
            ePSStack.pushInteger(this.chars_[i]);
            ePSStack.execObject(ePSProc);
            if (ePSStack.getExitStatus()) break;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof EPSString) {
            return this.value().equals(((EPSString)object).value());
        }
        return false;
    }

    @Override
    public boolean ge(EPSRelational ePSRelational) throws InvalidEPSObjectException {
        if (ePSRelational instanceof EPSString) {
            return this.value().compareTo(((EPSString)ePSRelational).value()) >= 0;
        }
        throw new InvalidEPSObjectException("(ge) invalid type");
    }

    @Override
    public boolean gt(EPSRelational ePSRelational) throws InvalidEPSObjectException {
        if (ePSRelational instanceof EPSString) {
            return this.value().compareTo(((EPSString)ePSRelational).value()) > 0;
        }
        throw new InvalidEPSObjectException("(gt) invalid type");
    }

    @Override
    public boolean le(EPSRelational ePSRelational) throws InvalidEPSObjectException {
        if (ePSRelational instanceof EPSString) {
            return this.value().compareTo(((EPSString)ePSRelational).value()) <= 0;
        }
        throw new InvalidEPSObjectException("(le) invalid type");
    }

    @Override
    public boolean lt(EPSRelational ePSRelational) throws InvalidEPSObjectException {
        if (ePSRelational instanceof EPSString) {
            return this.value().compareTo(((EPSString)ePSRelational).value()) < 0;
        }
        throw new InvalidEPSObjectException("(lt) invalid type");
    }

    public String toString() {
        String string = "";
        boolean bl = false;
        int n = this.chars_.length;
        for (int i = 0; i < n; ++i) {
            if (this.chars_[i] == '(' || this.chars_[i] == ')') {
                string = string + "\\";
                string = string + this.chars_[i];
                continue;
            }
            if (this.chars_[i] == '\\') {
                string = string + "\\\\";
                continue;
            }
            if (this.chars_[i] == '\n') {
                string = string + "\\n";
                continue;
            }
            if (this.chars_[i] == '\r') {
                string = string + "\\r";
                continue;
            }
            if (this.chars_[i] == '\t') {
                string = string + "\\t";
                continue;
            }
            if (this.chars_[i] == '\f') {
                string = string + "\\f";
                continue;
            }
            if (this.chars_[i] == '\b') {
                string = string + "\\b";
                continue;
            }
            if (this.chars_[i] == '\u0000') {
                string = string + "\\000";
                continue;
            }
            if (this.chars_[i] > '\u001f' && this.chars_[i] < '\u0080') {
                string = string + this.chars_[i];
                continue;
            }
            String string2 = Integer.toOctalString(this.chars_[i]);
            if (this.chars_[i] < '\b') {
                string2 = "00" + string2;
            } else if (this.chars_[i] < '@') {
                string2 = "0" + string2;
            }
            string = string + "\\" + string2;
        }
        return "(" + string + ")";
    }

    public String value() {
        return new String(this.chars_);
    }

    @Override
    public int length() {
        return this.chars_.length;
    }

    public char get(int n) throws NoReadAccessException, ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.chars_.length) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.chars_[n];
    }

    @Override
    public EPSObject get(EPSObject ePSObject) throws InvalidEPSObjectException, NoReadAccessException {
        if (!this.hasReadAccess()) {
            throw new NoReadAccessException();
        }
        if (!(ePSObject instanceof EPSNumber)) {
            throw new InvalidEPSObjectException("(get) numerical index required");
        }
        int n = ((EPSNumber)ePSObject).intValue();
        return new EPSInteger(this.chars_[n]);
    }

    @Override
    public void put(EPSObject ePSObject, EPSObject ePSObject2) throws InvalidEPSObjectException, NoWriteAccessException {
        if (!this.hasWriteAccess()) {
            throw new NoWriteAccessException();
        }
        if (!(ePSObject instanceof EPSNumber)) {
            throw new InvalidEPSObjectException("(put) invalid index");
        }
        if (!(ePSObject2 instanceof EPSNumber)) {
            throw new InvalidEPSObjectException("(put) invalid value");
        }
        int n = ((EPSNumber)ePSObject).intValue();
        int n2 = ((EPSNumber)ePSObject2).intValue();
        this.chars_[n] = (char)n2;
    }

    public void put(int n, char c) throws NoWriteAccessException, ArrayIndexOutOfBoundsException {
        if (!this.hasWriteAccess_) {
            throw new NoWriteAccessException();
        }
        if (n < 0 || n >= this.chars_.length) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this.chars_[n] = c;
    }

    @Override
    public EPSComposite getInterval(int n, int n2) throws NoReadAccessException, InvalidEPSObjectException {
        if (!this.hasReadAccess_) {
            throw new NoReadAccessException();
        }
        return new EPSString(new String(this.chars_, n, n2));
    }

    @Override
    public void putInterval(int n, EPSComposite ePSComposite) throws NoWriteAccessException, NoReadAccessException, InvalidEPSObjectException {
        if (!(ePSComposite instanceof EPSString)) {
            throw new InvalidEPSObjectException("string putinterval requires string subinterval");
        }
        EPSString ePSString = (EPSString)ePSComposite;
        if (!this.hasWriteAccess()) {
            throw new NoWriteAccessException();
        }
        if (!ePSString.hasReadAccess()) {
            throw new NoReadAccessException();
        }
        if (n + ePSString.chars_.length > this.chars_.length) {
            throw new ArrayIndexOutOfBoundsException("overflow in putInterval");
        }
        for (int i = 0; i < ePSString.chars_.length; ++i) {
            this.chars_[n + i] = ePSString.get(i);
        }
    }

    public void putInterval(int n, char[] cArray) throws NoWriteAccessException, NoReadAccessException {
        if (!this.hasWriteAccess_) {
            throw new NoWriteAccessException();
        }
        if (n + cArray.length - 1 >= this.chars_.length) {
            throw new ArrayIndexOutOfBoundsException("overflow in putInterval");
        }
        for (int i = 0; i < cArray.length; ++i) {
            this.chars_[n + i] = cArray[i];
        }
    }

    public int indexOf(EPSString ePSString) {
        return this.value().indexOf(ePSString.value());
    }

    public int indexOf(EPSString ePSString, int n) {
        return this.value().indexOf(ePSString.value(), n);
    }

    @Override
    public Object clone() {
        return new EPSString(this.chars_);
    }

    public char[] getChars() {
        return this.chars_;
    }

    @Override
    public void copy(EPSObject ePSObject) throws InvalidEPSObjectException, NoWriteAccessException {
        if (!this.hasWriteAccess()) {
            throw new NoWriteAccessException();
        }
        if (!(ePSObject instanceof EPSString)) {
            throw new InvalidEPSObjectException("(copy) not a EPSString");
        }
        char[] cArray = ((EPSString)ePSObject).chars_;
        for (int i = 0; i < cArray.length; ++i) {
            this.chars_[i] = cArray[i];
        }
    }

    public static boolean isAlphaNumeric(char c) {
        return Character.isLetterOrDigit(c);
    }

    public static boolean isWhiteSpace(char c) {
        return Character.isWhitespace(c);
    }

    public static boolean isDigit(char c) {
        return Character.isDigit(c);
    }

    public static boolean isHex(char c) {
        return Character.digit(c, 16) != -1;
    }

    public EPSObject token() throws InvalidFormatException {
        this.idx_ = 0;
        EPSObject ePSObject = this.readObject();
        String string = new String(this.chars_, this.idx_, this.chars_.length - this.idx_);
        this.chars_ = string.toCharArray();
        return ePSObject;
    }

    private EPSObject readObject() throws InvalidFormatException {
        EPSObject ePSObject = null;
        if (this.idx_ == this.chars_.length) {
            return null;
        }
        while (EPSString.isWhiteSpace(this.chars_[this.idx_])) {
            ++this.idx_;
            if (this.idx_ != this.chars_.length) continue;
            return null;
        }
        if (this.chars_[this.idx_] == '(') {
            ePSObject = this.readString();
        } else if (this.chars_[this.idx_] == '[') {
            ePSObject = new EPSMark();
            ++this.idx_;
        } else if (this.chars_[this.idx_] == '{') {
            ePSObject = this.readGroup();
        } else if (this.chars_[this.idx_] == '<') {
            if (this.chars_[this.idx_ + 1] == '<') {
                ePSObject = new EPSDictMark();
                this.idx_ += 2;
            } else {
                ePSObject = this.readHex();
            }
        } else {
            ePSObject = EPSString.isDigit(this.chars_[this.idx_]) || this.chars_[this.idx_] == '.' && EPSString.isDigit(this.chars_[this.idx_ + 1]) ? this.readNum() : this.readProc();
        }
        return ePSObject;
    }

    private EPSName readProc() {
        String string = "";
        boolean bl = false;
        while (this.idx_ < this.chars_.length && this.chars_[this.idx_] != '{' && this.chars_[this.idx_] != '[' && this.chars_[this.idx_] != '}' && this.chars_[this.idx_] != ']' && this.chars_[this.idx_] != '(' && this.chars_[this.idx_] != ')' && this.chars_[this.idx_] != '<' && this.chars_[this.idx_] != '>' && this.chars_[this.idx_] != '/') {
            block5: {
                block4: {
                    block3: {
                        if (EPSString.isWhiteSpace(this.chars_[this.idx_])) {
                            ++this.idx_;
                            break;
                        }
                        if (this.chars_[this.idx_] != '\\') break block3;
                        boolean bl2 = bl = !bl;
                        if (this.idx_ == this.chars_.length - 1) {
                            string = string + this.chars_[this.idx_];
                            break;
                        }
                        if (!bl || !EPSString.isDigit(this.chars_[this.idx_ + 1])) break block4;
                        string = string + this.readChar();
                        bl = false;
                        break block5;
                    }
                    bl = false;
                }
                string = string + this.chars_[this.idx_];
            }
            ++this.idx_;
        }
        return new EPSName(string);
    }

    private EPSObject readNum() throws InvalidFormatException {
        String string = "";
        boolean bl = true;
        boolean bl2 = false;
        if (this.chars_[this.idx_] == '+' || this.chars_[this.idx_] == '-') {
            string = string + this.chars_[this.idx_];
            ++this.idx_;
        }
        while (this.idx_ < this.chars_.length) {
            if (this.chars_[this.idx_] == '.') {
                if (!bl && !bl2) break;
                bl = false;
                bl2 = true;
                string = string + '.';
            } else if (this.chars_[this.idx_] == 'e' || this.chars_[this.idx_] == 'E') {
                bl2 = true;
                bl = false;
                string = string + this.chars_[this.idx_];
            } else if (!(this.chars_[this.idx_] != '+' && this.chars_[this.idx_] != '-' || this.chars_[this.idx_ - 1] != 'e' && this.chars_[this.idx_ - 1] != 'E')) {
                string = string + this.chars_[this.idx_];
            } else {
                if (!EPSString.isDigit(this.chars_[this.idx_])) break;
                string = string + this.chars_[this.idx_];
            }
            ++this.idx_;
        }
        if (EPSString.isWhiteSpace(this.chars_[this.idx_])) {
            ++this.idx_;
        }
        try {
            if (bl) {
                return new EPSInteger(string);
            }
            return new EPSDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFormatException("(token) can't parse number");
        }
    }

    private char readChar() {
        char c;
        if (this.chars_[this.idx_] == '\\') {
            ++this.idx_;
        }
        String string = "";
        for (int i = 0; i < 3 && EPSString.isDigit(c = this.chars_[this.idx_]); ++i) {
            string = string + c;
            ++this.idx_;
        }
        --this.idx_;
        return (char)Integer.parseInt(string, 8);
    }

    private EPSObject readString() throws InvalidFormatException {
        boolean bl = false;
        String string = "";
        int n = 1;
        while (true) {
            ++this.idx_;
            if (this.idx_ >= this.chars_.length) {
                return null;
            }
            if (this.chars_[this.idx_] == '\\') {
                boolean bl2 = bl = !bl;
                if (this.idx_ == this.chars_.length - 1) break;
                if (bl && EPSString.isDigit(this.chars_[this.idx_ + 1])) {
                    ++this.idx_;
                    string = string + this.readChar();
                    bl = false;
                    continue;
                }
            } else {
                bl = false;
            }
            if (this.chars_[this.idx_] == ')' && !bl) {
                if (--n == 0) {
                    break;
                }
            } else if (this.chars_[this.idx_] == '(' && !bl) {
                ++n;
            }
            string = string + this.chars_[this.idx_];
        }
        return new EPSString(string);
    }

    private EPSArray readArray() throws InvalidFormatException {
        ++this.idx_;
        Vector<EPSObject> vector = new Vector<EPSObject>();
        while (this.idx_ < this.chars_.length) {
            while (EPSString.isWhiteSpace(this.chars_[this.idx_])) {
                ++this.idx_;
            }
            if (this.idx_ == this.chars_.length) break;
            if (this.chars_[this.idx_] == ']') {
                ++this.idx_;
                break;
            }
            EPSObject ePSObject = this.readObject();
            if (ePSObject == null) {
                return null;
            }
            vector.add(ePSObject);
        }
        return new EPSArray(vector);
    }

    private EPSProc readGroup() throws InvalidFormatException {
        ++this.idx_;
        EPSProc ePSProc = new EPSProc();
        while (this.idx_ < this.chars_.length) {
            while (EPSString.isWhiteSpace(this.chars_[this.idx_])) {
                ++this.idx_;
            }
            if (this.idx_ == this.chars_.length) break;
            if (this.chars_[this.idx_] == '}') {
                ++this.idx_;
                break;
            }
            EPSObject ePSObject = this.readObject();
            if (ePSObject == null) {
                return null;
            }
            ePSProc.add(ePSObject);
        }
        return ePSProc;
    }

    private EPSString readHex() throws InvalidFormatException {
        int n;
        ++this.idx_;
        String string = "<";
        while (this.idx_ < this.chars_.length) {
            if (EPSString.isHex(this.chars_[this.idx_])) {
                string = string + this.chars_[this.idx_];
            } else {
                if (this.chars_[this.idx_] == '>') {
                    ++this.idx_;
                    break;
                }
                if (!EPSString.isWhiteSpace(this.chars_[this.idx_])) {
                    return null;
                }
            }
            ++this.idx_;
        }
        if ((n = string.length()) % 2 == 1) {
            string = string + '0';
            ++n;
        }
        char[] cArray = new char[n / 2];
        try {
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                cArray[n3] = (char)Integer.parseInt(string.substring(n2, 2), 16);
                n2 += 2;
                ++n3;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFormatException("Can't parse hexadecimal string");
        }
        return new EPSString(cArray);
    }

    @Override
    public EPSName pstype() {
        return new EPSName("stringtype");
    }

    @Override
    public boolean hasReadAccess() {
        return this.hasReadAccess_;
    }

    @Override
    public boolean hasWriteAccess() {
        return this.hasWriteAccess_;
    }

    @Override
    public void setReadAccess(boolean bl) throws InvalidEPSObjectException {
        this.hasReadAccess_ = bl;
    }

    @Override
    public void setWriteAccess(boolean bl) throws InvalidEPSObjectException {
        this.hasWriteAccess_ = bl;
    }

    @Override
    public void makeEqual(EPSObject ePSObject) {
        EPSString ePSString = (EPSString)ePSObject;
        if (this.chars_.length != ePSString.chars_.length) {
            this.chars_ = new char[ePSString.chars_.length];
        }
        for (int i = 0; i < this.chars_.length; ++i) {
            this.chars_[i] = ePSString.chars_[i];
        }
        this.hasReadAccess_ = ePSString.hasReadAccess_;
        this.hasWriteAccess_ = ePSString.hasWriteAccess_;
    }
}

