/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.io.eps;

import java.awt.geom.NoninvertibleTransformException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSArray;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSBoolean;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSComposite;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSDict;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSDictionaryInterface;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSDouble;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSFile;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSFilter;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSFont;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSIndexComposite;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSInteger;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSLogical;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSLong;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSMark;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSName;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSNull;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSNumber;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSObject;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSOperator;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSPackedArray;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSProc;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSReadable;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSRelational;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSSaveState;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSString;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSWriteable;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EmptyStackException;
import uk.ac.uea.cmp.nlct.jdr.io.eps.GraphicsState;
import uk.ac.uea.cmp.nlct.jdr.io.eps.InvalidEPSObjectException;
import uk.ac.uea.cmp.nlct.jdr.io.eps.NotMatrixException;

public class EPSStack
extends Vector<EPSObject> {
    private EPS eps_;
    private Vector<EPSDict> dictionaries;
    private boolean exit_ = false;
    private boolean stop_ = false;
    private EPSDict userdict;
    private EPSDict statusdict;

    public EPSStack(EPS ePS) {
        this.eps_ = ePS;
        this.userdict = new EPSDict();
        this.statusdict = new EPSDict();
        this.dictionaries = new Vector();
        this.dictionaries.add(ePS.getSystemDict());
        this.dictionaries.add(ePS.getGlobalDict());
        this.dictionaries.add(this.userdict);
    }

    public EPSDict getCurrentDictionary() {
        return this.dictionaries.lastElement();
    }

    public void pushObjects(Vector<EPSObject> vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.add(vector.get(i));
        }
    }

    public void pushString(String string) {
        this.add(new EPSString(string));
    }

    public void pushInteger(int n) {
        this.add(new EPSInteger(n));
    }

    public void pushLong(long l) {
        this.add(new EPSLong(l));
    }

    public void pushLong(int n) {
        this.add(new EPSLong(n));
    }

    public void pushDouble(double d) {
        this.add(new EPSDouble(d));
    }

    public void pushBoolean(boolean bl) {
        this.add(new EPSBoolean(bl));
    }

    public void pushArray(double[] dArray) {
        this.add(new EPSArray(dArray));
    }

    public EPSComposite popEPSComposite() throws InvalidEPSObjectException, EmptyStackException {
        EPSObject ePSObject = this.popObject();
        if (ePSObject instanceof EPSComposite) {
            return (EPSComposite)ePSObject;
        }
        throw new InvalidEPSObjectException("Composite expected", this.eps_.getLineNum());
    }

    public EPSIndexComposite popEPSIndexComposite() throws InvalidEPSObjectException, EmptyStackException {
        EPSObject ePSObject = this.popObject();
        if (ePSObject instanceof EPSIndexComposite) {
            return (EPSIndexComposite)ePSObject;
        }
        throw new InvalidEPSObjectException("Indexed composite expected", this.eps_.getLineNum());
    }

    public EPSSaveState popEPSSaveState() throws InvalidEPSObjectException, EmptyStackException {
        EPSObject ePSObject = this.popObject();
        if (ePSObject instanceof EPSSaveState) {
            return (EPSSaveState)ePSObject;
        }
        throw new InvalidEPSObjectException("Saved state expected", this.eps_.getLineNum());
    }

    public EPSReadable popEPSReadable() throws InvalidEPSObjectException, EmptyStackException {
        EPSObject ePSObject = this.popObject();
        if (ePSObject instanceof EPSReadable) {
            return (EPSReadable)ePSObject;
        }
        throw new InvalidEPSObjectException("Readable object expected", this.eps_.getLineNum());
    }

    public EPSWriteable popEPSWriteable() throws InvalidEPSObjectException, EmptyStackException {
        EPSObject ePSObject = this.popObject();
        if (ePSObject instanceof EPSWriteable) {
            return (EPSWriteable)ePSObject;
        }
        throw new InvalidEPSObjectException("Writeable object expected", this.eps_.getLineNum());
    }

    public EPSRelational popEPSRelational() throws InvalidEPSObjectException, EmptyStackException {
        EPSObject ePSObject = this.popObject();
        if (ePSObject instanceof EPSRelational) {
            return (EPSRelational)ePSObject;
        }
        throw new InvalidEPSObjectException("Relational object expected", this.eps_.getLineNum());
    }

    public EPSLogical popEPSLogical() throws InvalidEPSObjectException, EmptyStackException {
        EPSObject ePSObject = this.popObject();
        if (ePSObject instanceof EPSLogical) {
            return (EPSLogical)ePSObject;
        }
        throw new InvalidEPSObjectException("Logical object expected", this.eps_.getLineNum());
    }

    public EPSProc popEPSProc() throws InvalidEPSObjectException, EmptyStackException {
        EPSObject ePSObject = this.popObject();
        if (ePSObject instanceof EPSProc) {
            return (EPSProc)ePSObject;
        }
        throw new InvalidEPSObjectException("Procedure expected");
    }

    public GraphicsState popGraphicsState() throws InvalidEPSObjectException, EmptyStackException {
        EPSObject ePSObject = this.popObject();
        if (ePSObject instanceof GraphicsState) {
            return (GraphicsState)ePSObject;
        }
        throw new InvalidEPSObjectException("Graphics state expected", this.eps_.getLineNum());
    }

    public EPSName popEPSName() throws InvalidEPSObjectException, EmptyStackException {
        EPSObject ePSObject = this.popObject();
        if (ePSObject instanceof EPSName) {
            return (EPSName)ePSObject;
        }
        throw new InvalidEPSObjectException("Invalid parameter (name expected " + ePSObject.pstype() + " found)", this.eps_.getLineNum());
    }

    public String popString() throws InvalidEPSObjectException, EmptyStackException {
        return this.popEPSString().value();
    }

    public EPSString popEPSString() throws InvalidEPSObjectException, EmptyStackException {
        EPSObject ePSObject = this.popObject();
        if (ePSObject instanceof EPSString) {
            return (EPSString)ePSObject;
        }
        throw new InvalidEPSObjectException("EPSString expected, " + ePSObject.getClass() + " found", this.eps_.getLineNum());
    }

    public EPSNumber popNumber() throws InvalidEPSObjectException, EmptyStackException {
        EPSObject ePSObject = this.popObject();
        if (ePSObject instanceof EPSNumber) {
            return (EPSNumber)ePSObject;
        }
        throw new InvalidEPSObjectException("Number expected", this.eps_.getLineNum());
    }

    public double popDouble() throws InvalidEPSObjectException, EmptyStackException {
        return this.popNumber().doubleValue();
    }

    public int popInteger() throws InvalidEPSObjectException, EmptyStackException {
        return this.popNumber().intValue();
    }

    public long popLong() throws InvalidEPSObjectException, EmptyStackException {
        return this.popNumber().longValue();
    }

    public double[] popMatrix() throws InvalidEPSObjectException, NotMatrixException, EmptyStackException {
        EPSArray ePSArray = this.popEPSArray();
        return ePSArray.getMatrix();
    }

    public EPSArray popEPSMatrix() throws InvalidEPSObjectException, NotMatrixException, EmptyStackException {
        EPSArray ePSArray = this.popEPSArray();
        if (ePSArray.isMatrix()) {
            return ePSArray;
        }
        throw new InvalidEPSObjectException("matrix expected", this.eps_.getLineNum());
    }

    public double[] popDoubleArray() throws InvalidEPSObjectException, InvalidFormatException, EmptyStackException {
        EPSArray ePSArray = this.popEPSArray();
        return ePSArray.getDoubleArray();
    }

    public EPSArray popEPSArray() throws InvalidEPSObjectException, EmptyStackException {
        EPSObject ePSObject = this.popObject();
        if (ePSObject instanceof EPSArray) {
            return (EPSArray)ePSObject;
        }
        throw new InvalidEPSObjectException("Array expected", this.eps_.getLineNum());
    }

    public EPSPackedArray popPackedArray() throws InvalidEPSObjectException, EmptyStackException {
        EPSArray ePSArray = this.popEPSArray();
        if (ePSArray instanceof EPSPackedArray) {
            return (EPSPackedArray)ePSArray;
        }
        throw new InvalidEPSObjectException("Packed array expected", this.eps_.getLineNum());
    }

    public EPSBoolean popBoolean() throws InvalidEPSObjectException, EmptyStackException {
        EPSObject ePSObject = this.popObject();
        if (ePSObject instanceof EPSBoolean) {
            return (EPSBoolean)ePSObject;
        }
        throw new InvalidEPSObjectException("Boolean expected", this.eps_.getLineNum());
    }

    public EPSFont popFont() throws InvalidEPSObjectException, EmptyStackException {
        EPSObject ePSObject = this.popObject();
        if (ePSObject instanceof EPSFont) {
            return (EPSFont)ePSObject;
        }
        throw new InvalidEPSObjectException("Font expected", this.eps_.getLineNum());
    }

    public EPSDict popDict() throws InvalidEPSObjectException, EmptyStackException {
        EPSObject ePSObject = this.popObject();
        if (ePSObject instanceof EPSDictionaryInterface) {
            return (EPSDict)ePSObject;
        }
        throw new InvalidEPSObjectException("Dictionary expected", this.eps_.getLineNum());
    }

    public EPSMark popEPSMark() throws InvalidEPSObjectException, EmptyStackException {
        EPSObject ePSObject = this.popObject();
        if (ePSObject instanceof EPSMark) {
            return (EPSMark)ePSObject;
        }
        throw new InvalidEPSObjectException("Mark expected", this.eps_.getLineNum());
    }

    public EPSFile popEPSFile() throws InvalidFormatException, NoninvertibleTransformException, IOException {
        EPSObject ePSObject = this.popObject();
        if (ePSObject instanceof EPSFile) {
            return (EPSFile)ePSObject;
        }
        if (ePSObject instanceof EPSFilter) {
            return ((EPSFilter)ePSObject).getFile(this);
        }
        throw new InvalidEPSObjectException("File expected", this.eps_.getLineNum());
    }

    public EPSObject popObject() throws EmptyStackException {
        int n = this.size();
        if (n == 0) {
            throw new EmptyStackException(this.eps_.getLineNum());
        }
        EPSObject ePSObject = (EPSObject)this.remove(n - 1);
        return ePSObject;
    }

    @Override
    public boolean add(EPSObject ePSObject) {
        if (ePSObject == null) {
            return super.add(new EPSNull());
        }
        return super.add(ePSObject);
    }

    public void pushToDictStack(EPSDict ePSDict) {
        this.dictionaries.add(ePSDict);
    }

    public EPSDict popFromDictStack() {
        return this.dictionaries.remove(this.dictionaries.size() - 1);
    }

    public int getDictStackSize() {
        return this.dictionaries.size();
    }

    public EPSDict getDict(int n) {
        return this.dictionaries.get(n);
    }

    public void processObject(EPSObject ePSObject) throws InvalidFormatException, NoninvertibleTransformException, IOException {
        if (ePSObject instanceof EPSName) {
            this.process((EPSName)ePSObject);
        } else if (ePSObject instanceof EPSOperator) {
            ((EPSOperator)ePSObject).execute(this, this.eps_);
        } else {
            this.add(ePSObject);
        }
    }

    public void execObject(EPSObject ePSObject) throws InvalidFormatException, NoninvertibleTransformException, IOException {
        if (ePSObject instanceof EPSProc) {
            this.execProc((EPSProc)ePSObject);
        } else if (ePSObject instanceof EPSFile) {
            ((EPSFile)ePSObject).execute(this.eps_);
        } else if (ePSObject instanceof EPSFilter) {
            EPSFile ePSFile = ((EPSFilter)ePSObject).getFile(this);
            ePSFile.execute(this.eps_);
        } else {
            this.processObject(ePSObject);
        }
    }

    public void execProc(EPSProc ePSProc) throws InvalidFormatException, NoninvertibleTransformException, IOException {
        if (ePSProc.size() == 0) {
            return;
        }
        Enumeration enumeration = ePSProc.elements();
        while (enumeration.hasMoreElements()) {
            EPSObject ePSObject = (EPSObject)enumeration.nextElement();
            this.processObject(ePSObject);
            if (!this.exit_) continue;
            break;
        }
    }

    public void process(EPSName ePSName) throws InvalidFormatException, NoninvertibleTransformException, IOException {
        String string = ePSName.toString();
        if (string.startsWith("/")) {
            this.add(ePSName);
        } else if (string.equals("systemdict")) {
            this.add(this.eps_.getSystemDict());
        } else if (string.equals("userdict")) {
            this.add(this.userdict);
        } else if (string.equals("statusdict")) {
            this.add(this.statusdict);
        } else {
            for (int i = this.dictionaries.size() - 1; i >= 0; --i) {
                EPSDict ePSDict = this.dictionaries.get(i);
                EPSObject ePSObject = ePSDict.get(string);
                if (ePSObject == null) continue;
                if (ePSObject instanceof EPSName) {
                    this.process((EPSName)ePSObject);
                } else if (ePSObject instanceof EPSOperator) {
                    ((EPSOperator)ePSObject).execute(this, this.eps_);
                } else if (ePSObject instanceof EPSProc) {
                    this.execProc((EPSProc)ePSObject);
                } else {
                    this.add(ePSObject);
                }
                return;
            }
            throw new InvalidFormatException("unknown command '" + string + "'", this.eps_.getLineNum());
        }
    }

    public void setExitStatus(boolean bl) {
        this.exit_ = bl;
    }

    public boolean getExitStatus() {
        return this.exit_;
    }

    public void setStopStatus(boolean bl) {
        this.stop_ = bl;
    }

    public boolean getStopStatus() {
        return this.stop_;
    }

    public void printStack() {
        for (int i = this.size() - 1; i >= 0; --i) {
            JDR.messageSystem.messageln(((EPSObject)this.get(i)).toString());
        }
    }
}

