/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.io.eps;

import java.util.Enumeration;
import java.util.Vector;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSComposite;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSDict;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSName;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSObject;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSStack;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSString;
import uk.ac.uea.cmp.nlct.jdr.io.eps.GraphicsState;

public class EPSSaveState
implements EPSObject {
    private Vector<SaveComposite> composites;
    private GraphicsState graphicsState;

    private EPSSaveState() {
    }

    public EPSSaveState(EPS ePS) {
        EPSStack ePSStack = ePS.getStack();
        this.graphicsState = ePS.getCurrentGraphicsState();
        this.composites = new Vector();
        int n = ePSStack.getDictStackSize();
        for (int i = 0; i < n; ++i) {
            EPSDict ePSDict = ePSStack.getDict(i);
            Enumeration enumeration = ePSDict.elements();
            while (enumeration.hasMoreElements()) {
                EPSObject ePSObject = (EPSObject)enumeration.nextElement();
                if (!(ePSObject instanceof EPSComposite) || ePSObject instanceof EPSString) continue;
                this.composites.add(new SaveComposite((EPSComposite)ePSObject));
            }
        }
    }

    public void restore(EPS ePS) {
        ePS.grestoreall();
        EPSStack ePSStack = ePS.getStack();
        for (int i = 0; i < this.composites.size(); ++i) {
            SaveComposite saveComposite = this.composites.get(i);
            saveComposite.object.makeEqual(saveComposite.state);
        }
    }

    public String toString() {
        return "save";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EPSSaveState)) {
            return false;
        }
        EPSSaveState ePSSaveState = (EPSSaveState)object;
        if (ePSSaveState.graphicsState != this.graphicsState) {
            return false;
        }
        return ePSSaveState.composites.equals(this.composites);
    }

    @Override
    public EPSName pstype() {
        return new EPSName("savetype");
    }

    public GraphicsState getGraphicsState() {
        return this.graphicsState;
    }

    @Override
    public Object clone() {
        EPSSaveState ePSSaveState = new EPSSaveState();
        ePSSaveState.composites = new Vector(this.composites.size());
        for (int i = 0; i < this.composites.size(); ++i) {
            ePSSaveState.composites.add(i, (SaveComposite)this.composites.get(i).clone());
        }
        ePSSaveState.graphicsState = this.graphicsState;
        return ePSSaveState;
    }

    public class SaveComposite {
        public EPSComposite object;
        public EPSComposite state;

        public SaveComposite(EPSComposite ePSComposite) {
            this.object = ePSComposite;
            this.state = (EPSComposite)ePSComposite.clone();
        }

        private SaveComposite() {
        }

        public boolean equals(SaveComposite saveComposite) {
            return this.object == saveComposite.object && this.state.equals(saveComposite.state);
        }

        public Object clone() {
            SaveComposite saveComposite = new SaveComposite();
            saveComposite.object = this.object;
            saveComposite.state = (EPSComposite)this.state.clone();
            return saveComposite;
        }
    }
}

