/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.io.eps;

import java.util.Enumeration;
import java.util.Vector;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSArray;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSName;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSNumber;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSObject;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSOperator;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSReadable;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSStack;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSWriteable;
import uk.ac.uea.cmp.nlct.jdr.io.eps.InvalidEPSObjectException;
import uk.ac.uea.cmp.nlct.jdr.io.eps.NoReadAccessException;
import uk.ac.uea.cmp.nlct.jdr.io.eps.NoWriteAccessException;

public class EPSProc
extends Vector<EPSObject>
implements EPSObject,
EPSReadable,
EPSWriteable {
    private boolean hasReadAccess_ = true;
    private boolean hasWriteAccess_ = true;

    public int length() throws InvalidEPSObjectException {
        return this.size();
    }

    public void bind(EPSStack ePSStack) throws NoReadAccessException {
        if (!this.hasWriteAccess()) {
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            EPSOperator ePSOperator;
            EPSObject ePSObject = (EPSObject)this.get(i);
            if (ePSObject instanceof EPSProc) {
                ((EPSProc)ePSObject).bind(ePSStack);
                continue;
            }
            if (ePSObject instanceof EPSArray) {
                ((EPSArray)ePSObject).bind(ePSStack);
                continue;
            }
            if (!(ePSObject instanceof EPSName) || (ePSOperator = ((EPSName)ePSObject).getOperator(ePSStack)) == (EPSOperator)null) continue;
            this.set(i, ePSOperator);
        }
        try {
            this.setWriteAccess(false);
        }
        catch (InvalidEPSObjectException invalidEPSObjectException) {
            // empty catch block
        }
    }

    public EPSObject get(EPSObject ePSObject) throws InvalidEPSObjectException, NoReadAccessException {
        if (!this.hasReadAccess()) {
            throw new NoReadAccessException();
        }
        if (!(ePSObject instanceof EPSNumber)) {
            throw new InvalidEPSObjectException("(get) invalid index");
        }
        if (!this.hasReadAccess()) {
            throw new InvalidEPSObjectException("(get) no read access");
        }
        return (EPSObject)this.get(((EPSNumber)ePSObject).intValue());
    }

    public void put(EPSObject ePSObject, EPSObject ePSObject2) throws InvalidEPSObjectException, NoWriteAccessException {
        if (!this.hasWriteAccess()) {
            throw new NoWriteAccessException();
        }
        if (!(ePSObject instanceof EPSNumber)) {
            throw new InvalidEPSObjectException("(put) invalid index");
        }
        this.put(((EPSNumber)ePSObject).intValue(), ePSObject2);
    }

    public void copy(EPSObject ePSObject) throws InvalidEPSObjectException, NoWriteAccessException {
        if (!this.hasWriteAccess()) {
            throw new NoWriteAccessException();
        }
        if (!(ePSObject instanceof EPSProc)) {
            throw new InvalidEPSObjectException("(copy) not a proc");
        }
        EPSProc ePSProc = (EPSProc)ePSObject;
        int n = ePSProc.size();
        for (int i = 0; i < n; ++i) {
            this.put(i, (EPSObject)ePSProc.get(i));
        }
    }

    public EPSObject put(int n, EPSObject ePSObject) throws NoWriteAccessException {
        if (!this.hasWriteAccess_) {
            throw new NoWriteAccessException("(put) no write access");
        }
        return this.set(n, ePSObject);
    }

    @Override
    public String toString() {
        String string = "{";
        int n = this.size();
        int n2 = 0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            EPSObject ePSObject = (EPSObject)enumeration.nextElement();
            string = string + ePSObject;
            if (n2 < n - 1) {
                string = string + " ";
            }
            ++n2;
        }
        string = string + "}";
        return string;
    }

    @Override
    public EPSName pstype() {
        return new EPSName("arraytype");
    }

    @Override
    public boolean hasReadAccess() {
        return this.hasReadAccess_;
    }

    @Override
    public boolean hasWriteAccess() {
        return this.hasWriteAccess_;
    }

    @Override
    public void setReadAccess(boolean bl) throws InvalidEPSObjectException {
        this.hasReadAccess_ = bl;
    }

    @Override
    public void setWriteAccess(boolean bl) throws InvalidEPSObjectException {
        this.hasWriteAccess_ = bl;
    }
}

