/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.io.eps;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import uk.ac.uea.cmp.nlct.jdr.InvalidFontShapeException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFontSizeException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFontWeightException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRText;
import uk.ac.uea.cmp.nlct.jdr.LaTeXFont;
import uk.ac.uea.cmp.nlct.jdr.LaTeXFontBase;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSArray;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSDictionaryInterface;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSInteger;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSName;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSNumber;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSObject;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSProc;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSStack;
import uk.ac.uea.cmp.nlct.jdr.io.eps.InvalidEPSObjectException;
import uk.ac.uea.cmp.nlct.jdr.io.eps.NoReadAccessException;
import uk.ac.uea.cmp.nlct.jdr.io.eps.NoWriteAccessException;
import uk.ac.uea.cmp.nlct.jdr.io.eps.NotMatrixException;

public class EPSFont
implements EPSDictionaryInterface {
    private int series;
    private int shape;
    protected String family;
    private String postscriptName;
    private EPSArray transformationMatrix;
    protected LaTeXFontBase latexFontBase;
    private Hashtable<String, EPSObject> dict = new Hashtable();

    public EPSFont(String string, LaTeXFontBase laTeXFontBase) {
        this.init(string, laTeXFontBase, new AffineTransform());
    }

    public EPSFont(String string, LaTeXFontBase laTeXFontBase, AffineTransform affineTransform) {
        this.init(string, laTeXFontBase, affineTransform);
    }

    private EPSFont() {
        this.dict = new Hashtable();
    }

    private void init(String string, LaTeXFontBase laTeXFontBase, AffineTransform affineTransform) {
        this.postscriptName = string;
        this.latexFontBase = laTeXFontBase;
        this.series = 0;
        this.shape = 0;
        this.family = new String(string);
        String string2 = string.toLowerCase();
        if (string2.matches(".*bold.*")) {
            this.series = 1;
        }
        if (string2.matches(".*italic.*")) {
            this.shape = 2;
        } else if (string2.matches(".*oblique.*")) {
            this.shape = 3;
        }
        this.family = this.family.replaceAll("([oO]blique)|([bB]old)|([iI]talic)", "");
        this.family = this.family.replaceFirst("[\\.]", " ");
        this.family = this.family.replaceFirst("^/", "");
        this.family = this.family.replaceFirst(" *$", "");
        if (this.family.startsWith("Times")) {
            this.family = "Serif";
        } else if (this.family.startsWith("Helvetica")) {
            this.family = "SansSerif";
        } else if (this.family.startsWith("Courier")) {
            this.family = "Monospaced";
        }
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        dArray[0] = dArray[0] * 0.001;
        dArray[3] = dArray[3] * 0.001;
        this.transformationMatrix = new EPSArray(dArray);
        this.dict = new Hashtable();
        this.dict.put("FontMatrix", this.transformationMatrix);
        this.dict.put("FontType", new EPSInteger(1));
    }

    public void scaleFont(double d) {
        this.scale(d, d);
    }

    public void setTransform(double[] dArray) {
        for (int i = 0; i < 6; ++i) {
            try {
                ((EPSNumber)this.transformationMatrix.get(i)).set(dArray[i]);
                continue;
            }
            catch (NoReadAccessException noReadAccessException) {
                // empty catch block
            }
        }
    }

    public void setTransform(AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        this.setTransform(dArray);
    }

    public AffineTransform getAffineTransform() {
        try {
            return new AffineTransform(this.transformationMatrix.getMatrix());
        }
        catch (NotMatrixException notMatrixException) {
            return new AffineTransform();
        }
    }

    public void transform(double[] dArray) {
        AffineTransform affineTransform = this.getAffineTransform();
        affineTransform.concatenate(new AffineTransform(dArray));
        this.setTransform(affineTransform);
    }

    public void translate(double d, double d2) {
        AffineTransform affineTransform = this.getAffineTransform();
        affineTransform.translate(d, d2);
        this.setTransform(affineTransform);
    }

    public void scale(double d, double d2) {
        AffineTransform affineTransform = this.getAffineTransform();
        affineTransform.scale(d, d2);
        this.setTransform(affineTransform);
    }

    public void rotate(double d) {
        AffineTransform affineTransform = this.getAffineTransform();
        affineTransform.rotate(d);
        this.setTransform(affineTransform);
    }

    public void concatenate(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = this.getAffineTransform();
        affineTransform2.concatenate(affineTransform);
        this.setTransform(affineTransform2);
    }

    @Override
    public Object clone() {
        EPSFont ePSFont = new EPSFont();
        ePSFont.makeEqual(this);
        return ePSFont;
    }

    @Override
    public void makeEqual(EPSObject ePSObject) {
        EPSFont ePSFont = (EPSFont)ePSObject;
        this.postscriptName = ePSFont.postscriptName;
        this.latexFontBase = ePSFont.latexFontBase;
        this.family = ePSFont.family;
        this.series = ePSFont.series;
        this.shape = ePSFont.shape;
        Enumeration<String> enumeration = ePSFont.dict.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            EPSObject ePSObject2 = (EPSObject)ePSFont.dict.get(string).clone();
            this.dict.put(string, ePSObject2);
            if (!string.equals("FontMatrix")) continue;
            this.transformationMatrix = (EPSArray)ePSObject2;
        }
    }

    public Font getFont() {
        int n = 0;
        n += this.series == 0 ? 0 : 1;
        Font font = new Font(this.family, n += this.shape == 0 ? 0 : 2, 1000);
        AffineTransform affineTransform = this.getAffineTransform();
        return font.deriveFont(affineTransform);
    }

    public JDRText getJDRText(Graphics2D graphics2D, String string, AffineTransform affineTransform, Point2D point2D, Point2D point2D2) {
        JDRText jDRText = null;
        AffineTransform affineTransform2 = this.getAffineTransform();
        affineTransform2.preConcatenate(new AffineTransform(1000.0f, 0.0f, 0.0f, 1000.0f, 0.0f, 0.0f));
        double d = Math.round(0.5 * (Math.abs(affineTransform2.getScaleX()) + Math.abs(affineTransform2.getScaleY())));
        if (d == 0.0) {
            d = Math.round(this.latexFontBase.getNormalSize());
        }
        try {
            jDRText = new JDRText(graphics2D, this.family, this.series, this.shape, (int)d, string);
        }
        catch (InvalidFontWeightException invalidFontWeightException) {
        }
        catch (InvalidFontShapeException invalidFontShapeException) {
        }
        catch (InvalidFontSizeException invalidFontSizeException) {
            // empty catch block
        }
        LaTeXFont laTeXFont = LaTeXFont.fromPostScript(this.postscriptName);
        jDRText.setLaTeXFamily(laTeXFont.getFamily());
        jDRText.setLaTeXSeries(laTeXFont.getWeight());
        jDRText.setLaTeXShape(laTeXFont.getShape());
        jDRText.setLaTeXSize(this.latexFontBase.getLaTeXCmd(d));
        JDRPoint jDRPoint = jDRText.getStart();
        GlyphVector glyphVector = jDRText.getFont().createGlyphVector(graphics2D.getFontRenderContext(), jDRText.getText());
        Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
        Point2D.Double double_ = new Point2D.Double(rectangle2D.getWidth(), 0.0);
        AffineTransform affineTransform3 = new AffineTransform();
        affineTransform3.concatenate(affineTransform);
        affineTransform3.translate(point2D.getX(), point2D.getY());
        affineTransform3.concatenate(affineTransform2);
        affineTransform3.scale(1.0 / d, -1.0 / d);
        jDRText.transform(affineTransform3);
        jDRText.escapeTeXChars();
        if (point2D2 != null) {
            affineTransform3.deltaTransform(double_, point2D2);
        }
        return jDRText;
    }

    @Override
    public void copy(EPSObject ePSObject) throws InvalidEPSObjectException, NoWriteAccessException {
        if (!(ePSObject instanceof EPSFont)) {
            throw new InvalidEPSObjectException("(copy) not a font");
        }
        EPSFont ePSFont = (EPSFont)ePSObject;
        this.series = ePSFont.series;
        this.shape = ePSFont.shape;
        this.transformationMatrix = ePSFont.transformationMatrix;
        this.family = ePSFont.family;
        this.dict = ePSFont.dict;
    }

    @Override
    public int length() {
        return this.dict.size();
    }

    @Override
    public EPSObject get(EPSObject ePSObject) {
        return this.get(ePSObject.toString());
    }

    public EPSObject get(String string) {
        String string2 = string.toString();
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        return this.dict.get(string2);
    }

    @Override
    public void put(EPSObject ePSObject, EPSObject ePSObject2) {
        this.put(ePSObject.toString(), ePSObject2);
    }

    public void put(String string, EPSObject ePSObject) {
        String string2 = string;
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        if (string2.equals("FontMatrix")) {
            this.transformationMatrix = (EPSArray)ePSObject;
        }
        this.dict.put(string2, ePSObject);
    }

    @Override
    public void forall(EPSStack ePSStack, EPSProc ePSProc) throws InvalidFormatException, NoninvertibleTransformException, IOException {
        Enumeration<String> enumeration = this.dict.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            ePSStack.add(new EPSName("/" + string));
            ePSStack.add(this.dict.get(string));
            ePSStack.execObject(ePSProc);
            if (!ePSStack.getExitStatus()) continue;
            break;
        }
    }

    @Override
    public EPSName pstype() {
        return new EPSName("fonttype");
    }

    public String toString() {
        return "EPSFont[family=" + this.family + ",series=" + this.series + ",shape=" + this.shape + ",af=" + this.transformationMatrix + ",normalsize=" + this.latexFontBase.getNormalSize() + ",psfont=" + this.postscriptName + "]";
    }
}

