/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.io.eps;

import java.awt.geom.NoninvertibleTransformException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSDict;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSFile;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSName;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSObject;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSProc;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSStack;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSString;
import uk.ac.uea.cmp.nlct.jdr.io.eps.InvalidEPSObjectException;

public abstract class EPSFilter
implements EPSObject {
    private EPSObject data;
    private EPSDict dict;
    private EPSObject[] param;
    private EPSFile file = null;

    public EPSFilter(EPSObject ePSObject) throws InvalidEPSObjectException {
        if (!(ePSObject instanceof EPSFile || ePSObject instanceof EPSProc || ePSObject instanceof EPSString)) {
            throw new InvalidEPSObjectException("Invalid data source/target type");
        }
        this.data = ePSObject;
        this.dict = null;
        this.param = null;
    }

    public EPSFilter(EPSObject ePSObject, EPSDict ePSDict) throws InvalidEPSObjectException {
        if (!(ePSObject instanceof EPSFile || ePSObject instanceof EPSProc || ePSObject instanceof EPSString)) {
            throw new InvalidEPSObjectException("Invalid data source/target type");
        }
        this.data = ePSObject;
        this.dict = ePSDict;
        this.param = null;
    }

    public EPSFilter(EPSObject ePSObject, EPSDict ePSDict, EPSObject[] ePSObjectArray, String string) throws InvalidEPSObjectException {
        if (!(ePSObject instanceof EPSFile || ePSObject instanceof EPSProc || ePSObject instanceof EPSString)) {
            throw new InvalidEPSObjectException("Invalid data source/target type");
        }
        this.data = ePSObject;
        this.dict = ePSDict;
        this.param = ePSObjectArray;
    }

    protected EPSFilter() {
        this.data = null;
        this.dict = null;
        this.param = null;
    }

    public abstract String getName();

    public abstract boolean isEncoding();

    public EPSObject getData() {
        return this.data;
    }

    public EPSDict getDict() {
        return this.dict;
    }

    public EPSObject[] getParams() {
        return this.param;
    }

    public void encode(PrintWriter printWriter, EPSStack ePSStack) throws InvalidFormatException, IOException, NoninvertibleTransformException {
    }

    public void decode(PrintWriter printWriter, EPSStack ePSStack) throws InvalidFormatException, IOException, NoninvertibleTransformException {
    }

    public EPSFile getFile(EPSStack ePSStack) throws IOException, InvalidFormatException, NoninvertibleTransformException {
        if (this.file != null) {
            return this.file;
        }
        File file = File.createTempFile("epsjdr", null);
        file.deleteOnExit();
        PrintWriter printWriter = new PrintWriter(file);
        if (this.isEncoding()) {
            this.encode(printWriter, ePSStack);
        } else {
            this.decode(printWriter, ePSStack);
        }
        printWriter.close();
        this.file = new EPSFile(file, "r");
        return this.file;
    }

    public String toString() {
        return this.getName() + " filter";
    }

    public boolean equals(Object object) {
        if (!(object instanceof EPSFilter)) {
            return false;
        }
        EPSFilter ePSFilter = (EPSFilter)object;
        if (ePSFilter.dict == null && this.dict != null) {
            return false;
        }
        if (this.dict == null && ePSFilter.dict != null) {
            return false;
        }
        if (ePSFilter.param == null && this.param != null) {
            return false;
        }
        if (this.param == null && ePSFilter.param != null) {
            return false;
        }
        if (ePSFilter.data == null && this.data != null) {
            return false;
        }
        if (this.data == null && ePSFilter.data != null) {
            return false;
        }
        if (!this.getName().equals(ePSFilter.getName())) {
            return false;
        }
        if (this.dict != null && !this.dict.equals(ePSFilter.dict)) {
            return false;
        }
        if (this.param != null && !this.param.equals(ePSFilter.param)) {
            return false;
        }
        return this.data == null || this.data.equals(ePSFilter.data);
    }

    @Override
    public EPSName pstype() {
        return new EPSName(this.getName() + " filter");
    }

    @Override
    public abstract Object clone();

    public void makeEqual(EPSObject ePSObject) {
        EPSFilter ePSFilter = (EPSFilter)ePSObject;
        this.data = (EPSObject)ePSFilter.data.clone();
        this.dict = ePSFilter.dict == null ? null : ePSFilter.dict.clone();
        if (ePSFilter.param == null) {
            this.param = null;
        } else {
            this.param = new EPSObject[ePSFilter.param.length];
            for (int i = 0; i < this.param.length; ++i) {
                this.param[i] = (EPSObject)ePSFilter.param[i].clone();
            }
        }
        this.file = ePSFilter.file;
    }
}

