/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.io.eps;

import java.awt.geom.NoninvertibleTransformException;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidPathException;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSDictMark;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSDouble;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSInteger;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSMark;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSName;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSObject;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSProc;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSReadable;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSString;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSWriteable;
import uk.ac.uea.cmp.nlct.jdr.io.eps.InvalidEPSObjectException;
import uk.ac.uea.cmp.nlct.jdr.io.eps.NoReadAccessException;
import uk.ac.uea.cmp.nlct.jdr.io.eps.NoWriteAccessException;
import uk.ac.uea.cmp.nlct.jdr.io.eps.UnsupportedAccessException;

public class EPSFile
implements EPSObject,
EPSReadable,
EPSWriteable {
    private File file_;
    private String name_;
    public static final int CURRENTFILE = 0;
    public static final int STDIN = 1;
    public static final int STDOUT = 2;
    public static final int STDERR = 4;
    public static final int OTHER = 5;
    private int type_;
    private boolean canRead_;
    private boolean canWrite_;
    private BufferedReader in_ = null;
    private PrintWriter out_ = null;
    private boolean eof = false;
    private int lineNum = 0;
    private int markLineNum = 0;
    private int previousRead = -1;
    private boolean discardLF = false;

    public EPSFile(EPSString ePSString, EPSString ePSString2) throws IOException, UnsupportedAccessException {
        this(ePSString.value(), ePSString2.value());
    }

    public EPSFile(String string, String string2) throws IOException, UnsupportedAccessException {
        if (string.equals("%stdin")) {
            this.type_ = 1;
            this.file_ = null;
            this.canRead_ = true;
            this.canWrite_ = false;
            this.name_ = "%stdin";
        } else if (string.equals("%stdout")) {
            this.type_ = 2;
            this.file_ = null;
            this.canRead_ = false;
            this.canWrite_ = true;
            this.name_ = "%stdout";
        } else if (string.equals("%stderr")) {
            this.type_ = 4;
            this.file_ = null;
            this.canRead_ = false;
            this.canWrite_ = true;
            this.name_ = "%stderr";
        } else {
            this.file_ = new File(string);
            this.name_ = string;
            this.type_ = 5;
            if (string2.equals("r")) {
                if (!this.file_.exists()) {
                    throw new IOException("Can't open file '" + string + "' in 'r' mode: file doesn't exist");
                }
                this.canRead_ = true;
                this.canWrite_ = false;
                this.in_ = new BufferedReader(new FileReader(this.file_));
            } else if (string2.equals("w")) {
                this.canRead_ = false;
                this.canWrite_ = true;
                this.out_ = new PrintWriter(this.file_);
            } else {
                throw new UnsupportedAccessException(string2);
            }
        }
    }

    public EPSFile(File file, String string) throws IOException, UnsupportedAccessException {
        this.file_ = file;
        this.name_ = file.getName();
        this.type_ = 5;
        if (string.equals("r")) {
            if (!this.file_.exists()) {
                throw new IOException("Can't open file '" + this.name_ + "' in 'r' mode: file doesn't exist");
            }
            this.canRead_ = true;
            this.canWrite_ = false;
            this.in_ = new BufferedReader(new FileReader(this.file_));
        } else if (string.equals("w")) {
            this.canRead_ = false;
            this.canWrite_ = true;
            this.out_ = new PrintWriter(this.file_);
        } else {
            throw new UnsupportedAccessException(string);
        }
    }

    public EPSFile(BufferedReader bufferedReader) {
        this.type_ = 0;
        this.file_ = null;
        this.in_ = bufferedReader;
        this.canRead_ = true;
        this.canWrite_ = false;
        this.name_ = "currentfile";
    }

    private EPSFile() {
    }

    public int getType() {
        return this.type_;
    }

    public boolean isCurrentFile() {
        return this.type_ == 0;
    }

    public boolean isStdin() {
        return this.type_ == 1;
    }

    public boolean isStdout() {
        return this.type_ == 2;
    }

    public boolean isStderr() {
        return this.type_ == 4;
    }

    public boolean equals(Object object) {
        if (object instanceof EPSFile) {
            EPSFile ePSFile = (EPSFile)object;
            if (this.type_ == ePSFile.type_ && this.type_ != 5) {
                return true;
            }
            if (this.file_ == null || ePSFile.file_ == null) {
                return false;
            }
            return this.file_.equals(ePSFile.file_);
        }
        return false;
    }

    public String getName() {
        switch (this.type_) {
            case 0: {
                return "currentfile";
            }
            case 1: {
                return "%stdin";
            }
            case 2: {
                return "%stdout";
            }
            case 4: {
                return "%stderr";
            }
        }
        return this.name_;
    }

    public String toString() {
        if (this.type_ != 5) {
            return this.getName();
        }
        String string = "";
        if (this.canRead_) {
            string = "r";
        }
        if (this.canWrite_) {
            string = string + "w";
        }
        return this.name_ + " (" + string + ")";
    }

    public int getLineNum() {
        return this.lineNum;
    }

    @Override
    public EPSName pstype() {
        return new EPSName("file");
    }

    @Override
    public boolean hasReadAccess() {
        return this.canRead_;
    }

    @Override
    public boolean hasWriteAccess() {
        return this.canWrite_;
    }

    @Override
    public void setWriteAccess(boolean bl) throws InvalidEPSObjectException {
        throw new InvalidEPSObjectException("invalid type");
    }

    @Override
    public void setReadAccess(boolean bl) throws InvalidEPSObjectException {
        throw new InvalidEPSObjectException("invalid type");
    }

    public void closefile() throws IOException {
        if (this.in_ != null) {
            this.in_.close();
        }
        if (this.out_ != null) {
            this.out_.close();
        }
    }

    public void flush() {
        if (this.canWrite_) {
            if (this.out_ != null) {
                this.out_.flush();
            } else if (this.isStdout()) {
                System.out.flush();
            } else if (this.isStderr()) {
                System.err.flush();
            }
        }
    }

    public boolean status() {
        if (this.type_ == 5 || this.type_ == 0) {
            if (this.canRead_ && this.in_ != null) {
                return true;
            }
            if (this.canWrite_ && this.out_ != null) {
                return true;
            }
        }
        return true;
    }

    public int read() throws NoReadAccessException, IOException {
        if (!this.canRead_) {
            throw new NoReadAccessException("no read access for file '" + this.name_ + "'");
        }
        int n = -1;
        if (this.type_ == 1) {
            n = System.in.read();
            if (this.discardLF && n == 10) {
                n = System.in.read();
            }
        } else {
            if (this.in_ == null) {
                throw new NoReadAccessException("can't read from file '" + this.name_ + "' (file closed)");
            }
            n = this.in_.read();
            if (this.discardLF && n == 10) {
                n = this.in_.read();
            }
        }
        this.discardLF = false;
        if (n == -1) {
            this.eof = true;
        } else if (n == 13) {
            ++this.lineNum;
        } else if (n == 10 && this.previousRead != 13) {
            ++this.lineNum;
        }
        this.previousRead = n;
        return n;
    }

    public void write(int n) throws NoWriteAccessException, IOException {
        this.write((char)n);
    }

    public void write(char c) throws NoWriteAccessException, IOException {
        if (this.type_ == 2) {
            System.out.print(c);
        } else if (this.type_ == 4) {
            System.err.print(c);
        } else {
            if (!this.canWrite_) {
                throw new NoWriteAccessException("no write access for file '" + this.name_ + "'");
            }
            if (this.out_ == null) {
                throw new IOException("can't write to file '" + this.name_ + "' (file closed)");
            }
            this.out_.print(c);
        }
    }

    public boolean readstring(char[] cArray) {
        boolean bl = true;
        if (!this.canRead_) {
            return false;
        }
        try {
            for (int i = 0; i < cArray.length; ++i) {
                int n = this.read();
                if (n == -1) {
                    bl = false;
                    break;
                }
                cArray[i] = (char)n;
            }
        }
        catch (NoReadAccessException noReadAccessException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return bl;
    }

    public void writestring(EPSString ePSString) {
        this.writestring(ePSString.value());
    }

    public void writestring(String string) {
        if (!this.canWrite_) {
            return;
        }
        switch (this.type_) {
            case 2: {
                System.out.print(string);
                return;
            }
            case 4: {
                System.err.print(string);
                return;
            }
        }
        this.out_.print(string);
    }

    public void writestring(char[] cArray) {
        if (!this.canWrite_) {
            return;
        }
        switch (this.type_) {
            case 2: {
                System.out.print(cArray);
                return;
            }
            case 4: {
                System.err.print(cArray);
                return;
            }
        }
        this.out_.print(cArray);
    }

    public void writehexstring(EPSString ePSString) {
        this.writehexstring(ePSString.getChars());
    }

    public void writehexstring(char[] cArray) {
        if (!this.canWrite_) {
            return;
        }
        switch (this.type_) {
            case 2: {
                for (int i = 0; i < cArray.length; ++i) {
                    System.out.print(Integer.toHexString(cArray[i]));
                }
                return;
            }
            case 4: {
                for (int i = 0; i < cArray.length; ++i) {
                    System.err.print(Integer.toHexString(cArray[i]));
                }
                return;
            }
        }
        if (this.out_ != null) {
            for (int i = 0; i < cArray.length; ++i) {
                this.out_.print(Integer.toHexString(cArray[i]));
            }
        }
    }

    public int readhexstring(char[] cArray) {
        int n = 0;
        if (!this.canRead_) {
            return 0;
        }
        try {
            int n2;
            int n3 = -1;
            char[] cArray2 = new char[2];
            int n4 = 0;
            n4 = 0;
            while (n4 < cArray.length && (n2 = this.read()) != -1) {
                if (!EPSString.isHex((char)n2)) continue;
                if (n3 == -1) {
                    n3 = n2;
                    continue;
                }
                cArray2[0] = (char)n3;
                cArray2[1] = (char)n2;
                cArray[n4] = (char)Integer.parseInt(new String(cArray2), 16);
                n3 = -1;
                ++n4;
            }
            n = n4;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
        catch (IOException iOException) {
        }
        catch (NoReadAccessException noReadAccessException) {
            return 0;
        }
        return n;
    }

    public void mark(int n) throws EOFException, IOException, IllegalArgumentException {
        if (this.eof) {
            throw new EOFException("file mark failed (end of file)");
        }
        if (this.in_ == null) {
            if (this.type_ == 1) {
                throw new IOException("file mark not supported for stdin");
            }
            if (!this.canRead_) {
                throw new IOException("file mark not supported ('" + this.name_ + "' has no read access)");
            }
            throw new IOException("file mark failed ('" + this.name_ + "' is closed)");
        }
        this.in_.mark(n);
        this.markLineNum = this.lineNum;
    }

    public void reset() throws IOException {
        if (this.in_ != null) {
            if (!this.in_.markSupported()) {
                throw new IOException("mark not supported");
            }
        } else {
            if (this.type_ == 1) {
                throw new IOException("file reset not supported for stdin");
            }
            if (!this.canRead_) {
                throw new IOException("file reset not supported ('" + this.name_ + "' has no read access)");
            }
            throw new IOException("file reset failed ('" + this.name_ + "' is closed)");
        }
        this.in_.reset();
        this.eof = false;
        this.lineNum = this.markLineNum;
    }

    public void restart() throws IOException {
        if (this.type_ != 5) {
            throw new IOException("file restart not supported for " + this.getName());
        }
        if (!this.canRead_) {
            throw new IOException("file restart not supported ('" + this.name_ + "' has no read access)");
        }
        if (this.in_ != null) {
            this.in_.close();
        }
        this.in_ = new BufferedReader(new FileReader(this.file_));
        this.lineNum = 0;
        this.markLineNum = 0;
        this.previousRead = -1;
        this.discardLF = false;
        this.eof = false;
    }

    public String readline() throws IOException, NoReadAccessException {
        String string = null;
        if (!this.canRead_) {
            throw new NoReadAccessException("readline failed ('" + this.name_ + "' has no read access)");
        }
        int n = 0;
        string = "";
        while (n != 10 && n != 13 && (n = this.read()) != -1) {
            if (n == 10 || n == 13) continue;
            string = string + (char)n;
        }
        this.discardLF = n == 13;
        return string;
    }

    public boolean atEOF() {
        return this.eof;
    }

    public EPSObject readObject(EPS ePS) throws IOException, InvalidFormatException {
        int n = this.read();
        if (n == -1) {
            return null;
        }
        while (Character.isWhitespace(n)) {
            n = this.read();
        }
        if (n == -1) {
            return null;
        }
        if (n == 37) {
            String string = this.readline();
            if (string.startsWith("%Trailer") || string.equals("%EOF")) {
                return null;
            }
            return this.readObject(ePS);
        }
        if (n == 123) {
            return this.readGroup(ePS);
        }
        if (n == 91) {
            return new EPSMark();
        }
        if (n == 93) {
            return new EPSName("]");
        }
        if (n == 60) {
            this.mark(2);
            n = this.read();
            if (n == 60) {
                return new EPSDictMark();
            }
            this.reset();
            return this.readHexString(ePS);
        }
        if (n == 62) {
            this.mark(2);
            n = this.read();
            if (n == 62) {
                return new EPSName(">>");
            }
            this.reset();
            n = 62;
        } else {
            if (n == 40) {
                return this.readString(ePS);
            }
            if (n == 47) {
                return this.readProc((char)n);
            }
            if (n == 46 || Character.isDigit(n) || n == 43 || n == 45) {
                return this.readNum((char)n);
            }
        }
        String string = new String("");
        while (!Character.isWhitespace(n)) {
            string = string + (char)n;
            this.mark(2);
            n = this.read();
            if (n == 37) {
                this.readline();
                break;
            }
            if (n != 123 && n != 125 && n != 91 && n != 93 && n != 60 && n != 62 && n != 47) continue;
            this.reset();
            break;
        }
        return new EPSName(string);
    }

    public EPSString readHexString(EPS ePS) throws IOException, EOFException, InvalidFormatException {
        String string = new String("");
        ePS.printMessage("Reading hexadecimal data");
        int n = this.read();
        if (n == -1) {
            throw new EOFException("EOF encountered while scanning hexadecimal string");
        }
        int n2 = 0;
        ePS.resetProgress();
        ePS.setIndeterminate(true);
        while (n != 62) {
            if (n == 37) {
                this.readline();
                n = 32;
            }
            if (!Character.isWhitespace(n)) {
                string = string + (char)n;
                if (n2++ % 256 == 0) {
                    ePS.incrementProgress();
                }
            }
            n = this.read();
        }
        ePS.printlnMessage("");
        int n3 = string.length();
        if (n3 % 2 == 1) {
            string = string + '0';
            ++n3;
        }
        char[] cArray = new char[n3 / 2];
        try {
            n2 = 0;
            int n4 = 0;
            while (n2 < n3) {
                cArray[n4] = (char)Integer.parseInt(string.substring(n2, n2 + 2), 16);
                n2 += 2;
                ++n4;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFormatException("Can't parse hexadecimal string");
        }
        return new EPSString(cArray);
    }

    public EPSString readString(EPS ePS) throws IOException, EOFException, InvalidFormatException {
        String string;
        block22: {
            string = new String("");
            boolean bl = false;
            int n = 1;
            int n2 = this.read();
            if (n2 == -1) {
                throw new EOFException("EOF encountered while scanning literal string");
            }
            int n3 = 0;
            ePS.resetProgress();
            ePS.setIndeterminate(true);
            do {
                if (n3++ % 256 == 0) {
                    ePS.incrementProgress();
                }
                if (n2 == 92) {
                    boolean bl2 = bl = !bl;
                    if (bl) continue;
                    string = string + (char)n2;
                    continue;
                }
                if (n2 == 40) {
                    if (!bl) {
                        ++n;
                    }
                    string = string + (char)n2;
                } else if (n2 == 41) {
                    if (!bl && --n == 0) break block22;
                    string = string + (char)n2;
                } else if (bl && Character.digit((char)n2, 8) != -1) {
                    string = string + (char)this.readOct((char)n2);
                } else if (bl && n2 == 110) {
                    string = string + '\n';
                } else if (bl && n2 == 114) {
                    string = string + '\r';
                } else if (bl && n2 == 116) {
                    string = string + '\t';
                } else if (bl && n2 == 98) {
                    string = string + '\b';
                } else if (bl && n2 == 102) {
                    string = string + '\f';
                } else if (!bl || n2 != 10 && n2 != 13) {
                    string = string + (char)n2;
                }
                bl = false;
            } while ((n2 = this.read()) != -1);
            this.eof = true;
            throw new EOFException("EOF encountered while scanning literal string");
        }
        return new EPSString(string);
    }

    public int readOct(char c) throws IOException, EOFException, InvalidFormatException {
        String string = "" + c;
        for (int i = 0; i < 2; ++i) {
            this.mark(2);
            int n = this.read();
            if (n == -1) break;
            if (n == 37) {
                this.readline();
                n = 32;
            }
            if (Character.digit((char)n, 8) == -1) {
                this.reset();
                break;
            }
            string = string + (char)n;
        }
        try {
            return Integer.parseInt(string, 8);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFormatException(numberFormatException.getMessage());
        }
    }

    public EPSProc readGroup(EPS ePS) throws EOFException, IOException, InvalidFormatException {
        EPSProc ePSProc = new EPSProc();
        while (true) {
            this.mark(2);
            int n = this.read();
            if (n == -1) {
                this.eof = true;
                throw new EOFException("Unexpected EOF while scanning {...}");
            }
            while (Character.isWhitespace(n)) {
                this.mark(2);
                n = this.read();
                if (n != -1) continue;
                this.eof = true;
                throw new EOFException("Unexpected EOF while scanning {...}");
            }
            if (n == 125) break;
            if (n == 37) {
                this.readline();
                continue;
            }
            this.reset();
            EPSObject ePSObject = this.readObject(ePS);
            ePSProc.add(ePSObject);
        }
        return ePSProc;
    }

    public EPSName readProc(char c) throws IOException, InvalidFormatException {
        String string = "" + c;
        while (true) {
            this.mark(2);
            int n = this.read();
            if (n == -1) break;
            if (n == 123 || n == 91 || n == 125 || n == 93 || n == 40 || n == 41 || n == 60 || n == 62 || n == 47) {
                this.reset();
                break;
            }
            if (n == 37) {
                this.readline();
                break;
            }
            if (Character.isWhitespace((char)n)) break;
            string = string + (char)n;
        }
        return new EPSName(string);
    }

    public EPSObject readNum(char n) throws IOException, InvalidFormatException {
        String string = "" + (char)n;
        boolean bl = n != 46;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = n;
        while (true) {
            this.mark(2);
            int n3 = this.read();
            if (n3 == -1) break;
            if (n3 == 37) {
                this.readline();
                n3 = 32;
            }
            if (n3 == 46) {
                if (bl3) {
                    this.reset();
                    break;
                }
                if (!bl && !bl2) break;
                bl = false;
                bl2 = true;
                string = string + '.';
            } else if (n3 == 101 || n3 == 69) {
                bl2 = true;
                bl = false;
                string = string + (char)n3;
            } else if (!(n3 != 43 && n3 != 45 || n2 != 101 && n2 != 69)) {
                string = string + (char)n3;
            } else if (Character.isDigit((char)n3)) {
                string = string + (char)n3;
            } else if (n3 == 35) {
                if (bl3) {
                    this.reset();
                    break;
                }
                string = string + (char)n3;
                bl3 = true;
            } else {
                if (Character.isWhitespace((char)n3)) break;
                this.reset();
                break;
            }
            n2 = n3;
        }
        try {
            if (bl3) {
                String[] stringArray = string.split("#", 2);
                int n4 = Integer.parseInt(stringArray[0]);
                int n5 = Integer.parseInt(stringArray[1], n4);
                return new EPSInteger(n5);
            }
            if (bl) {
                return new EPSInteger(string);
            }
            return new EPSDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return new EPSName(string);
        }
    }

    @Override
    public Object clone() {
        return this;
    }

    public void execute(EPS ePS) throws InvalidFormatException, InvalidPathException, NoninvertibleTransformException, IOException {
        EPSObject ePSObject = this.readObject(ePS);
        while (ePSObject != null) {
            ePS.processObject(ePSObject);
            ePSObject = this.readObject(ePS);
        }
    }
}

