/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr.io.eps;

import java.awt.geom.NoninvertibleTransformException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSArray;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSBoolean;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSComposite;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSDictionaryInterface;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSName;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSNumber;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSObject;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSProc;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSReadable;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSStack;
import uk.ac.uea.cmp.nlct.jdr.io.eps.EPSWriteable;
import uk.ac.uea.cmp.nlct.jdr.io.eps.InvalidEPSObjectException;
import uk.ac.uea.cmp.nlct.jdr.io.eps.NoReadAccessException;
import uk.ac.uea.cmp.nlct.jdr.io.eps.NoWriteAccessException;

public class EPSDict
extends Hashtable<String, EPSObject>
implements EPSObject,
EPSComposite,
EPSReadable,
EPSWriteable,
EPSDictionaryInterface {
    private int capacity_;
    private boolean hasReadAccess_ = true;
    private boolean hasWriteAccess_ = true;

    public EPSDict() {
        this(11);
    }

    public EPSDict(int n) {
        super(n);
        this.capacity_ = n;
    }

    public int getCapacity() {
        return this.capacity_;
    }

    @Override
    public void forall(EPSStack ePSStack, EPSProc ePSProc) throws InvalidFormatException, NoninvertibleTransformException, IOException {
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ePSStack.add(new EPSName(string));
            ePSStack.add(this.get(string));
            ePSStack.execObject(ePSProc);
            if (!ePSStack.getExitStatus()) continue;
            break;
        }
    }

    public void putInterval(int n, EPSComposite ePSComposite) throws InvalidEPSObjectException, NoWriteAccessException, NoReadAccessException {
        throw new InvalidEPSObjectException("putinterval not available for dictionaries");
    }

    public EPSComposite getInterval(int n, int n2) throws InvalidEPSObjectException, NoReadAccessException {
        throw new InvalidEPSObjectException("getinterval not available for dictionaries");
    }

    @Override
    public EPSObject get(EPSObject ePSObject) throws InvalidEPSObjectException, NoReadAccessException {
        if (!this.hasReadAccess()) {
            throw new NoReadAccessException();
        }
        if (!(ePSObject instanceof EPSName)) {
            throw new InvalidEPSObjectException("(get) invalid key");
        }
        String string = ((EPSName)ePSObject).toString();
        return (EPSObject)super.get(string);
    }

    public EPSObject get(String string) throws NoReadAccessException {
        if (!this.hasReadAccess_) {
            throw new NoReadAccessException();
        }
        EPSObject ePSObject = (EPSObject)super.get(string);
        if (ePSObject == null) {
            ePSObject = (EPSObject)super.get("/" + string);
        }
        return ePSObject;
    }

    @Override
    public void put(EPSObject ePSObject, EPSObject ePSObject2) throws InvalidEPSObjectException, NoWriteAccessException {
        if (!this.hasWriteAccess()) {
            throw new NoWriteAccessException();
        }
        if (!(ePSObject instanceof EPSName)) {
            throw new InvalidEPSObjectException("(put) invalid key");
        }
        String string = ((EPSName)ePSObject).toString();
        super.put(string, ePSObject2);
    }

    public EPSObject putValue(String string, EPSObject ePSObject) throws NoWriteAccessException {
        if (!this.hasWriteAccess()) {
            throw new NoWriteAccessException();
        }
        return super.put(string, ePSObject);
    }

    public boolean getBoolean(String string) throws InvalidEPSObjectException, NoReadAccessException {
        EPSObject ePSObject;
        if (!this.hasReadAccess()) {
            throw new NoReadAccessException();
        }
        EPSObject ePSObject2 = this.get(string);
        if (ePSObject2 == null) {
            throw new InvalidEPSObjectException(string + " not found in dictionary");
        }
        if (ePSObject2 instanceof EPSBoolean) {
            return ((EPSBoolean)ePSObject2).booleanValue();
        }
        if (ePSObject2 instanceof EPSArray && ((EPSArray)ePSObject2).size() == 1 && (ePSObject = ((EPSArray)ePSObject2).get(0)) instanceof EPSBoolean) {
            return ((EPSBoolean)ePSObject).booleanValue();
        }
        throw new InvalidEPSObjectException("Boolean expected for key '" + string + "'");
    }

    public int getInt(String string) throws InvalidEPSObjectException, NoReadAccessException {
        EPSObject ePSObject;
        if (!this.hasReadAccess()) {
            throw new NoReadAccessException();
        }
        EPSObject ePSObject2 = this.get(string);
        if (ePSObject2 == null) {
            throw new InvalidEPSObjectException(string + " not found in dictionary");
        }
        if (ePSObject2 instanceof EPSNumber) {
            return ((EPSNumber)ePSObject2).intValue();
        }
        if (ePSObject2 instanceof EPSArray && ((EPSArray)ePSObject2).size() == 1 && (ePSObject = ((EPSArray)ePSObject2).get(0)) instanceof EPSNumber) {
            return ((EPSNumber)ePSObject).intValue();
        }
        throw new InvalidEPSObjectException("Number expected for key '" + string + "'");
    }

    public double getDouble(String string) throws InvalidEPSObjectException, NoReadAccessException {
        EPSObject ePSObject;
        if (!this.hasReadAccess()) {
            throw new NoReadAccessException();
        }
        EPSObject ePSObject2 = this.get(string);
        if (ePSObject2 == null) {
            throw new InvalidEPSObjectException(string + " not found in dictionary");
        }
        if (ePSObject2 instanceof EPSNumber) {
            return ((EPSNumber)ePSObject2).doubleValue();
        }
        if (ePSObject2 instanceof EPSArray && ((EPSArray)ePSObject2).size() == 1 && (ePSObject = ((EPSArray)ePSObject2).get(0)) instanceof EPSNumber) {
            return ((EPSNumber)ePSObject).doubleValue();
        }
        throw new InvalidEPSObjectException("Number expected for key '" + string + "'");
    }

    public EPSDict getDict(String string) throws InvalidEPSObjectException, NoReadAccessException {
        if (!this.hasReadAccess()) {
            throw new NoReadAccessException();
        }
        EPSObject ePSObject = this.get(string);
        if (ePSObject == null) {
            throw new InvalidEPSObjectException(string + " not found in dictionary");
        }
        if (ePSObject instanceof EPSDict) {
            return (EPSDict)ePSObject;
        }
        throw new InvalidEPSObjectException("Key-Val Dictionary expected for key '" + string + "'");
    }

    public EPSArray getArray(String string) throws InvalidEPSObjectException, NoReadAccessException {
        if (!this.hasReadAccess()) {
            throw new NoReadAccessException();
        }
        EPSObject ePSObject = this.get(string);
        if (ePSObject == null) {
            throw new InvalidEPSObjectException(string + " not found in dictionary");
        }
        if (ePSObject instanceof EPSArray) {
            return (EPSArray)ePSObject;
        }
        EPSArray ePSArray = new EPSArray(1);
        try {
            ePSArray.set(0, ePSObject);
        }
        catch (NoWriteAccessException noWriteAccessException) {
            // empty catch block
        }
        return ePSArray;
    }

    public EPSName getProc(String string) throws InvalidEPSObjectException, NoReadAccessException {
        if (!this.hasReadAccess()) {
            throw new NoReadAccessException();
        }
        EPSObject ePSObject = this.get(string);
        if (ePSObject == null) {
            throw new InvalidEPSObjectException(string + " not found in dictionary");
        }
        if (ePSObject instanceof EPSName) {
            return (EPSName)ePSObject;
        }
        throw new InvalidEPSObjectException("procedure or name expected for key '" + string + "'");
    }

    public double[] getDoubleArray(String string) throws InvalidEPSObjectException, NoReadAccessException {
        if (!this.hasReadAccess()) {
            throw new NoReadAccessException();
        }
        EPSArray ePSArray = this.getArray(string);
        return ePSArray.getDoubleArray();
    }

    @Override
    public void copy(EPSObject ePSObject) throws InvalidEPSObjectException, NoWriteAccessException {
        if (!this.hasWriteAccess()) {
            throw new NoWriteAccessException();
        }
        if (!(ePSObject instanceof EPSDict)) {
            throw new InvalidEPSObjectException("(copy) not a dictionary");
        }
        EPSDict ePSDict = (EPSDict)ePSObject;
        Enumeration enumeration = ePSDict.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                this.putValue(string, ePSDict.get(string));
            }
            catch (NoReadAccessException noReadAccessException) {
                throw new InvalidEPSObjectException("(copy) copied object has no read access");
            }
        }
    }

    @Override
    public int length() {
        return this.size();
    }

    public String getDetails() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "<<" + string;
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            string2 = string2 + string3 + " => " + super.get(string3);
        }
        string2 = string2 + ">>";
        return string2;
    }

    @Override
    public String toString() {
        return "-dict-";
    }

    @Override
    public EPSName pstype() {
        return new EPSName("dicttype");
    }

    @Override
    public boolean hasReadAccess() {
        return this.hasReadAccess_;
    }

    @Override
    public boolean hasWriteAccess() {
        return this.hasWriteAccess_;
    }

    @Override
    public void setReadAccess(boolean bl) throws InvalidEPSObjectException {
        this.hasReadAccess_ = bl;
    }

    @Override
    public void setWriteAccess(boolean bl) throws InvalidEPSObjectException {
        this.hasWriteAccess_ = bl;
    }

    @Override
    public EPSDict clone() {
        EPSDict ePSDict = new EPSDict(this.capacity_);
        ePSDict.makeEqual(this);
        return ePSDict;
    }

    private EPSObject getValue(String string) {
        return (EPSObject)super.get(string);
    }

    @Override
    public void makeEqual(EPSObject ePSObject) {
        EPSDict ePSDict = (EPSDict)ePSObject;
        this.hasReadAccess_ = ePSDict.hasReadAccess_;
        this.hasWriteAccess_ = ePSDict.hasWriteAccess_;
        this.clear();
        Enumeration enumeration = ePSDict.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            EPSObject ePSObject2 = ePSDict.getValue(string);
            super.put(string, ePSObject2);
        }
    }
}

